/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.command.Command;
import org.nlogo.command.DoubleReporter;
import org.nlogo.command.Instruction;
import org.nlogo.command.Procedure;
import org.nlogo.command.Reporter;
import org.nlogo.compiler.Let;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.JobThread;
import org.nlogo.nvm.LetMap;
import org.nlogo.nvm.LogoException;
import org.nlogo.nvm.ReporterActivation;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp final class Context
implements Cloneable {
    static boolean halting = false;
    static Object haltingOwner = null;
    private static final int DEFAULT_STACK_CAPACITY = 1;
    public final Job job;
    public final Agent myself;
    public Agent agent;
    public int ip;
    public Activation activation;
    public boolean waiting;
    private LetMap letVars;
    public boolean stopping;
    public boolean finished;
    public Object scratch;
    private Object[] stack;
    public int stackSize;

    final void step() throws LogoException {
        if (this.agent.id == -1) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                command.checkAgentClass(this.agent);
                command.perform(this);
                if (!halting || haltingOwner != null && haltingOwner != this.job.owner) continue;
                this.finished = true;
                throw new HaltException(false);
            } while (!command.switches && !this.finished);
        }
        catch (LogoException ex) {
            ex.rethrow(this, command);
        }
    }

    public final void runExclusive() throws LogoException {
        if (this.agent.id == -1) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.procedure.code[this.ip];
                command.checkAgentClass(this.agent);
                command.perform(this);
                if (!halting || haltingOwner != null && haltingOwner != this.job.owner) continue;
                this.finished = true;
                throw new HaltException(false);
            } while (!this.finished);
        }
        catch (LogoException ex) {
            ex.rethrow(this, command);
        }
    }

    public final boolean hasParentContext() {
        boolean bl = false;
        if (this.job.parentContext != null) {
            bl = true;
        }
        return bl;
    }

    public final boolean atTopActivation() {
        boolean bl = false;
        if (this.job.parentContext == null || this.activation != this.job.parentContext.activation) {
            bl = true;
        }
        return bl;
    }

    public final Job makeNewJob() {
        return new Job(this.job.owner, this);
    }

    public final Job makeNewJob(AgentSet agentset, int addr, Agent newMyself) {
        return new Job(this.job.owner, agentset, addr, this, newMyself);
    }

    public final void returnFromProcedure() {
        this.ip = this.activation.returnAddress;
        this.restoreStack();
        this.activation = this.activation.parent;
    }

    public final void restoreStack() {
        while (this.stackSize > this.activation.stackSizeOnEntry) {
            this.stackPop();
        }
    }

    public final Context makeEvaluationContext() {
        Context result = new Context(this.job, null, 0, this.activation, this.agent);
        result.letVars = this.letVars;
        return result;
    }

    public final Object evaluateReporter(Agent agent, Reporter reporter) throws LogoException {
        this.agent = agent;
        return reporter.report(this);
    }

    public final double evaluateDoubleReporter(Agent agent, DoubleReporter reporter) throws LogoException {
        this.agent = agent;
        return reporter.reportDoubleValue(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object callReporterProcedure(ReporterActivation newActivation) throws LogoException {
        boolean oldExclusive = false;
        Command command = null;
        oldExclusive = this.job.exclusive;
        this.job.exclusive = true;
        this.activation = newActivation;
        this.ip = 0;
        try {
            try {
                do {
                    command = this.activation.procedure.code[this.ip];
                    command.checkAgentClass(this.agent);
                    command.perform(this);
                    if (!halting || haltingOwner != null && haltingOwner != this.job.owner) continue;
                    this.finished = true;
                    throw new HaltException(false);
                } while (!this.finished && newActivation.result == null);
            }
            catch (LogoException ex) {
                ex.rethrow(this, command);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.job.exclusive = oldExclusive;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.job.exclusive = oldExclusive;
            this.ip = this.activation.returnAddress;
            this.activation = this.activation.parent;
            return newActivation.result;
        }
    }

    public final void let(Let let, Object value) {
        if (this.letVars == null) {
            this.letVars = new LetMap();
        }
        this.letVars.add(let, this.activation, value);
    }

    public final Object getLet(Let let) {
        Object value;
        if (this.letVars != null && (value = this.letVars.get(let, this.activation)) != null) {
            return value;
        }
        return this.job.parentContext.getLet(let);
    }

    public final void setLet(Let let, Object value) {
        this.setLet(let, this.activation, value);
    }

    private final void setLet(Let let, Activation activation, Object value) {
        if (this.letVars == null || !this.letVars.set(let, activation, value)) {
            this.job.parentContext.setLet(let, value);
        }
    }

    public final String toString() {
        return "Context: ip: " + this.ip + " job: " + this.job;
    }

    final void runtimeError(Exception ex) {
        if (this.ip >= 0 && this.ip < this.activation.procedure.code.length) {
            Instruction instruction = null;
            Context context = null;
            if (ex instanceof LogoException) {
                instruction = ((LogoException)ex).instruction;
                context = ((LogoException)ex).context;
            }
            if (instruction == null) {
                instruction = this.activation.procedure.code[this.ip];
            }
            if (context == null) {
                context = this;
            }
            if (Thread.currentThread() instanceof JobThread) {
                ((JobThread)Thread.currentThread()).jobManagerOwner.runtimeError(this.job.owner, context, instruction, ex);
            }
        } else {
            Exceptions.handle(ex);
        }
    }

    public final String buildRuntimeErrorMessage(Instruction instruction, Throwable throwable) {
        Procedure procedure;
        String exceptionName = "." + throwable.getClass().getName();
        exceptionName = exceptionName.substring(exceptionName.lastIndexOf(46) + 1);
        String instructionName = instruction.displayName();
        String procedureName = "";
        Procedure procedure2 = procedure = this.activation == null ? null : this.activation.procedure;
        if (procedure != null && !procedure.topLevel) {
            procedureName = " in procedure " + procedure.name;
        }
        Activation parentActivation = this.activation == null ? null : this.activation.parent;
        while (parentActivation != null) {
            if (parentActivation.procedure != null) {
                if (parentActivation.procedure.topLevel) break;
                procedureName = procedureName + "\ncalled by procedure " + parentActivation.procedure.name;
            }
            parentActivation = parentActivation.parent;
        }
        String message = throwable instanceof LogoException ? "error while " + this.agent + " executing " + instructionName + procedureName + '\n' + throwable.getMessage() : "error (" + exceptionName + ")\nwhile " + this.agent + " executing " + instructionName + procedureName;
        if (this.job.owner != null) {
            message = message + "\n(halted execution of " + this.job.owner.displayName() + ')';
        }
        return message;
    }

    public final void stackPush(Object item) {
        int stackCapacity;
        int n = 0;
        if (this.stack != null) {
            n = this.stack.length;
        }
        if (this.stackSize >= (stackCapacity = n)) {
            int n2 = 1;
            if (stackCapacity != 0) {
                n2 = 2 * stackCapacity;
            }
            int newCapacity = n2;
            Object[] newStack = new Object[newCapacity];
            if (stackCapacity > 0) {
                System.arraycopy(this.stack, 0, newStack, 0, stackCapacity);
            }
            this.stack = newStack;
        }
        this.stack[this.stackSize++] = item;
    }

    public final Object stackPop() {
        Object result = this.stack[--this.stackSize];
        this.stack[this.stackSize] = null;
        return result;
    }

    public final Object stackPeek() {
        return this.stack[this.stackSize - 1];
    }

    public final String dumpStack() {
        StringBuffer buf = new StringBuffer();
        buf.append("|");
        int j = 0;
        while (this.stack != null && j < this.stack.length) {
            if (this.stack[j] != null) {
                buf.append("{" + this.stack[j] + '}');
            }
            ++j;
        }
        buf.append("|");
        return buf.toString();
    }

    public final Object stackPeek(Class c) {
        int j = this.stackSize - 1;
        while (j >= 0) {
            if (c.isInstance(this.stack[j])) {
                return this.stack[j];
            }
            --j;
        }
        return null;
    }

    public final Context save() {
        try {
            return (Context)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void restore(Context savedContext) {
        this.agent = savedContext.agent;
        this.ip = savedContext.ip;
        this.activation = savedContext.activation;
        this.waiting = savedContext.waiting;
        this.stopping = savedContext.stopping;
        this.finished = savedContext.finished;
        this.scratch = savedContext.scratch;
        this.stack = savedContext.stack;
        this.stackSize = savedContext.stackSize;
    }

    private final /* synthetic */ void this() {
        this.waiting = false;
        this.stopping = false;
        this.finished = false;
        this.stackSize = 0;
    }

    public Context(Job job, Agent agent, int ip, Activation activation, Agent myself) {
        this.this();
        this.job = job;
        this.agent = agent;
        this.ip = ip;
        this.activation = activation;
        this.myself = myself;
    }
}

