/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.io.PrintStream;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Context;

public abstract class Tracer {
    public static final boolean buildWithProfiling = false;
    public static Tracer tracer;
    public static String defaultTracerClass;

    public static Tracer maybeInitializeTracer() {
        if (Boolean.getBoolean("org.nlogo.nvm.enableProfiling")) {
            return Tracer.initializeTracer();
        }
        return null;
    }

    public static Tracer initializeTracer() {
        String traceClas = System.getProperty("org.nlogo.nvm.traceClass", defaultTracerClass);
        return Tracer.initializeTracer(traceClas);
    }

    public static void enableTracer() {
        if (tracer != null) {
            System.out.println("Enabling tracer: " + tracer);
            tracer.enable();
        }
    }

    public static void disableTracer() {
        if (tracer != null) {
            System.out.println("Disabling tracer: " + tracer);
            tracer.disable();
        }
    }

    public static void resetTracer() {
        if (tracer != null) {
            System.out.println("Resetting tracer: " + tracer);
            tracer.reset();
        }
    }

    public static void dumpTracer(PrintStream stream) {
        if (tracer != null) {
            System.out.println("Dumping tracer to stream: " + stream);
            tracer.dump(stream);
        }
    }

    public static void dumpTracer() {
        if (tracer != null) {
            PrintStream stream = System.out;
            System.out.println("Dumping tracer to stream: " + stream);
            tracer.dump(stream);
        }
    }

    public static Tracer initializeTracer(String traceClas) {
        try {
            Class<?> clas = Class.forName(traceClas);
            return Tracer.initializeTracer(clas);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("PROFILER: Cannot find Tracer class [" + traceClas + ']');
            return null;
        }
    }

    public static Tracer initializeTracer(Class traceClas) {
        try {
            tracer = (Tracer)traceClas.newInstance();
        }
        catch (IllegalAccessException ex) {
            System.err.println("PROFILER: " + ex);
            tracer = null;
        }
        catch (InstantiationException ex) {
            System.err.println("PROFILER: " + ex);
            tracer = null;
        }
        return tracer;
    }

    public abstract void enable();

    public abstract void disable();

    public abstract void reset();

    public abstract void dump(PrintStream var1);

    public abstract void openCallRecord(Context var1, Activation var2);

    public abstract void closeCallRecord(Context var1, Activation var2);

    static {
        defaultTracerClass = "org.nlogo.nvm.StreamTracer";
    }
}

