/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.awt.Utils;
import org.nlogo.editor.Colorizer;
import org.nlogo.properties.BigStringEditor;
import org.nlogo.properties.BooleanAccessor;
import org.nlogo.properties.BooleanEditor;
import org.nlogo.properties.CommandsAccessor;
import org.nlogo.properties.CommandsEditor;
import org.nlogo.properties.DoubleAccessor;
import org.nlogo.properties.DoubleEditor;
import org.nlogo.properties.IntegerAccessor;
import org.nlogo.properties.IntegerEditor;
import org.nlogo.properties.KeyAccessor;
import org.nlogo.properties.KeyEditor;
import org.nlogo.properties.LogoListStringEditor;
import org.nlogo.properties.NumberAccessor;
import org.nlogo.properties.NumberEditor;
import org.nlogo.properties.OptionsAccessor;
import org.nlogo.properties.OptionsEditor;
import org.nlogo.properties.PlotPensAccessor;
import org.nlogo.properties.PlotPensEditor;
import org.nlogo.properties.PropertyEditor;
import org.nlogo.properties.ReporterAccessor;
import org.nlogo.properties.ReporterEditor;
import org.nlogo.properties.StringAccessor;
import org.nlogo.properties.StringEditor;
import org.nlogo.properties.VariableNameEditor;
import org.nlogo.properties.WidgetWrapperInterface;
import org.nlogo.swing.OptionDialog;
import org.nlogo.window.Editable;
import org.nlogo.window.PropertyDescription;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class EditView
extends JPanel {
    private final Editable widget;
    private final boolean widgetIsNew;
    private final List propertyEditors;
    private PropertyEditor getsFirstFocus;
    private Dimension originalSize;
    private Dimension originalPreferredSize;
    private Colorizer editorColorizer;

    public void requestFocus() {
        if (this.getsFirstFocus != null) {
            this.getsFirstFocus.requestFocus();
        }
    }

    boolean isResizable() {
        int i = 0;
        while (i < this.propertyEditors.size()) {
            PropertyEditor editor = (PropertyEditor)this.propertyEditors.get(i);
            if (editor instanceof BigStringEditor || editor instanceof CommandsEditor || editor instanceof ReporterEditor) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void changed() {
        if (!(this.widget instanceof Component)) {
            return;
        }
        Component comp = (Component)((Object)this.widget);
        Container parent = comp.getParent();
        if (parent instanceof WidgetWrapperInterface) {
            WidgetWrapperInterface wrapper = (WidgetWrapperInterface)((Object)parent);
            Dimension prefSize = wrapper.getPreferredSize();
            if (this.widgetIsNew) {
                wrapper.setSize(prefSize);
            } else if (!this.originalPreferredSize.equals(prefSize)) {
                int width = StrictMath.max(prefSize.width, this.originalSize.width);
                int height = StrictMath.max(prefSize.height, this.originalSize.height);
                wrapper.setSize(width, height);
            }
        }
    }

    boolean valid() {
        int i = 0;
        while (i < this.propertyEditors.size()) {
            PropertyEditor editor = (PropertyEditor)this.propertyEditors.get(i);
            if (editor.get() == null) {
                if (!editor.handlesOwnErrors()) {
                    String message = "Invalid value for " + editor.name;
                    Object[] options = new String[]{"OK"};
                    OptionDialog.show(Utils.getFrame(this), "Invalid Entry", message, options);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    void apply() {
        int i = 0;
        while (i < this.propertyEditors.size()) {
            PropertyEditor editor = (PropertyEditor)this.propertyEditors.get(i);
            editor.apply();
            ++i;
        }
        this.changed();
    }

    void revert() {
        Component comp;
        Container parent;
        int i = 0;
        while (i < this.propertyEditors.size()) {
            PropertyEditor editor = (PropertyEditor)this.propertyEditors.get(i);
            editor.revert();
            editor.refresh();
            ++i;
        }
        if (this.widget instanceof Component && (parent = (comp = (Component)((Object)this.widget)).getParent()) instanceof WidgetWrapperInterface) {
            WidgetWrapperInterface wrapper = (WidgetWrapperInterface)((Object)parent);
            wrapper.setSize(this.originalSize);
        }
    }

    private final PropertyEditor getEditor(PropertyDescription description, Editable r, EditView editView) {
        if (description.type.equals("BigString")) {
            return new BigStringEditor(editView, new StringAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("Boolean")) {
            return new BooleanEditor(editView, new BooleanAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("Commands")) {
            return new CommandsEditor(editView, new CommandsAccessor(r, description.accessString), description.name, this.editorColorizer);
        }
        if (description.type.equals("Reporter")) {
            return new ReporterEditor(editView, new ReporterAccessor(r, description.accessString), description.name, this.editorColorizer);
        }
        if (description.type.equals("Double")) {
            return new DoubleEditor(editView, new DoubleAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("Options")) {
            return new OptionsEditor(editView, new OptionsAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("Integer")) {
            return new IntegerEditor(editView, new IntegerAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("Key")) {
            return new KeyEditor(editView, new KeyAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("Number")) {
            return new NumberEditor(editView, new NumberAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("PlotPens")) {
            return new PlotPensEditor(editView, new PlotPensAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("String")) {
            return new StringEditor(editView, new StringAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("VariableName")) {
            return new VariableNameEditor(editView, new StringAccessor(r, description.accessString), description.name);
        }
        if (description.type.equals("LogoListString")) {
            return new LogoListStringEditor(editView, new StringAccessor(r, description.accessString), description.name);
        }
        throw new RuntimeException("unknown editor class: " + description.type);
    }

    private final /* synthetic */ void this() {
        this.propertyEditors = new ArrayList();
    }

    EditView(Editable widget, boolean widgetIsNew, boolean liveUpdate, Colorizer editorColorizer) {
        this.this();
        this.widget = widget;
        this.widgetIsNew = widgetIsNew;
        this.editorColorizer = editorColorizer;
        List properties = widget.propertySet();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.getsFirstFocus = null;
        if (widget instanceof Component && ((Component)((Object)widget)).getParent() instanceof WidgetWrapperInterface) {
            WidgetWrapperInterface wrapper = (WidgetWrapperInterface)((Object)((Component)((Object)widget)).getParent());
            this.originalSize = wrapper.getSize();
            this.originalPreferredSize = wrapper.getPreferredSize();
        }
        int i = 0;
        while (i < properties.size()) {
            PropertyDescription description = (PropertyDescription)properties.get(i);
            PropertyEditor editor = this.getEditor(description, widget, this);
            editor.liveUpdate(liveUpdate);
            GridBagConstraints c = editor.getConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.gridwidth = description.gridwidth;
            gridbag.setConstraints(editor, c);
            this.add(editor);
            if (description.notes != null) {
                if (c.gridwidth != 0) {
                    throw new IllegalStateException();
                }
                c.insets = new Insets(0, 3, 6, 3);
                JLabel notesLabel = new JLabel(description.notes);
                notesLabel.setFont(notesLabel.getFont().deriveFont(9.0f));
                gridbag.setConstraints(notesLabel, c);
                this.add(notesLabel);
            }
            this.propertyEditors.add(editor);
            editor.refresh();
            if (description.getsFirstFocus) {
                this.getsFirstFocus = editor;
            }
            ++i;
        }
    }
}

