/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.nlogo.awt.Utils;
import org.nlogo.properties.EditView;
import org.nlogo.properties.PlotPensAccessor;
import org.nlogo.properties.PropertyEditor;
import org.nlogo.swing.ColorSwatch;
import org.nlogo.swing.InputDialog;
import org.nlogo.swing.OptionDialog;
import org.nlogo.swing.TextField;
import org.nlogo.window.graphing.GraphPen;
import org.nlogo.window.graphing.GraphWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class PlotPensEditor
extends PropertyEditor
implements ItemListener,
ActionListener {
    private static final String CUSTOM_COLOR_STRING = "<custom>";
    private static final int CUSTOM_COLOR_INDEX = 0;
    private final JComboBox currentPens;
    private final JComboBox penColors;
    private final ColorSwatch swatch;
    private final TextField intervalField;
    private final JComboBox penModes;
    private final JButton deletePen;
    private final JButton createPen;
    private final JButton renamePen;
    private final JButton customColor;
    private final JCheckBox showPenInLegend;
    private double currentPenInterval;
    private GraphPen currentPen;
    private final JLabel plotPensLabel;
    private final JPanel penPanel;

    Object get() {
        if (this.validInterval()) {
            this.updatePenValues();
            return this.penList();
        }
        return null;
    }

    void set(Object value) {
    }

    private final List penList() {
        ArrayList penList = new ArrayList(this.currentPens.getItemCount());
        int i = 0;
        while (i < this.currentPens.getItemCount()) {
            penList.add(this.currentPens.getItemAt(i));
            ++i;
        }
        return penList;
    }

    private final void updateWidgetValues() {
        this.currentPen = (GraphPen)this.currentPens.getSelectedItem();
        this.intervalField.setText(new Double(this.currentPen.plotInterval()).toString());
        this.updatePenColors(this.currentPen.color());
        this.penModes.setSelectedIndex(this.currentPen.plotPenMode());
        this.showPenInLegend.setSelected(this.currentPen.showInPensLegend());
        this.currentPenInterval = this.currentPen.plotInterval();
        if (this.currentPens.getItemCount() <= 1) {
            this.deletePen.setEnabled(false);
        } else {
            this.deletePen.setEnabled(true);
        }
    }

    private final void updatePenValues() {
        this.currentPen.plotInterval(this.currentPenInterval);
        this.currentPen.plotPenMode(this.penModes.getSelectedIndex());
        this.currentPen.showInPensLegend(this.showPenInLegend.isSelected());
    }

    private final void updatePenColors(Color col) {
        this.swatch.setBackground(col);
        this.swatch.repaint();
        int i = 0;
        while (i < this.penColors.getItemCount()) {
            if (!this.penColors.getItemAt(i).equals(CUSTOM_COLOR_STRING) && col.equals(this.convertColor((String)this.penColors.getItemAt(i)))) {
                this.penColors.setSelectedIndex(i);
                if (this.penColors.getItemAt(0).equals(CUSTOM_COLOR_STRING)) {
                    this.penColors.removeItemAt(0);
                }
                return;
            }
            ++i;
        }
        if (!this.penColors.getItemAt(0).equals(CUSTOM_COLOR_STRING)) {
            this.penColors.insertItemAt(CUSTOM_COLOR_STRING, 0);
        }
        this.penColors.setSelectedIndex(0);
    }

    private final Color convertColor(String colorName) {
        return new Color(org.nlogo.agent.Color.getBaseColor(colorName));
    }

    private final void setColor(Color col) {
        this.swatch.setBackground(col);
        this.swatch.repaint();
        this.currentPen.color(col);
    }

    private final void addPen(String penName) {
        GraphPen gp = new GraphPen();
        gp.displayName(penName);
        this.currentPens.addItem(gp);
        this.currentPens.setSelectedIndex(this.currentPens.getItemCount() - 1);
        this.currentPens.getEditor().selectAll();
    }

    private final void deleteCurrentPen() {
        int index = this.currentPens.getSelectedIndex();
        this.intervalField.setText("1");
        this.currentPens.removeItemAt(index);
        if (this.currentPens.getItemCount() != 0) {
            this.updateWidgetValues();
        } else {
            this.addPen("default");
        }
    }

    private final boolean validInterval() {
        String intervalString = this.intervalField.getText();
        try {
            Double foo = new Double(intervalString);
            this.currentPenInterval = foo;
        }
        catch (NumberFormatException ex) {
            this.showError("Invalid value for the pen interval");
            return false;
        }
        return true;
    }

    private final boolean validName(GraphPen pen, String name) {
        if (name.length() > 0) {
            return this.noOtherPenHasName(pen, name);
        }
        this.showError("Pen names must be at least one character long.");
        return false;
    }

    private final boolean noOtherPenHasName(GraphPen pen, String name) {
        int i = 0;
        while (i < this.currentPens.getItemCount()) {
            GraphPen otherPen = (GraphPen)this.currentPens.getItemAt(i);
            if (name.equals(otherPen.displayName()) && pen != otherPen) {
                this.showError("Another pen has this name.  Please change this pen's name.");
                return false;
            }
            ++i;
        }
        return true;
    }

    private final void showError(String errorMessage) {
        Object[] options = new String[]{"OK"};
        OptionDialog.show(Utils.getFrame(this.editView), "Invalid Entry", errorMessage, options);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource().equals(this.currentPens) && !this.currentPen.equals(this.currentPens.getSelectedItem())) {
                if (this.validInterval()) {
                    this.updatePenValues();
                    this.updateWidgetValues();
                } else {
                    this.currentPens.setSelectedItem(this.currentPen);
                }
            } else if (e.getSource().equals(this.penColors)) {
                String selected = (String)this.penColors.getSelectedItem();
                if (!selected.equals(CUSTOM_COLOR_STRING)) {
                    this.setColor(this.convertColor(selected));
                    if (this.penColors.getItemAt(0).equals(CUSTOM_COLOR_STRING)) {
                        this.penColors.removeItemAt(0);
                    }
                }
            } else if (e.getSource().equals(this.showPenInLegend)) {
                this.showPenInLegend.setSelected(this.showPenInLegend.isSelected());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Color newColor;
        if (e.getSource().equals(this.deletePen)) {
            String message = "Are you sure you want to delete the pen, " + ((GraphPen)this.currentPens.getSelectedItem()).displayName() + '?';
            Object[] options = new String[]{"OK", "Cancel"};
            if (OptionDialog.show(Utils.getFrame(this.editView), "Confirm Delete Pen", message, options) == 0) {
                this.deleteCurrentPen();
                this.currentPens.requestFocus();
            }
        } else if (e.getSource().equals(this.createPen)) {
            if (this.validInterval()) {
                this.updatePenValues();
                String newName = this.getNewPenName(null);
                if (newName != null) {
                    this.addPen(newName.trim());
                }
            }
        } else if (e.getSource().equals(this.renamePen)) {
            String newName = this.getNewPenName((GraphPen)this.currentPens.getSelectedItem());
            if (newName != null) {
                ((GraphPen)this.currentPens.getSelectedItem()).displayName(newName.trim());
                this.currentPens.repaint();
            }
        } else if (e.getSource().equals(this.customColor) && (newColor = JColorChooser.showDialog(Utils.getFrame(this.editView), "Choose Pen Color", this.currentPen.color())) != null) {
            this.setColor(newColor);
            if (!this.penColors.getItemAt(0).equals(CUSTOM_COLOR_STRING)) {
                this.penColors.insertItemAt(CUSTOM_COLOR_STRING, 0);
                this.penColors.setSelectedIndex(0);
            }
        }
    }

    private final String getNewPenName(GraphPen pen) {
        String newName;
        String[] buttons = new String[]{"OK", "Cancel"};
        while ((newName = InputDialog.show(this, "Enter Pen Name", "Enter a name for the pen:", "", buttons)) != null && !this.validName(pen, newName.trim())) {
        }
        return newName;
    }

    private final void addWidgets() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints constraints = this.getConstraints();
        JPanel[] p = new JPanel[5];
        int i = 0;
        while (i < p.length) {
            p[i] = new JPanel();
            p[i].setLayout(new BorderLayout(5, 0));
            ++i;
        }
        constraints.gridy = 0;
        constraints.gridx = 0;
        gridbag.setConstraints(this.plotPensLabel, constraints);
        this.add(this.plotPensLabel);
        this.plotPensLabel.setFont(this.plotPensLabel.getFont().deriveFont(1));
        ++constraints.gridx;
        p[0].add((Component)new JLabel("Choose Pen to Edit"), "West");
        this.currentPens.setSize(this.currentPens.getPreferredSize().width + 5, this.currentPens.getPreferredSize().height);
        p[0].add((Component)this.currentPens, "Center");
        gridbag.setConstraints(p[0], constraints);
        this.add(p[0]);
        ++constraints.gridx;
        constraints.anchor = 10;
        gridbag.setConstraints(this.renamePen, constraints);
        this.add(this.renamePen);
        ++constraints.gridx;
        gridbag.setConstraints(this.deletePen, constraints);
        this.add(this.deletePen);
        ++constraints.gridx;
        gridbag.setConstraints(this.createPen, constraints);
        this.add(this.createPen);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        GridBagConstraints penConstraints = this.getConstraints();
        GridBagLayout penGB = new GridBagLayout();
        this.penPanel.setLayout(penGB);
        penConstraints.gridy = 0;
        penConstraints.gridx = 0;
        penConstraints.anchor = 17;
        p[1].add((Component)new JLabel("Color"), "West");
        p[1].add((Component)this.swatch, "Center");
        p[2].add((Component)p[1], "West");
        p[2].add((Component)this.penColors, "Center");
        penGB.setConstraints(p[2], penConstraints);
        this.penPanel.add(p[2]);
        ++penConstraints.gridx;
        p[3].add((Component)new JLabel("Mode"), "West");
        p[3].add((Component)this.penModes, "Center");
        penGB.setConstraints(p[3], penConstraints);
        this.penPanel.add(p[3]);
        ++penConstraints.gridx;
        p[4].add((Component)new JLabel("Interval"), "West");
        p[4].add((Component)this.intervalField, "Center");
        penGB.setConstraints(p[4], penConstraints);
        this.penPanel.add(p[4]);
        ++penConstraints.gridx;
        penGB.setConstraints(this.showPenInLegend, penConstraints);
        this.penPanel.add(this.showPenInLegend);
        ++penConstraints.gridy;
        penConstraints.gridx = 0;
        penConstraints.anchor = 10;
        penGB.setConstraints(this.customColor, penConstraints);
        this.penPanel.add(this.customColor);
        this.penPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        gridbag.setConstraints(this.penPanel, constraints);
        this.add(this.penPanel);
        this.currentPens.addItemListener(this);
        this.penColors.addItemListener(this);
        this.deletePen.addActionListener(this);
        this.createPen.addActionListener(this);
        this.renamePen.addActionListener(this);
        this.showPenInLegend.addItemListener(this);
        this.customColor.addActionListener(this);
    }

    GridBagConstraints getConstraints() {
        GridBagConstraints c = super.getConstraints();
        c.fill = 2;
        c.weightx = 0.1;
        return c;
    }

    private final /* synthetic */ void this() {
        this.swatch = new ColorSwatch(20, 20);
        this.intervalField = new TextField("", 8);
        this.deletePen = new JButton("Delete");
        this.createPen = new JButton("Create");
        this.renamePen = new JButton("Rename");
        this.customColor = new JButton("Custom Color...");
        this.showPenInLegend = new JCheckBox("Show in Legend", true);
        this.currentPenInterval = 0.0;
        this.plotPensLabel = new JLabel("Plot Pens");
        this.penPanel = new JPanel();
    }

    PlotPensEditor(EditView editView, PlotPensAccessor accessor, String name) {
        super(editView, accessor, name);
        this.this();
        this.handlesOwnErrors(true);
        GraphWidget graphWidget = (GraphWidget)accessor.owner();
        this.currentPens = new JComboBox<Object>(graphWidget.editPlotPens().toArray());
        this.currentPens.setRenderer(new PenRenderer());
        this.penColors = new JComboBox<String>(org.nlogo.agent.Color.getColorNamesArray());
        this.penModes = new JComboBox<Object>(GraphPen.getPlotPenModeNames().toArray());
        this.addWidgets();
        this.updateWidgetValues();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PenRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : ((GraphPen)value).displayName());
            return this;
        }

        public PenRenderer() {
            this.setOpaque(true);
        }
    }
}

