/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nlogo.util.Exceptions;

strictfp abstract class PropertyAccessor {
    abstract Object get();

    abstract void set(Object var1);

    static Method findGetOfType(Class type, Class c, String accessString) {
        Method[] methods = c.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(accessString) && methods[i].getReturnType().equals(type) && methods[i].getParameterTypes().length == 0) {
                return methods[i];
            }
            ++i;
        }
        throw new IllegalStateException(accessString + " get method not found in " + c);
    }

    static Method findSetOfType(Class type, Class c, String accessString) {
        Method[] methods = c.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(accessString) && methods[i].getReturnType().equals(Void.TYPE) && methods[i].getParameterTypes().length == 1 && methods[i].getParameterTypes()[0].equals(type)) {
                return methods[i];
            }
            ++i;
        }
        throw new IllegalStateException(accessString + " set method not found in " + c);
    }

    void invokeSetMethod(Method setMethod, Object owner, Object[] args) {
        try {
            setMethod.invoke(owner, args);
        }
        catch (InvocationTargetException ex) {
            Exceptions.handle(ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.handle(ex);
        }
    }

    Object invokeGetMethod(Method getMethod, Object owner) {
        try {
            return getMethod.invoke(owner, null);
        }
        catch (InvocationTargetException ex) {
            Exceptions.handle(ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.handle(ex);
        }
        return null;
    }

    PropertyAccessor() {
    }
}

