/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.util.StringTokenizer;
import org.nlogo.shapes.Element;
import org.nlogo.util.Exceptions;

public strictfp class Circle
extends Element
implements Cloneable {
    private int x;
    private int y;
    private int xDiameter;
    private int yDiameter;
    private String modifiedPoint;
    private Point top;
    private Point bottom;
    private Point right;
    private Point left;

    private final Point getOrigin() {
        return new Point(this.x + Circle.round(this.xDiameter / 2), this.y + Circle.round(this.yDiameter / 2));
    }

    public void setFilled(boolean fill) {
        this.filled = fill;
    }

    public Object clone() {
        return super.clone();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.xDiameter, this.yDiameter);
    }

    public void modify(Point center, Point circum) {
        double radius = this.distance(center, circum);
        this.x = center.x - Circle.round(radius);
        this.y = center.y - Circle.round(radius);
        this.yDiameter = this.xDiameter = Circle.round((double)2 * radius);
    }

    public void reshapeElement(Point oldPoint, Point newPoint) {
        double change = this.distance(this.getOrigin(), newPoint);
        this.x = this.getOrigin().x - (int)change;
        this.y = this.getOrigin().y - (int)change;
        this.xDiameter = (int)change * 2;
        this.yDiameter = (int)change * 2;
    }

    public void moveElement(Point oldPoint, Point newPoint) {
        this.translate(newPoint.x - oldPoint.x, newPoint.y - oldPoint.y);
    }

    public Point[] getHandles() {
        this.top = new Point(this.x + this.xDiameter / 2, this.y);
        this.left = new Point(this.x, this.y + this.yDiameter / 2);
        this.right = new Point(this.x + this.xDiameter, this.y + this.yDiameter / 2);
        this.bottom = new Point(this.x + this.xDiameter / 2, this.y + this.yDiameter);
        return new Point[]{this.top, this.left, this.right, this.bottom};
    }

    public boolean contains(Point p) {
        Ellipse2D.Double check = new Ellipse2D.Double(this.x, this.y, this.xDiameter, this.yDiameter);
        return check.contains(p.x, p.y);
    }

    public void draw(Graphics g, Color turtleColor) {
        if (this.marked && turtleColor != null) {
            g.setColor(turtleColor);
        } else {
            g.setColor(this.getColor());
        }
        if (this.filled) {
            g.fillOval(this.x, this.y, this.xDiameter, this.yDiameter);
        } else {
            g.drawOval(this.x, this.y, this.xDiameter, this.yDiameter);
        }
    }

    public void rotateLeft() {
        int oldX = this.x;
        this.x = this.y;
        this.y = 300 - oldX - this.yDiameter;
        int oldXDiameter = this.xDiameter;
        this.xDiameter = this.yDiameter;
        this.yDiameter = oldXDiameter;
    }

    public void rotateRight() {
        int oldX = this.x;
        this.x = 300 - this.y - this.xDiameter;
        this.y = oldX;
        int oldXDiameter = this.xDiameter;
        this.xDiameter = this.yDiameter;
        this.yDiameter = oldXDiameter;
    }

    public void flipHorizontal() {
        this.x = 300 - this.x - this.xDiameter;
    }

    public void flipVertical() {
        this.y = 300 - this.y - this.yDiameter;
    }

    public void rotate(Point pivot, int angle) {
        Point newCenter = this.rotatePoint(new Point(this.x + this.xDiameter / 2, this.y + this.yDiameter / 2), pivot, angle);
        this.x = newCenter.x - this.xDiameter / 2;
        this.y = newCenter.y - this.yDiameter / 2;
    }

    public void scale(double xscale, double yscale) {
        this.x = Circle.round((double)this.x * xscale);
        this.y = Circle.round((double)this.y * yscale);
        this.xDiameter = Circle.ceiling((double)this.xDiameter * xscale);
        this.yDiameter = Circle.ceiling((double)this.yDiameter * yscale);
    }

    public void translate(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public String toReadableString() {
        return "Type: Circle, color: " + this.c + ",\n bounds: " + this.getBounds();
    }

    public String toString() {
        return "Circle " + this.c.getRGB() + ' ' + this.filled + ' ' + this.marked + ' ' + this.x + ' ' + this.y + ' ' + this.xDiameter;
    }

    public static Circle parseCircle(String text) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(text);
            tokenizer.nextToken();
            String color = tokenizer.nextToken();
            boolean b1 = new Boolean(tokenizer.nextToken());
            boolean b2 = new Boolean(tokenizer.nextToken());
            int x1 = Integer.valueOf(tokenizer.nextToken());
            int y1 = Integer.valueOf(tokenizer.nextToken());
            int diam = Integer.valueOf(tokenizer.nextToken());
            if (diam == 0) {
                return null;
            }
            Circle circle = new Circle(x1, y1, diam, Color.decode(color));
            circle.setFilled(b1);
            circle.setMarked(b2);
            return circle;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    public void setModifiedPoint(Point modified) {
        if (modified.equals(this.top)) {
            this.modifiedPoint = "top";
        } else if (modified.equals(this.bottom)) {
            this.modifiedPoint = "bottom";
        } else if (modified.equals(this.right)) {
            this.modifiedPoint = "right";
        } else if (modified.equals(this.left)) {
            this.modifiedPoint = "left";
        }
    }

    public Circle() {
    }

    public Circle(Point center, Point circum, Color color) {
        super(color);
        double radius = this.distance(center, circum);
        this.x = center.x - Circle.round(radius);
        this.y = center.y - Circle.round(radius);
        this.yDiameter = this.xDiameter = Circle.round((double)2 * radius);
    }

    public Circle(int x, int y, int xDiameter, Color color) {
        super(color);
        this.x = x;
        this.y = y;
        this.xDiameter = xDiameter;
        this.yDiameter = xDiameter;
    }
}

