/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.nlogo.agent.Shape;
import org.nlogo.shapes.Circle;
import org.nlogo.shapes.Element;
import org.nlogo.shapes.Line;
import org.nlogo.shapes.Polygon;
import org.nlogo.shapes.Rectangle;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class VectorShape
extends Observable
implements Serializable,
Shape,
Cloneable {
    static final long serialVersionUID = 0L;
    private static final int FGR_UNKNOWN = 0;
    private static final int FGR_TRUE = 1;
    private static final int FGR_FALSE = 2;
    private static final Point PIVOT = new Point(150, 150);
    protected List elementList;
    protected String name;
    protected boolean rotatable;
    protected int editableColorIndex;
    private int fgRecolorable;

    public Object clone() {
        VectorShape newShape;
        try {
            newShape = (VectorShape)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        newShape.elementList = new ArrayList();
        Iterator iter = this.elementList.iterator();
        while (iter.hasNext()) {
            newShape.elementList.add(((Element)iter.next()).clone());
        }
        return newShape;
    }

    public List getElements() {
        return this.elementList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setEditableColorIndex(int editableColorIndex) {
        this.editableColorIndex = editableColorIndex;
    }

    public int getEditableColorIndex() {
        return this.editableColorIndex;
    }

    public boolean fgRecolorable() {
        if (this.fgRecolorable == 0) {
            this.fgRecolorable = 2;
            Color editableColor = new Color(org.nlogo.agent.Color.getBaseColor(this.editableColorIndex));
            int n = this.elementList.size();
            int i = 0;
            while (i < n) {
                if (this.element(i).getColor().equals(editableColor)) {
                    this.fgRecolorable = 1;
                    break;
                }
                ++i;
            }
        }
        boolean bl = false;
        if (this.fgRecolorable == 1) {
            bl = true;
        }
        return bl;
    }

    public void markRecolorableElements(Color editableColor, int editableColorIndex) {
        try {
            this.editableColorIndex = editableColorIndex;
            this.fgRecolorable = 2;
            int i = 0;
            while (i < this.elementList.size()) {
                if (this.element(i).getColor().equals(editableColor)) {
                    this.element(i).setMarked(true);
                    this.fgRecolorable = 1;
                } else {
                    this.element(i).setMarked(false);
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
    }

    protected Element element(int i) {
        return (Element)this.elementList.get(i);
    }

    public void remove(Element element) {
        boolean removed = this.elementList.remove(element);
        if (removed) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void changed() {
        this.setChanged();
        this.notifyObservers();
    }

    public void removeLast() {
        if (!this.elementList.isEmpty()) {
            int lastIndex = this.elementList.size() - 1;
            this.elementList.remove(lastIndex);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void removeAll() {
        if (!this.elementList.isEmpty()) {
            this.elementList.clear();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void add(Element element) {
        this.elementList.add(element);
        if (element instanceof Rectangle) {
            ((Rectangle)element).setMaxsAndMins();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void addAtPosition(int index, Element element) {
        this.elementList.add(index, element);
        this.setChanged();
        this.notifyObservers();
    }

    public void rotateLeft() {
        int i = 0;
        while (i < this.elementList.size()) {
            this.element(i).rotateLeft();
            ++i;
        }
    }

    public void rotateRight() {
        int i = 0;
        while (i < this.elementList.size()) {
            this.element(i).rotateRight();
            ++i;
        }
    }

    public void flipHorizontal() {
        int i = 0;
        while (i < this.elementList.size()) {
            this.element(i).flipHorizontal();
            ++i;
        }
    }

    public void flipVertical() {
        int i = 0;
        while (i < this.elementList.size()) {
            this.element(i).flipVertical();
            ++i;
        }
    }

    public void paint(Graphics g, Color turtleColor, int x, int y, double size, int width, int height, int angle) {
        try {
            int newx = (int)((double)x - (size - 1.0) * (double)width / (double)2);
            int newy = (int)((double)y - (size - 1.0) * (double)height / (double)2);
            int i = 0;
            while (i < this.elementList.size()) {
                Element newElement = (Element)this.element(i).clone();
                if (this.isRotatable()) {
                    newElement.rotate(PIVOT, angle);
                }
                newElement.scale((double)width * size / 300.0, (double)height * size / 300.0);
                newElement.translate(newx, newy);
                newElement.draw(g, turtleColor);
                ++i;
            }
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
    }

    public void paint(Graphics g, Color turtleColor, int x, int y, int width, int height, int angle) {
        this.paint(g, turtleColor, x, y, 1.0, width, height, angle);
    }

    public String toReadableString() {
        String ret = "Shape " + this.name + ":\n";
        int i = 0;
        while (i < this.elementList.size()) {
            ret = ret + ((Element)this.elementList.get(i)).toString();
            ++i;
        }
        return ret;
    }

    public String toString() {
        String ret = this.name + '\n' + this.rotatable + '\n' + this.editableColorIndex;
        int i = 0;
        while (i < this.elementList.size()) {
            Element elt = (Element)this.elementList.get(i);
            if (elt.shouldSave()) {
                ret = ret + '\n' + elt.toString();
            }
            ++i;
        }
        return ret;
    }

    public void addElement(String line) {
        Element element = null;
        try {
            if (line.startsWith("Line")) {
                element = Line.parseLine(line);
            } else if (line.startsWith("Rectangle")) {
                element = Rectangle.parseRectangle(line);
            } else if (line.startsWith("Circle")) {
                element = Circle.parseCircle(line);
            } else if (line.startsWith("Polygon")) {
                element = Polygon.parsePolygon(line);
            } else {
                throw new RuntimeException("Invalid shape format in file: " + line);
            }
            if (element != null) {
                this.add(element);
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public static List parseShapes(String[] shapes) {
        try {
            int index = 0;
            ArrayList<VectorShape> ret = new ArrayList<VectorShape>();
            while (shapes.length > index && VectorShape.getString(shapes, index).length() == 0) {
                ++index;
            }
            while (shapes.length > index) {
                VectorShape shape = new VectorShape();
                shape.setName(VectorShape.getString(shapes, index++));
                if (shape.getName().indexOf("StarLogoT") != -1) continue;
                shape.setRotatable(new Boolean(VectorShape.getString(shapes, index++)));
                shape.setEditableColorIndex(new Integer(VectorShape.getString(shapes, index++)));
                while (VectorShape.getString(shapes, index).length() != 0) {
                    shape.addElement(VectorShape.getString(shapes, index++));
                }
                ret.add(shape);
                ++index;
            }
            return ret;
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    private static final String getString(String[] v, int index) {
        try {
            if (v != null && v.length > index) {
                return v[index];
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
        return "";
    }

    private final /* synthetic */ void this() {
        this.elementList = new ArrayList();
        this.name = "";
        this.rotatable = true;
    }

    public VectorShape() {
        this.this();
    }
}

