/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.nlogo.awt.ColumnLayout;
import org.nlogo.shapes.Element;
import org.nlogo.shapes.VectorShape;
import org.nlogo.shapes.editor.ColorCellRenderer;
import org.nlogo.shapes.editor.ManagerDialog;
import org.nlogo.shapes.editor.ShapePreview;
import org.nlogo.shapes.editor.ShapeView;
import org.nlogo.swing.ColorIcon;
import org.nlogo.swing.TextField;
import org.nlogo.swing.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class EditorDialog
extends JDialog
implements Observer {
    private final VectorShape originalShape;
    private final VectorShape shape;
    private final ManagerDialog manager;
    private final ShapeView shapeView;
    private int elementType;
    private Color elementColor;
    private boolean shapeChanged;
    private boolean editingElements;
    private final ShapePreview[] previews;
    private final TextField nameText;
    private final JToggleButton editElements;
    private final JButton deleteSelected;
    private final JButton duplicateSelected;
    private final JButton bringToFront;
    private final JButton sendToBack;
    private final JButton undoButton;
    private UndoableEdit undoableEdit;
    private final JComboBox colorSelection;
    private boolean fillShapes;
    private boolean shapeRotatable;
    private boolean snapToGrid;
    static /* synthetic */ Class class$org$nlogo$shapes$editor$EditorDialog;
    static /* synthetic */ Class class$org$nlogo$shapes$editor$EditorDialog$CreateAction;

    int getElementType() {
        return this.elementType;
    }

    Color getElementColor() {
        return this.elementColor;
    }

    boolean fillShapes() {
        return this.fillShapes;
    }

    boolean isRotatable() {
        return this.shapeRotatable;
    }

    boolean snapToGrid() {
        return this.snapToGrid;
    }

    boolean editingElements() {
        return this.editingElements;
    }

    void setEditingElements(boolean e) {
        this.editingElements = e;
        this.editElements.setSelected(e);
        if (e) {
            this.shapeView.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.shapeView.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public void makeUndoableModification(Element el, int z) {
        this.undoableEdit = new UndoableModification(el, z);
        this.undoButton.setEnabled(this.undoableEdit.canUndo());
    }

    public void makeUndoableDraw(Element el) {
        this.undoableEdit = new UndoableDraw(el);
        this.undoButton.setEnabled(this.undoableEdit.canUndo());
    }

    public void makeUndoableUnfinishedPolygon() {
        this.undoableEdit = new UndoableUnfinishedPolygon();
        this.undoButton.setEnabled(this.undoableEdit.canUndo());
    }

    public void update(Observable o, Object obj) {
        this.shapeChanged = true;
        this.deleteSelected.setEnabled(this.shapeView.hasSelectedElement());
        this.duplicateSelected.setEnabled(this.shapeView.hasSelectedElement());
        this.bringToFront.setEnabled(this.shapeView.hasSelectedElement());
        this.sendToBack.setEnabled(this.shapeView.hasSelectedElement());
    }

    private final void cancel() {
        this.dispose();
    }

    private final void checkForSave() {
        if (!this.shapeChanged) {
            this.dispose();
        } else {
            String message = this.nameText.getText().equals("") ? "Save changes to shape?" : "Save changes to \"" + this.nameText.getText() + "\"?";
            int save = JOptionPane.showConfirmDialog(this, message, "Confirm save", 0);
            if (save == 0) {
                this.saveShape();
            } else if (save == 1) {
                this.dispose();
            }
        }
    }

    private final void saveShape() {
        int overwrite;
        String name;
        if (this.nameText.getText().equals("")) {
            name = JOptionPane.showInputDialog(this, (Object)"Please name your shape:");
            if (name == null) {
                return;
            }
        } else {
            name = this.nameText.getText();
        }
        if ((name = name.toLowerCase()) == null || name.equals("")) {
            return;
        }
        String originalName = this.originalShape.getName();
        if (this.exists(name) && !name.equals(originalName) && (overwrite = JOptionPane.showConfirmDialog(this, "A shape with this name already exists. Overwrite it?", "Confirm overwrite", 0)) != 0) {
            return;
        }
        if (!originalName.equals(name) && !originalName.equals("default")) {
            this.manager.removeShape(this.originalShape);
        }
        VectorShape newShape = this.shape;
        newShape.setName(name);
        newShape.setRotatable(this.shapeRotatable);
        newShape.markRecolorableElements(EditorDialog.getColor(this.shape.getEditableColorIndex()), this.shape.getEditableColorIndex());
        this.manager.addShape(newShape);
        this.dispose();
        this.manager.update();
        this.manager.selectShapeName(name);
    }

    private final boolean exists(String name) {
        Iterator currentNames = this.manager.shapeList.getNames().iterator();
        while (currentNames.hasNext()) {
            if (!name.equals((String)currentNames.next())) continue;
            return true;
        }
        return false;
    }

    private final void setEditableColor() {
        this.shape.setEditableColorIndex(this.colorSelection.getSelectedIndex());
        this.shape.markRecolorableElements(EditorDialog.getColor(this.shape.getEditableColorIndex()), this.shape.getEditableColorIndex());
    }

    private final AbstractButton addToolBarButton(JToolBar toolbar, ButtonGroup group, Action action) {
        JToggleButton newButton = new JToggleButton(action);
        newButton.setText(null);
        toolbar.add(newButton);
        group.add(newButton);
        return newButton;
    }

    static Color getColor(int index) {
        return new Color(org.nlogo.agent.Color.getBaseColor(index));
    }

    private final void setNameEditable(boolean editable) {
        this.nameText.setEnabled(editable);
    }

    static /* synthetic */ boolean access$15(EditorDialog editorDialog) {
        return editorDialog.snapToGrid;
    }

    static /* synthetic */ Color access$21(EditorDialog editorDialog) {
        return editorDialog.elementColor;
    }

    static /* synthetic */ int access$23(EditorDialog editorDialog) {
        return editorDialog.elementType;
    }

    static /* synthetic */ boolean access$25(EditorDialog editorDialog) {
        return editorDialog.fillShapes;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.elementType = -1;
        this.shapeChanged = false;
        this.editingElements = false;
        this.fillShapes = true;
        this.shapeRotatable = true;
        this.snapToGrid = true;
    }

    EditorDialog(ManagerDialog manager, VectorShape originalShape) {
        super((Frame)null, true);
        this.this();
        this.manager = manager;
        this.originalShape = originalShape;
        this.shape = (VectorShape)originalShape.clone();
        this.shape.addObserver(this);
        this.shapeView = new ShapeView(this, this.shape);
        this.shape.addObserver(this.shapeView);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                EditorDialog.this.checkForSave();
            }
        });
        Utils.addEscKeyAction(this, (Action)new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.cancel();
            }
        });
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new ColumnLayout(0, 0.5f, 0.0f));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new ColumnLayout(0, 0.5f, 0.0f));
        JToolBar editingToolBar = new JToolBar();
        editingToolBar.setFloatable(false);
        editingToolBar.setLayout(new GridLayout(4, 2));
        ButtonGroup editingToolGroup = new ButtonGroup();
        Class clazz = class$org$nlogo$shapes$editor$EditorDialog;
        if (clazz == null) {
            clazz = class$org$nlogo$shapes$editor$EditorDialog = EditorDialog.class("[Lorg.nlogo.shapes.editor.EditorDialog;", false);
        }
        this.editElements = new JToggleButton(new ImageIcon(clazz.getResource("/shapes-editor/arrow.gif")), false);
        this.editElements.setToolTipText("Edit elements");
        this.editElements.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.editingElements = EditorDialog.this.editElements.isSelected();
                EditorDialog.this.shapeView.deselectAll();
                EditorDialog.this.deleteSelected.setEnabled(false);
                EditorDialog.this.duplicateSelected.setEnabled(false);
                if (EditorDialog.this.editingElements) {
                    EditorDialog.this.shapeView.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    EditorDialog.this.shapeView.setCursor(Cursor.getPredefinedCursor(1));
                }
                if (EditorDialog.this.shapeView.drawingPolygon()) {
                    EditorDialog.this.shapeView.selfFinishPolygon(true);
                }
            }
        });
        editingToolGroup.add(this.editElements);
        editingToolBar.add(this.editElements);
        this.deleteSelected = new JButton("Delete");
        this.deleteSelected.setEnabled(false);
        this.deleteSelected.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.undoableEdit = new UndoableDeleteEdit(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                EditorDialog.this.undoButton.setEnabled(EditorDialog.this.undoableEdit.canUndo());
                EditorDialog.this.shape.remove(EditorDialog.this.shapeView.getSelectedElement());
                EditorDialog.this.shapeView.deselectAll();
                if (EditorDialog.this.shape.getElements().isEmpty()) {
                    EditorDialog.this.deleteSelected.setEnabled(false);
                    EditorDialog.this.bringToFront.setEnabled(false);
                    EditorDialog.this.sendToBack.setEnabled(false);
                    EditorDialog.this.shape.changed();
                }
            }
        });
        this.duplicateSelected = new JButton("Duplicate");
        this.duplicateSelected.setEnabled(false);
        this.duplicateSelected.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.getSelectedElement() != null) {
                    Element newElement = (Element)EditorDialog.this.shapeView.getSelectedElement().clone();
                    EditorDialog.this.shape.add(newElement);
                    EditorDialog.this.makeUndoableDraw(newElement);
                }
            }
        });
        this.bringToFront = new JButton("Bring to front");
        this.bringToFront.setEnabled(false);
        this.bringToFront.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                EditorDialog.this.shape.remove(EditorDialog.this.shapeView.getSelectedElement());
                EditorDialog.this.shape.add(EditorDialog.this.shapeView.getSelectedElement());
            }
        });
        this.sendToBack = new JButton("Send to back");
        this.sendToBack.setEnabled(false);
        this.sendToBack.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                EditorDialog.this.shape.remove(EditorDialog.this.shapeView.getSelectedElement());
                EditorDialog.this.shape.addAtPosition(0, EditorDialog.this.shapeView.getSelectedElement());
            }
        });
        this.undoButton = new JButton("Undo");
        this.undoButton.setEnabled(false);
        this.undoButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.undoableEdit.undo();
                EditorDialog.this.undoButton.setEnabled(EditorDialog.this.undoableEdit.canUndo());
                EditorDialog.this.shapeView.deselectAll();
            }
        });
        AbstractButton lineButton = this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("line", 101, "Draw lines", false));
        AbstractButton filledRectangleButton = this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("rectangle-filled", 102, "Draw filled rectangles", true));
        AbstractButton rectangleButton = this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("rectangle", 102, "Draw unfilled rectangles", false));
        AbstractButton filledCircleButton = this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("circle-filled", 103, "Draw filled circles", true));
        AbstractButton circleButton = this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("circle", 103, "Draw unfilled circles", false));
        AbstractButton filledPolygonButton = this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("polygon-filled", 105, "Draw filled polygons", true));
        AbstractButton polygonButton = this.addToolBarButton(editingToolBar, editingToolGroup, new CreateAction("polygon", 105, "Draw unfilled polygons", false));
        ArrayList<Integer> colors = new ArrayList<Integer>(16);
        ButtonGroup colorGroup = new ButtonGroup();
        JToolBar colorGrid = new JToolBar();
        colorGrid.setFloatable(false);
        colorGrid.setLayout(new GridLayout(4, 4));
        int icolor = 0;
        while (icolor < 16) {
            String userstr = "Draw in " + org.nlogo.agent.Color.getBaseColorName(icolor);
            AbstractButton button = this.addToolBarButton(colorGrid, colorGroup, new ColorAction(org.nlogo.agent.Color.getBaseColorName(icolor), new Color(org.nlogo.agent.Color.getBaseColor(icolor)), userstr));
            if (icolor == this.shape.getEditableColorIndex()) {
                button.setSelected(true);
            }
            colors.add(new Integer(icolor));
            ++icolor;
        }
        this.colorSelection = new JComboBox<Object>(colors.toArray());
        this.colorSelection.setRenderer(new ColorCellRenderer());
        this.colorSelection.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.setEditableColor();
            }
        });
        final JCheckBox snapToGridButton = new JCheckBox("Snap to grid", true);
        snapToGridButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.snapToGrid = snapToGridButton.isSelected();
            }
        });
        final JCheckBox rotatableButton = new JCheckBox("Rotatable", true);
        rotatableButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.shapeRotatable = rotatableButton.isSelected();
                int i = 0;
                while (i < EditorDialog.this.previews.length) {
                    EditorDialog.this.previews[i].updateRotation(EditorDialog.this.shapeRotatable);
                    ++i;
                }
                EditorDialog.this.shape.setRotatable(EditorDialog.this.shapeRotatable);
                EditorDialog.this.shapeView.repaint();
            }
        });
        JButton rotateLeftButton = new JButton("Rotate Left");
        rotateLeftButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.hasSelectedElement()) {
                    EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                    EditorDialog.this.shapeView.getSelectedElement().rotateLeft();
                } else {
                    EditorDialog.this.undoableEdit = null;
                    EditorDialog.this.undoButton.setEnabled(false);
                    EditorDialog.this.shape.rotateLeft();
                }
                EditorDialog.this.shapeView.repaint();
            }
        });
        JButton rotateRightButton = new JButton("Rotate Right");
        rotateRightButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.hasSelectedElement()) {
                    EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                    EditorDialog.this.shapeView.getSelectedElement().rotateRight();
                } else {
                    EditorDialog.this.undoableEdit = null;
                    EditorDialog.this.undoButton.setEnabled(false);
                    EditorDialog.this.shape.rotateRight();
                }
                EditorDialog.this.shapeView.repaint();
            }
        });
        JButton flipHorizontalButton = new JButton("Flip Horizontal");
        flipHorizontalButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.hasSelectedElement()) {
                    EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                    EditorDialog.this.shapeView.getSelectedElement().flipHorizontal();
                } else {
                    EditorDialog.this.undoableEdit = null;
                    EditorDialog.this.undoButton.setEnabled(false);
                    EditorDialog.this.shape.flipHorizontal();
                }
                EditorDialog.this.shapeView.repaint();
            }
        });
        JButton flipVerticalButton = new JButton("Flip Vertical");
        flipVerticalButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                if (EditorDialog.this.shapeView.hasSelectedElement()) {
                    EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                    EditorDialog.this.shapeView.getSelectedElement().flipVertical();
                } else {
                    EditorDialog.this.undoableEdit = null;
                    EditorDialog.this.undoButton.setEnabled(false);
                    EditorDialog.this.shape.flipVertical();
                }
                EditorDialog.this.shapeView.repaint();
            }
        });
        leftPanel.add(editingToolBar);
        leftPanel.add(snapToGridButton);
        leftPanel.add(colorGrid);
        leftPanel.add(Box.createVerticalStrut(10));
        leftPanel.add(new JLabel("Color that changes:"));
        leftPanel.add(Box.createVerticalStrut(3));
        leftPanel.add(this.colorSelection);
        leftPanel.add(this.deleteSelected);
        leftPanel.add(this.duplicateSelected);
        leftPanel.add(this.bringToFront);
        leftPanel.add(this.sendToBack);
        leftPanel.add(this.undoButton);
        leftPanel.add(rotatableButton);
        rightPanel.add(rotateLeftButton);
        rightPanel.add(rotateRightButton);
        rightPanel.add(flipHorizontalButton);
        rightPanel.add(flipVerticalButton);
        JLabel nameLabel = new JLabel("Name");
        this.nameText = new TextField(4);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.cancel();
            }
        });
        JButton done = new JButton("Done");
        done.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                EditorDialog.this.saveShape();
            }
        });
        this.previews = new ShapePreview[5];
        this.previews[0] = new ShapePreview(this.shape, 9, 5);
        this.previews[1] = new ShapePreview(this.shape, 12, -4);
        this.previews[2] = new ShapePreview(this.shape, 20, 3);
        this.previews[3] = new ShapePreview(this.shape, 30, -2);
        this.previews[4] = new ShapePreview(this.shape, 50, 1);
        int i = 0;
        while (i < this.previews.length) {
            this.shape.addObserver(this.previews[i]);
            ++i;
        }
        int borderWidth = 10;
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BoxLayout(previewPanel, 0));
        int i2 = 0;
        while (i2 < this.previews.length) {
            previewPanel.add(this.previews[i2]);
            ++i2;
        }
        JPanel graphicPanel = new JPanel();
        graphicPanel.setLayout(new BoxLayout(graphicPanel, 1));
        graphicPanel.add(this.shapeView);
        graphicPanel.add(previewPanel);
        JPanel drawingPanel = new JPanel();
        drawingPanel.setLayout(new BoxLayout(drawingPanel, 0));
        drawingPanel.add(Box.createHorizontalStrut(borderWidth));
        drawingPanel.add(leftPanel);
        drawingPanel.add(Box.createHorizontalStrut(15));
        drawingPanel.add(graphicPanel);
        drawingPanel.add(Box.createHorizontalStrut(15));
        drawingPanel.add(rightPanel);
        drawingPanel.add(Box.createHorizontalStrut(borderWidth));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalStrut(borderWidth));
        buttonPanel.add(nameLabel);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this.nameText);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(cancel);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(done);
        buttonPanel.add(Box.createHorizontalStrut(borderWidth));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(Box.createVerticalStrut(borderWidth));
        this.getContentPane().add(drawingPanel);
        this.getContentPane().add(Box.createVerticalStrut(15));
        this.getContentPane().add(buttonPanel);
        this.getContentPane().add(Box.createVerticalStrut(borderWidth));
        this.nameText.setText(this.shape.getName());
        this.shapeRotatable = this.shape.isRotatable();
        rotatableButton.setSelected(this.shapeRotatable);
        i2 = 0;
        while (i2 < this.previews.length) {
            this.previews[i2].updateRotation(this.shapeRotatable);
            ++i2;
        }
        this.colorSelection.setSelectedIndex(this.shape.getEditableColorIndex());
        this.elementColor = EditorDialog.getColor(this.shape.getEditableColorIndex());
        this.setLocation(manager.getLocation().x + 10, manager.getLocation().y + 10);
        if (this.shape.getName().equals("")) {
            this.setTitle("Editing (new shape)");
        } else {
            this.setTitle("Editing \"" + this.shape.getName() + '\"');
            if (this.shape.getName().equals("default")) {
                this.setNameEditable(false);
            }
        }
        this.pack();
        this.nameText.requestFocus();
        this.setEditingElements(true);
        this.setVisible(true);
        this.shape.changed();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class UndoableModification
    extends AbstractUndoableEdit {
        private final Element originalElement;
        private final Element modifiedElement;
        private final int zOrder;

        public void undo() {
            super.undo();
            EditorDialog.this.shape.remove(this.modifiedElement);
            EditorDialog.this.shape.addAtPosition(this.zOrder, this.originalElement);
            if (EditorDialog.this.shapeView.hasSelectedElement()) {
                EditorDialog.this.shapeView.selectElement(this.originalElement);
            }
        }

        public UndoableModification(Element el, int zOrder) {
            this.originalElement = (Element)el.clone();
            this.modifiedElement = el;
            this.zOrder = zOrder;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class UndoableDraw
    extends AbstractUndoableEdit {
        private final Element newElement;

        public void undo() {
            super.undo();
            EditorDialog.this.shape.remove(this.newElement);
        }

        public UndoableDraw(Element newElement) {
            this.newElement = newElement;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class UndoableUnfinishedPolygon
    extends AbstractUndoableEdit {
        public void undo() {
            super.undo();
            EditorDialog.this.shapeView.setTempElement(null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class CreateAction
    extends AbstractAction {
        private final int typeID;
        private final boolean filled;

        public void actionPerformed(ActionEvent e) {
            if (EditorDialog.this.shapeView.drawingPolygon()) {
                EditorDialog.this.shapeView.selfFinishPolygon(true);
            }
            EditorDialog.this.elementType = this.typeID;
            EditorDialog.this.fillShapes = this.filled;
            EditorDialog.this.editingElements = false;
            EditorDialog.this.shapeView.deselectAll();
            EditorDialog.this.shapeView.setCursor(Cursor.getPredefinedCursor(1));
        }

        CreateAction(String name, int typeID, String toolTip, boolean filled) {
            super(name);
            this.typeID = typeID;
            this.filled = filled;
            Class clazz = class$org$nlogo$shapes$editor$EditorDialog$CreateAction;
            if (clazz == null) {
                clazz = class$org$nlogo$shapes$editor$EditorDialog$CreateAction = EditorDialog.class("[Lorg.nlogo.shapes.editor.EditorDialog$CreateAction;", false);
            }
            this.putValue("SmallIcon", new ImageIcon(clazz.getResource("/shapes-editor/" + name + ".gif")));
            if (toolTip != null) {
                this.putValue("ShortDescription", toolTip);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class ColorAction
    extends AbstractAction {
        private final Color color;

        public void actionPerformed(ActionEvent e) {
            EditorDialog.this.elementColor = this.color;
            if (EditorDialog.this.editingElements && EditorDialog.this.shapeView.getSelectedElement() != null) {
                EditorDialog.this.makeUndoableModification(EditorDialog.this.shapeView.getSelectedElement(), EditorDialog.this.shape.getElements().indexOf(EditorDialog.this.shapeView.getSelectedElement()));
                EditorDialog.this.shapeView.getSelectedElement().setColor(this.color);
                EditorDialog.this.shapeView.repaint();
            }
        }

        ColorAction(String name, Color color, String toolTip) {
            super(name);
            this.color = color;
            this.putValue("SmallIcon", new ColorIcon(color, 13, 13));
            if (toolTip != null) {
                this.putValue("ShortDescription", toolTip);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class UndoableDeleteEdit
    extends AbstractUndoableEdit {
        private final Element deletedElement;
        private final int zOrder;

        public void undo() {
            super.undo();
            EditorDialog.this.shape.addAtPosition(this.zOrder, this.deletedElement);
        }

        public UndoableDeleteEdit(Element el, int zOrder) {
            this.deletedElement = (Element)el.clone();
            this.zOrder = zOrder;
        }
    }
}

