/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.nlogo.agent.ShapeList;
import org.nlogo.shapes.VectorShape;
import org.nlogo.shapes.editor.ManagerDialog;
import org.nlogo.shapes.editor.ShapeCellRenderer;
import org.nlogo.swing.Utils;
import org.nlogo.util.Exceptions;

strictfp class ImportDialog
extends JDialog {
    final ManagerDialog manager;
    List foreignShapes;
    final JList list;
    DefaultListModel listModel;

    void display(String[] strings) {
        this.listModel.clear();
        List importedShapes = VectorShape.parseShapes(strings);
        if (importedShapes == null) {
            this.dispose();
            return;
        }
        this.foreignShapes = ShapeList.sortShapes(importedShapes);
        if (this.foreignShapes == null) {
            this.dispose();
        } else {
            Iterator iter = this.foreignShapes.iterator();
            while (iter.hasNext()) {
                this.listModel.addElement(((VectorShape)iter.next()).getName());
            }
            this.setVisible(true);
        }
    }

    private final void importSelectedShapes() {
        try {
            Object[] choices = new Object[]{"Overwrite", "Rename", "Cancel"};
            int[] selected = this.list.getSelectedIndices();
            int i = 0;
            while (i < selected.length) {
                VectorShape shape = (VectorShape)this.foreignShapes.get(selected[i]);
                while (this.manager.shapeList.exists(shape.getName())) {
                    int choice = JOptionPane.showOptionDialog(this, "A shape with the name \"" + shape.getName() + "\" already exists in this model.\nYou can either overwrite the existing one or rename the imported one.", "Name conflict", 1, 2, null, choices, choices[0]);
                    if (choice == 0) {
                        this.manager.addShape(shape);
                        break;
                    }
                    if (choice == 1) {
                        String name = JOptionPane.showInputDialog(this, (Object)"Please rename the shape you are importing:");
                        if (name == null) continue;
                        shape.setName(name);
                        continue;
                    }
                    return;
                }
                this.manager.addShape(shape);
                ++i;
            }
            this.manager.update();
            this.manager.selectShapeName("default");
            this.dispose();
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
    }

    void sendImportWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Problem Importing", 2);
    }

    ImportDialog(Frame frame, ManagerDialog manager) {
        super(frame, "Select shapes to import", true);
        this.manager = manager;
        this.list = new JList();
        this.list.setVisibleRowCount(15);
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        this.list.setFixedCellHeight(34);
        this.list.setCellRenderer(new ShapeCellRenderer(this));
        JButton importButton = new JButton("Import");
        importButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                ImportDialog.this.importSelectedShapes();
            }
        });
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public final void actionPerformed(ActionEvent e) {
                ImportDialog.this.dispose();
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        Utils.addEscKeyAction(this, (Action)cancelAction);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        panel.add(cancelButton);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(importButton);
        panel.add(Box.createHorizontalStrut(5));
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)panel, "South");
        this.pack();
        this.setLocation(manager.getLocation().x + 10, manager.getLocation().y + 10);
    }
}

