/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import org.nlogo.agent.ShapeList;
import org.nlogo.agent.World;
import org.nlogo.awt.ColumnLayout;
import org.nlogo.awt.Utils;
import org.nlogo.shapes.ShapesManagerInterface;
import org.nlogo.shapes.VectorShape;
import org.nlogo.shapes.editor.EditorDialog;
import org.nlogo.shapes.editor.ImportDialog;
import org.nlogo.shapes.editor.ShapeCellRenderer;
import org.nlogo.swing.FileDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.FileIO;
import org.nlogo.util.UserCancelException;
import org.nlogo.workspace.ModelReader;

public strictfp class ManagerDialog
extends JDialog
implements ListSelectionListener,
ShapesManagerInterface {
    final ShapeList shapeList;
    private final Frame parentFrame;
    private final World world;
    private final ShapeChangeListener shapeChangeListener;
    private ImportDialog importDialog;
    List shapes;
    private JList list;
    private DefaultListModel listModel;
    private JScrollPane scrollPane;
    private JButton editButton;
    private JButton deleteButton;
    private JButton newButton;
    private JButton importButton;
    private JButton libraryButton;
    private JButton copyButton;

    public void init() {
        this.update();
        this.selectShapeName("default");
        this.setTitle("Shapes in this model:");
        this.setVisible(true);
    }

    public void update() {
        this.listModel.clear();
        this.shapes = this.shapeList.getShapes();
        Iterator iter = this.shapes.iterator();
        while (iter.hasNext()) {
            this.listModel.addElement(((VectorShape)iter.next()).getName());
        }
    }

    public void selectShapeName(String name) {
        int index = -1;
        while (++index < this.listModel.size()) {
            if (((String)this.listModel.elementAt(index)).equals(name)) break;
        }
        this.list.addSelectionInterval(index, index);
    }

    void selectShapeIndex(int index) {
        this.list.addSelectionInterval(index, index);
    }

    public void valueChanged(ListSelectionEvent e) {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length != 1) {
            this.editButton.setEnabled(false);
            this.copyButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.copyButton.setEnabled(true);
        }
        if (selected.length == 1 && ((String)this.listModel.elementAt(selected[0])).equals("default")) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
    }

    private final void newShape() {
        new EditorDialog(this, new VectorShape());
    }

    private final void editShape() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length == 1) {
            new EditorDialog(this, (VectorShape)this.shapes.get(selected[0]));
        }
    }

    void copyShape() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length == 1) {
            VectorShape newShape = (VectorShape)((VectorShape)this.shapes.get(selected[0])).clone();
            newShape.setName("");
            new EditorDialog(this, newShape);
        }
    }

    private final void deleteShapes() {
        int delete;
        int[] selected = this.list.getSelectedIndices();
        if (selected.length > 1) {
            delete = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete these " + selected.length + " shapes?", "Confirm delete", 0);
        } else if (selected.length == 1) {
            delete = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this shape?", "Confirm delete", 0);
        } else {
            return;
        }
        if (delete != 0) {
            return;
        }
        int i = 0;
        while (i < selected.length) {
            if (((VectorShape)this.shapes.get(selected[i])).getName().equals("default")) {
                this.deleteButton.setEnabled(false);
            } else {
                this.removeShape((VectorShape)this.shapes.get(selected[i]));
            }
            ++i;
        }
        i = selected.length - 1;
        while (i >= 0) {
            if (!((VectorShape)this.shapes.get(selected[i])).getName().equals("default")) {
                this.shapes.remove(selected[i]);
                this.listModel.remove(selected[i]);
            }
            --i;
        }
        this.selectShapeIndex(selected[0] >= this.shapes.size() ? selected[0] - 1 : selected[0]);
        this.editButton.setEnabled(true);
    }

    void addShape(VectorShape shape) {
        if (shape != null) {
            VectorShape replacedShape = (VectorShape)this.shapeList.addNewShape(shape);
            if (this.shapeChangeListener != null) {
                this.shapeChangeListener.shapeChanged(replacedShape == null ? shape : replacedShape);
            }
        }
    }

    void removeShape(VectorShape shape) {
        VectorShape removedShape = (VectorShape)this.shapeList.removeShape(shape);
        if (removedShape != null) {
            this.world.removeFromBreedShapes(shape.getName());
            if (this.shapeChangeListener != null) {
                this.shapeChangeListener.shapeChanged(removedShape);
            }
        }
    }

    private final void importFromLibrary() {
        try {
            this.importDialog = new ImportDialog(this.parentFrame, this);
            String[] defaultShapes = org.nlogo.util.Utils.getResourceAsStringArray("/system/defaultShapes.txt");
            String[] libraryShapes = org.nlogo.util.Utils.getResourceAsStringArray("/system/libraryShapes.txt");
            String[] mergedShapes = new String[defaultShapes.length + 1 + libraryShapes.length];
            System.arraycopy(defaultShapes, 0, mergedShapes, 0, defaultShapes.length);
            mergedShapes[defaultShapes.length] = "";
            System.arraycopy(libraryShapes, 0, mergedShapes, defaultShapes.length + 1, libraryShapes.length);
            this.importDialog.display(mergedShapes);
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
    }

    private final void importFromModel() {
        this.importDialog = new ImportDialog(this.parentFrame, this);
        try {
            String name = FileDialog.show(this.parentFrame, "Import shapes from model", 0);
            Map map = ModelReader.parseString(FileIO.file2String(name));
            if (map != null && map.get(ModelReader.VERSION) != null && ((String[])map.get(ModelReader.VERSION)).length > 0 && ModelReader.parseVersion(map).startsWith("NetLogo")) {
                String[] shapesV = (String[])map.get(ModelReader.SHAPES);
                if (shapesV != null) {
                    if (shapesV.length == 0) {
                        this.importDialog.sendImportWarning("The model you selected has no shapes.");
                    } else {
                        this.importDialog.display(shapesV);
                    }
                }
            } else {
                this.importDialog.sendImportWarning("The file you selected is not a valid NetLogo model.");
            }
        }
        catch (UserCancelException e) {
            Exceptions.ignore(e);
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
    }

    public ManagerDialog(Frame parentFrame, World world, ShapeChangeListener shapeChangeListener) {
        super(parentFrame);
        this.parentFrame = parentFrame;
        this.world = world;
        this.shapeChangeListener = shapeChangeListener;
        this.shapeList = world.shapeList;
        this.list = new JList();
        this.list.setVisibleRowCount(10);
        this.listModel = new DefaultListModel();
        this.list.setModel(this.listModel);
        this.list.setCellRenderer(new ShapeCellRenderer(this));
        this.list.setFixedCellHeight(34);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new MouseInputAdapter(){

            public final void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ManagerDialog.this.editShape();
                }
            }
        });
        this.importButton = new JButton("Import from model...");
        this.importButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                ManagerDialog.this.importFromModel();
            }
        });
        this.libraryButton = new JButton("Import from library...");
        this.libraryButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                ManagerDialog.this.importFromLibrary();
            }
        });
        this.editButton = new JButton("Edit");
        this.editButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                ManagerDialog.this.editShape();
            }
        });
        this.newButton = new JButton("New");
        this.newButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                ManagerDialog.this.newShape();
            }
        });
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                ManagerDialog.this.deleteShapes();
            }
        });
        AbstractAction cancelAction = new AbstractAction("Done"){

            public final void actionPerformed(ActionEvent e) {
                ManagerDialog.this.dispose();
            }
        };
        org.nlogo.swing.Utils.addEscKeyAction(this, (Action)cancelAction);
        this.copyButton = new JButton("Copy");
        this.copyButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                ManagerDialog.this.copyShape();
            }
        });
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.add(Box.createHorizontalGlue());
        panel1.add(Box.createHorizontalStrut(20));
        panel1.add(this.newButton);
        panel1.add(Box.createHorizontalStrut(5));
        panel1.add(this.editButton);
        panel1.add(Box.createHorizontalStrut(5));
        panel1.add(this.copyButton);
        panel1.add(Box.createHorizontalStrut(5));
        panel1.add(this.deleteButton);
        panel1.add(Box.createHorizontalStrut(20));
        panel1.add(Box.createHorizontalGlue());
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 0));
        panel2.add(Box.createHorizontalGlue());
        panel2.add(Box.createHorizontalStrut(20));
        panel2.add(this.libraryButton);
        panel2.add(Box.createHorizontalStrut(5));
        panel2.add(this.importButton);
        panel2.add(Box.createHorizontalStrut(20));
        panel2.add(Box.createHorizontalGlue());
        JPanel panel3 = new JPanel();
        panel3.setLayout(new ColumnLayout(3, 0.5f, 0.0f));
        panel3.add(panel1);
        panel3.add(panel2);
        JLabel label = new JLabel("(many more shapes are available by importing from the library)", 0);
        label.setFont(new Font(Utils.platformFont(), 0, 10));
        panel3.add(label);
        this.scrollPane = new JScrollPane(this.list);
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)panel3, "South");
        this.pack();
        Rectangle maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setLocation(maxBounds.x + maxBounds.width / 3, maxBounds.y + maxBounds.height / 3);
    }

    public static interface ShapeChangeListener {
        public void shapeChanged(VectorShape var1);
    }
}

