/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.nlogo.awt.Utils;
import org.nlogo.shapes.Element;
import org.nlogo.shapes.VectorShape;
import org.nlogo.shapes.editor.EditorDialog;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class ShapePreview
extends JPanel
implements Observer {
    private int rotationAngle;
    private int rotationSpeed;
    private boolean stopRotation;
    private int scale;
    private final VectorShape shape;
    Timer timer;
    private int colorNumber;

    public Dimension getPreferredSize() {
        return new Dimension(60, 78);
    }

    public Dimension getMinimumSize() {
        return new Dimension(60, 78);
    }

    public Dimension getMaximumSize() {
        return new Dimension(60, 78);
    }

    public void update(Observable o, Object rect) {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintComponent(Graphics g) {
        int x;
        super.paintComponent(g);
        int y = x = Element.round(0.5 * (double)this.getWidth() - 0.5 * (double)this.scale);
        g.setColor(Color.BLACK);
        g.fillRect(x, y, this.scale, this.scale);
        g.setFont(new Font(Utils.platformFont(), 0, 10));
        g.drawString(Integer.toString(this.scale), (this.getWidth() - g.getFontMetrics().stringWidth(Integer.toString(this.scale))) / 2, y + this.scale + g.getFontMetrics().getHeight() + 2);
        g.clipRect(x, y, this.scale, this.scale);
        VectorShape vectorShape = this.shape;
        synchronized (vectorShape) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.shape.paint(g, new Color(org.nlogo.agent.Color.computeColor(this.colorNumber)), x, y, this.scale, this.scale, this.rotationAngle);
            this.shape.setRotatable(true);
            return;
        }
    }

    void updateRotation(boolean rotatable) {
        this.stopRotation = rotatable ^ true;
    }

    public void addNotify() {
        super.addNotify();
        this.timer.start();
    }

    public void removeNotify() {
        this.timer.stop();
        super.removeNotify();
    }

    private final int newColorNumber() {
        return 5 + 10 * (int)((long)StrictMath.floor(System.currentTimeMillis() / 200L) % 14L);
    }

    private final void rotate() {
        int lastColorNumber = this.colorNumber;
        this.colorNumber = this.newColorNumber();
        if (this.colorNumber != lastColorNumber) {
            this.shape.markRecolorableElements(EditorDialog.getColor(this.shape.getEditableColorIndex()), this.shape.getEditableColorIndex());
            this.repaint();
        }
        if (!this.stopRotation || this.rotationAngle != 0) {
            int fastSpeed;
            int newRotationAngle;
            this.rotationAngle = this.stopRotation ? ((newRotationAngle = (this.rotationAngle + (fastSpeed = this.rotationSpeed > 0 ? 16 : -16) + 360) % 360) - this.rotationAngle != fastSpeed ? 0 : newRotationAngle) : (this.rotationAngle + this.rotationSpeed + 360) % 360;
            this.repaint();
        }
    }

    private final /* synthetic */ void this() {
        this.stopRotation = false;
        this.timer = new Timer(30, new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                ShapePreview.this.rotate();
            }
        });
        this.colorNumber = -1;
    }

    ShapePreview(VectorShape shape, int scale, int rotationSpeed) {
        this.this();
        this.shape = shape;
        this.scale = scale;
        this.rotationSpeed = rotationSpeed;
        this.rotationAngle = 0;
        this.setBackground(Color.DARK_GRAY);
    }
}

