/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shapes.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.nlogo.shapes.Circle;
import org.nlogo.shapes.Element;
import org.nlogo.shapes.Line;
import org.nlogo.shapes.Polygon;
import org.nlogo.shapes.Rectangle;
import org.nlogo.shapes.VectorShape;
import org.nlogo.shapes.editor.EditorDialog;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class ShapeView
extends JPanel
implements Observer {
    private final VectorShape shape;
    private final EditorDialog editorDialog;
    private Point start;
    private Point last;
    private Point previous;
    private Element tempElement;
    private Element selectedElement;
    private Point[] handles;
    private boolean draggingHandle;
    private boolean draggingElement;
    private boolean drawingPolygon;
    private int handleIndex;
    private Point originalHandle;
    private double gridGapX;
    private double gridGapY;

    public int getHandleIndex() {
        return this.handleIndex;
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public boolean hasSelectedElement() {
        boolean bl = false;
        if (this.selectedElement != null) {
            bl = true;
        }
        return bl;
    }

    public boolean drawingPolygon() {
        return this.drawingPolygon;
    }

    public void setDrawingPolygon(boolean drawing) {
        this.drawingPolygon = drawing;
    }

    public void selectElement(Element el) {
        this.selectedElement = el;
        el.select();
    }

    public void setTempElement(Element el) {
        this.tempElement = el;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public Dimension getMinimumSize() {
        return new Dimension(300, 300);
    }

    public Dimension getMaximumSize() {
        return new Dimension(300, 300);
    }

    public void update(Observable o, Object rect) {
        if (rect == null) {
            this.repaint();
        } else {
            this.repaint((java.awt.Rectangle)rect);
        }
    }

    public void snapPointToGrid(Point pointToChange) {
        double clickedGridX = (double)((int)(pointToChange.getX() / this.gridGapX)) * this.gridGapX;
        double clickedGridY = (double)((int)(pointToChange.getY() / this.gridGapY)) * this.gridGapY;
        if (pointToChange.getX() < clickedGridX + this.gridGapX / (double)2) {
            if (pointToChange.getY() < clickedGridY + this.gridGapY / (double)2) {
                pointToChange.setLocation(clickedGridX, clickedGridY);
            } else {
                pointToChange.setLocation(clickedGridX, clickedGridY + this.gridGapY);
            }
        } else if (pointToChange.getY() < clickedGridY + this.gridGapY / (double)2) {
            pointToChange.setLocation(clickedGridX + this.gridGapX, clickedGridY);
        } else {
            pointToChange.setLocation(clickedGridX + this.gridGapX, clickedGridY + this.gridGapY);
        }
    }

    public void selfFinishPolygon(boolean add) {
        if (this.tempElement instanceof Polygon) {
            ((Polygon)this.tempElement).selfClose();
            this.tempElement.setFilled(this.editorDialog.fillShapes());
            this.editorDialog.makeUndoableDraw(this.tempElement);
            if (add) {
                this.shape.add(this.tempElement);
            }
            this.drawingPolygon = false;
            this.tempElement = null;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        java.awt.Rectangle bounds = this.getBounds();
        List elements = this.shape.getElements();
        if (this.editorDialog.isRotatable()) {
            g.setColor(Color.DARK_GRAY);
            g.fillRect(0, 0, bounds.width, bounds.height);
            g.setColor(Color.BLACK);
            g.fillOval(0, 0, bounds.width, bounds.height);
        }
        this.gridGapX = (double)bounds.width / 20.0;
        this.gridGapY = (double)bounds.height / 20.0;
        g.setColor(Color.DARK_GRAY);
        int i = 1;
        while (i < 20) {
            g.drawLine(i * Element.round(this.gridGapX), 0, i * Element.round(this.gridGapX), bounds.height);
            g.drawLine(0, i * Element.round(this.gridGapY), bounds.width, i * Element.round(this.gridGapY));
            ++i;
        }
        g.setColor(Color.GRAY);
        g.drawLine(bounds.width / 2, 0, bounds.width / 2, bounds.height);
        g.drawLine(0, bounds.height / 2, bounds.width, bounds.width / 2);
        g.drawLine(0, 20 * Element.round(this.gridGapY), bounds.width, 20 * Element.round(this.gridGapY));
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        i = 0;
        while (i < elements.size()) {
            Element element = (Element)elements.get(i);
            g.setColor(element.getColor());
            element.draw(g, null);
            ++i;
        }
        if (this.tempElement != null) {
            g.setColor(this.editorDialog.getElementColor());
            this.tempElement.draw(g, null);
        }
        if (this.hasSelectedElement()) {
            this.handles = this.getSelectedElement().getHandles();
            i = 0;
            while (i < this.handles.length) {
                g.setColor(Color.WHITE);
                g.drawRect(this.handles[i].x - 2, this.handles[i].y - 2, 4, 4);
                g.setColor(Color.BLACK);
                g.fillRect(this.handles[i].x - 1, this.handles[i].y - 1, 3, 3);
                ++i;
            }
        }
    }

    int checkHandles(Point start) {
        int i = 0;
        while (i < this.handles.length) {
            if (start.x < this.handles[i].x + 3 && start.x > this.handles[i].x - 3 && start.y < this.handles[i].y + 3 && start.y > this.handles[i].y - 3) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void selectHandle(int index, Element lastElement) {
        this.draggingHandle = true;
        this.handleIndex = index;
        lastElement.setModifiedPoint(this.handles[index]);
        this.editorDialog.makeUndoableModification(this.selectedElement, this.shape.getElements().indexOf(this.selectedElement));
    }

    void deselectAll() {
        int i = 0;
        while (i < this.shape.getElements().size()) {
            ((Element)this.shape.getElements().get(i)).deselect();
            ++i;
        }
        this.selectedElement = null;
        this.shape.changed();
        this.repaint();
    }

    private final void checkElements(Point start) {
        int i = this.shape.getElements().size() - 1;
        while (i >= 0) {
            int spIndex;
            Element currentElement = (Element)this.shape.getElements().get(i);
            if (this.hasSelectedElement() && (spIndex = this.checkHandles(start)) != -1) {
                this.selectHandle(spIndex, this.selectedElement);
                return;
            }
            if (currentElement.contains(start)) {
                this.draggingElement = true;
                if (this.hasSelectedElement()) {
                    this.selectedElement.deselect();
                }
                currentElement.select();
                this.selectedElement = currentElement;
                this.editorDialog.makeUndoableModification(this.selectedElement, this.shape.getElements().indexOf(this.selectedElement));
                this.shape.changed();
                this.repaint();
                return;
            }
            --i;
        }
        this.deselectAll();
        this.repaint();
    }

    private final void mousePressed(MouseEvent e) {
        this.start = this.last = e.getPoint();
        if (this.editorDialog.editingElements()) {
            this.checkElements(this.start);
        }
        if (this.editorDialog.snapToGrid()) {
            this.snapPointToGrid(this.start);
        }
        if (this.tempElement != null && this.tempElement instanceof Polygon) {
            ((Polygon)this.tempElement).addNewPoint(this.start);
            this.repaint();
        } else if (this.editorDialog.getElementType() == 105) {
            this.tempElement = this.createElement(this.start, this.start);
            this.editorDialog.makeUndoableUnfinishedPolygon();
            this.drawingPolygon = true;
        }
    }

    private final void mouseMoved(MouseEvent e) {
        this.last = e.getPoint();
        if (this.editorDialog.snapToGrid()) {
            this.snapPointToGrid(this.last);
        }
        if (this.tempElement != null && this.tempElement instanceof Polygon) {
            ((Polygon)this.tempElement).modifyPoint(this.last);
            this.repaint();
        }
    }

    private final void mouseDragged(MouseEvent e) {
        this.previous = this.last;
        this.last = e.getPoint();
        if (this.editorDialog.snapToGrid()) {
            this.snapPointToGrid(this.last);
        }
        if (this.editorDialog.editingElements()) {
            if (this.draggingHandle) {
                this.selectedElement.reshapeElement(this.handles[this.handleIndex], this.last);
            } else if (this.draggingElement) {
                this.selectedElement.moveElement(this.previous, this.last);
            }
            this.repaint();
        }
        if (this.editorDialog.getElementType() != 105) {
            if (this.tempElement == null) {
                this.tempElement = this.createElement(this.start, this.last);
            } else {
                this.tempElement.modify(this.start, this.last);
            }
            this.repaint();
        }
    }

    private final void mouseReleased(MouseEvent e) {
        if (this.editorDialog.editingElements()) {
            if (this.draggingHandle) {
                this.draggingHandle = false;
                this.shape.changed();
            } else if (this.draggingElement) {
                this.draggingElement = false;
                this.shape.changed();
            }
        }
        if (!(this.tempElement instanceof Polygon) || e.getClickCount() == 2) {
            if (this.tempElement != null) {
                if (this.tempElement instanceof Polygon) {
                    ((Polygon)this.tempElement).finishUp();
                }
                if (!(this.tempElement instanceof Polygon) || ((Polygon)this.tempElement).getXcoords().size() >= 3) {
                    this.tempElement.setFilled(this.editorDialog.fillShapes());
                    this.shape.add(this.tempElement);
                    this.editorDialog.makeUndoableDraw(this.tempElement);
                    this.tempElement.select();
                    this.selectedElement = this.tempElement;
                    this.editorDialog.setEditingElements(true);
                    this.shape.changed();
                }
                this.drawingPolygon = false;
                this.tempElement = null;
            }
            this.previous = null;
            this.last = null;
            this.start = null;
            this.repaint();
        }
    }

    private final Element createElement(Point start, Point last) {
        if (!this.editorDialog.editingElements()) {
            switch (this.editorDialog.getElementType()) {
                case 101: {
                    return new Line(start, last, this.editorDialog.getElementColor());
                }
                case 102: {
                    return new Rectangle(start, last, this.editorDialog.getElementColor());
                }
                case 103: {
                    return new Circle(start, last, this.editorDialog.getElementColor());
                }
                case 105: {
                    return new Polygon(start, this.editorDialog.getElementColor());
                }
            }
            return null;
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.selectedElement = null;
        this.draggingHandle = false;
        this.draggingElement = false;
        this.drawingPolygon = false;
        this.gridGapX = (double)this.getBounds().width / 20.0;
        this.gridGapY = (double)this.getBounds().height / 20.0;
    }

    ShapeView(EditorDialog editorDialog, VectorShape shape) {
        this.this();
        this.editorDialog = editorDialog;
        this.shape = shape;
        this.setBackground(Color.BLACK);
        this.setCursor(Cursor.getPredefinedCursor(1));
        MouseInputAdapter handler = new MouseInputAdapter(){

            public final void mousePressed(MouseEvent e) {
                ShapeView.this.mousePressed(e);
            }

            public final void mouseMoved(MouseEvent e) {
                ShapeView.this.mouseMoved(e);
            }

            public final void mouseDragged(MouseEvent e) {
                ShapeView.this.mouseDragged(e);
            }

            public final void mouseReleased(MouseEvent e) {
                ShapeView.this.mouseReleased(e);
            }
        };
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
    }
}

