/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JFileChooser;
import net.roydesign.ui.FolderDialog;
import org.nlogo.awt.Utils;
import org.nlogo.util.UserCancelException;

public strictfp class FileDialog {
    private static String currentDirectory = org.nlogo.util.Utils.getUserDirectory();
    private static final boolean MAC = System.getProperty("os.name").startsWith("Mac");

    public static void setDirectory(String directory) {
        currentDirectory = directory;
    }

    public static String show(Component component, String title, int mode, String file) throws UserCancelException {
        return FileDialog.show(Utils.getFrame(component), title, mode, false, file);
    }

    public static String show(Frame parentFrame, String title, int mode) throws UserCancelException {
        return FileDialog.show(parentFrame, title, mode, false);
    }

    public static String show(Frame parentFrame, String title, int mode, boolean directoriesOnly) throws UserCancelException {
        return FileDialog.show(parentFrame, title, mode, directoriesOnly, null);
    }

    private static final String show(Frame parentFrame, String title, int mode, boolean directoriesOnly, String file) throws UserCancelException {
        if (!MAC && directoriesOnly) {
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(parentFrame) != 0) {
                throw new UserCancelException();
            }
            return chooser.getSelectedFile().getAbsolutePath();
        }
        java.awt.FileDialog dialog = directoriesOnly ? new FolderDialog(parentFrame, title) : new java.awt.FileDialog(parentFrame, title, mode);
        if (!directoriesOnly) {
            dialog.setDirectory(currentDirectory);
            if (file != null) {
                dialog.setFile(file);
            }
        }
        dialog.setVisible(true);
        if (!directoriesOnly && dialog.getFile() == null || directoriesOnly && dialog.getDirectory() == null) {
            throw new UserCancelException();
        }
        currentDirectory = dialog.getDirectory();
        if (directoriesOnly) {
            return currentDirectory;
        }
        if (dialog.getDirectory() == null) {
            return dialog.getFile();
        }
        return dialog.getDirectory() + dialog.getFile();
    }

    private FileDialog() {
        throw new IllegalStateException();
    }
}

