/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.nlogo.swing.ButtonPanel;
import org.nlogo.swing.OptionDialog;
import org.nlogo.swing.TextField;
import org.nlogo.swing.Utils;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class FindDialog
implements ActionListener,
ItemListener {
    public static final Action FIND_ACTION = new FindAction();
    public static final Action FIND_AGAIN_ACTION = new FindAgainAction();
    private static QueryObject queryObject;
    private static final List FIND_LIST;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private boolean isOpen;
    private JTextComponent parent;
    private JPanel findPanel;
    private TextField findBox;
    private JButton findButton;
    private JButton cancelButton;
    private JDialog dialog;
    private JCheckBox matchWhole;
    private JCheckBox caseSens;
    private JCheckBox stopAtEnd;
    private ButtonGroup direction;
    private JRadioButton searchDown;
    private JRadioButton searchUp;
    private JComboBox prevSearches;

    public static void setActionsEnabled(boolean enabled) {
        FIND_ACTION.setEnabled(enabled);
        FIND_AGAIN_ACTION.setEnabled(enabled);
    }

    private final void find() {
        if (!this.isOpen) {
            this.isOpen = true;
            this.init();
        }
        this.dialog.setVisible(true);
    }

    private final void findAgain() {
        if (queryObject != null) {
            this.doFind();
        }
    }

    private final void addEntry(String entry) {
        if (FIND_LIST.contains(entry)) {
            FIND_LIST.remove(entry);
        }
        FIND_LIST.add(entry);
    }

    private final Iterator getSearches() {
        return FIND_LIST.iterator();
    }

    private final void setPrevSearches() {
        if (this.prevSearches != null && !FIND_LIST.isEmpty()) {
            Iterator iter = this.getSearches();
            String[] reverseList = new String[FIND_LIST.size()];
            int count = 0;
            while (iter.hasNext()) {
                reverseList[count] = (String)iter.next();
                ++count;
            }
            int i = reverseList.length - 1;
            while (i >= 0) {
                this.prevSearches.addItem(reverseList[i]);
                --i;
            }
        }
    }

    private final void init() {
        try {
            Frame frame = org.nlogo.awt.Utils.getFrame(this.parent);
            this.dialog = new JDialog(frame, "Find", true);
            this.dialog.setResizable(false);
            this.dialog.addWindowListener(new WindowAdapter(){

                public final void windowClosing(WindowEvent e) {
                    FindDialog.this.dialog.setVisible(false);
                    FindDialog.this.isOpen = false;
                    FindDialog.this.dialog.dispose();
                }
            });
            Utils.addEscKeyAction(this.dialog, (Action)new AbstractAction("Cancel"){

                public final void actionPerformed(ActionEvent e) {
                    FindDialog.this.close();
                }
            });
            this.findBox = new TextField(10);
            this.findButton = new JButton("Find");
            this.cancelButton = new JButton("Cancel");
            this.dialog.getRootPane().setDefaultButton(this.findButton);
            this.findPanel = new JPanel();
            if (FIND_LIST.isEmpty()) {
                this.findPanel.setLayout(new FlowLayout());
                this.findPanel.add(this.findBox);
            } else {
                this.findPanel.setLayout(new GridLayout(2, 1));
                this.findPanel.add(this.findBox);
                this.prevSearches = new JComboBox();
                this.setPrevSearches();
                this.prevSearches.addItemListener(this);
                this.findPanel.add(this.prevSearches);
                this.findBox.setText((String)this.prevSearches.getItemAt(0));
                this.findBox.selectAll();
            }
            JPanel optionsPanel = new JPanel();
            optionsPanel.setLayout(new FlowLayout());
            this.caseSens = new JCheckBox("case sensitive", false);
            this.stopAtEnd = new JCheckBox("stop at end", false);
            this.matchWhole = new JCheckBox("match whole word", false);
            optionsPanel.add(this.matchWhole);
            optionsPanel.add(this.stopAtEnd);
            optionsPanel.add(this.caseSens);
            JPanel searchDirPanel = new JPanel();
            searchDirPanel.setLayout(new GridLayout(1, 2));
            this.direction = new ButtonGroup();
            this.searchDown = new JRadioButton("down", true);
            this.searchDown.setActionCommand("down");
            this.searchUp = new JRadioButton("up", false);
            this.searchUp.setActionCommand("up");
            this.direction.add(this.searchDown);
            this.direction.add(this.searchUp);
            searchDirPanel.add(this.searchUp);
            searchDirPanel.add(this.searchDown);
            optionsPanel.add(searchDirPanel);
            this.findButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.findBox.addActionListener(this);
            ButtonPanel buttonPanel = new ButtonPanel(new JComponent[]{this.findButton, this.cancelButton});
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.findPanel, "Center");
            this.dialog.getContentPane().add((Component)buttonPanel, "South");
            this.dialog.getContentPane().add((Component)optionsPanel, "East");
            this.dialog.pack();
            this.dialog.setLocation(frame.getLocation().x + frame.getWidth() - this.dialog.getPreferredSize().width, frame.getLocation().y + frame.getHeight() / 2 - this.dialog.getPreferredSize().height / 2);
        }
        catch (RuntimeException e) {
            Exceptions.handle(e);
        }
    }

    private final void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.findBox.setText((String)e.getItem());
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource().equals(this.findButton) || e.getSource().equals(this.findBox)) {
                this.query(this.findBox.getText());
                this.doFind();
            } else if (e.getSource().equals(this.cancelButton)) {
                this.close();
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    private final void doFind() {
        if (this.find(queryObject)) {
            this.addEntry(queryObject.getQueryString());
            this.close();
        } else {
            String findstring = "NOT FOUND: " + queryObject.getQueryString();
            Object[] options = new String[]{"Close"};
            OptionDialog.show(org.nlogo.awt.Utils.getFrame(this.parent), "Find Error:", findstring, options);
        }
    }

    private final void query(String findstring) {
        queryObject = new QueryObject(findstring);
        queryObject.setMatchWhole(this.matchWhole.isSelected());
        queryObject.setDirection(this.direction.getSelection().getActionCommand());
        queryObject.setCaseSens(this.caseSens.isSelected());
        queryObject.setStopAtEnd(this.stopAtEnd.isSelected());
    }

    private final boolean find(QueryObject queryObj) {
        String s = this.parent.getText();
        int startquery = 0;
        switch (queryObj.getDirection()) {
            case 1: {
                startquery = this.parent.getSelectedText() == null ? this.parent.getCaretPosition() : StrictMath.max(this.parent.getSelectionStart(), this.parent.getSelectionEnd());
                break;
            }
            case 0: {
                startquery = this.parent.getSelectedText() == null ? this.parent.getCaretPosition() : StrictMath.min(this.parent.getSelectionStart(), this.parent.getSelectionEnd());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int found = queryObj.getIndexInString(s, startquery);
        if (-1 == found && !queryObj.isStopAtEnd()) {
            startquery = queryObj.getDirection() == 1 ? 0 : s.length();
            found = queryObj.getIndexInString(s, startquery);
        }
        if (-1 != found) {
            this.parent.select(found, found + queryObj.length());
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$1(FindDialog findDialog) {
        return findDialog.isOpen;
    }

    static /* synthetic */ int access$6() {
        return 0;
    }

    static /* synthetic */ int access$7() {
        return 1;
    }

    private final /* synthetic */ void this() {
        this.isOpen = false;
    }

    private FindDialog(JTextComponent parent) {
        this.this();
        this.parent = parent;
    }

    static {
        FindDialog.setActionsEnabled(false);
        FIND_LIST = new ArrayList();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class QueryObject {
        final Integer directionKey;
        final Integer caseSensitiveKey;
        final Integer stopAtEndKey;
        final Integer matchWholeKey;
        Map restraintMap;
        String queryString;
        String tempString;
        char[] delim;

        int length() {
            return this.queryString.length();
        }

        String getQueryString() {
            return this.queryString;
        }

        int getIndexInString(String searchline, int startIndex) {
            int index = 0;
            if (this.isMatchWhole()) {
                List tokenList = this.getTokens(searchline);
                switch (this.getDirection()) {
                    case 0: {
                        index = searchline.length();
                        int i = tokenList.size() - 1;
                        while (i >= 0) {
                            String test = (String)tokenList.get(i);
                            if (this.isCaseSens() && this.queryString.equals(test) && index <= startIndex) {
                                return index - this.queryString.length();
                            }
                            if (!this.isCaseSens() && this.queryString.equalsIgnoreCase(test) && index <= startIndex) {
                                return index - this.queryString.length();
                            }
                            index -= test.length();
                            --i;
                        }
                        break;
                    }
                    case 1: {
                        int i = 0;
                        while (i < tokenList.size()) {
                            String test = (String)tokenList.get(i);
                            if (this.isCaseSens() && this.queryString.equals(test) && index >= startIndex) {
                                return index;
                            }
                            if (!this.isCaseSens() && this.queryString.equalsIgnoreCase(test) && index >= startIndex) {
                                return index;
                            }
                            index += test.length();
                            ++i;
                        }
                        break;
                    }
                }
                return -1;
            }
            switch (this.getDirection()) {
                case 0: {
                    index = this.isCaseSens() ? searchline.substring(0, startIndex).lastIndexOf(this.getQueryString()) : searchline.substring(0, startIndex).toUpperCase().lastIndexOf(this.getQueryString().toUpperCase());
                    return index;
                }
                case 1: {
                    if (this.isCaseSens()) {
                        return searchline.indexOf(this.getQueryString(), startIndex);
                    }
                    return searchline.toUpperCase().indexOf(this.getQueryString().toUpperCase(), startIndex);
                }
            }
            return -1;
        }

        void setMatchWhole(boolean matchWhole) {
            this.restraintMap.put(this.matchWholeKey, new Boolean(matchWhole));
        }

        void setDirection(String direction) {
            int intDirection = 1;
            intDirection = direction.equalsIgnoreCase("UP") ? 0 : 1;
            this.restraintMap.put(this.directionKey, new Integer(intDirection));
        }

        void setCaseSens(boolean caseSense) {
            this.restraintMap.put(this.caseSensitiveKey, new Boolean(caseSense));
        }

        void setStopAtEnd(boolean stopAtEnd) {
            this.restraintMap.put(this.stopAtEndKey, new Boolean(stopAtEnd));
        }

        int getDirection() {
            if (this.restraintMap.containsKey(this.directionKey)) {
                return (Integer)this.restraintMap.get(this.directionKey);
            }
            return -1;
        }

        boolean isMatchWhole() {
            if (this.restraintMap.containsKey(this.matchWholeKey)) {
                return (Boolean)this.restraintMap.get(this.matchWholeKey);
            }
            return false;
        }

        boolean isCaseSens() {
            if (this.restraintMap.containsKey(this.caseSensitiveKey)) {
                return (Boolean)this.restraintMap.get(this.caseSensitiveKey);
            }
            return false;
        }

        boolean isStopAtEnd() {
            if (this.restraintMap.containsKey(this.stopAtEndKey)) {
                return (Boolean)this.restraintMap.get(this.stopAtEndKey);
            }
            return false;
        }

        List getTokens(String searchString) {
            ArrayList<String> tokenList = new ArrayList<String>();
            int count = 0;
            int currentIndex = 0;
            while (currentIndex < searchString.length()) {
                StringBuffer temp = new StringBuffer();
                int searchindex = searchString.indexOf(this.queryString, currentIndex);
                if (searchindex != currentIndex || searchindex == -1) {
                    count = currentIndex;
                    while (this.isDelim(searchString.charAt(count)) == null) {
                        temp.append(searchString.charAt(count));
                        ++count;
                    }
                    if (temp.length() != 0) {
                        tokenList.add(temp.toString());
                    }
                    tokenList.add(this.isDelim(searchString.charAt(count)));
                    currentIndex = count + this.isDelim(searchString.charAt(count)).length();
                    continue;
                }
                currentIndex += this.queryString.length();
                tokenList.add(this.queryString);
            }
            return tokenList;
        }

        String isDelim(char test) {
            int i = 0;
            while (i < this.delim.length) {
                if (test == this.delim[i]) {
                    return String.valueOf(this.delim[i]);
                }
                ++i;
            }
            return null;
        }

        private final /* synthetic */ void this() {
            this.directionKey = new Integer(0);
            this.caseSensitiveKey = new Integer(1);
            this.stopAtEndKey = new Integer(2);
            this.matchWholeKey = new Integer(3);
            this.delim = new char[]{' ', '\t', '\n', '\r', '[', ']', '(', ')', ';'};
        }

        QueryObject(String queryString) {
            this.this();
            this.queryString = queryString;
            this.tempString = queryString;
            this.restraintMap = new HashMap();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class FindAction
    extends TextAction {
        static /* synthetic */ Class class$org$nlogo$swing$FindDialog;

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                new FindDialog(target).find();
            }
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        FindAction() {
            super("Find");
            Class clazz = class$org$nlogo$swing$FindDialog;
            if (clazz == null) {
                clazz = class$org$nlogo$swing$FindDialog = FindAction.class("[Lorg.nlogo.swing.FindDialog;", false);
            }
            this.putValue("SmallIcon", new ImageIcon(clazz.getResource("/images/magnify.gif")));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class FindAgainAction
    extends TextAction {
        static /* synthetic */ Class class$org$nlogo$swing$FindDialog;

        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            if (target != null) {
                new FindDialog(target).findAgain();
            }
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        FindAgainAction() {
            super("Find Again");
            Class clazz = class$org$nlogo$swing$FindDialog;
            if (clazz == null) {
                clazz = class$org$nlogo$swing$FindDialog = FindAgainAction.class("[Lorg.nlogo.swing.FindDialog;", false);
            }
            this.putValue("SmallIcon", new ImageIcon(clazz.getResource("/images/magnify.gif")));
        }
    }
}

