/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import org.nlogo.awt.Utils;
import org.nlogo.swing.Printable;
import org.nlogo.util.Exceptions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class PrinterManager {
    private final String fileName;
    private List textPages;
    private Font printFont;

    public static void print(final Printable p, String fileName) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrinterManager printer = new PrinterManager(fileName);
        printerJob.setPrintable(new java.awt.print.Printable(){

            public final int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
                return p.print(g, pageFormat, pageIndex, PrinterManager.this);
            }
        }, printerJob.pageDialog(printerJob.defaultPage()));
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterAbortException abortEx) {
                Exceptions.ignore(abortEx);
            }
            catch (PrinterException ex) {
                Exceptions.handle(ex);
            }
        }
    }

    protected String getFooter(int pageNum, int pageWidth, FontMetrics fm) {
        String pageNumString = " - page " + String.valueOf(pageNum);
        String shortFileName = Utils.shortenStringToFit(this.fileName, pageWidth - fm.stringWidth(pageNumString), fm);
        return shortFileName + pageNumString;
    }

    private final List buildTextPages(Graphics g, PageFormat pageFormat, String text) {
        ArrayList pages = new ArrayList();
        ArrayList<Object> lines = new ArrayList<Object>();
        Point2D.Float pen = new Point2D.Float();
        float wrappingWidth = (float)pageFormat.getImageableWidth();
        Graphics2D g2d = (Graphics2D)g;
        TextLayout defaultLayout = new TextLayout(" ", this.printFont, g2d.getFontRenderContext());
        float layoutDescent = defaultLayout.getDescent();
        float layoutAscent = defaultLayout.getAscent();
        double pageHeight = pageFormat.getImageableHeight() - (double)(2.0f * (defaultLayout.getLeading() + layoutDescent + layoutAscent));
        LineNumberReader lineReader = new LineNumberReader(new StringReader(text));
        try {
            String nextLine = lineReader.readLine();
            while (nextLine != null) {
                if (nextLine.length() == 0) {
                    pen.y += layoutAscent + layoutDescent;
                    if ((double)pen.y < pageHeight) {
                        lines.add(nextLine);
                        pen.y += defaultLayout.getLeading();
                    } else {
                        pages.add(lines);
                        lines = new ArrayList();
                        lines.add(nextLine);
                        pen = new Point2D.Float();
                        pen.y += defaultLayout.getLeading() + layoutDescent + layoutAscent;
                    }
                    nextLine = lineReader.readLine();
                    continue;
                }
                AttributedString formattedText = new AttributedString(nextLine);
                formattedText.addAttribute(TextAttribute.FONT, this.printFont);
                AttributedCharacterIterator charIterator = formattedText.getIterator();
                LineBreakMeasurer measurer = new LineBreakMeasurer(charIterator, g2d.getFontRenderContext());
                while (measurer.getPosition() < charIterator.getEndIndex()) {
                    TextLayout layout = measurer.nextLayout(wrappingWidth);
                    pen.y += layoutAscent + layoutDescent;
                    if ((double)pen.y < pageHeight) {
                        lines.add(layout);
                        pen.y += layout.getLeading();
                        continue;
                    }
                    pages.add(lines);
                    lines = new ArrayList();
                    lines.add(layout);
                    pen = new Point2D.Float();
                    pen.y += layout.getLeading() + layoutDescent + layoutAscent;
                }
                nextLine = lineReader.readLine();
            }
            pages.add(lines);
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
        return pages;
    }

    public int printText(Graphics g, PageFormat pageFormat, int pageIndex, String text) throws PrinterException {
        if (this.textPages == null) {
            this.textPages = this.buildTextPages(g, pageFormat, text);
        }
        if (pageIndex >= this.textPages.size()) {
            return 1;
        }
        float wrappingWidth = (float)pageFormat.getImageableWidth();
        Graphics2D g2d = (Graphics2D)g;
        TextLayout defaultLayout = new TextLayout(" ", this.printFont, g2d.getFontRenderContext());
        float layoutDescent = defaultLayout.getDescent();
        float layoutAscent = defaultLayout.getAscent();
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        List lines = (List)this.textPages.get(pageIndex);
        Point2D.Float pen = new Point2D.Float();
        int i = 0;
        while (i < lines.size()) {
            if (!(lines.get(i) instanceof TextLayout)) {
                pen.y += defaultLayout.getLeading() + layoutDescent + layoutAscent;
            } else {
                TextLayout layout = (TextLayout)lines.get(i);
                pen.y += layoutAscent;
                layout.draw(g2d, pen.x, pen.y);
                pen.y += layoutDescent + layout.getLeading();
            }
            ++i;
        }
        String footer = this.getFooter(pageIndex + 1, (int)StrictMath.floor(pageFormat.getImageableWidth()), g.getFontMetrics(this.printFont));
        TextLayout footerLayout = new TextLayout(footer, this.printFont, g2d.getFontRenderContext());
        pen.x = (wrappingWidth - footerLayout.getAdvance()) / 2.0f;
        pen.y = (float)pageFormat.getImageableHeight() - layoutDescent;
        footerLayout.draw(g2d, pen.x, pen.y);
        return 0;
    }

    private final /* synthetic */ void this() {
        this.printFont = new Font("Monospaced", 0, 9);
    }

    private PrinterManager(String fileName) {
        this.this();
        this.fileName = fileName;
        this.textPages = null;
    }
}

