/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.nlogo.swing.Utils;
import org.nlogo.swing.WrappingPopupMenu;

public strictfp abstract class ToolBarMenu
extends JPanel {
    private final String name;

    protected abstract void populate(JPopupMenu var1);

    protected abstract void menuSelection(String var1);

    public Dimension getMinimumSize() {
        return new Dimension(11, 20);
    }

    public Dimension getPreferredSize() {
        Dimension size = this.getMinimumSize();
        int xpad = 5;
        int ypad = 2;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        size.width = StrictMath.max(size.width, fontMetrics.stringWidth(this.name) + 2 * xpad + 11);
        size.height = StrictMath.max(size.height, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 2 * ypad);
        return size;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getForeground());
        FontMetrics fontMetrics = g.getFontMetrics();
        g.drawString(this.name, 5, fontMetrics.getMaxAscent() + 2);
        int[] xpnts = new int[]{this.getWidth() - 13, this.getWidth() - 9, this.getWidth() - 5};
        int[] ypnts = new int[]{this.getHeight() / 2 - 2, this.getHeight() / 2 + 2, this.getHeight() / 2 - 2};
        g.fillPolygon(xpnts, ypnts, 3);
    }

    public ToolBarMenu(String name) {
        this.name = name;
        this.setBorder(Utils.createWidgetBorder());
        if (System.getProperty("os.name").startsWith("Mac")) {
            this.setBackground(Color.WHITE);
        }
        this.addMouseListener(new MouseAdapter(){

            public final void mousePressed(MouseEvent e) {
                WrappingPopupMenu menu = new WrappingPopupMenu();
                ToolBarMenu.this.populate(menu);
                menu.show(ToolBarMenu.this, 0, ToolBarMenu.this.getHeight());
            }
        });
        org.nlogo.awt.Utils.adjustDefaultFont(this);
    }
}

