/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;

public strictfp class UndoManager
extends javax.swing.undo.UndoManager {
    private static UndoAction undoAction = new UndoAction();
    private static RedoAction redoAction = new RedoAction();
    private static UndoManager currentManager = null;

    public static UndoAction undoAction() {
        return undoAction;
    }

    public static Action redoAction() {
        return redoAction;
    }

    public static void setCurrentManager(UndoManager manager) {
        currentManager = manager;
        undoAction.updateUndoState();
        redoAction.updateRedoState();
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        super.undoableEditHappened(e);
        if (this == currentManager) {
            undoAction.updateUndoState();
            redoAction.updateRedoState();
        }
    }

    public void discardAllEdits() {
        super.discardAllEdits();
        if (this == currentManager) {
            undoAction.updateUndoState();
            redoAction.updateRedoState();
        }
    }

    strictfp static class UndoAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            currentManager.undo();
            this.updateUndoState();
            redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (currentManager != null && currentManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", currentManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }
    }

    strictfp static class RedoAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            currentManager.redo();
            this.updateRedoState();
            undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (currentManager != null && currentManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", currentManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }
    }
}

