/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Color;
import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.text.DefaultEditorKit;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;

public strictfp class Utils {
    private static final Border WIDGET_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.GRAY), BorderFactory.createRaisedBevelBorder());
    private static final Border WIDGET_PRESSED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, Color.GRAY), BorderFactory.createLoweredBevelBorder());
    private static Map actionMap = new HashMap();

    public static void detectBadJVMs() {
        if (org.nlogo.util.Utils.getProperty("java.version").startsWith("1.0") || org.nlogo.util.Utils.getProperty("java.version").startsWith("1.1") || org.nlogo.util.Utils.getProperty("java.version").startsWith("1.2") || org.nlogo.util.Utils.getProperty("java.version").startsWith("1.3") || org.nlogo.util.Utils.getProperty("java.version").startsWith("1.4.0")) {
            Utils.warn("NetLogo requires Java 1.4.1 or higher to run.");
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            try {
                int mrjMajorVersion;
                String mrj = System.getProperty("mrj.version");
                int n = mrjMajorVersion = mrj.indexOf(46) == -1 ? Integer.parseInt(mrj) : Integer.parseInt(mrj.substring(0, mrj.indexOf(46)));
                if (mrjMajorVersion < 69 || System.getProperty("os.version").startsWith("10.3") && mrjMajorVersion < 99) {
                    Utils.warn("NetLogo requires a newer version of Java for Mac OS X, which you may obtain via Software Update.");
                }
            }
            catch (NumberFormatException ex) {
                Exceptions.ignore(ex);
            }
        }
    }

    private static final void warn(String message) {
        Frame bogusFrame = new Frame();
        bogusFrame.pack();
        int choice = OptionDialog.show(bogusFrame, "Warning", message + "  If you choose to continue, NetLogo may not function properly.", new String[]{"Quit", "Continue"});
        if (choice == 0) {
            System.exit(0);
        }
    }

    public static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ex) {
            Exceptions.handle(ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.handle(ex);
        }
        catch (ClassNotFoundException ex) {
            Exceptions.handle(ex);
        }
        catch (InstantiationException ex) {
            Exceptions.handle(ex);
        }
    }

    public static Border createWidgetBorder() {
        return WIDGET_BORDER;
    }

    public static Border createWidgetPressedBorder() {
        return WIDGET_PRESSED_BORDER;
    }

    public static Action getDefaultEditorKitAction(String name) {
        return (Action)actionMap.get(name);
    }

    public static void addEscKeyAction(JDialog dialog, Action action) {
        Utils.addEscKeyAction(dialog.getRootPane(), action);
    }

    public static void addEscKeyAction(JWindow window, Action action) {
        Utils.addEscKeyAction(window.getRootPane(), action);
    }

    public static void addEscKeyAction(JComponent component, Action action) {
        component.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "ESC_ACTION");
        component.getActionMap().put("ESC_ACTION", action);
    }

    private Utils() {
        throw new IllegalStateException();
    }

    static {
        Action[] actions = new DefaultEditorKit().getActions();
        int i = 0;
        while (i < actions.length) {
            actionMap.put(actions[i].getValue("Name"), actions[i]);
            ++i;
        }
    }
}

