/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.nlogo.awt.RowLayout;
import org.nlogo.awt.Utils;
import org.nlogo.swing.WindowCloseBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class WindowDragger
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");
    private JWindow window;
    private JLabel titleLabel;
    private Point mousePressLoc;
    private Point mousePressAbsLoc;
    private Point locationWhenPressed;
    private WindowCloseBox closeBox;

    public void setTitle(String title) {
        this.titleLabel.setText(title);
        this.revalidate();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressLoc = e.getPoint();
        this.mousePressAbsLoc = new Point(this.mousePressLoc);
        Utils.convertPointToScreen(this.mousePressAbsLoc, this);
        this.locationWhenPressed = this.window.getLocationOnScreen();
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.inCloseBox(this.mousePressLoc)) {
            Point dragAbsLoc = new Point(e.getPoint());
            Utils.convertPointToScreen(dragAbsLoc, this);
            this.window.setLocation(this.locationWhenPressed.x + (dragAbsLoc.x - this.mousePressAbsLoc.x), this.locationWhenPressed.y + (dragAbsLoc.y - this.mousePressAbsLoc.y));
        }
    }

    private final boolean inCloseBox(Point p) {
        boolean bl = false;
        if (p.x >= 7 && p.x <= 13 && p.y >= 2 && p.y <= 8) {
            bl = true;
        }
        return bl;
    }

    public JButton getCloseBox() {
        return this.closeBox;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.BLACK);
        int x = 1;
        while (x < this.getWidth()) {
            int y = 1;
            while (y < this.getHeight()) {
                g.fillRect(x, y, 1, 1);
                y += 2;
            }
            x += 2;
        }
    }

    private final /* synthetic */ void this() {
        this.titleLabel = new JLabel();
    }

    public WindowDragger(JWindow window) {
        this.this();
        this.window = window;
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(Color.WHITE);
        this.closeBox = new WindowCloseBox();
        if (!IS_MAC) {
            GridBagLayout gridBag = new GridBagLayout();
            this.setLayout(gridBag);
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = -1;
            gridBag.setConstraints(this.titleLabel, c);
            this.add(this.titleLabel);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.anchor = 13;
            gridBag.setConstraints(this.closeBox, c);
            this.add(this.closeBox);
        } else {
            this.setLayout(new RowLayout(3, 0.0f, 0.5f));
            this.add(this.closeBox);
            this.add(this.titleLabel);
        }
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.titleLabel.addMouseListener(this);
        this.titleLabel.addMouseMotionListener(this);
    }
}

