/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.util;

public strictfp final class RingBufferQueueOfInt {
    private int head;
    private int tail;
    private int[] data = new int[4096];

    public final void makeEmpty() {
        this.tail = this.head;
    }

    public final boolean isEmpty() {
        boolean bl = false;
        if (this.head == this.tail) {
            bl = true;
        }
        return bl;
    }

    public final int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.data.length - this.head + this.tail;
    }

    public final void addLast(int val) {
        this.data[this.tail] = val;
        ++this.tail;
        if (this.tail >= this.data.length) {
            this.tail = 0;
        }
        if (this.head == this.tail) {
            int[] newData = new int[2 * this.data.length];
            int i = 0;
            while (i < this.data.length) {
                newData[i] = this.data[(this.head + i) % this.data.length];
                ++i;
            }
            this.head = 0;
            this.tail = this.data.length;
            this.data = newData;
        }
    }

    public final int getFirst() {
        if (this.isEmpty()) {
            System.out.println("getFirst() called on empty RingBufferQueueOfInt");
            return -1;
        }
        return this.data[this.head];
    }

    public final void removeFirst() {
        ++this.head;
        if (this.head >= this.data.length) {
            this.head = 0;
        }
    }

    public RingBufferQueueOfInt() {
        this.makeEmpty();
    }
}

