/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public strictfp class TimedSet
extends AbstractSet {
    private List contents;
    private Map timestamps;
    private long idleLifetime;

    public synchronized boolean add(Object o) {
        if (!this.touch(o)) {
            this.contents.add(o);
            this.timestamps.put(o, new TimeStamp());
            return true;
        }
        return false;
    }

    public synchronized boolean remove(Object o) {
        boolean bl = false;
        if (this.timestamps.remove(o) != null && this.contents.remove(o)) {
            bl = true;
        }
        return bl;
    }

    public Object get(int index) {
        return this.contents.get(index);
    }

    public synchronized void clear() {
        this.contents.clear();
        this.timestamps.clear();
    }

    public synchronized boolean contains(Object o) {
        return this.timestamps.containsKey(o);
    }

    public synchronized int size() {
        return this.contents.size();
    }

    public synchronized Iterator iterator() {
        return this.contents.iterator();
    }

    public synchronized Object[] toArray() {
        return this.contents.toArray();
    }

    public synchronized boolean touch(Object o) {
        TimeStamp ts = (TimeStamp)this.timestamps.get(o);
        if (ts != null) {
            ts.modified = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public synchronized int expire() {
        long now = System.currentTimeMillis();
        Iterator it = this.iterator();
        int expired = 0;
        while (it.hasNext()) {
            Object o = it.next();
            TimeStamp ts = (TimeStamp)this.timestamps.get(o);
            if (now - ts.modified <= this.idleLifetime) continue;
            this.timestamps.remove(o);
            it.remove();
            ++expired;
        }
        return expired;
    }

    public synchronized long getModifiedTime(Object o) {
        TimeStamp ts = (TimeStamp)this.timestamps.get(o);
        if (ts == null) {
            throw new NoSuchElementException("TimedSet does not contain " + o);
        }
        return ts.modified;
    }

    public synchronized long getAddedTime(Object o) {
        TimeStamp ts = (TimeStamp)this.timestamps.get(o);
        if (ts == null) {
            throw new NoSuchElementException("TimedSet does not contain " + o);
        }
        return ts.created;
    }

    public TimedSet(long idleLifetime) {
        this.idleLifetime = idleLifetime;
        this.contents = new ArrayList();
        this.timestamps = new HashMap();
    }

    public TimedSet(long idleLifetime, int initialCapacity) {
        this.idleLifetime = idleLifetime;
        this.contents = new ArrayList(initialCapacity);
        this.timestamps = new HashMap(initialCapacity);
    }

    private static class TimeStamp {
        public long created;
        public long modified;

        public TimeStamp() {
            this.modified = this.created = System.currentTimeMillis();
        }
    }
}

