/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import org.nlogo.awt.DarkenImageFilter;
import org.nlogo.awt.Utils;
import org.nlogo.event.EditWidgetEvent;
import org.nlogo.event.SpeedSliderChangedEvent;
import org.nlogo.swing.OptionDialog;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.GraphicsWidget;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Slider;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class GraphicsControlStrip
extends JPanel {
    private static final int MIN_HEIGHT = 20;
    private static final Point TOOL_TIP_OFFSET = new Point(0, -18);
    private final GUIWorkspace workspace;
    private final GraphicsWidget graphicsWidget;
    private final SizeControl sizeControlXY;
    private final SizeControl sizeControlX;
    private final SizeControl sizeControlY;
    final Slider speedSlider;
    private final ShapesSwitch shapesSwitch;
    private final DisplaySwitch displaySwitch;
    static /* synthetic */ Class class$org$nlogo$window$GraphicsControlStrip$ShapesSwitch;
    static /* synthetic */ Class class$org$nlogo$window$GraphicsControlStrip$DisplaySwitch;

    public Dimension getMinimumSize() {
        return new Dimension(super.getMinimumSize().width, 20);
    }

    public Dimension getPreferredSize() {
        if (this.graphicsWidget.isZoomed()) {
            return super.getPreferredSize();
        }
        return new Dimension(super.getPreferredSize().width, 20);
    }

    public Dimension getMaximumSize() {
        return new Dimension(75 + this.speedSlider.getPreferredSize().width, super.getMaximumSize().height);
    }

    public void doLayout() {
        boolean bigEnough;
        this.speedSlider.setVisible(true);
        if (this.workspace.kioskLevel == 0) {
            this.sizeControlXY.setVisible(true);
            this.sizeControlX.setVisible(true);
            this.sizeControlY.setVisible(true);
        }
        if (this.workspace.kioskLevel != 2) {
            this.shapesSwitch.setVisible(true);
            this.displaySwitch.setVisible(true);
        }
        boolean bl = false;
        if (this.getWidth() >= this.getMinimumSize().width) {
            bl = bigEnough = true;
        }
        if (this.workspace.kioskLevel == 0) {
            this.sizeControlXY.setVisible(bigEnough);
            this.sizeControlX.setVisible(bigEnough);
            this.sizeControlY.setVisible(bigEnough);
        }
        if (this.workspace.kioskLevel != 2) {
            this.shapesSwitch.setVisible(bigEnough);
            this.displaySwitch.setVisible(bigEnough);
        }
        super.doLayout();
    }

    public void minSpeed() {
        this.speedSlider.value(this.speedSlider.minimum());
    }

    public void maxSpeed() {
        this.speedSlider.value(this.speedSlider.maximum());
    }

    void reset() {
        this.displaySwitchOn(true);
        this.shapesSwitchOn(this.graphicsWidget.refreshShaped());
        this.maxSpeed();
        this.doLayout();
    }

    boolean displaySwitchOn() {
        boolean bl = false;
        if (this.displaySwitch == null || !this.displaySwitch.isSelected()) {
            bl = true;
        }
        return bl;
    }

    void displaySwitchOn(boolean on) {
        if (this.displaySwitch != null && on == this.displaySwitch.isSelected()) {
            this.displaySwitch.setSelected(on ^ true);
            if (on) {
                this.thaw();
            } else {
                this.freeze();
            }
        }
    }

    private final void thaw() {
        this.workspace.graphicsWindow.thaw();
        this.graphicsWidget.status("");
    }

    private final void freeze() {
        this.workspace.graphicsWindow.freeze();
        this.graphicsWidget.status("display frozen");
    }

    void shapesSwitchOn(boolean on) {
        if (this.shapesSwitch != null) {
            this.shapesSwitch.setSelected(on);
        }
    }

    private final boolean newSizeOK(int sex, int sey) {
        boolean bl = false;
        if (sex >= 0 && sey >= 0 && this.graphicsWidget.patchSize() * (double)(sex * 2 + 1) >= (double)this.getMinimumSize().width) {
            bl = true;
        }
        return bl;
    }

    private final boolean checkWithUser() {
        boolean bl = false;
        if (!this.workspace.jobManager.anyPrimaryJobs() || OptionDialog.show(this, "Warning", "Changing the size will halt and clear the world.", new String[]{"OK", "Cancel"}) == 0) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    GraphicsControlStrip(GUIWorkspace workspace, GraphicsWidget graphicsWidget) {
        this.workspace = workspace;
        this.graphicsWidget = graphicsWidget;
        this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        if (workspace.kioskLevel == 0) {
            this.sizeControlXY = new SizeControl("/images/arrowsdiag.gif", 1, 1);
            this.sizeControlXY.setToolTipText("change width & height in patches");
            layout.setConstraints(this.sizeControlXY, c);
            this.add(this.sizeControlXY);
            this.sizeControlX = new SizeControl("/images/arrowsx.gif", 1, 0);
            this.sizeControlX.setToolTipText("change width in patches");
            layout.setConstraints(this.sizeControlX, c);
            this.add(this.sizeControlX);
            this.sizeControlY = new SizeControl("/images/arrowsy.gif", 0, 1);
            this.sizeControlY.setToolTipText("change height in patches");
            layout.setConstraints(this.sizeControlY, c);
            this.add(this.sizeControlY);
        } else {
            this.sizeControlXY = null;
            this.sizeControlX = null;
            this.sizeControlY = null;
        }
        this.speedSlider = new SpeedSlider();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        layout.setConstraints(this.speedSlider, c);
        this.add(this.speedSlider);
        if (workspace.kioskLevel != 2) {
            this.shapesSwitch = new ShapesSwitch();
            c.weightx = 0.0;
            c.fill = 0;
            layout.setConstraints(this.shapesSwitch, c);
            this.add(this.shapesSwitch);
            this.displaySwitch = new DisplaySwitch();
            layout.setConstraints(this.displaySwitch, c);
            this.add(this.displaySwitch);
        } else {
            this.shapesSwitch = null;
            this.displaySwitch = null;
        }
        if (workspace.kioskLevel == 0) {
            MoreButton moreButton = new MoreButton();
            layout.setConstraints(moreButton, c);
            this.add(moreButton);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SizeControl
    extends JButton
    implements ActionListener {
        private final int sexChange;
        private final int seyChange;
        private Point mousePressLoc;

        public Point getToolTipLocation(MouseEvent e) {
            return TOOL_TIP_OFFSET;
        }

        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }

        private final boolean increase() {
            if (this.sexChange == 1 && this.seyChange == 0) {
                boolean bl = false;
                if (this.mousePressLoc.x >= this.getWidth() / 2) {
                    bl = true;
                }
                return bl;
            }
            if (this.sexChange == 0 && this.seyChange == 1) {
                boolean bl = false;
                if (this.mousePressLoc.y >= this.getHeight() / 2) {
                    bl = true;
                }
                return bl;
            }
            boolean bl = false;
            if (this.mousePressLoc.x + this.mousePressLoc.y >= (this.getHeight() + this.getWidth()) / 2) {
                bl = true;
            }
            return bl;
        }

        public void actionPerformed(ActionEvent e) {
            int newSEY;
            if (!GraphicsControlStrip.this.checkWithUser()) {
                return;
            }
            int newSEX = ((GraphicsControlStrip)GraphicsControlStrip.this).workspace.world.screenEdgeX() + this.sexChange * (this.increase() ? 1 : -1);
            if (GraphicsControlStrip.this.newSizeOK(newSEX, newSEY = ((GraphicsControlStrip)GraphicsControlStrip.this).workspace.world.screenEdgeY() + this.seyChange * (this.increase() ? 1 : -1))) {
                GraphicsWidget graphicsWidget = (GraphicsWidget)((GraphicsControlStrip)GraphicsControlStrip.this).workspace.graphicsWindow.getParent();
                graphicsWidget.screenEdgeXAndY(newSEX, newSEY);
                graphicsWidget.status("size = " + (newSEX * 2 + 1) + " x " + (newSEY * 2 + 1));
                graphicsWidget.resizeWithProgress(false);
            }
        }

        static /* synthetic */ Point access$0(SizeControl sizeControl) {
            return sizeControl.mousePressLoc;
        }

        SizeControl(String imagePath, int sexChange, int seyChange) {
            this.sexChange = sexChange;
            this.seyChange = seyChange;
            this.setOpaque(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            Class clazz = class$org$nlogo$window$GraphicsControlStrip$DisplaySwitch;
            if (clazz == null) {
                clazz = class$org$nlogo$window$GraphicsControlStrip$DisplaySwitch = GraphicsControlStrip.class("[Lorg.nlogo.window.GraphicsControlStrip$DisplaySwitch;", false);
            }
            this.setIcon(new ImageIcon(clazz.getResource(imagePath)));
            this.addMouseListener(new MouseAdapter(){

                public final void mousePressed(MouseEvent e) {
                    SizeControl.this.mousePressLoc = e.getPoint();
                }
            });
            this.addActionListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ShapesSwitch
    extends JCheckBox
    implements ActionListener {
        public Point getToolTipLocation(MouseEvent e) {
            return TOOL_TIP_OFFSET;
        }

        public void actionPerformed(ActionEvent e) {
            GraphicsControlStrip.this.graphicsWidget.refreshShaped(this.isSelected());
            GraphicsControlStrip.this.graphicsWidget.status("shapes " + (this.isSelected() ? "on" : "off"));
        }

        ShapesSwitch() {
            this.setOpaque(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            Class clazz = class$org$nlogo$window$GraphicsControlStrip$ShapesSwitch;
            if (clazz == null) {
                clazz = class$org$nlogo$window$GraphicsControlStrip$ShapesSwitch = GraphicsControlStrip.class("[Lorg.nlogo.window.GraphicsControlStrip$ShapesSwitch;", false);
            }
            this.setSelectedIcon(new ImageIcon(clazz.getResource("/images/arrowhead.gif")));
            this.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(((ImageIcon)this.getSelectedIcon()).getImage().getSource(), new DarkenImageFilter(0.5)))));
            this.setToolTipText("turn turtle shapes on/off");
            this.addActionListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DisplaySwitch
    extends JCheckBox
    implements ActionListener {
        public Point getToolTipLocation(MouseEvent e) {
            return TOOL_TIP_OFFSET;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isSelected()) {
                GraphicsControlStrip.this.freeze();
            } else {
                GraphicsControlStrip.this.thaw();
            }
        }

        DisplaySwitch() {
            this.setOpaque(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            Class clazz = class$org$nlogo$window$GraphicsControlStrip$DisplaySwitch;
            if (clazz == null) {
                clazz = class$org$nlogo$window$GraphicsControlStrip$DisplaySwitch = GraphicsControlStrip.class("[Lorg.nlogo.window.GraphicsControlStrip$DisplaySwitch;", false);
            }
            this.setIcon(new ImageIcon(clazz.getResource("/images/oldswitch.gif")));
            this.setToolTipText("freeze/unfreeze display");
            this.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(((ImageIcon)this.getIcon()).getImage().getSource(), new DarkenImageFilter(0.5)))));
            this.addActionListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SpeedSlider
    extends Slider
    implements SpeedSliderChangedEvent.Raiser {
        public Point getToolTipLocation(MouseEvent e) {
            return TOOL_TIP_OFFSET;
        }

        public Dimension getPreferredSize(Font font) {
            return new Dimension(super.getPreferredSize((Font)font).width, this.getHeight());
        }

        protected void valueSetter(Number value) {
            super.valueSetter(value);
            float oldValue = ((GraphicsControlStrip)GraphicsControlStrip.this).workspace.jobManager.speed();
            float newValue = this.value().floatValue();
            ((GraphicsControlStrip)GraphicsControlStrip.this).workspace.jobManager.speed(newValue);
            boolean bl = false;
            if (newValue == 100.0f) {
                bl = true;
            }
            boolean bl2 = false;
            if (oldValue == 100.0f) {
                bl2 = true;
            }
            if (bl != bl2) {
                boolean bl3 = false;
                if (newValue == 100.0f) {
                    bl3 = true;
                }
                new SpeedSliderChangedEvent(this, bl3).raise();
            }
        }

        SpeedSlider() {
            super(InterfaceColors.GRAPHICS_HANDLE, Utils.mixColors(InterfaceColors.GRAPHICS_BACKGROUND, Color.BLACK, 0.5));
            this.setToolTipText("adjust speed");
            this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
            this.minimum = org.nlogo.util.Utils.ZERO;
            this.maximum = org.nlogo.util.Utils.reuseInteger(100);
            this.increment = new Double(2);
            this.value = this.maximum;
            this.name("XXXXXXXXXXXXX");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MoreButton
    extends JButton
    implements EditWidgetEvent.Raiser {
        public Point getToolTipLocation(MouseEvent e) {
            return TOOL_TIP_OFFSET;
        }

        public void updateUI() {
            this.setUI(new BasicButtonUI());
        }

        public MoreButton() {
            super("More...");
            this.setFont(new Font(Utils.platformFont(), 0, 10));
            this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.setFocusable(false);
            this.setToolTipText("change graphics window settings");
            this.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    new EditWidgetEvent(MoreButton.this, GraphicsControlStrip.this.graphicsWidget, false).raise();
                }
            });
        }
    }
}

