/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.ShapeList;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.shapes.VectorShape;
import org.nlogo.window.AWTColor;
import org.nlogo.window.TurtleDrawer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class GraphicsPainter {
    private static final boolean MACINTOSH = System.getProperty("os.name").startsWith("Mac");
    private static final ColorModel COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);
    private static final Double GRAY = new Double(5);
    private static final double HEX_Y_SCALE = 1.5 * StrictMath.tan(0.5235987755982988);
    private final World world;
    private final Component graphicsWindow;
    private final TurtleDrawer turtleDrawer;
    private int[] patchColors;
    private Image patchImage;
    private boolean shapesOn;
    private int centerAdjustment;
    private boolean exactDraw;
    private double patchSize;
    private final List visibleTurtles;
    private TurtleDrawer hexagonDrawer;
    private Turtle hexagonTurtle;
    private boolean hexDraw;

    private final void setUpPatchImage() {
        if (this.patchColors != this.world.patchColors()) {
            this.patchColors = this.world.patchColors();
            this.patchImage = new BufferedImage(COLOR_MODEL, Raster.createWritableRaster(COLOR_MODEL.createCompatibleSampleModel(this.world.screenSizeX(), this.world.screenSizeY()), new DataBufferInt(this.patchColors, this.patchColors.length), new Point(0, 0)), true, new Hashtable());
        }
    }

    boolean shapesOn() {
        return this.shapesOn;
    }

    boolean shapesOnNew(boolean b) {
        if (b == this.shapesOn) {
            return false;
        }
        this.shapesOn = b;
        if (!this.shapesOn) {
            this.resetCache();
        }
        return true;
    }

    private final void centerAdjustment(FontMetrics fm) {
        this.centerAdjustment = (int)(this.patchSize / (double)4 - (double)(fm.getMaxAscent() / 4));
        this.centerAdjustment = StrictMath.min(0, this.centerAdjustment);
    }

    boolean exactDraw() {
        return this.exactDraw;
    }

    void exactDraw(boolean b) {
        this.exactDraw = b;
    }

    double patchSize() {
        return this.patchSize;
    }

    boolean patchSizeNew(double l) {
        if (l == this.patchSize) {
            return false;
        }
        this.patchSize = l;
        this.resetCache();
        return true;
    }

    void fillWith(Graphics g, Color color) {
        Rectangle bounds = this.graphicsWindow.getBounds();
        g.setColor(color);
        g.fillRect(0, 0, bounds.width, bounds.height);
    }

    void paint(Graphics g) {
        this.centerAdjustment(g.getFontMetrics());
        if (this.hexDraw) {
            this.paintHexPatches(g);
            this.paintHexTurtles(g);
        } else {
            this.setUpPatchImage();
            this.paintPatches(g);
            if (this.exactDraw) {
                this.paintExactTurtles(g);
            } else {
                this.paintGridTurtles(g);
            }
        }
    }

    private final void paintPatches(Graphics g) {
        g.setFont(this.graphicsWindow.getFont());
        if (this.world.patchesAllBlack()) {
            this.fillWith(g, Color.BLACK);
        } else {
            if (MACINTOSH) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            g.drawImage(this.patchImage, 0, 0, this.graphicsWindow.getWidth(), this.graphicsWindow.getHeight(), null);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.world.patchesWithLabels > 0) {
            int patchCount = this.world.patches().count();
            int i = 0;
            while (i < patchCount) {
                Patch patch = this.world.getPatch(i);
                if (patch.hasLabel()) {
                    this.drawLabel(g, patch);
                }
                ++i;
            }
        }
    }

    private final void paintExactTurtles(Graphics g) {
        int turtlesDrawn = 0;
        Collection breeds = this.world.program().breeds.values();
        Iterator iter = breeds.iterator();
        while (iter.hasNext()) {
            AgentSet breed = (AgentSet)iter.next();
            Iterator iter2 = breed.iterator();
            while (iter2.hasNext()) {
                this.drawTurtle(g, (Turtle)iter2.next());
                ++turtlesDrawn;
            }
        }
        if (turtlesDrawn < this.world.turtles().count()) {
            iter = this.world.turtles().iterator();
            while (iter.hasNext()) {
                Turtle turtle = (Turtle)iter.next();
                if (turtle.getBreed() != this.world.turtles()) continue;
                this.drawTurtle(g, turtle);
            }
        }
    }

    private final void drawTurtle(Graphics g, Turtle turtle) {
        if (!turtle.hidden()) {
            this.drawTurtleBody(g, turtle);
            if (turtle.hasLabel()) {
                this.drawLabel(g, turtle);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void paintGridTurtles(Graphics g) {
        try {
            Turtle turtle;
            if (this.world.turtles().count() == 0) {
                Object var3_2 = null;
                this.visibleTurtles.clear();
                return;
            }
            int patchCount = this.world.patches().count();
            int i = 0;
            while (i < patchCount) {
                Turtle turtle2 = this.world.getPatch(i).getTopTurtle();
                if (turtle2 != null) {
                    this.visibleTurtles.add(turtle2);
                }
                ++i;
            }
            boolean anyLabels = false;
            Iterator turtles = this.visibleTurtles.iterator();
            while (turtles.hasNext()) {
                turtle = (Turtle)turtles.next();
                if (turtle.hidden()) continue;
                this.drawTurtleBody(g, turtle);
                if (!turtle.hasLabel()) continue;
                anyLabels = true;
            }
            if (anyLabels) {
                turtles = this.visibleTurtles.iterator();
                while (turtles.hasNext()) {
                    turtle = (Turtle)turtles.next();
                    if (!turtle.hasLabel()) continue;
                    this.drawLabel(g, turtle);
                }
            }
            Object var3_4 = null;
            this.visibleTurtles.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.visibleTurtles.clear();
            throw throwable;
        }
    }

    private final void drawTurtleBody(Graphics g, Turtle turtle) {
        double effectiveTurtleSize;
        double d = effectiveTurtleSize = this.exactDraw ? turtle.size() : 1.0;
        if (this.shapesOn && effectiveTurtleSize * this.patchSize > (double)2) {
            int n = this.graphicsX(turtle);
            int n2 = this.graphicsY(turtle);
            int n3 = (int)StrictMath.floor(this.patchSize);
            int n4 = (int)StrictMath.floor(this.patchSize);
            boolean bl = false;
            if (effectiveTurtleSize == 1.0) {
                bl = true;
            }
            this.turtleDrawer.drawTurtle(g, n, n2, n3, n4, effectiveTurtleSize, turtle, bl);
        } else {
            g.setColor(AWTColor.getColor(turtle.color()));
            int rectSize = (int)(this.patchSize * effectiveTurtleSize);
            int offset = (rectSize - (int)this.patchSize) / 2;
            if (this.patchSize >= (double)5) {
                g.fillRect(this.graphicsX(turtle) - offset + 1, this.graphicsY(turtle) - offset + 1, rectSize - 2, rectSize - 2);
            } else {
                g.fillRect(this.graphicsX(turtle) - offset, this.graphicsY(turtle) - offset, rectSize, rectSize);
            }
        }
    }

    private final void drawLabel(Graphics g, Turtle turtle) {
        this.drawLabel(g, this.graphicsX(turtle), this.graphicsY(turtle), turtle.labelString(), turtle.labelColor());
    }

    private final void drawLabel(Graphics g, Patch patch) {
        this.drawLabel(g, this.graphicsX(patch), this.graphicsY(patch), patch.labelString(), patch.labelColor());
    }

    private final void drawLabel(Graphics g, int x, int y, String label, double color) {
        y = (int)((double)y + this.patchSize);
        g.setColor(AWTColor.getColor(color));
        FontMetrics fm = g.getFontMetrics();
        int leftx = (int)StrictMath.floor((double)(x - fm.stringWidth(label)) + this.patchSize);
        if (this.patchSize >= (double)(fm.getMaxAscent() + fm.getMaxDescent())) {
            g.drawString(label, leftx, y - fm.getMaxDescent());
        } else {
            g.drawString(label, leftx, y - this.centerAdjustment);
        }
    }

    String getCacheReport() {
        return this.turtleDrawer.getCacheReport();
    }

    void resetCache() {
        this.turtleDrawer.resetCache(this.patchSize);
        this.resetHexagonStuff();
    }

    public int graphicsX(Patch patch) {
        return (int)(this.patchSize * (double)(patch.pxcor + this.world.screenEdgeX()));
    }

    public int graphicsY(Patch patch) {
        return (int)(this.patchSize * (double)(this.world.screenEdgeY() - patch.pycor));
    }

    public int graphicsX(Turtle turtle) {
        return this.exactDraw ? (int)(this.patchSize * (turtle.xcor() + (double)this.world.screenEdgeX())) : this.graphicsX(turtle.getPatchHere());
    }

    public int graphicsY(Turtle turtle) {
        return this.exactDraw ? (int)(this.patchSize * ((double)this.world.screenEdgeY() - turtle.ycor())) : this.graphicsY(turtle.getPatchHere());
    }

    private final void resetHexagonStuff() {
        VectorShape hexagonShape = (VectorShape)VectorShape.parseShapes(new String[]{"hexagon", "false", "0", "Polygon -7566196 true true 150 0 280 75 280 225 150 300 20 225 20 75 150 0"}).get(0);
        this.hexagonDrawer = new TurtleDrawer(new ShapeList(hexagonShape), this.patchSize);
        this.hexagonTurtle = new Turtle(0.0, 0.0, hexagonShape, false);
    }

    boolean hexDraw() {
        return this.hexDraw;
    }

    void hexDraw(boolean b) {
        this.hexDraw = b;
    }

    private final void paintHexPatches(Graphics g) {
        this.fillWith(g, Color.BLACK);
        int patchCount = this.world.patches().count();
        int rectSize = (int)this.patchSize;
        int i = 0;
        while (i < patchCount) {
            Patch patch = this.world.getPatch(i);
            this.hexagonTurtle.colorDoubleUnchecked(patch.pcolorDouble());
            this.hexagonDrawer.drawTurtle(g, this.hexGraphicsX(patch), this.hexGraphicsY(patch), rectSize, rectSize, 1.0, this.hexagonTurtle, true);
            ++i;
        }
    }

    private final void paintHexTurtles(Graphics g) {
        if (this.world.turtles().count() > 0) {
            throw new RuntimeException("hex turtles not implemented yet -- patches only for now");
        }
    }

    public int hexGraphicsX(Patch patch) {
        if ((patch.pycor + this.world.screenEdgeY()) % 2 == 0) {
            return (int)(this.patchSize * ((double)patch.pxcor + 0.25 + (double)this.world.screenEdgeX()));
        }
        return (int)(this.patchSize * ((double)patch.pxcor - 0.25 + (double)this.world.screenEdgeX()));
    }

    public int hexGraphicsY(Patch patch) {
        return (int)(HEX_Y_SCALE * this.patchSize * (double)(this.world.screenEdgeY() - patch.pycor));
    }

    private final /* synthetic */ void this() {
        this.shapesOn = true;
        this.exactDraw = false;
        this.patchSize = 12.0;
        this.visibleTurtles = new ArrayList();
        this.hexDraw = false;
    }

    GraphicsPainter(World world, Component graphicsWindow, ShapeList shapeList) {
        this.this();
        this.world = world;
        this.graphicsWindow = graphicsWindow;
        this.turtleDrawer = new TurtleDrawer(shapeList, this.patchSize);
        this.resetCache();
    }
}

