/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.awt.ImageSelection;
import org.nlogo.awt.Utils;
import org.nlogo.event.EditWidgetEvent;
import org.nlogo.event.LoadBeginEvent;
import org.nlogo.event.LoadEndEvent;
import org.nlogo.event.RemoveAllJobsEvent;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.util.Exceptions;
import org.nlogo.util.UserCancelException;
import org.nlogo.window.Editable;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.GraphicsControlStrip;
import org.nlogo.window.GraphicsWidgetInterface;
import org.nlogo.window.GraphicsWindow;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.PropertyDescription;
import org.nlogo.window.Widget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class GraphicsWidget
extends Widget
implements ActionListener,
GraphicsWidgetInterface,
Editable,
RemoveAllJobsEvent.Raiser,
EditWidgetEvent.Raiser,
LoadBeginEvent.Handler,
LoadEndEvent.Handler {
    private static final int INSIDE_BORDER_HEIGHT = 1;
    private static final int STATUS_LABEL_GAP = 7;
    private final GUIWorkspace workspace;
    public final GraphicsWindow graphicsWindow;
    public final GraphicsControlStrip controlStrip;
    public final JLabel statusLabel;
    private List propertySet;
    private boolean edgesChanged;
    private boolean patchSizeChanged;
    private boolean fontSizeChanged;
    private int newScreenEdgeX;
    private int newScreenEdgeY;
    private int newFontSize;

    public String classDisplayName() {
        return "Graphics";
    }

    public final int getExtraHeight() {
        return this.getInsets().top + this.getInsets().bottom + 1;
    }

    public void doLayout() {
        int availableWidth = this.getWidth() - this.getInsets().left - this.getInsets().right;
        double patchSize = this.computePatchSize(availableWidth, this.workspace.world.screenSizeX());
        int graphicsHeight = (int)StrictMath.round(patchSize * (double)this.workspace.world.screenSizeY());
        int stripHeight = this.getHeight() - graphicsHeight - this.getInsets().top - this.getInsets().bottom;
        this.graphicsWindow.graphicsPainter.patchSizeNew(patchSize);
        this.graphicsWindow.setBounds(this.getInsets().left, this.getInsets().top + 1 + stripHeight, availableWidth, graphicsHeight);
        this.controlStrip.setBounds(this.getInsets().left, this.getInsets().top, StrictMath.min(availableWidth, this.controlStrip.getMaximumSize().width), stripHeight);
        int labelWidth = this.getWidth() - this.controlStrip.getLocation().x - this.controlStrip.getWidth() - 7 - this.getInsets().right;
        this.statusLabel.setBounds(this.getWidth() - this.getInsets().right - labelWidth, (stripHeight - this.statusLabel.getPreferredSize().height) / 2 + this.getInsets().top, labelWidth, this.statusLabel.getPreferredSize().height);
    }

    public void status(String status) {
        this.statusLabel.setText(status);
    }

    private final double computePatchSize(int width, int numPatches) {
        double exactPatchSize = (double)width / (double)numPatches;
        int precision = 0;
        while (precision < 15) {
            double roundedPatchSize = org.nlogo.util.Utils.approximate(exactPatchSize, precision);
            if ((int)((double)numPatches * roundedPatchSize) == width) {
                return roundedPatchSize;
            }
            ++precision;
        }
        return exactPatchSize;
    }

    private final double getUnzoomedPatchSize() {
        return this.computePatchSize(this.getUnzoomedBounds().width - this.getInsets().left - this.getInsets().right, this.workspace.world.screenSizeX());
    }

    private final void addProperties() {
        this.propertySet(new ArrayList());
        this.propertySet().add(new PropertyDescription("screenEdgeX", "Screen Edge X", "Integer", 0, true));
        this.propertySet().add(new PropertyDescription("screenEdgeY", "Screen Edge Y", "Integer", 0, false));
        this.propertySet().add(new PropertyDescription("patchSize", "Patch Size (pixels)", "Double", 0, false));
        this.propertySet().add(new PropertyDescription("fontSize", "Font Size (of turtle and patch labels)", "Integer", 0, false));
        this.propertySet().add(new PropertyDescription("refreshShaped", "Turtle Shapes", "Boolean", 0, false));
        this.propertySet().add(new PropertyDescription("exactDraw", "Exact Turtle Positions & Sizes", "Boolean", 0, false));
    }

    public List propertySet() {
        this.newScreenEdgeX = this.workspace.world.screenEdgeX();
        this.newScreenEdgeY = this.workspace.world.screenEdgeY();
        return this.propertySet;
    }

    public void propertySet(List propertySet) {
        this.propertySet = propertySet;
    }

    public void editFinished() {
        super.editFinished();
        if (this.edgesChanged || this.patchSizeChanged) {
            if (this.edgesChanged) {
                this.status("");
            }
            this.resizeWithProgress(true);
            this.edgesChanged = false;
            this.patchSizeChanged = false;
        }
        if (this.fontSizeChanged) {
            this.applyNewFontSize();
            this.fontSizeChanged = false;
        }
        this.graphicsWindow.dirty();
        this.graphicsWindow.repaint();
    }

    public void editWidgetFinished(Editable target, boolean cancelled) {
        this.editFinished();
    }

    void resizeWithProgress(boolean showProgress) {
        boolean oldGraphicsOn = this.workspace.world.displayOn();
        if (oldGraphicsOn) {
            this.workspace.world.displayOn(false);
        }
        Runnable runnable = new Runnable(){

            public final void run() {
                try {
                    if (GraphicsWidget.this.edgesChanged) {
                        new RemoveAllJobsEvent(GraphicsWidget.this).raise();
                        ((GraphicsWidget)GraphicsWidget.this).workspace.world.createPatches(GraphicsWidget.this.newScreenEdgeX, GraphicsWidget.this.newScreenEdgeY);
                        GraphicsWidget.this.workspace.patchesCreatedNotify();
                    }
                    GraphicsWidget.this.resetSize();
                }
                catch (RuntimeException ex) {
                    Exceptions.handle(ex);
                }
            }
        };
        if (showProgress) {
            new ModalProgressTask(Utils.getFrame(this), runnable, "Resizing...");
        } else {
            runnable.run();
        }
        this.controlStrip.displaySwitchOn(true);
        if (oldGraphicsOn) {
            this.workspace.world.displayOn(true);
            this.graphicsWindow.dirty();
            this.graphicsWindow.repaint();
        }
    }

    public void screenEdgeX(int screenEdgeX) {
        this.newScreenEdgeX = StrictMath.max(screenEdgeX, 0);
        boolean bl = false;
        if (this.edgesChanged || this.newScreenEdgeX != this.workspace.world.screenEdgeX()) {
            bl = true;
        }
        this.edgesChanged = bl;
    }

    public int screenEdgeX() {
        return this.newScreenEdgeX;
    }

    public void screenEdgeY(int screenEdgeY) {
        this.newScreenEdgeY = StrictMath.max(screenEdgeY, 0);
        boolean bl = false;
        if (this.edgesChanged || this.newScreenEdgeY != this.workspace.world.screenEdgeY()) {
            bl = true;
        }
        this.edgesChanged = bl;
    }

    public int screenEdgeY() {
        return this.newScreenEdgeY;
    }

    public void screenEdgeXAndY(int screenEdgeX, int screenEdgeY) {
        screenEdgeX = StrictMath.max(screenEdgeX, 0);
        screenEdgeY = StrictMath.max(screenEdgeY, 0);
        if (this.workspace.world.patches() == null || screenEdgeX != this.workspace.world.screenEdgeX() || screenEdgeY != this.workspace.world.screenEdgeY()) {
            new RemoveAllJobsEvent(this).raise();
            this.workspace.world.createPatches(screenEdgeX, screenEdgeY);
            this.workspace.patchesCreatedNotify();
            this.resetSize();
        }
    }

    public void patchSize(double size) {
        boolean bl = false;
        if (this.graphicsWindow.graphicsPainter.patchSizeNew(size) || this.patchSizeChanged) {
            bl = true;
        }
        this.patchSizeChanged = bl;
    }

    public double patchSize() {
        return this.graphicsWindow.graphicsPainter.patchSize();
    }

    public boolean refreshShaped() {
        return this.graphicsWindow.graphicsPainter.shapesOn();
    }

    public void refreshShaped(boolean value) {
        this.graphicsWindow.graphicsPainter.shapesOnNew(value);
        this.controlStrip.shapesSwitchOn(value);
        this.graphicsWindow.dirty();
        this.graphicsWindow.repaint();
    }

    public boolean exactDraw() {
        return this.graphicsWindow.graphicsPainter.exactDraw();
    }

    public void exactDraw(boolean value) {
        this.graphicsWindow.graphicsPainter.exactDraw(value);
        this.graphicsWindow.dirty();
        this.graphicsWindow.repaint();
    }

    public boolean hexDraw() {
        return this.graphicsWindow.graphicsPainter.hexDraw();
    }

    public void hexDraw(boolean value) {
        this.graphicsWindow.graphicsPainter.hexDraw(value);
        this.graphicsWindow.dirty();
        this.graphicsWindow.repaint();
    }

    public Dimension getPreferredSize(Font font) {
        return new Dimension(0, 0);
    }

    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    public Dimension getMinimumSize() {
        Dimension gSize = this.graphicsWindow.getMinimumSize();
        Dimension stripSize = this.controlStrip.getMinimumSize();
        if (gSize.width > stripSize.width) {
            return new Dimension(gSize.width + this.getInsets().left + this.getInsets().right, gSize.height + this.getExtraHeight() + stripSize.height);
        }
        int ssx = this.workspace.world.screenSizeX();
        int ssy = this.workspace.world.screenSizeY();
        double minPatchSize = this.computePatchSize(stripSize.width, ssx);
        return new Dimension(stripSize.width + this.getInsets().left + this.getInsets().right, stripSize.height + this.getExtraHeight() + (int)(minPatchSize * (double)ssy));
    }

    private final void resetSize() {
        Dimension dim = this.graphicsWindow.getPreferredSize();
        this.setSize(dim.width + this.getInsets().left + this.getInsets().right, dim.height + this.getExtraHeight() + this.controlStrip.getPreferredSize().height);
        this.doLayout();
        this.resetZoomInfo();
    }

    public void setBounds(int x, int y, int width, int height) {
        try {
            Rectangle bounds = this.getBounds();
            if (width != bounds.width || height != bounds.height || x != bounds.x || y != bounds.y) {
                super.setBounds(x, y, width, height);
                this.resetSizeInfo();
            }
        }
        catch (RuntimeException ex) {
            Exceptions.handle(ex);
        }
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Rectangle constrainDrag(Rectangle newBounds, Rectangle originalBounds, int mouseMode) {
        int stripHeight = this.controlStrip.getMinimumSize().height;
        double patchSizeBasedOnNewWidth = this.computePatchSize(newBounds.width - this.getInsets().left + this.getInsets().right, this.workspace.world.screenSizeX());
        double patchSizeBasedOnNewHeight = this.computePatchSize(newBounds.height - stripHeight - this.getExtraHeight(), this.workspace.world.screenSizeY());
        double newPatchSize = newBounds.height == originalBounds.height ? patchSizeBasedOnNewWidth : (newBounds.width == originalBounds.width ? patchSizeBasedOnNewHeight : StrictMath.max(patchSizeBasedOnNewWidth, patchSizeBasedOnNewHeight));
        int newWidth = (int)(newPatchSize * (double)this.workspace.world.screenSizeX()) + this.getInsets().left + this.getInsets().right;
        int newHeight = (int)(newPatchSize * (double)this.workspace.world.screenSizeY()) + this.getExtraHeight() + stripHeight;
        int widthAdjust = newBounds.width - newWidth;
        int heightAdjust = newBounds.height - newHeight;
        int newX = newBounds.x;
        int newY = newBounds.y;
        switch (mouseMode) {
            case 2: {
                newY += heightAdjust;
                break;
            }
            case 3: {
                newX += widthAdjust;
                newY += heightAdjust;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                newX += widthAdjust;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                newX += widthAdjust;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                newY += heightAdjust;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (mouseMode) {
            case 6: 
            case 9: {
                int midpointX = originalBounds.x + originalBounds.width / 2;
                newX = midpointX - newWidth / 2;
                break;
            }
            case 7: 
            case 8: {
                int midpointY = originalBounds.y + originalBounds.height / 2;
                newY = midpointY - newHeight / 2;
                break;
            }
        }
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    public int fontSize() {
        return this.graphicsWindow.getFont().getSize();
    }

    public void fontSize(int newFontSize) {
        this.newFontSize = newFontSize;
        this.fontSizeChanged = true;
    }

    private final void applyNewFontSize() {
        Font font = this.graphicsWindow.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), this.newFontSize);
        this.graphicsWindow.setFont(newFont);
        this.graphicsWindow.dirty();
        this.graphicsWindow.repaint();
    }

    public boolean zoomSubcomponents() {
        return true;
    }

    public Widget asWidget() {
        return this;
    }

    public void handleLoadBeginEvent(LoadBeginEvent e) {
        this.status("");
    }

    public void handleLoadEndEvent(LoadEndEvent e) {
        this.controlStrip.reset();
    }

    public void actionPerformed(ActionEvent e) {
        AgentMenuItem item = (AgentMenuItem)e.getSource();
        this.workspace.inspectAgent(item.agent.getClass(), item.agent);
    }

    public boolean hasContextMenu() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void populateContextMenu(JPopupMenu menu, Point p) {
        JMenuItem copyItem = new JMenuItem("Copy Graphics");
        copyItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(((GraphicsWidget)GraphicsWidget.this).workspace.graphicsWindow.exportGraphics()), null);
            }
        });
        menu.add(copyItem);
        JMenuItem exportItem = new JMenuItem("Export Graphics...");
        exportItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                GraphicsWidget.this.exportGraphics();
            }
        });
        menu.add(exportItem);
        menu.add(new JPopupMenu.Separator());
        p = new Point(p);
        this.graphicsWindow.translatePointToXCorYCor(p);
        World world = this.workspace.world;
        synchronized (world) {
            Patch patch = this.workspace.world.getPatchAt(this.graphicsWindow.mouseXCor(), this.graphicsWindow.mouseYCor());
            menu.add(new AgentMenuItem(patch));
            int i = patch.turtlesHere.size() - 1;
            while (i >= 0) {
                if (i == patch.turtlesHere.size() - 1) {
                    menu.add(new JPopupMenu.Separator());
                }
                Turtle turtle = (Turtle)patch.turtlesHere.get(i);
                menu.add(new AgentMenuItem(turtle));
                --i;
            }
            return;
        }
    }

    private final void exportGraphics() {
        try {
            final String exportPath = FileDialog.show(this, "Exporting", 1, "graphics.png");
            final IOException[] exception = new IOException[1];
            new ModalProgressTask(Utils.getFrame(this), new Runnable(){

                public final void run() {
                    try {
                        GraphicsWidget.this.workspace.exportGraphics(exportPath, "png");
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            }, "Exporting...");
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
        catch (IOException ex) {
            Exceptions.handle(ex);
        }
    }

    public Object load(String[] strings, String version) {
        this.screenEdgeXAndY(Integer.parseInt(strings[5]), Integer.parseInt(strings[6]));
        boolean bl = false;
        if (Integer.parseInt(strings[8]) != 0) {
            bl = true;
        }
        this.refreshShaped(bl);
        if (strings.length > 9) {
            this.fontSize(Integer.parseInt(strings[9]));
            this.applyNewFontSize();
        }
        if (strings.length > 12) {
            boolean bl2 = false;
            if (Integer.parseInt(strings[12]) != 0) {
                bl2 = true;
            }
            this.exactDraw(bl2);
        } else {
            this.exactDraw(true);
        }
        if (strings.length > 13) {
            boolean bl3 = false;
            if (Integer.parseInt(strings[13]) != 0) {
                bl3 = true;
            }
            this.hexDraw(bl3);
        }
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        if (StrictMath.abs((double)(x2 - x1) / (Double.valueOf(strings[5]) * (double)2 + 1.0) * (Double.valueOf(strings[6]) * (double)2 + 1.0) - (double)(y2 - y1)) <= 1.0) {
            this.setSize(x2 - x1 + this.getInsets().left + this.getInsets().right, y2 - y1 + this.getExtraHeight() + this.controlStrip.getMinimumSize().height);
        } else {
            this.setSize(x2 - x1, y2 - y1);
        }
        this.doLayout();
        this.workspace.world.clearTurtles();
        this.workspace.world.clearPatches();
        this.workspace.world.displayOn(true);
        return this;
    }

    public String save() {
        return "GRAPHICS-WINDOW\n" + this.getBoundsString() + this.workspace.world.screenEdgeX() + '\n' + this.workspace.world.screenEdgeY() + '\n' + this.getUnzoomedPatchSize() + '\n' + (this.graphicsWindow.graphicsPainter.shapesOn() ? "1" : "0") + '\n' + this.findWidgetContainer().getUnzoomedFontSize(this.graphicsWindow) + '\n' + (this.graphicsWindow.graphicsPainter.exactDraw() ? "1" : "0") + '\n' + (this.graphicsWindow.graphicsPainter.exactDraw() ? "1" : "0") + '\n' + (this.graphicsWindow.graphicsPainter.exactDraw() ? "1" : "0") + '\n' + (this.graphicsWindow.graphicsPainter.hexDraw() ? "1" : "0") + '\n';
    }

    private final /* synthetic */ void this() {
        this.statusLabel = new JLabel();
        this.propertySet = null;
        this.edgesChanged = false;
        this.patchSizeChanged = false;
        this.fontSizeChanged = false;
    }

    GraphicsWidget(GUIWorkspace workspace) {
        this.this();
        this.workspace = workspace;
        this.graphicsWindow = new GraphicsWindow(workspace);
        this.controlStrip = new GraphicsControlStrip(workspace, this);
        this.addProperties();
        this.setBackground(InterfaceColors.GRAPHICS_BACKGROUND);
        this.setBorder(BorderFactory.createCompoundBorder(this.widgetBorder, BorderFactory.createMatteBorder(1, 3, 4, 2, InterfaceColors.GRAPHICS_BACKGROUND)));
        this.setLayout(null);
        this.add(this.graphicsWindow);
        this.add(this.controlStrip);
        this.add(this.statusLabel);
        Utils.adjustDefaultFont(this.statusLabel);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AgentMenuItem
    extends JMenuItem {
        Agent agent;

        AgentMenuItem(Agent agent) {
            super("inspect " + agent.toString());
            this.agent = agent;
            this.addActionListener(GraphicsWidget.this);
        }
    }
}

