/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.nlogo.command.Instruction;
import org.nlogo.event.Event;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.LogoException;
import org.nlogo.swing.MessageDialog;
import org.nlogo.util.Utils;
import org.nlogo.util.Version;
import org.nlogo.workspace.Workspace;

public strictfp class RuntimeErrorDialog
extends MessageDialog {
    private static String title;
    private static boolean knownError;
    private static String errorMessage;
    private static String javaStackTrace;
    private static String eventTrace;
    private static String className;
    private static String threadName;
    private static String textWithoutDetails;
    private static String textWithDetails;
    public static boolean suppressJavaExceptionDialogs;
    public static String modelName;
    private static final JButton SUPPRESS_BUTTON;
    private static final JCheckBox CHECKBOX;

    public static MessageDialog init(Component owner) {
        dialog = new RuntimeErrorDialog(owner);
        return dialog;
    }

    public static boolean alreadyVisible() {
        boolean bl = false;
        if (dialog != null && dialog.isVisible()) {
            bl = true;
        }
        return bl;
    }

    public static void show(String title, Context context, Instruction instruction, Thread thread, Throwable throwable) {
        RuntimeErrorDialog.title = title;
        threadName = thread.getName();
        knownError = throwable instanceof LogoException;
        boolean bl = false;
        if (!knownError && context == null) {
            bl = true;
        }
        SUPPRESS_BUTTON.setVisible(bl);
        javaStackTrace = Utils.getStackTrace(throwable);
        eventTrace = Event.recentEventTrace();
        errorMessage = context != null ? context.buildRuntimeErrorMessage(instruction, throwable) : (knownError ? throwable.getMessage() : null);
        RuntimeErrorDialog.buildTexts();
        RuntimeErrorDialog.showJavaDetails(CHECKBOX.isSelected());
    }

    protected List makeButtons() {
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        buttons.addAll(super.makeButtons());
        if (!Workspace.isApplet()) {
            JButton copyButton = new JButton("Copy");
            copyButton.addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    RuntimeErrorDialog.this.textArea.selectAll();
                    RuntimeErrorDialog.this.textArea.copy();
                    RuntimeErrorDialog.this.textArea.setCaretPosition(0);
                }
            });
            buttons.add(copyButton);
        }
        CHECKBOX.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                RuntimeErrorDialog.showJavaDetails(CHECKBOX.isSelected());
            }
        });
        buttons.add(CHECKBOX);
        SUPPRESS_BUTTON.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                suppressJavaExceptionDialogs = true;
                RuntimeErrorDialog.this.setVisible(false);
            }
        });
        buttons.add(SUPPRESS_BUTTON);
        return buttons;
    }

    private static final void buildTexts() {
        String extra = "";
        if (!knownError) {
            extra = "NetLogo is unable to supply you with more details about this error.  Please report the problem to bugs@ccl.northwestern.edu and paste the contents of this window into your E-mail.\n\n";
        }
        textWithoutDetails = "";
        if (errorMessage != null) {
            textWithoutDetails = errorMessage;
        }
        if (!(textWithDetails = textWithoutDetails).equals("")) {
            textWithDetails = textWithDetails + "\n\n";
        }
        textWithDetails = textWithDetails + extra + javaStackTrace + '\n' + Version.version() + "\nmain: " + className + "\nthread: " + threadName + '\n' + Utils.getVMInfoString() + '\n' + Utils.getOSInfoString() + "\nmodel: " + modelName + "\n\n" + eventTrace;
        if (!Workspace.isApp()) {
            String browser = Utils.getBrowserInfoString();
            textWithDetails = textWithDetails + '\n';
            textWithDetails = textWithDetails + (browser == null ? "running as applet in unknown browser" : "browser info: " + browser);
        }
    }

    private static final void showJavaDetails(boolean flag) {
        if (knownError) {
            CHECKBOX.setVisible(true);
        } else {
            CHECKBOX.setVisible(false);
            flag = true;
        }
        int lines = 1;
        int lineBegin = 0;
        int longestLine = 0;
        String text = flag ? textWithDetails : textWithoutDetails;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                ++lines;
                if (i - lineBegin > longestLine) {
                    longestLine = i - lineBegin;
                }
                lineBegin = i;
            }
            ++i;
        }
        longestLine += 2;
        if (lines < 5) {
            lines = 5;
        }
        if (lines > 15) {
            lines = 15;
        }
        if (longestLine > 70) {
            longestLine = 70;
        }
        ((RuntimeErrorDialog)dialog).doShow(title, text, lines, longestLine);
    }

    protected RuntimeErrorDialog(Component owner) {
        super(owner);
        className = owner.getClass().getName();
    }

    static {
        suppressJavaExceptionDialogs = false;
        SUPPRESS_BUTTON = new JButton("Don't show again");
        CHECKBOX = new JCheckBox("Show internal details");
    }
}

