/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.nlogo.awt.Utils;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.Widget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class Slider
extends Widget {
    static final int LEFT_MARGIN = 1;
    static final int RIGHT_MARGIN = 2;
    private static final int MIN_HEIGHT = 33;
    private static final int MIN_WIDTH = 92;
    private static final int MIN_PREFERRED_WIDTH = 150;
    private static final int PADDING = 23;
    private static final int CHANNEL_HEIGHT = 12;
    private static final int CHANNEL_Y_POS = 3;
    private static final int HANDLE_Y_POS = 2;
    private static final int HANDLE_WIDTH = 8;
    private static final int HANDLE_HEIGHT = 14;
    protected final Handle handle;
    protected final Channel channel;
    protected String name;
    protected String units;
    protected Number minimum;
    protected Number maximum;
    protected Number increment;
    protected Number value;

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.handle.setToolTipText(text);
        this.channel.setToolTipText(text);
    }

    public void doLayout() {
        super.doLayout();
        float scaleFactor = this.getBorder() != null ? (float)this.getHeight() / 33.0f : (float)this.getHeight() / 18.0f;
        this.handle.setSize((int)(8.0f * scaleFactor), (int)(14.0f * scaleFactor));
        this.handle.setLocation(this.handleXPos(), 2);
        this.channel.setBounds(1, 3, this.getBounds().width - 1 - 2, (int)(12.0f * scaleFactor));
    }

    private final int handleXPos() {
        return 7 + (int)StrictMath.round((this.value.doubleValue() - this.minimum.doubleValue()) / this.scaleFactor()) - this.handle.getBounds().width / 2;
    }

    public Dimension getMinimumSize() {
        if (this.getBorder() != null) {
            return new Dimension(92, 33);
        }
        return new Dimension(30, 14);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, 33);
    }

    public Dimension getPreferredSize(Font font) {
        int width = 0;
        FontMetrics metrics = this.getFontMetrics(font);
        width = this.maxValueWidth(metrics) + metrics.stringWidth(this.name) + 2 + 1 + 23;
        return new Dimension(StrictMath.max(width, 150), 33);
    }

    private final int maxValueWidth(FontMetrics metrics) {
        int result = metrics.stringWidth(this.valueString(this.minimum));
        result = StrictMath.max(result, metrics.stringWidth(this.valueString(this.maximum)));
        if (this.isIntegerSlider()) {
            result = StrictMath.max(result, metrics.stringWidth(this.valueString(new Integer(this.minimum.intValue() + this.increment.intValue()))));
            result = StrictMath.max(result, metrics.stringWidth(this.valueString(new Integer(this.maximum.intValue() - this.increment.intValue()))));
        } else {
            result = StrictMath.max(result, metrics.stringWidth(this.valueString(new Double(this.minimum.doubleValue() + this.increment.doubleValue()))));
            result = StrictMath.max(result, metrics.stringWidth(this.valueString(new Double(this.maximum.doubleValue() - this.increment.doubleValue()))));
        }
        return result;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
        this.repaint();
    }

    public String units() {
        return this.units;
    }

    public void units(String units) {
        this.units = units;
        this.repaint();
    }

    public Number minimum() {
        return this.minimum;
    }

    public void minimum(Number minimum) {
        this.minimum = minimum;
        this.value(this.value);
        this.revalidate();
        this.repaint();
    }

    public Number maximum() {
        return this.maximum;
    }

    public void maximum(Number maximum) {
        this.maximum = maximum;
        this.value(this.value);
        this.revalidate();
        this.repaint();
    }

    protected Number effectiveMaximum() {
        if (this.minimum.doubleValue() >= this.maximum.doubleValue()) {
            return this.minimum();
        }
        if (this.increment.doubleValue() == 0.0) {
            return this.minimum();
        }
        double result = this.minimum.doubleValue() + this.increment().doubleValue() * StrictMath.floor((this.maximum.doubleValue() - this.minimum.doubleValue()) / this.increment.doubleValue());
        if (org.nlogo.util.Utils.approximate(result + this.increment().doubleValue(), this.getPrecision()) <= this.maximum.doubleValue()) {
            result += this.increment().doubleValue();
        }
        if (this.isIntegerSlider()) {
            return new Integer((int)StrictMath.round(result));
        }
        return new Double(org.nlogo.util.Utils.approximate(result, this.getPrecision()));
    }

    public Number increment() {
        return this.increment;
    }

    public void increment(Number increment) {
        this.increment = increment;
        this.value(this.value);
        this.revalidate();
        this.repaint();
    }

    public Number value() {
        return this.value;
    }

    public void value(Number value) {
        this.valueSetter(value);
    }

    public void value(Number value, boolean buttonRelease) {
        this.valueSetter(value);
    }

    protected void valueSetter(Number value) {
        Number oldValue = this.value;
        if (value.doubleValue() > this.effectiveMaximum().doubleValue()) {
            value = this.effectiveMaximum();
        } else if (value.doubleValue() <= this.minimum().doubleValue()) {
            value = this.minimum();
        } else {
            value = new Double(org.nlogo.util.Utils.approximate(value.doubleValue(), this.getPrecision()));
            double numDivisions = StrictMath.floor((value.doubleValue() - this.minimum.doubleValue()) / this.increment.doubleValue());
            double roundedDown = this.minimum.doubleValue() + numDivisions * this.increment.doubleValue();
            double roundedUp = this.minimum.doubleValue() + (numDivisions + 1.0) * this.increment.doubleValue();
            if (roundedUp <= this.effectiveMaximum().doubleValue()) {
                double newValue = StrictMath.abs(value.doubleValue() - roundedDown) < StrictMath.abs(roundedUp - value.doubleValue()) ? roundedDown : roundedUp;
                value = new Double(newValue);
            } else {
                value = this.effectiveMaximum();
            }
        }
        if (this.isIntegerSlider() && value instanceof Double) {
            value = new Integer(value.intValue());
        } else if (!this.isIntegerSlider() && value instanceof Integer) {
            value = new Double(value.doubleValue());
        }
        if (!this.isIntegerSlider()) {
            value = new Double(org.nlogo.util.Utils.approximate(value.doubleValue(), this.getPrecision()));
        }
        this.value = value;
        if (!value.equals(oldValue)) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isIntegerSlider() {
        boolean bl = false;
        if (this.minimum instanceof Integer && this.maximum instanceof Integer && this.increment instanceof Integer) {
            bl = true;
        }
        return bl;
    }

    public void handlePositionChanged(int x, boolean buttonRelease) {
        double newValue = this.minimum.doubleValue() + (double)x * this.scaleFactor();
        if (this.isIntegerSlider()) {
            this.value(new Integer((int)StrictMath.round(newValue)), buttonRelease);
        } else {
            this.value(new Double(newValue), buttonRelease);
        }
    }

    public void incrementClick(int x) {
        Rectangle thisRect = this.channel.getBounds();
        Rectangle handleRect = this.handle.getBounds();
        int center = handleRect.x + this.handle.getBounds().width / 2;
        if (x + thisRect.x > center) {
            this.value(new Double(this.value.doubleValue() + this.increment.doubleValue()));
        } else {
            this.value(new Double(this.value.doubleValue() - this.increment.doubleValue()));
        }
    }

    private final String valueString(Number num) {
        String result;
        if (num instanceof Integer) {
            result = num.toString();
        } else {
            String numString = num.toString();
            int precision = this.getPrecision();
            int place = numString.indexOf(46);
            if (place == -1) {
                numString = numString + '.';
                place = numString.length() - 1;
            }
            if (numString.indexOf(69) == -1) {
                int padding = precision - (numString.length() - place - 1);
                int i = 0;
                while (i < padding) {
                    numString = numString + '0';
                    ++i;
                }
            }
            result = numString;
        }
        if (this.units.equals("")) {
            return result;
        }
        return result + ' ' + this.units;
    }

    private final double scaleFactor() {
        return (this.maximum().doubleValue() - this.minimum.doubleValue()) / (double)(this.getBounds().width - 1 - 2 - 6 - 6);
    }

    private final int getPrecision() {
        int incPrec;
        int minPrec = this.getPrecision(this.minimum);
        return minPrec > (incPrec = this.getPrecision(this.increment)) ? minPrec : incPrec;
    }

    private final int getPrecision(Number n) {
        String s = n.toString();
        int place = 0;
        int prec = 0;
        place = s.indexOf("E");
        if (place != -1) {
            String precstr = s.substring(place + 2);
            prec = Integer.valueOf(precstr);
        } else {
            place = s.indexOf(".");
            if (place != -1) {
                while (s.lastIndexOf(48) == s.length() - 1) {
                    s = s.substring(0, s.length() - 1);
                }
                prec = s.length() - place - 1;
            }
        }
        return prec;
    }

    public void paintComponent(Graphics g) {
        int padLabelHeight = 4;
        int padNameHeight = 3;
        int nameXOffset = 10;
        Rectangle rect = this.getBounds();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        super.paintComponent(g);
        if (this.getBorder() != null) {
            g.setColor(this.getForeground());
            String valueString = this.valueString(this.value);
            FontMetrics fontMetrics = g.getFontMetrics();
            int labelHeight = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + padLabelHeight;
            Rectangle newRect = new Rectangle(rect);
            newRect.x = 0;
            newRect.width = this.getWidth();
            newRect.y = rect.height - labelHeight;
            newRect.height = labelHeight;
            int valueWidth = fontMetrics.stringWidth(valueString);
            String shortenedName = Utils.shortenStringToFit(this.name, rect.width - nameXOffset - valueWidth - 2 - 6 - 2, fontMetrics);
            g.setColor(this.getForeground());
            g.drawString(shortenedName, nameXOffset, rect.height - fontMetrics.getMaxDescent() - padNameHeight);
            g.drawString(valueString, rect.width - valueWidth - 2 - 6, rect.height - fontMetrics.getMaxDescent() - padNameHeight);
        }
    }

    private final /* synthetic */ void this() {
        this.handle = new Handle();
        this.channel = new Channel();
        this.name = "";
        this.units = "";
        this.minimum = new Integer(0);
        this.maximum = new Integer(100);
        this.increment = new Integer(1);
        this.value = new Integer(50);
    }

    public Slider() {
        this.this();
        this.setOpaque(true);
        this.setLayout(null);
        this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
        Utils.adjustDefaultFont(this);
        this.add(this.handle);
        this.add(this.channel);
        this.doLayout();
    }

    public Slider(Color handleBackground, Color channelBackground) {
        this.this();
        this.handle.setBackground(handleBackground);
        this.channel.setBackground(channelBackground);
        this.setOpaque(true);
        this.setLayout(null);
        this.setBackground(InterfaceColors.SLIDER_BACKGROUND);
        Utils.adjustDefaultFont(this);
        this.add(this.handle);
        this.add(this.channel);
        this.doLayout();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class Handle
    extends JPanel {
        public Point getToolTipLocation(MouseEvent e) {
            Point loc = Slider.this.getToolTipLocation(e);
            if (loc != null) {
                loc = new Point(loc);
                loc.translate(-this.getX(), -this.getY());
            }
            return loc;
        }

        private final void changed(int mouseX, boolean buttonReleased) {
            Slider.this.handlePositionChanged(mouseX + this.getX() - this.getWidth() / 2, buttonReleased);
        }

        Handle() {
            this.setBackground(InterfaceColors.SLIDER_HANDLE);
            this.setBorder(org.nlogo.swing.Utils.createWidgetBorder());
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(){

                public final void mouseReleased(MouseEvent e) {
                    Handle.this.changed(e.getX(), true);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public final void mouseDragged(MouseEvent e) {
                    Handle.this.changed(e.getX(), false);
                }
            });
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private strictfp class Channel
    extends JComponent {
        static final int CHANNEL_LEFT_MARGIN = 6;
        static final int CHANNEL_RIGHT_MARGIN = 6;

        public Point getToolTipLocation(MouseEvent e) {
            Point loc = Slider.this.getToolTipLocation(e);
            if (loc != null) {
                loc = new Point(loc);
                loc.translate(-this.getX(), -this.getY());
            }
            return loc;
        }

        public void paintComponent(Graphics g) {
            int x = 6;
            int y = 0;
            int width = this.getWidth() - 6 - 6;
            int height = this.getHeight();
            g.setColor(this.getBackground());
            g.fillRect(x, y, width, height);
            org.nlogo.swing.Utils.createWidgetBorder().paintBorder(this, g, x, y, width, height);
        }

        Channel() {
            this.setOpaque(false);
            this.setBackground(Utils.mixColors(InterfaceColors.SLIDER_BACKGROUND, Color.BLACK, 0.5));
            this.addMouseListener(new MouseAdapter(){

                public final void mousePressed(MouseEvent e) {
                    if (Utils.button1Mask(e)) {
                        Slider.this.incrementClick(e.getX());
                    }
                }
            });
        }
    }
}

