/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import org.nlogo.agent.ShapeList;
import org.nlogo.agent.Turtle;
import org.nlogo.shapes.VectorShape;
import org.nlogo.util.Exceptions;
import org.nlogo.util.RingBufferQueue;
import org.nlogo.window.AWTColor;
import org.nlogo.window.CacheKey;
import org.nlogo.window.CachedShape;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class TurtleDrawer {
    private static final double ANGLESTEP = 15.0;
    private static final int NUM_ANGLESTEPS = 24;
    private static final int MAX_CACHE_PIXELS = 0x100000;
    private static final int WINDOWS_MAX_CACHE_SIZE = 4000;
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private final RingBufferQueue cacheQueue;
    private final Map shapeCache;
    private final CacheKey reusableCacheKey;
    private final ShapeList shapeList;
    private int cellSize;
    private int cacheSize;

    public String getCacheReport() {
        return "shapes " + this.cacheSize + " pixels " + this.cacheSize * this.cellSize * this.cellSize + (IS_WINDOWS ? " (limit=4000)" : "");
    }

    public void resetCache(double patchSize) {
        while (this.cacheSize > 0) {
            this.discardOldestShape();
        }
        this.shapeCache.clear();
        this.cacheQueue.removeAll();
        this.cacheSize = 0;
        this.cellSize = (int)StrictMath.floor(patchSize);
    }

    public void drawTurtle(Graphics g, int x, int y, int width, int height, double size, Turtle turtle, boolean useCache) {
        VectorShape shape = (VectorShape)turtle.cachedShape();
        if (shape == null) {
            shape = (VectorShape)this.shapeList.shape(turtle.shape());
            turtle.cachedShape(shape);
        }
        if (useCache) {
            Color fgColor = shape.fgRecolorable() ? AWTColor.getColor(turtle.color()) : Color.WHITE;
            CachedShape cachedShape = this.getShape(shape, fgColor, turtle.heading());
            if (cachedShape != null) {
                cachedShape.draw(g, x, y);
            } else {
                shape.paint(g, AWTColor.getColor(turtle.color()), x, y, size, width, height, (int)turtle.heading());
            }
        } else {
            shape.paint(g, AWTColor.getColor(turtle.color()), x, y, size, width, height, (int)turtle.heading());
        }
    }

    private final CachedShape getShape(VectorShape shape, Color color, double angle) {
        int angleIndex;
        if (shape.isRotatable()) {
            angleIndex = (int)StrictMath.rint(angle / 15.0);
            if (angleIndex == 24) {
                angleIndex = 0;
            }
            angle = (double)angleIndex * 15.0;
        } else {
            angleIndex = 0;
            angle = 0.0;
        }
        this.reusableCacheKey.reuse(color.getRGB(), angleIndex, shape);
        CachedShape cachedShape = (CachedShape)this.shapeCache.get(this.reusableCacheKey);
        if (cachedShape == null) {
            while (this.cacheSize * this.cellSize * this.cellSize >= 0x100000 || IS_WINDOWS && this.cacheSize >= 4000) {
                this.discardOldestShape();
            }
            cachedShape = new CachedShape(shape, (int)angle, this.cellSize, color);
            try {
                CacheKey newKey = (CacheKey)this.reusableCacheKey.clone();
                this.shapeCache.put(newKey, cachedShape);
                this.cacheQueue.addLast(newKey);
                ++this.cacheSize;
            }
            catch (CloneNotSupportedException ex) {
                Exceptions.handle(ex);
            }
        }
        return cachedShape;
    }

    private final void discardOldestShape() {
        CacheKey oldKey = (CacheKey)this.cacheQueue.getFirst();
        this.shapeCache.remove(oldKey);
        this.cacheQueue.removeFirst();
        --this.cacheSize;
    }

    private final /* synthetic */ void this() {
        this.cacheQueue = new RingBufferQueue();
        this.shapeCache = new HashMap();
        this.reusableCacheKey = new CacheKey(0, 0, null);
        this.cacheSize = 0;
    }

    public TurtleDrawer(ShapeList shapeList, double patchSize) {
        this.this();
        this.shapeList = shapeList;
        this.cellSize = (int)StrictMath.floor(patchSize);
    }
}

