/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window.graphing;

import java.util.ArrayList;
import java.util.List;
import org.nlogo.awt.Utils;
import org.nlogo.window.graphing.GraphException;
import org.nlogo.window.graphing.GraphListener;
import org.nlogo.window.graphing.GraphListenerLiaison;
import org.nlogo.window.graphing.GraphPen;
import org.nlogo.window.graphing.GraphWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class GraphManager
implements GraphListenerLiaison {
    private final List graphs;
    private GraphListener listener;
    private GraphWidget currentGraph;

    public GraphListener getListener() {
        return this.listener;
    }

    public void listener(GraphListener listener) {
        this.listener = listener;
    }

    public void currentGraph(GraphWidget currentGraph) {
        this.currentGraph = currentGraph;
    }

    public GraphWidget currentGraph() throws GraphException {
        Utils.mustBeEventDispatchThread();
        if (this.currentGraph == null) {
            throw new GraphException("There is no current plot.  Please select a current plot using the set-current-plot command.");
        }
        return this.currentGraph;
    }

    public boolean currentGraphNull() {
        Utils.mustBeEventDispatchThread();
        boolean bl = false;
        if (this.currentGraph == null) {
            bl = true;
        }
        return bl;
    }

    public GraphPen currentPen() throws GraphException {
        Utils.mustBeEventDispatchThread();
        return this.currentGraph().currentPen();
    }

    public GraphWidget createGraph(String s, boolean makeCurrent) {
        Utils.mustBeEventDispatchThread();
        GraphWidget graph = new GraphWidget(this);
        graph.plotName(s);
        if (makeCurrent) {
            this.currentGraph = graph;
        }
        this.graphs.add(graph);
        return graph;
    }

    public void selectGraphNoCreate(GraphWidget graph) {
        Utils.mustBeEventDispatchThread();
        this.currentGraph = graph;
    }

    private final GraphWidget selectGraph(String s) {
        Utils.mustBeEventDispatchThread();
        GraphWidget graph = this.getGraph(s);
        if (graph == null) {
            graph = this.createGraph(s, true);
        }
        this.currentGraph = graph;
        return this.currentGraph;
    }

    public boolean selectGraphNoCreate(String s) {
        Utils.mustBeEventDispatchThread();
        GraphWidget graph = this.getGraph(s);
        if (graph != null) {
            this.currentGraph = graph;
            return true;
        }
        return false;
    }

    public GraphWidget createUntitledGraph() {
        Utils.mustBeEventDispatchThread();
        return this.selectGraph(this.nextName());
    }

    private final String nextName() {
        String result;
        int nameCounter = 1;
        while (this.getGraph(result = "plot" + nameCounter++) != null) {
        }
        return result;
    }

    public GraphWidget getGraph(String name) {
        Utils.mustBeEventDispatchThread();
        int i = 0;
        while (i < this.graphs.size()) {
            GraphWidget graph = (GraphWidget)this.graphs.get(i);
            if (graph.plotName().toLowerCase().equals(name.toLowerCase())) {
                return graph;
            }
            ++i;
        }
        return null;
    }

    public boolean hasGraph(String name) {
        Utils.mustBeEventDispatchThread();
        boolean bl = false;
        if (this.getGraph(name) != null) {
            bl = true;
        }
        return bl;
    }

    public String[] getGraphNames() {
        Utils.mustBeEventDispatchThread();
        String[] graphNames = new String[this.graphs.size()];
        int i = 0;
        while (i < this.graphs.size()) {
            graphNames[i] = ((GraphWidget)this.graphs.get(i)).plotName();
            ++i;
        }
        return graphNames;
    }

    public void forgetGraph(GraphWidget goner) {
        if (this.currentGraph == goner) {
            this.currentGraph = null;
        }
        this.graphs.remove(goner);
    }

    public void clearAll() {
        Utils.mustBeEventDispatchThread();
        int i = 0;
        while (i < this.graphs.size()) {
            ((GraphWidget)this.graphs.get(i)).clear();
            ++i;
        }
        if (this.getListener() != null) {
            this.getListener().clearAll();
        }
    }

    private final /* synthetic */ void this() {
        this.graphs = new ArrayList();
        this.listener = null;
    }

    public GraphManager() {
        this.this();
    }
}

