/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window.graphing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.nlogo.agent.CSV;
import org.nlogo.util.Utils;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.graphing.GraphPen;
import org.nlogo.window.graphing.GraphPenList;
import org.nlogo.window.graphing.GraphPoint;
import org.nlogo.window.graphing.GraphWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
strictfp class GraphPlot
extends JPanel {
    private static final double AUTOPLOT_X_FACTOR = 1.25;
    private static final double AUTOPLOT_Y_FACTOR = 1.1;
    private GraphWidget owner;
    private boolean dirty;
    private boolean repaintNeeded;
    private final GraphPenList penList;
    GraphPen currentPen;
    private boolean mouseHere;
    private Point mouseLoc;
    private final MouseListener mouseListener;
    private final MouseMotionListener mouseMotionListener;
    private boolean autoPlotOn;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    Image offScreenImage;
    Graphics gOff;
    private int numBars;
    private int[] bars;
    private double barWidth;
    private int histMax;

    void repaintIfNeeded() {
        if (this.dirty) {
            this.setupOffscreenImage();
            if (this.dirty) {
                this.refresh();
            }
        }
        if (this.repaintNeeded) {
            this.repaintNeeded = false;
            this.repaint();
        }
    }

    void dirty() {
        this.dirty = true;
    }

    GraphPenList penList() {
        return this.penList;
    }

    void penList(List newPens) {
        this.penList.clear();
        int i = 0;
        while (i < newPens.size()) {
            GraphPen pen = (GraphPen)((GraphPen)newPens.get(i)).clone();
            this.penList.addPen(pen);
            ++i;
        }
    }

    GraphPen getPen(String s) {
        return this.penList.getPen(s.toLowerCase());
    }

    GraphPen getFirstPen() {
        return this.penList.getFirst();
    }

    GraphPen createPen(String s, boolean temporary) {
        GraphPen pen = new GraphPen();
        pen.displayName(s);
        pen.temporary(temporary);
        this.penList.addPen(pen);
        return pen;
    }

    void autoPlotOn(boolean autoPlotOn) {
        this.autoPlotOn = autoPlotOn;
    }

    boolean autoPlotOn() {
        return this.autoPlotOn;
    }

    void xMin(double xMin) {
        this.xMin = xMin;
        if (this.owner != null) {
            String label = Double.toString(xMin);
            if (label.endsWith(".0")) {
                label = label.substring(0, label.length() - 2);
            }
            this.owner.xMinLabel(label);
        }
    }

    double xMin() {
        return this.xMin;
    }

    void xMax(double xMax) {
        this.xMax = xMax;
        if (this.owner != null) {
            String label = Double.toString(xMax);
            if (label.endsWith(".0")) {
                label = label.substring(0, label.length() - 2);
            }
            this.owner.xMaxLabel(label);
        }
    }

    double xMax() {
        return this.xMax;
    }

    void yMin(double yMin) {
        this.yMin = yMin;
        if (this.owner != null) {
            String label = Double.toString(yMin);
            if (label.endsWith(".0")) {
                label = label.substring(0, label.length() - 2);
            }
            this.owner.yMinLabel(label);
        }
    }

    double yMin() {
        return this.yMin;
    }

    void yMax(double yMax) {
        this.yMax = yMax;
        if (this.owner != null) {
            String label = Double.toString(yMax);
            if (label.endsWith(".0")) {
                label = label.substring(0, label.length() - 2);
            }
            this.owner.yMaxLabel(label);
        }
    }

    double yMax() {
        return this.yMax;
    }

    private final boolean pointOnGraph(GraphPoint p) {
        return this.pointOnGraph(p.xcor(), p.ycor());
    }

    private final boolean pointOnGraph(double x, double y) {
        boolean bl = false;
        if (x >= this.xMin() && x <= this.xMax() && y >= this.yMin() && y <= this.yMax()) {
            bl = true;
        }
        return bl;
    }

    public void paintComponent(Graphics g) {
        this.setupOffscreenImage();
        g.drawImage(this.offScreenImage, 0, 0, null);
        if (this.mouseHere) {
            this.drawMouseCoords(g);
        }
    }

    private final void drawMouseCoords(Graphics g) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int fontHeight = fontMetrics.getAscent();
        int xPrecision = (int)(-StrictMath.floor(StrictMath.log(this.fromScreenXCor(1.0) - this.fromScreenXCor(0.0)) / StrictMath.log(10.0)));
        String xcor = Double.toString(Utils.approximate(this.fromScreenXCor(this.mouseLoc.x), xPrecision));
        if (xPrecision <= 0) {
            xcor = xcor.substring(0, xcor.length() - 2);
        }
        int xcorWidth = fontMetrics.stringWidth(xcor);
        int yPrecision = (int)(-StrictMath.floor(StrictMath.log(this.fromScreenYCor(0.0) - this.fromScreenYCor(1.0)) / StrictMath.log(10.0)));
        String ycor = Double.toString(Utils.approximate(this.fromScreenYCor(this.mouseLoc.y), yPrecision));
        if (yPrecision <= 0) {
            ycor = ycor.substring(0, ycor.length() - 2);
        }
        int ycorWidth = fontMetrics.stringWidth(ycor);
        int xx = this.mouseLoc.x - xcorWidth / 2;
        xx = StrictMath.max(xx, ycorWidth);
        xx = StrictMath.min(xx, this.getBounds().width - xcorWidth);
        int xy = this.getBounds().height - fontHeight + 1;
        g.setColor(InterfaceColors.PLOT_BACKGROUND);
        g.fillRect(xx - 1, xy, xcorWidth + 1, fontHeight + 1);
        g.setColor(Color.BLACK);
        g.drawString(xcor, xx, xy + fontHeight - 1);
        int yy = this.mouseLoc.y - fontHeight / 2;
        yy = StrictMath.max(yy, 0);
        yy = StrictMath.min(yy, this.getBounds().height - 2 * fontHeight);
        int yx = 0;
        g.setColor(InterfaceColors.PLOT_BACKGROUND);
        g.fillRect(yx, yy, ycorWidth + 1, fontHeight + 1);
        g.setColor(Color.BLACK);
        g.drawString(ycor, yx, yy + fontHeight - 1);
    }

    private final void setupOffscreenImage() {
        if (this.offScreenImage == null || this.offScreenImage.getWidth(this) != this.getWidth() || this.offScreenImage.getHeight(this) != this.getHeight()) {
            if (this.offScreenImage != null) {
                this.offScreenImage.flush();
                this.offScreenImage = null;
            }
            this.offScreenImage = this.createImage(this.getWidth(), this.getHeight());
            if (this.gOff != null) {
                this.gOff.dispose();
            }
            this.gOff = this.offScreenImage.getGraphics();
            ((Graphics2D)this.gOff).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.gOff.setColor(Color.WHITE);
            this.gOff.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.refresh();
        }
    }

    private final void refresh() {
        this.gOff.setColor(Color.WHITE);
        this.gOff.fillRect(0, 0, this.getWidth(), this.getHeight());
        Iterator iter = this.penList.pensIterator();
        while (iter.hasNext()) {
            GraphPen pen = (GraphPen)iter.next();
            if (pen.penModeChanged()) {
                pen.penModeChanged(false);
            }
            this.refreshPen(pen, this.collectPoints(pen));
        }
        this.dirty = false;
        this.repaintNeeded = true;
    }

    private final List collectPoints(GraphPen pen) {
        ArrayList<GraphPoint> pointsToPlot;
        switch (pen.plotPenMode()) {
            case 0: 
            case 2: {
                pointsToPlot = pen.points();
                break;
            }
            case 1: {
                GraphPoint point1 = null;
                GraphPoint point2 = null;
                GraphPoint point3 = null;
                GraphPoint point4 = null;
                this.barWidth(pen.plotInterval());
                pointsToPlot = new ArrayList<GraphPoint>();
                int i = 0;
                while (i < pen.points().size()) {
                    point2 = new GraphPoint((GraphPoint)pen.points().get(i));
                    point2.penDown(true);
                    point1 = new GraphPoint(point2);
                    point1.ycor(0.0);
                    point3 = new GraphPoint(point2);
                    point3.xcor(point3.xcor() + this.barWidth);
                    point4 = new GraphPoint(point3);
                    point4.ycor(0.0);
                    point4.penDown(false);
                    pointsToPlot.add(point1);
                    pointsToPlot.add(point2);
                    pointsToPlot.add(point3);
                    pointsToPlot.add(point4);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return pointsToPlot;
    }

    private final void refreshPen(GraphPen pen, List pointsToPlot) {
        GraphPoint last = null;
        Color color = null;
        int minY = 0;
        int maxY = 0;
        boolean coalescing = false;
        int i = 0;
        while (pointsToPlot.size() != i) {
            GraphPoint next = (GraphPoint)pointsToPlot.get(i);
            if (!next.color().equals(color)) {
                color = next.color();
                this.gOff.setColor(color);
            }
            if (pen.plotPenMode() == 2) {
                this.drawPoint(this.gOff, next);
            } else if (last == null || !last.penDown()) {
                this.drawEdge(this.gOff, next, next);
            } else if (i != pointsToPlot.size() - 1 && last != null && this.screenXCor(last.xcor()) == this.screenXCor(next.xcor()) && last.color().equals(next.color()) && last.penDown() == next.penDown()) {
                int y = this.screenYCor(next.ycor());
                if (coalescing) {
                    minY = StrictMath.min(minY, y);
                    maxY = StrictMath.max(maxY, y);
                } else {
                    this.drawEdge(this.gOff, last, next);
                    coalescing = true;
                    minY = y;
                    maxY = y;
                }
            } else {
                if (coalescing) {
                    this.gOff.setColor(last.color());
                    this.gOff.fillRect(this.screenXCor(last.xcor()), minY, 1, maxY - minY + 1);
                    coalescing = false;
                    this.gOff.setColor(color);
                }
                this.drawEdge(this.gOff, last, next);
            }
            last = next;
            ++i;
        }
    }

    private final boolean fitGraphToPoint(GraphPoint p, boolean useFactors) {
        double x = p.xcor();
        double y = p.ycor();
        return this.fitGraphToPoint(x, y, useFactors);
    }

    private final boolean fitGraphToPoint(double pointX, double pointY, boolean useFactors) {
        double newRange;
        boolean changed = false;
        if (pointX > this.xMax()) {
            newRange = pointX - this.xMin();
            if (useFactors) {
                newRange *= 1.25;
            }
            this.xMax(Utils.approximateCeiling(this.xMin() + newRange, (int)((double)2 - StrictMath.floor(StrictMath.log(newRange) / StrictMath.log(10.0)))));
            changed = true;
        }
        if (pointX < this.xMin()) {
            newRange = this.xMax() - pointX;
            if (useFactors) {
                newRange *= 1.25;
            }
            this.xMin(Utils.approximateCeiling(this.xMax() - newRange, (int)((double)2 - StrictMath.floor(StrictMath.log(newRange) / StrictMath.log(10.0)))));
            changed = true;
        }
        if (pointY > this.yMax()) {
            newRange = pointY - this.yMin();
            if (useFactors) {
                newRange *= 1.1;
            }
            this.yMax(Utils.approximateCeiling(this.yMin() + newRange, (int)((double)2 - StrictMath.floor(StrictMath.log(newRange) / StrictMath.log(10.0)))));
            changed = true;
        }
        if (pointY < this.yMin()) {
            newRange = this.yMax() - pointY;
            if (useFactors) {
                newRange *= 1.1;
            }
            this.yMin(Utils.approximateCeiling(this.yMax() - newRange, (int)((double)2 - StrictMath.floor(StrictMath.log(newRange) / StrictMath.log(10.0)))));
            changed = true;
        }
        return changed;
    }

    void plot(double y) {
        if (this.currentPen.plotPenMode() == 1) {
            this.barWidth(this.currentPen.plotInterval());
        }
        this.currentPen.plot(y);
        this.updateForNewPoint();
    }

    void plot(double x, double y) {
        if (this.currentPen.plotPenMode() == 1) {
            this.barWidth(this.currentPen.plotInterval());
        }
        this.currentPen.plot(x, y);
        this.updateForNewPoint();
    }

    private final boolean enoughSpaceForPoint(GraphPoint pointToPlot) {
        if (this.currentPen.plotPenMode() != 1) {
            return this.pointOnGraph(pointToPlot);
        }
        GraphPoint temp = new GraphPoint(pointToPlot);
        temp.xcor(temp.xcor() + this.barWidth);
        temp.ycor(0.0);
        boolean bl = false;
        if (this.pointOnGraph(pointToPlot) && this.pointOnGraph(temp)) {
            bl = true;
        }
        return bl;
    }

    private final void updateForNewPoint() {
        if (this.currentPen.edgePoint2() == null || !this.currentPen.penDown()) {
            return;
        }
        if (this.autoPlotOn() && !this.enoughSpaceForPoint(this.currentPen.edgePoint2()) || this.currentPen.penModeChanged()) {
            this.fitGraphToPoint(this.currentPen.edgePoint2(), true);
            if (this.currentPen.plotPenMode() == 1) {
                this.barWidth(this.currentPen.plotInterval());
                GraphPoint temp = new GraphPoint(this.currentPen.edgePoint2());
                temp.xcor(temp.xcor() + this.barWidth);
                temp.ycor(0.0);
                this.fitGraphToPoint(temp, true);
            }
            this.dirty();
        } else if (!this.dirty) {
            GraphPoint point1 = this.currentPen.points().size() <= 1 ? this.currentPen.edgePoint2() : this.currentPen.edgePoint1();
            this.updatePartial(this.currentPen.plotPenMode(), this.currentPen.plotInterval(), point1, this.currentPen.edgePoint2());
            this.repaintNeeded = true;
        }
    }

    private final void updatePartial(int mode, double interval, GraphPoint point1, GraphPoint point2) {
        switch (mode) {
            case 2: {
                this.gOff.setColor(point2.color());
                this.drawPoint(this.gOff, point2);
                break;
            }
            case 0: {
                this.gOff.setColor(point2.color());
                this.drawEdge(this.gOff, point1, point2);
                break;
            }
            case 1: {
                this.barWidth(interval);
                point1 = new GraphPoint(point2);
                point1.ycor(0.0);
                GraphPoint point3 = new GraphPoint(point2);
                point3.xcor(point3.xcor() + this.barWidth);
                GraphPoint point4 = new GraphPoint(point3);
                point4.ycor(0.0);
                point4.penDown(false);
                this.gOff.setColor(point2.color());
                this.drawEdge(this.gOff, point1, point2);
                this.drawEdge(this.gOff, point2, point3);
                this.drawEdge(this.gOff, point3, point4);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void clear() {
        this.penList.clear();
        this.dirty();
    }

    void resetPen(boolean resetPoints) {
        GraphPen resetPen;
        if (this.currentPen.temporary()) {
            resetPen = new GraphPen();
            resetPen.color(this.currentPen.color());
            resetPen.plotPenMode(this.currentPen.plotPenMode());
            resetPen.plotInterval(this.currentPen.plotInterval());
        } else {
            resetPen = this.owner.defaultForPen(this.currentPen);
            resetPen.plotInterval(this.currentPen.plotInterval());
        }
        this.currentPen.reset(resetPoints, resetPen);
    }

    void penDown(boolean penDown) {
        this.currentPen.penDown(penDown);
        this.dirty();
    }

    private final void drawPoint(Graphics g, GraphPoint p) {
        g.drawRect(this.screenXCor(p.xcor()), this.screenYCor(p.ycor()), 1, 1);
    }

    private final void drawEdge(Graphics g, GraphPoint p1, GraphPoint p2) {
        g.drawLine(this.screenXCor(p1.xcor()), this.screenYCor(p1.ycor()), this.screenXCor(p2.xcor()), this.screenYCor(p2.ycor()));
    }

    private final int screenXCor(double x) {
        int width = this.getBounds().width - 1;
        double range = this.xMax() - this.xMin();
        double scale = range / (double)width;
        double result = StrictMath.rint((x - this.xMin()) / scale);
        if (result > 16383.0) {
            return 16383;
        }
        if (result < -16383.0) {
            return -16383;
        }
        return (int)result;
    }

    private final int screenYCor(double y) {
        int height = this.getBounds().height - 1;
        double range = this.yMax() - this.yMin();
        double scale = range / (double)height;
        double result = StrictMath.rint((double)height - (y - this.yMin()) / scale);
        if (result > 16383.0) {
            return 16383;
        }
        if (result < -16383.0) {
            return -16383;
        }
        return (int)result;
    }

    private final double fromScreenXCor(double screenX) {
        double width = this.getBounds().width - 1;
        double range = this.xMax() - this.xMin();
        return this.xMin() + screenX * range / width;
    }

    private final double fromScreenYCor(double screenY) {
        double height = this.getBounds().height - 1;
        double range = this.yMax() - this.yMin();
        return this.yMax() - screenY * range / height;
    }

    void setHistogramNumBars(int numBars) {
        this.currentPen.plotInterval((this.xMax() - this.xMin()) / (double)numBars);
    }

    List bars() {
        ArrayList<Integer> barsv = new ArrayList<Integer>(this.bars.length);
        int i = 0;
        while (i < this.bars.length) {
            barsv.add(new Integer(this.bars[i]));
            ++i;
        }
        return barsv;
    }

    void bars(List barsv) {
        this.bars = new int[barsv.size()];
        int bar = 0;
        while (bar < barsv.size()) {
            this.bars[bar] = (Integer)barsv.get(bar);
            if (this.bars[bar] > this.histMax) {
                this.histMax = this.bars[bar];
            }
            ++bar;
        }
    }

    void barWidth(double barWidth) {
        this.barWidth = barWidth;
    }

    double barWidth() {
        return this.barWidth;
    }

    void beginHistogram() {
        this.numBars = (int)StrictMath.floor((this.xMax() - this.xMin()) / this.currentPen.plotInterval());
        this.barWidth(this.currentPen.plotInterval());
        this.bars = new int[this.numBars];
        this.histMax = 0;
        this.currentPen.reset(true);
    }

    void nextHistogramValue(double value) {
        int bar = (int)StrictMath.floor((value - this.xMin()) / this.barWidth);
        if (bar >= 0 && bar < this.numBars) {
            int n = bar;
            this.bars[n] = this.bars[n] + 1;
            if (this.bars[bar] > this.histMax) {
                this.histMax = this.bars[bar];
            }
        }
    }

    void endHistogram() {
        if (this.autoPlotOn()) {
            this.fitGraphToPoint(this.xMin(), this.histMax, false);
        }
        int bar = 0;
        while (bar < this.bars.length) {
            double x = this.xMin() + (double)bar * this.barWidth;
            if (this.bars[bar] > 0) {
                double y = this.bars[bar];
                this.currentPen.penDownWOPlotting(true);
                this.currentPen.plot(x, y);
            } else {
                this.currentPen.penDownWOPlotting(false);
            }
            ++bar;
        }
        this.dirty();
    }

    void export(PrintWriter writer) {
        this.exportPlotGlobals(writer);
        this.exportPlotPensInfo(writer);
        this.exportPlotData(writer);
    }

    private final void exportPlotGlobals(PrintWriter writer) {
        writer.println(CSV.data(this.owner.plotName()));
        writer.println(CSV.headerRow(new String[]{"x min", "x max", "y min", "y max", "autoplot?", "current pen", "pens displayed?", "number of pens"}));
        writer.println(CSV.dataRow(new Object[]{new Double(this.owner.xMin()), new Double(this.owner.xMax()), new Double(this.owner.yMin()), new Double(this.owner.yMax()), new Boolean(this.owner.autoPlotOn()), this.currentPen.displayName(), new Boolean(this.penList.isOpen()), new Integer(this.penList.penCount())}));
        writer.println();
    }

    private final void exportPlotPensInfo(PrintWriter writer) {
        writer.println(CSV.headerRow(new String[]{"pen name", "pen down?", "mode", "interval", "color", "xcor"}));
        Iterator pensToExport = this.penList.pensIterator();
        while (pensToExport.hasNext()) {
            GraphPen penToExport = (GraphPen)pensToExport.next();
            writer.println(CSV.dataRow(new Object[]{penToExport.displayName(), new Boolean(penToExport.penDown()), new Integer(penToExport.plotPenMode()), new Double(penToExport.plotInterval()), CSV.rgbToLogoObject(penToExport.color().getRGB()), new Double(penToExport.xcor())}));
        }
        writer.println();
    }

    private final void exportPlotData(PrintWriter writer) {
        Iterator pens = this.penList.pensIterator();
        int numPlotPens = 0;
        while (pens.hasNext()) {
            String penName = ((GraphPen)pens.next()).displayName();
            writer.print(CSV.data(penName));
            if (pens.hasNext()) {
                writer.print(",,,,");
            }
            ++numPlotPens;
        }
        writer.println();
        ArrayList<String> pointHeaders = new ArrayList<String>();
        int numPointHeaders = 0;
        int i = 0;
        while (i < numPlotPens) {
            pointHeaders.add("x");
            pointHeaders.add("y");
            pointHeaders.add("color");
            pointHeaders.add("pen down?");
            numPointHeaders += 4;
            ++i;
        }
        writer.println(CSV.headerRow(pointHeaders.toArray(new String[0])));
        ArrayList penDataListsList = new ArrayList();
        pens = this.penList.pensIterator();
        int maxPenDataListSize = 0;
        while (pens.hasNext()) {
            GraphPen pen = (GraphPen)pens.next();
            ArrayList penDataList = pen.points();
            if (penDataList == null) {
                penDataList = new ArrayList();
            }
            maxPenDataListSize = StrictMath.max(maxPenDataListSize, penDataList.size());
            penDataListsList.add(penDataList);
        }
        GraphPoint[][] outColumnsArray = new GraphPoint[maxPenDataListSize][numPlotPens];
        int i2 = 0;
        while (i2 < numPlotPens) {
            List penDataList = (List)penDataListsList.get(i2);
            int penDataListSize = penDataList.size();
            int j = 0;
            while (j < penDataListSize) {
                outColumnsArray[j][i2] = (GraphPoint)penDataList.get(j);
                ++j;
            }
            ++i2;
        }
        int row = 0;
        while (row < maxPenDataListSize) {
            int col = 0;
            while (col < numPlotPens) {
                if (outColumnsArray[row][col] != null) {
                    writer.print(CSV.data(new Double(outColumnsArray[row][col].xcor())));
                    writer.print(",");
                    writer.print(CSV.data(new Double(outColumnsArray[row][col].ycor())));
                    writer.print(",");
                    writer.print(CSV.data(CSV.rgbToLogoObject(outColumnsArray[row][col].color().getRGB())));
                    writer.print(",");
                    writer.print(CSV.data(new Boolean(outColumnsArray[row][col].penDown())));
                    if (col + 1 < numPlotPens) {
                        writer.print(",");
                    }
                } else if (col + 1 < numPlotPens) {
                    writer.print(",,,,");
                } else {
                    writer.print(",,,");
                }
                ++col;
            }
            writer.println();
            ++row;
        }
    }

    static /* synthetic */ boolean access$0(GraphPlot graphPlot) {
        return graphPlot.mouseHere;
    }

    private final /* synthetic */ void this() {
        this.dirty = false;
        this.repaintNeeded = false;
        this.mouseHere = false;
        this.mouseLoc = null;
        this.mouseListener = new MouseAdapter(){

            public final void mouseEntered(MouseEvent e) {
                GraphPlot.this.mouseHere = true;
                GraphPlot.this.mouseLoc = e.getPoint();
                GraphPlot.this.repaint();
            }

            public final void mouseExited(MouseEvent e) {
                GraphPlot.this.mouseHere = false;
                GraphPlot.this.repaint();
            }
        };
        this.mouseMotionListener = new MouseMotionListener(){

            public final void mouseDragged(MouseEvent e) {
                GraphPlot.this.mouseLoc = e.getPoint();
                boolean bl = false;
                if (((GraphPlot)GraphPlot.this).mouseLoc.x >= 0 && ((GraphPlot)GraphPlot.this).mouseLoc.y >= 0 && ((GraphPlot)GraphPlot.this).mouseLoc.x < GraphPlot.this.getBounds().width && ((GraphPlot)GraphPlot.this).mouseLoc.y < GraphPlot.this.getBounds().height) {
                    bl = true;
                }
                GraphPlot.this.mouseHere = bl;
                GraphPlot.this.repaint();
            }

            public final void mouseMoved(MouseEvent e) {
                GraphPlot.this.mouseHere = true;
                GraphPlot.this.mouseLoc = e.getPoint();
                GraphPlot.this.repaint();
            }
        };
        this.numBars = 10;
    }

    GraphPlot(GraphWidget owner) {
        this.this();
        this.owner = owner;
        this.penList = new GraphPenList(owner);
        this.setOpaque(true);
        this.autoPlotOn = owner.defaultAutoPlotOn();
        this.setBackground(Color.WHITE);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }
}

