/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window.graphing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicButtonUI;
import org.nlogo.awt.ImageSelection;
import org.nlogo.awt.Utils;
import org.nlogo.event.ExportPlotEvent;
import org.nlogo.event.PeriodicUpdateEvent;
import org.nlogo.swing.FileDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.UserCancelException;
import org.nlogo.window.Editable;
import org.nlogo.window.InterfaceColors;
import org.nlogo.window.PropertyDescription;
import org.nlogo.window.Widget;
import org.nlogo.window.graphing.GraphException;
import org.nlogo.window.graphing.GraphListenerLiaison;
import org.nlogo.window.graphing.GraphPen;
import org.nlogo.window.graphing.GraphPenList;
import org.nlogo.window.graphing.GraphPlot;
import org.nlogo.window.graphing.GraphPoint;
import org.nlogo.window.graphing.GraphXAxisLabels;
import org.nlogo.window.graphing.GraphYAxisLabels;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public strictfp class GraphWidget
extends Widget
implements Editable,
ExportPlotEvent.Raiser,
PeriodicUpdateEvent.Handler {
    public static final int EXPORT_PROMPT = 0;
    public static final int EXPORT_ALL = 1;
    public static final int EXPORT_ARGUMENT = 2;
    private static final Dimension MIN_SIZE = new Dimension(160, 120);
    private static final Dimension PREF_SIZE = new Dimension(200, 150);
    private final GraphListenerLiaison liaison;
    private final GraphPlot graphPlot;
    private final GraphPenList penList;
    private final JLabel nameLabel;
    private final GraphXAxisLabels xAxis;
    private final GraphYAxisLabels yAxis;
    private double defaultXMin;
    private double defaultXMax;
    private double defaultYMin;
    private double defaultYMax;
    private boolean defaultAutoPlotOn;
    private List defaultPlotPens;
    private List propertySet;
    private boolean includeInterfaceGlobalsInExport;

    public String classDisplayName() {
        return "Plot";
    }

    public String displayName() {
        Utils.mustBeEventDispatchThread();
        return this.plotName();
    }

    public boolean needsPreferredWidthFudgeFactor() {
        return false;
    }

    public boolean zoomSubcomponents() {
        return true;
    }

    public List propertySet() {
        if (this.propertySet == null) {
            this.propertySet = new ArrayList();
            this.propertySet.add(new PropertyDescription("plotName", "Name", "String", 0, true));
            this.propertySet.add(new PropertyDescription("xLabel", "X axis label", "String", 1, false));
            this.propertySet.add(new PropertyDescription("defaultXMin", "X min", "Double", -1, false));
            this.propertySet.add(new PropertyDescription("defaultXMax", "X max", "Double", 0, false));
            this.propertySet.add(new PropertyDescription("yLabel", "Y axis label", "String", 1, false));
            this.propertySet.add(new PropertyDescription("defaultYMin", "Y min", "Double", -1, false));
            this.propertySet.add(new PropertyDescription("defaultYMax", "Y max", "Double", 0, false));
            this.propertySet.add(new PropertyDescription("defaultAutoPlotOn", "Autoplot?", "Boolean", 0, false));
            this.propertySet.add(new PropertyDescription("editPlotPens", "Plot pens", "PlotPens", 0, false));
        }
        return this.propertySet;
    }

    public void editFinished() {
        Utils.mustBeEventDispatchThread();
        super.editFinished();
        this.clear();
    }

    public boolean hasContextMenu() {
        return true;
    }

    public void populateContextMenu(JPopupMenu menu, Point p) {
        JMenuItem copyItem = new JMenuItem("Copy Image");
        copyItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(GraphWidget.this.exportGraphics()), null);
            }
        });
        menu.add(copyItem);
        JMenuItem exportItem = new JMenuItem("Export...");
        exportItem.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                try {
                    String exportPath = FileDialog.show(GraphWidget.this, "Exporting", 1, "plot.csv");
                    new ExportPlotEvent(GraphWidget.this, 2, GraphWidget.this, exportPath).raise();
                }
                catch (UserCancelException uce) {
                    Exceptions.ignore(uce);
                }
            }
        });
        menu.add(exportItem);
    }

    public List editPlotPens() {
        Utils.mustBeEventDispatchThread();
        ArrayList<Object> pens = new ArrayList<Object>(this.defaultPlotPens.size());
        int i = 0;
        while (i < this.defaultPlotPens.size()) {
            pens.add(((GraphPen)this.defaultPlotPens.get(i)).clone());
            ++i;
        }
        return pens;
    }

    public void editPlotPens(List plotPens) {
        Utils.mustBeEventDispatchThread();
        GraphPen defaultPen = (GraphPen)plotPens.get(0);
        if (defaultPen.temporary() && !this.isDefaultPen(defaultPen)) {
            defaultPen.temporary(false);
        }
        this.defaultPlotPens = plotPens;
        if (this.penList.isOpen()) {
            this.penList.emptyAndFill();
        }
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().editPlotPens(plotPens);
        }
    }

    GraphPen defaultForPen(GraphPen pen) {
        Utils.mustBeEventDispatchThread();
        int i = 0;
        while (i < this.defaultPlotPens.size()) {
            GraphPen defaultPen = (GraphPen)this.defaultPlotPens.get(i);
            if (pen.displayName().equals(defaultPen.displayName())) {
                return (GraphPen)defaultPen.clone();
            }
            ++i;
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    public Dimension getPreferredSize(Font font) {
        return PREF_SIZE;
    }

    public Dimension getMaximumSize() {
        return null;
    }

    private final boolean isDefaultPen(GraphPen pen) {
        boolean bl = false;
        if (pen.displayName().equals("default") && pen.color().equals(Color.BLACK) && pen.plotInterval() == 1.0 && pen.plotPenMode() == 0) {
            bl = true;
        }
        return bl;
    }

    public void clear() {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.clear();
        this.graphPlot.penList(this.defaultPlotPens);
        this.graphPlot.currentPen = this.graphPlot.getFirstPen();
        this.graphPlot.xMin(this.defaultXMin);
        this.graphPlot.xMax(this.defaultXMax);
        this.graphPlot.yMin(this.defaultYMin);
        this.graphPlot.yMax(this.defaultYMax);
        this.graphPlot.autoPlotOn(this.defaultAutoPlotOn);
        if (this.penList.isOpen()) {
            this.penList.emptyAndFill();
        }
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().clear();
        }
    }

    public String plotName() {
        Utils.mustBeEventDispatchThread();
        return this.nameLabel.getText();
    }

    public void plotName(String name) {
        Utils.mustBeEventDispatchThread();
        this.nameLabel.setText(name);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().plotName(name);
        }
    }

    public String xLabel() {
        Utils.mustBeEventDispatchThread();
        return this.xAxis.getLabel();
    }

    public void xLabel(String label) {
        Utils.mustBeEventDispatchThread();
        this.xAxis.setLabel(label);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().xLabel(label);
        }
    }

    public String yLabel() {
        Utils.mustBeEventDispatchThread();
        return this.yAxis.getLabel();
    }

    public void yLabel(String label) {
        Utils.mustBeEventDispatchThread();
        this.yAxis.setLabel(label);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().yLabel(label);
        }
    }

    public double defaultXMin() {
        Utils.mustBeEventDispatchThread();
        return this.defaultXMin;
    }

    public void defaultXMin(double defaultXMin) {
        Utils.mustBeEventDispatchThread();
        this.defaultXMin = defaultXMin;
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().defaultXMin(defaultXMin);
        }
    }

    public double defaultYMin() {
        Utils.mustBeEventDispatchThread();
        return this.defaultYMin;
    }

    public void defaultYMin(double defaultYMin) {
        Utils.mustBeEventDispatchThread();
        this.defaultYMin = defaultYMin;
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().defaultYMin(defaultYMin);
        }
    }

    public double defaultXMax() {
        Utils.mustBeEventDispatchThread();
        return this.defaultXMax;
    }

    public void defaultXMax(double defaultXMax) {
        Utils.mustBeEventDispatchThread();
        this.defaultXMax = defaultXMax;
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().defaultXMax(defaultXMax);
        }
    }

    public double defaultYMax() {
        Utils.mustBeEventDispatchThread();
        return this.defaultYMax;
    }

    public void defaultYMax(double defaultYMax) {
        Utils.mustBeEventDispatchThread();
        this.defaultYMax = defaultYMax;
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().defaultYMax(defaultYMax);
        }
    }

    public boolean defaultAutoPlotOn() {
        Utils.mustBeEventDispatchThread();
        return this.defaultAutoPlotOn;
    }

    public void defaultAutoPlotOn(boolean defaultAutoPlotOn) {
        Utils.mustBeEventDispatchThread();
        this.defaultAutoPlotOn = defaultAutoPlotOn;
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().defaultAutoPlotOn(defaultAutoPlotOn);
        }
    }

    void xMinLabel(String label) {
        Utils.mustBeEventDispatchThread();
        this.xAxis.setMin(label);
    }

    void xMaxLabel(String label) {
        Utils.mustBeEventDispatchThread();
        this.xAxis.setMax(label);
    }

    void yMinLabel(String label) {
        Utils.mustBeEventDispatchThread();
        this.yAxis.setMin(label);
    }

    void yMaxLabel(String label) {
        Utils.mustBeEventDispatchThread();
        this.yAxis.setMax(label);
    }

    GraphPen currentPen() {
        Utils.mustBeEventDispatchThread();
        return this.graphPlot.currentPen;
    }

    public void beginHistogram() throws GraphException {
        Utils.mustBeEventDispatchThread();
        if (this.graphPlot.currentPen.plotInterval() == 0.0) {
            throw new GraphException("You cannot histogram with a plot-pen-interval of 0.");
        }
        this.beginHistogramSafe();
    }

    public void beginHistogramSafe() {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.beginHistogram();
    }

    public void nextHistogramValue(double value) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.nextHistogramValue(value);
    }

    public void histogramFromBars(List bars) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.bars(bars);
    }

    public void endHistogram() {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.endHistogram();
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().histogram(this.graphPlot.bars());
        }
    }

    public boolean autoPlotOn() {
        Utils.mustBeEventDispatchThread();
        return this.graphPlot.autoPlotOn();
    }

    public void autoPlotOn(boolean flag) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.autoPlotOn(flag);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().autoPlotOn(flag);
        }
    }

    public boolean validPlotPenMode(int plotPenMode) {
        Utils.mustBeEventDispatchThread();
        return this.graphPlot.currentPen.validPlotPenMode(plotPenMode);
    }

    public void plotPenMode(int plotPenMode) {
        Utils.mustBeEventDispatchThread();
        if (this.validPlotPenMode(plotPenMode)) {
            this.graphPlot.currentPen.plotPenMode(plotPenMode);
            this.graphPlot.dirty();
            if (this.liaison.getListener() != null) {
                this.liaison.getListener().plotPenMode(plotPenMode);
            }
        }
    }

    public void plot(double y) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.plot(y);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().plot(this.graphPlot.currentPen.xcor(), y);
        }
    }

    public void plot(double x, double y) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.plot(x, y);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().plot(x, y);
        }
    }

    public void resetPen(boolean resetPoints) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.resetPen(resetPoints);
        this.graphPlot.dirty();
        this.graphPlot.currentPen.repaint();
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().resetPen(resetPoints);
        }
    }

    public void penDown(boolean flag) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.penDown(flag);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().penDown(flag);
        }
    }

    public void setHistogramNumBars(int num) throws GraphException {
        Utils.mustBeEventDispatchThread();
        if (num == 0) {
            throw new GraphException("You cannot make a histogram with 0 bars.");
        }
        this.graphPlot.setHistogramNumBars(num);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().setHistogramNumBars(num);
        }
    }

    public GraphPen getPen(String s) {
        Utils.mustBeEventDispatchThread();
        return this.graphPlot.getPen(s);
    }

    public GraphPen createAndSelectTemporaryPen(String s) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.currentPen = this.graphPlot.createPen(s, true);
        return this.graphPlot.currentPen;
    }

    public GraphPen selectOrCreatePen(String s) throws GraphException {
        Utils.mustBeEventDispatchThread();
        GraphPen pen = this.graphPlot.getPen(s);
        if (pen == null) {
            pen = this.graphPlot.createPen(s, true);
        } else if (!pen.temporary()) {
            throw new GraphException("There is already a permanent plot pen named \"" + s + "\" in the current plot, so you cannot create a temporary pen with that name.");
        }
        this.graphPlot.currentPen = pen;
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().setPen(s);
        }
        return pen;
    }

    public GraphPen selectPen(String s) throws GraphException {
        Utils.mustBeEventDispatchThread();
        GraphPen pen = this.graphPlot.getPen(s);
        if (pen == null) {
            throw new GraphException("The plot pen " + s + " does not exist in the current plot.  You must create it first before you set it to be the current plot pen.  To make the pen a temporary pen, use the create-temporary-plot-pen primitive.  To make the pen a permanent plot pen, edit the current plot and add the pen in the current plot's Edit dialog box.");
        }
        this.graphPlot.currentPen = pen;
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().setPen(s);
        }
        return pen;
    }

    public void setPenColor(Color color) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.currentPen.color(color);
        this.graphPlot.currentPen.repaint();
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().setPenColor(color);
        }
    }

    public void setInterval(double interval) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.currentPen.plotInterval(interval);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().setInterval(interval);
        }
    }

    public void xRange(double min, double max) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.xMin(min);
        this.graphPlot.xMax(max);
        this.graphPlot.dirty();
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().xRange(min, max);
        }
    }

    public void yRange(double min, double max) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.yMin(min);
        this.graphPlot.yMax(max);
        this.graphPlot.dirty();
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().yRange(min, max);
        }
    }

    public double xMin() {
        Utils.mustBeEventDispatchThread();
        return this.graphPlot.xMin();
    }

    public double xMax() {
        Utils.mustBeEventDispatchThread();
        return this.graphPlot.xMax();
    }

    public double yMin() {
        Utils.mustBeEventDispatchThread();
        return this.graphPlot.yMin();
    }

    public double yMax() {
        Utils.mustBeEventDispatchThread();
        return this.graphPlot.yMax();
    }

    public void xMin(double min) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.xMin(min);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().xMin(min);
        }
    }

    public void xMax(double max) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.xMax(max);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().xMax(max);
        }
    }

    public void yMin(double min) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.yMin(min);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().yMin(min);
        }
    }

    public void yMax(double max) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.yMax(max);
        if (this.liaison.getListener() != null) {
            this.liaison.getListener().yMax(max);
        }
    }

    public List getYcorsAsList() {
        Utils.mustBeEventDispatchThread();
        List points = this.graphPlot.currentPen.points();
        ArrayList<Double> result = new ArrayList<Double>();
        int i = 0;
        while (i < points.size()) {
            GraphPoint point = (GraphPoint)points.get(i);
            result.add(new Double(point.ycor()));
            ++i;
        }
        return result;
    }

    public boolean includeInterfaceGlobalsInExport() {
        Utils.mustBeEventDispatchThread();
        return this.includeInterfaceGlobalsInExport;
    }

    public void setIncludeInterfaceGlobalsInExport(boolean includeInterfaceGlobalsInExport) {
        Utils.mustBeEventDispatchThread();
        this.includeInterfaceGlobalsInExport = includeInterfaceGlobalsInExport;
    }

    public void export(PrintWriter writer) {
        Utils.mustBeEventDispatchThread();
        this.graphPlot.export(writer);
    }

    public BufferedImage exportGraphics() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paint(image.getGraphics());
        return image;
    }

    public void handlePeriodicUpdateEvent(PeriodicUpdateEvent e) {
        this.repaintIfNeeded();
    }

    public void repaintIfNeeded() {
        this.graphPlot.repaintIfNeeded();
    }

    public String save() {
        StringBuffer s = new StringBuffer();
        s.append("PLOT\n");
        s.append(this.getBoundsString());
        s.append((this.plotName() != null && !this.plotName().equals("") ? this.plotName() : "NIL") + '\n');
        s.append((this.xLabel() != null && !this.xLabel().equals("") ? this.xLabel() : "NIL") + '\n');
        s.append((this.yLabel() != null && !this.yLabel().equals("") ? this.yLabel() : "NIL") + '\n');
        s.append("" + this.defaultXMin() + '\n');
        s.append("" + this.defaultXMax() + '\n');
        s.append("" + this.defaultYMin() + '\n');
        s.append("" + this.defaultYMax() + '\n');
        s.append("" + this.defaultAutoPlotOn() + '\n');
        s.append("" + this.penList.isOpen() + '\n');
        if (this.defaultPlotPens.size() > 0) {
            int haveDefaultPen = this.isDefaultPen((GraphPen)this.defaultPlotPens.get(0));
            if (this.defaultPlotPens.size() != 1 || haveDefaultPen == 0) {
                s.append("PENS\n");
                int i = haveDefaultPen;
                while (i < this.defaultPlotPens.size()) {
                    GraphPen pen = (GraphPen)this.defaultPlotPens.get(i);
                    s.append("\"" + org.nlogo.util.Utils.escapeString(pen.displayName()) + "\" " + pen.plotInterval() + ' ' + pen.plotPenMode() + ' ' + pen.color().getRGB() + ' ' + pen.showInPensLegend() + '\n');
                    ++i;
                }
            }
        }
        return s.toString();
    }

    public Object load(String[] strings, String version) {
        int x1 = Integer.parseInt(strings[1]);
        int y1 = Integer.parseInt(strings[2]);
        int x2 = Integer.parseInt(strings[3]);
        int y2 = Integer.parseInt(strings[4]);
        this.setSize(x2 - x1, y2 - y1);
        this.plotName(strings[5].equals("NIL") ? "" : strings[5]);
        if (7 < strings.length) {
            this.xLabel(strings[6].equals("NIL") ? "" : strings[6]);
            this.yLabel(strings[7].equals("NIL") ? "" : strings[7]);
        }
        if (11 < strings.length) {
            this.defaultXMin(Double.valueOf(strings[8]));
            this.defaultXMax(Double.valueOf(strings[9]));
            this.defaultYMin(Double.valueOf(strings[10]));
            this.defaultYMax(Double.valueOf(strings[11]));
            this.graphPlot.xMin(this.defaultXMin());
            this.graphPlot.xMax(this.defaultXMax());
            this.graphPlot.yMin(this.defaultYMin());
            this.graphPlot.yMax(this.defaultYMax());
        }
        if (13 < strings.length) {
            this.defaultAutoPlotOn(Boolean.valueOf(strings[12]));
            this.graphPlot.autoPlotOn(this.defaultAutoPlotOn());
            this.penList.setOpen(Boolean.valueOf(strings[13]));
        }
        if (15 < strings.length && strings[14].equals("PENS")) {
            ArrayList<GraphPen> pens = new ArrayList<GraphPen>();
            int i = 15;
            while (i < strings.length) {
                GraphPen pen = new GraphPen();
                StringTokenizer penTokenizer = new StringTokenizer(strings[i]);
                String name = penTokenizer.nextToken().substring(1);
                while (!name.endsWith("\"") || name.endsWith("\\\"")) {
                    name = name + ' ' + penTokenizer.nextToken();
                }
                name = org.nlogo.util.Utils.unEscapeString(name.substring(0, name.length() - 1));
                pen.displayName(name);
                pen.plotInterval(Double.valueOf(penTokenizer.nextToken()));
                int penMode = (int)Double.valueOf(penTokenizer.nextToken()).doubleValue();
                if (pen.validPlotPenMode(penMode)) {
                    pen.plotPenMode(penMode);
                }
                pen.color(new Color((int)Double.valueOf(penTokenizer.nextToken()).doubleValue()));
                pen.showInPensLegend(Boolean.valueOf(penTokenizer.nextToken()));
                pens.add(pen);
                ++i;
            }
            this.editPlotPens(pens);
        }
        this.clear();
        return this;
    }

    private final /* synthetic */ void this() {
        this.graphPlot = new GraphPlot(this);
        this.nameLabel = new JLabel("", 0);
        this.xAxis = new GraphXAxisLabels();
        this.yAxis = new GraphYAxisLabels();
        this.defaultXMin = 0.0;
        this.defaultXMax = 10.0;
        this.defaultYMin = 0.0;
        this.defaultYMax = 10.0;
        this.defaultAutoPlotOn = true;
        this.includeInterfaceGlobalsInExport = true;
    }

    public GraphWidget(GraphListenerLiaison liaison) {
        this.this();
        Utils.mustBeEventDispatchThread();
        this.liaison = liaison;
        this.setBorder(this.widgetBorder);
        this.setOpaque(true);
        Utils.adjustDefaultFont(this);
        this.penList = this.graphPlot.penList();
        this.setBackground(InterfaceColors.PLOT_BACKGROUND);
        this.defaultPlotPens = new ArrayList();
        GraphPen defaultPen = this.graphPlot.createPen("default", true);
        this.defaultPlotPens.add(defaultPen);
        this.graphPlot.penList(this.defaultPlotPens);
        this.graphPlot.xMin(this.defaultXMin);
        this.graphPlot.xMax(this.defaultXMax);
        this.graphPlot.yMin(this.defaultYMin);
        this.graphPlot.yMax(this.defaultYMax);
        this.graphPlot.currentPen = (GraphPen)this.defaultPlotPens.get(0);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 1, 1, 1);
        c.gridx = 1;
        c.gridwidth = -1;
        c.anchor = 10;
        c.fill = 2;
        gridbag.setConstraints(this.nameLabel, c);
        this.add(this.nameLabel);
        Utils.adjustDefaultFont(this.nameLabel);
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
        c.gridx = -1;
        JButton penListControl = new JButton(new AbstractAction(){

            public final void actionPerformed(ActionEvent e) {
                GraphWidget.this.penList.toggle();
            }
        }){

            public final void updateUI() {
                this.setUI(new BasicButtonUI());
            }
        };
        penListControl.setOpaque(false);
        Utils.adjustDefaultFont(penListControl);
        penListControl.setText("Pens");
        penListControl.setFocusable(false);
        penListControl.setBorder(null);
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(penListControl, c);
        this.add(penListControl);
        c.insets = new Insets(0, 1, 0, 1);
        c.gridwidth = 1;
        c.gridheight = -1;
        c.weighty = 3;
        c.anchor = 17;
        c.fill = 3;
        gridbag.setConstraints(this.yAxis, c);
        this.add(this.yAxis);
        c.gridwidth = -1;
        c.weightx = 3;
        c.anchor = 10;
        c.fill = 1;
        gridbag.setConstraints(this.graphPlot, c);
        this.add(this.graphPlot);
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.anchor = 11;
        c.fill = 0;
        c.insets = new Insets(0, 3, 0, 1);
        gridbag.setConstraints(this.penList, c);
        this.add(this.penList);
        c.insets = new Insets(0, 0, 0, 0);
        JLabel filler2 = new JLabel();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 0;
        gridbag.setConstraints(filler2, c);
        this.add(filler2);
        c.gridwidth = -1;
        c.anchor = 10;
        c.fill = 2;
        gridbag.setConstraints(this.xAxis, c);
        this.add(this.xAxis);
        JLabel filler3 = new JLabel();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        c.fill = 0;
        gridbag.setConstraints(filler3, c);
        this.add(filler3);
    }
}

