/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.nlogo.util.FileIO;
import org.nlogo.util.Version;

public strictfp class Library {
    public static Node rootNode = null;

    public static String[] getModelPaths() {
        Library.scanForModels();
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<TreeNode> models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            Node node = (Node)models.nextElement();
            if (node.isFolder() || !Version.isCities() && node.path.indexOf("models" + File.separator.charAt(0) + "under development" + File.separator.charAt(0) + "cities" + File.separator.charAt(0)) != -1) continue;
            result.add(node.path);
        }
        return result.toArray(new String[0]);
    }

    public static List findModelsBySubstring(String targetName) throws IOException {
        Node model;
        String path;
        Library.scanForModels();
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<TreeNode> models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            int loc;
            Node node = (Node)models.nextElement();
            if (node.isFolder() || (loc = (path = node.path.replace(File.separator.charAt(0), '/')).toUpperCase().lastIndexOf("/" + targetName.toUpperCase() + ".NLOGO")) == -1 || loc != path.lastIndexOf(47)) continue;
            result.add(node.name);
            return result;
        }
        models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            model = (Node)models.nextElement();
            if (model.isFolder() || (path = model.path.replace(File.separator.charAt(0), '/')).toUpperCase().lastIndexOf("/" + targetName.toUpperCase()) != path.lastIndexOf(47) || result.contains(model.name)) continue;
            result.add(model.name);
        }
        models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            model = (Node)models.nextElement();
            if (model.isFolder() || (path = model.path.replace(File.separator.charAt(0), '/')).toUpperCase().lastIndexOf(targetName.toUpperCase()) <= path.lastIndexOf(47) || result.contains(model.name)) continue;
            result.add(model.name);
        }
        return result;
    }

    public static String getModelPath(String targetName) throws IOException {
        Library.scanForModels();
        Enumeration<TreeNode> models = rootNode.depthFirstEnumeration();
        while (models.hasMoreElements()) {
            Node model = (Node)models.nextElement();
            String path = model.path.replace(File.separator.charAt(0), '/');
            if (path.toUpperCase().indexOf("/" + targetName.toUpperCase() + ".NLOGO") != path.lastIndexOf(47)) continue;
            return model.path;
        }
        return null;
    }

    public static boolean needsModelScan() {
        boolean bl = false;
        if (rootNode == null) {
            bl = true;
        }
        return bl;
    }

    public static void scanForModels() {
        if (!Library.needsModelScan()) {
            return;
        }
        File directoryRoot = new File("models", "");
        rootNode = new Node("models", "", true);
        Library.scanDirectory(directoryRoot, null, rootNode);
    }

    public static String getInfoWindow(String filePath) throws IOException {
        String file = FileIO.file2String(filePath);
        String delimiter = "@#$#@#$#@";
        int dlength = delimiter.length();
        int startIndex = 0;
        int i = 0;
        while (i < 2) {
            startIndex = file.indexOf(delimiter, startIndex);
            if (i < 1) {
                startIndex += dlength;
            }
            ++i;
        }
        int endIndex = file.indexOf(delimiter, startIndex += delimiter.length());
        if (startIndex >= 0 && startIndex <= file.length() && endIndex >= 0 && endIndex <= file.length()) {
            return file.substring(startIndex, endIndex).trim();
        }
        return "";
    }

    public static String getImagePath(String filePath) {
        int index = filePath.indexOf(".nlogo");
        if (index != -1) {
            filePath = filePath.substring(0, index);
        }
        return filePath + ".png";
    }

    private static final void scanDirectory(File directory, Node grandparent, Node parent) {
        if (!directory.isDirectory()) {
            return;
        }
        String[] rawEntries = directory.list();
        List orderedEntries = new ArrayList<String>();
        int i = 0;
        while (i < rawEntries.length) {
            orderedEntries.add(rawEntries[i]);
            ++i;
        }
        if ((orderedEntries = Library.orderItems(orderedEntries, parent.isRoot())).size() > 0 && grandparent != null) {
            grandparent.add(parent);
        }
        i = 0;
        while (i < orderedEntries.size()) {
            String fileName = (String)orderedEntries.get(i);
            File file = new File(directory, fileName);
            Node child = new Node(Library.translateNameForDisplay(fileName), file.getAbsolutePath() + (file.isDirectory() ? "/" : ""), file.isDirectory());
            if (child.isFolder()) {
                Library.scanDirectory(file, parent, child);
            } else {
                parent.add(child);
            }
            ++i;
        }
    }

    private static final String translateNameForDisplay(String name) {
        if (name.equalsIgnoreCase("UNVERIFIED")) {
            return "(unverified)";
        }
        if (name.equalsIgnoreCase("FOR USE WITH PLOT MIRRORING")) {
            return "(for use with plot mirroring)";
        }
        return Library.removeSuffix(name);
    }

    private static final List orderItems(List names, boolean topLevel) {
        String[] orderednames = topLevel ? new String[]{"SAMPLE MODELS", "CURRICULAR MODELS", "CODE EXAMPLES", "HUBNET COMPUTER ACTIVITIES", "HUBNET CALCULATOR ACTIVITIES", "USER COMMUNITY MODELS", "UNDER DEVELOPMENT", "BENCHMARKS"} : new String[]{};
        names = new ArrayList(names);
        Collections.sort(names, new CustomComparator());
        ArrayList tempFolders = new ArrayList();
        if (names != null) {
            int number = 0;
            while (number < orderednames.length) {
                int i = 0;
                while (i < names.size()) {
                    String tempName = (String)names.get(i);
                    if (tempName.equalsIgnoreCase(orderednames[number])) {
                        tempFolders.add(names.get(i));
                        names.remove(i);
                        break;
                    }
                    ++i;
                }
                ++number;
            }
            String unverified = null;
            String underDevelopment = null;
            String plotMirroring = null;
            int i = 0;
            while (i < names.size()) {
                String temp = ((String)names.get(i)).toUpperCase();
                if (!Library.isBadName(temp)) {
                    if (temp.equals("UNVERIFIED")) {
                        unverified = (String)names.get(i);
                    } else if (temp.equals("UNDER DEVELOPMENT")) {
                        underDevelopment = (String)names.get(i);
                    } else if (temp.equals("FOR USE WITH PLOT MIRRORING")) {
                        plotMirroring = (String)names.get(i);
                    } else {
                        tempFolders.add(names.get(i));
                    }
                }
                ++i;
            }
            if (unverified != null) {
                tempFolders.add(unverified);
            }
            if (plotMirroring != null) {
                tempFolders.add(plotMirroring);
            }
            if (underDevelopment != null) {
                tempFolders.add(underDevelopment);
            }
        }
        return tempFolders;
    }

    private static final boolean isBadName(String name) {
        boolean bl = false;
        if (name.startsWith(".") || name.equals("CLIENTS") || name.equals("CVS") || name.equals("TAGS") || name.endsWith(".GIF") || name.endsWith(".PGM") || name.endsWith(".PNG") || name.endsWith(".NINFO") || name.endsWith(".JAR") || name.endsWith(".MOV") || name.endsWith(".NCOMMENT") || name.endsWith(".RTF") || name.endsWith(".TXT") || name.endsWith(".SLOGO") || name.endsWith(".CSV") || name.endsWith(".NINFO") || name.endsWith(".SLT") || name.endsWith(".NIM") || name.endsWith(".NLS") || name.endsWith("~")) {
            bl = true;
        }
        return bl;
    }

    private static final String removeSuffix(String reference) {
        if (reference.endsWith(".nlogo")) {
            return reference.substring(0, reference.lastIndexOf(".nlogo"));
        }
        return reference;
    }

    private Library() {
        throw new IllegalStateException();
    }

    public strictfp static class Node
    extends DefaultMutableTreeNode {
        private final String name;
        private final String path;

        public boolean isFolder() {
            return this.allowsChildren;
        }

        public String getName() {
            return this.name;
        }

        public String getFilePath() {
            return this.path;
        }

        public String toString() {
            return this.name;
        }

        public boolean isLeaf() {
            return this.isFolder() ^ true;
        }

        Node(String name, String path, boolean isFolder) {
            this.name = name;
            this.path = path;
            this.allowsChildren = isFolder;
        }
    }

    private static class CustomComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.munge(o1), this.munge(o2));
        }

        private final String munge(Object o) {
            String s = ((String)o).toUpperCase();
            return s.endsWith(".NLOGO") ? s.substring(0, s.length() - 6) : s;
        }

        private CustomComparator() {
        }
    }
}

