/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Dump;
import org.nlogo.agent.Importer;
import org.nlogo.agent.Program;
import org.nlogo.agent.Shape;
import org.nlogo.agent.World;
import org.nlogo.agent.WorldResizer;
import org.nlogo.command.Procedure;
import org.nlogo.compiler.Compiler;
import org.nlogo.nvm.JobManager;
import org.nlogo.nvm.JobManagerOwner;
import org.nlogo.nvm.LogoException;
import org.nlogo.nvm.Tracer;
import org.nlogo.util.Exceptions;
import org.nlogo.util.LocalFile;
import org.nlogo.util.OutputObject;
import org.nlogo.util.Utils;
import org.nlogo.workspace.Evaluator;
import org.nlogo.workspace.Exporter;
import org.nlogo.workspace.ExtensionManager;
import org.nlogo.workspace.FileManager;
import org.nlogo.workspace.HubNetInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Workspace
implements WorldResizer,
JobManagerOwner {
    public static final int TYPE_NEW = 0;
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_LIBRARY = 2;
    public static final int TYPE_CONVERTED = 3;
    public static Tracer profilingTracer;
    private static boolean isApp;
    private static boolean isApplet;
    public static final int OUTPUT_NORMAL = 0;
    public static final int OUTPUT_TO_OUTPUT_AREA = 1;
    public static final int OUTPUT_TO_FILE = 2;
    public final World world;
    public final JobManager jobManager;
    private final HubNetManagerFactory hubNetManagerFactory;
    protected HubNetInterface hubNetManager;
    public final Evaluator evaluator;
    public final FileManager fileManager;
    private final ExtensionManager extensionManager;
    private String modelFileName;
    private String modelDir;
    private int modelType;
    protected boolean computerHubNetRunning;

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public Shape getDefaultShape() {
        return null;
    }

    public abstract boolean headless();

    public boolean warningMessage(String message) {
        System.err.println();
        System.err.println("WARNING: " + message);
        System.err.println();
        return true;
    }

    public static boolean isApp() {
        return isApp;
    }

    public static void isApp(boolean isApp) {
        Workspace.isApp = isApp;
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void isApplet(boolean isApplet) {
        Workspace.isApplet = isApplet;
    }

    public HubNetInterface getHubNetManager() {
        if (this.hubNetManager == null && this.hubNetManagerFactory != null) {
            this.hubNetManager = this.hubNetManagerFactory.newInstance(this);
        }
        return this.hubNetManager;
    }

    public boolean computerHubNetRunning() {
        return this.computerHubNetRunning;
    }

    public void computerHubNetRunning(boolean computerHubNetRunning) {
        this.computerHubNetRunning = computerHubNetRunning;
    }

    protected void setModelPath(String modelPath) {
        if (modelPath == null) {
            this.modelFileName = null;
            this.modelDir = null;
        } else {
            File file = new File(modelPath);
            this.modelFileName = file.getName();
            modelPath = file.getAbsolutePath();
            int sepIndex = modelPath.lastIndexOf(File.separatorChar);
            if (sepIndex == -1) {
                this.modelDir = null;
            } else {
                this.modelDir = modelPath.substring(0, modelPath.lastIndexOf(File.separatorChar));
                if (this.modelDir == "") {
                    this.modelDir = null;
                }
            }
        }
    }

    public String attachModelDir(String filePath) {
        if (Workspace.isApplet() || new File(filePath).isAbsolute()) {
            return filePath;
        }
        try {
            String path = this.getModelPath();
            if (path == null) {
                path = Utils.getUserDirectory() + File.separatorChar + "dummy.txt";
            }
            URL urlForm = new URL(new File(path).toURL(), filePath);
            return new File(urlForm.getFile()).getAbsolutePath();
        }
        catch (MalformedURLException ex) {
            Exceptions.handle(ex);
            return null;
        }
    }

    public void convertToNormal() throws LogoException {
        File cvs = new File(this.attachModelDir("CVS"));
        if (!cvs.exists() || !cvs.isDirectory()) {
            throw new LogoException("no CVS directory found");
        }
        this.modelType = 1;
    }

    protected void setModelType(int modelType) {
        this.modelType = modelType;
    }

    public String getModelPath() {
        if (this.modelDir == null || this.modelFileName == null) {
            return null;
        }
        return this.modelDir + File.separatorChar + this.modelFileName;
    }

    public String getModelFileName() {
        return this.modelFileName;
    }

    public String getModelDir() {
        return this.modelDir;
    }

    public int getModelType() {
        return this.modelType;
    }

    public boolean forceSaveAs() {
        boolean bl = false;
        if (this.modelType == 0 || this.modelType == 2 || this.modelType == 3) {
            bl = true;
        }
        return bl;
    }

    public String modelNameForDisplay() {
        return Workspace.makeModelNameForDisplay(this.modelFileName);
    }

    static String makeModelNameForDisplay(String str) {
        if (str == null) {
            return "(new model)";
        }
        int suffixIndex = str.lastIndexOf(".nlogo");
        if (suffixIndex > 0 && suffixIndex == str.length() - 6) {
            str = str.substring(0, str.length() - 6);
        }
        return str;
    }

    public void init(Program program) {
        Iterator iter = program.getProcedures();
        while (iter.hasNext()) {
            Procedure procedure = (Procedure)iter.next();
            procedure.init(this);
        }
    }

    public abstract void inspectAgent(Class var1, Agent var2);

    public void clearAll() throws LogoException {
        this.world.clearAll();
        this.clearOutput();
    }

    public void resetTimer() {
        this.world.resetTimer();
    }

    public abstract void magicOpen(String var1);

    public abstract void clearOutput() throws LogoException;

    public void outputObject(Object object, Object owner, boolean addNewline, boolean readable, int destination) throws LogoException {
        OutputObject oo = new OutputObject(owner instanceof Agent ? Dump.logoObject(owner) : "", (readable && !(owner instanceof Agent) ? " " : "") + Dump.logoObject(object, readable, false), addNewline, false);
        if (destination == 2) {
            this.fileManager.writeOutputObject(oo);
        } else {
            boolean bl = false;
            if (destination == 1) {
                bl = true;
            }
            this.sendOutput(oo, bl);
        }
    }

    protected abstract void sendOutput(OutputObject var1, boolean var2) throws LogoException;

    protected abstract Importer.ErrorHandler getImporterErrorHandler();

    public void importWorld(String filename) throws IOException {
        this.doImport(new Importer(this, filename){

            public final void doImport(BufferedReader reader) throws IOException {
                new org.nlogo.agent.Importer(Workspace.this.getImporterErrorHandler(), Workspace.this.world, Workspace.this, Compiler.STRING_READER).importWorld(reader);
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doImport(Importer importer) throws IOException {
        LocalFile file = new LocalFile(importer.filename);
        try {
            ((org.nlogo.util.File)file).open(1);
            importer.doImport(((org.nlogo.util.File)file).getBufferedReader());
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                ((org.nlogo.util.File)file).close(false);
                throw throwable;
            }
            catch (IOException ex2) {
                Exceptions.ignore(ex2);
            }
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        try {}
        catch (IOException ex2) {
            Exceptions.ignore(ex2);
            return;
        }
        ((org.nlogo.util.File)file).close(false);
    }

    public void exportWorld(String filename) throws IOException {
        new Exporter(filename){

            protected final void export(PrintWriter writer) throws IOException {
                Workspace.this.world.exportWorld(writer, true);
            }
        }.export("world", this.modelFileName, "");
    }

    public abstract void exportGraphics(String var1, String var2) throws IOException;

    public abstract void exportInterface(String var1) throws IOException;

    public void exportBehaviors(String filename, String behaviorCode, final String data) throws IOException {
        new Exporter(filename){

            protected final void export(PrintWriter writer) throws IOException {
                writer.println(data);
            }
        }.export("BehaviorSpace", this.modelFileName, "behavior reporter = \"" + behaviorCode + '\"');
    }

    private final /* synthetic */ void this() {
        this.computerHubNetRunning = false;
    }

    protected Workspace(HubNetManagerFactory hubNetManagerFactory) {
        this.this();
        this.hubNetManagerFactory = hubNetManagerFactory;
        this.modelType = 0;
        this.evaluator = new Evaluator(this);
        this.world = new World(this.getDefaultShape());
        this.jobManager = new JobManager(this, this.world);
        this.fileManager = new FileManager(this);
        this.extensionManager = new ExtensionManager(this);
    }

    static {
        isApp = false;
        isApplet = true;
    }

    public static interface HubNetManagerFactory {
        public HubNetInterface newInstance(Workspace var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected abstract class Importer {
        public String filename;

        public abstract void doImport(BufferedReader var1) throws IOException;

        Importer(String filename) {
            this.filename = filename;
        }
    }
}

