/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.table;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.nlogo.api.Argument;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.DefaultCommand;
import org.nlogo.api.DefaultReporter;
import org.nlogo.api.Dump;
import org.nlogo.api.Equality;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.ExtensionObject;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.Primitive;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableExtension
extends DefaultClassManager {
    private static WeakHashMap<Table, Long> tables = new WeakHashMap();
    private static long next = 0L;

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("clear", (Primitive)new Clear());
        primManager.addPrimitive("get", (Primitive)new Get());
        primManager.addPrimitive("has-key?", (Primitive)new HasKey());
        primManager.addPrimitive("keys", (Primitive)new Keys());
        primManager.addPrimitive("length", (Primitive)new Length());
        primManager.addPrimitive("make", (Primitive)new Make());
        primManager.addPrimitive("put", (Primitive)new Put());
        primManager.addPrimitive("remove", (Primitive)new Remove());
        primManager.addPrimitive("from-list", (Primitive)new FromList());
        primManager.addPrimitive("to-list", (Primitive)new ToList());
    }

    public void clearAll() {
        tables.clear();
        next = 0L;
    }

    public StringBuilder exportWorld() {
        StringBuilder buffer = new StringBuilder();
        for (Table table : tables.keySet()) {
            buffer.append(Dump.csv().encode(Dump.extensionObject((ExtensionObject)table, (boolean)true, (boolean)true, (boolean)false)) + "\n");
        }
        return buffer;
    }

    public void importWorld(List<String[]> lines, ExtensionManager reader, ImportErrorHandler handler) throws ExtensionException {
        for (String[] line : lines) {
            try {
                reader.readFromString(line[0]);
            }
            catch (CompilerException e) {
                handler.showError("Error importing arrays", e.getMessage(), "This array will be ignored");
            }
        }
    }

    public ExtensionObject readExtensionObject(ExtensionManager reader, String typeName, String value) throws ExtensionException {
        try {
            String[] s = value.split(":");
            long id = Long.parseLong(s[0]);
            Table table = this.getOrCreateTableFromId(id);
            if (s.length > 1) {
                table.addAll((LogoList)reader.readFromString(s[1]));
            }
            return table;
        }
        catch (CompilerException ex) {
            throw new ExtensionException(ex.getMessage());
        }
    }

    private Table getOrCreateTableFromId(long id) {
        for (Table table : tables.keySet()) {
            if (table.id != id) continue;
            return table;
        }
        return new Table(id);
    }

    private static boolean isValidKey(Object key) {
        return key instanceof Double || key instanceof String || key instanceof Boolean || key instanceof LogoList && TableExtension.containsOnlyValidKeys((LogoList)key);
    }

    private static boolean containsOnlyValidKeys(LogoList list) {
        for (Object o : list) {
            if (TableExtension.isValidKey(o)) continue;
            return false;
        }
        return true;
    }

    public static class FromList
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoList alist = args[0].getList();
            return new Table(alist);
        }
    }

    public static class ToList
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return ((Table)arg0).toList();
        }
    }

    public static class Remove
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            ((Table)arg0).remove(args[1].get());
        }
    }

    public static class Put
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType(), Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            Object key = args[1].get();
            if (!TableExtension.isValidKey(key)) {
                throw new ExtensionException(Dump.logoObject((Object)key) + " is not a valid table key " + "(a table key may only be a number, a string, true or false, or a list " + "whose items are valid keys)");
            }
            ((Table)arg0).put(key, args[2].get());
        }
    }

    public static class Make
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new Table();
        }
    }

    public static class Length
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return (double)((Table)arg0).size();
        }
    }

    public static class Keys
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return LogoList.fromJava(((Table)arg0).keySet());
        }
    }

    public static class HasKey
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.BooleanType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return ((Table)arg0).containsKey(args[1].get());
        }
    }

    public static class Get
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            Object key = args[1].get();
            Object result = ((Table)arg0).get(key);
            if (result == null) {
                throw new ExtensionException("No value for " + Dump.logoObject((Object)key) + " in table.");
            }
            return result;
        }
    }

    public static class Clear
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            ((Table)arg0).clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table
    extends LinkedHashMap<Object, Object>
    implements ExtensionObject {
        private final long id;

        public Table() {
            tables.put(this, next);
            this.id = next;
            next++;
        }

        public Table(LogoList alist) throws ExtensionException {
            this();
            this.addAll(alist);
        }

        public void addAll(LogoList alist) throws ExtensionException {
            for (Object pair : alist) {
                if (pair instanceof LogoList && ((LogoList)pair).size() < 2 || !(pair instanceof LogoList)) {
                    throw new ExtensionException("expected a two-element list: " + Dump.logoObject(pair));
                }
                this.put(((LogoList)pair).first(), ((LogoList)pair).butFirst().first());
            }
        }

        public Table(long id) {
            this.id = id;
            tables.put(this, id);
            next = StrictMath.max(next, id + 1L);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public LogoList toList() {
            LogoListBuilder alist = new LogoListBuilder();
            for (Map.Entry entry : this.entrySet()) {
                LogoListBuilder pair = new LogoListBuilder();
                pair.add(entry.getKey());
                pair.add(entry.getValue());
                alist.add((Object)pair.toLogoList());
            }
            return alist.toLogoList();
        }

        public String dump(boolean readable, boolean exportable, boolean reference) {
            if (exportable && reference) {
                return "" + this.id;
            }
            return (exportable ? this.id + ": " : "") + Dump.logoObject((Object)this.toList(), (boolean)true, (boolean)exportable);
        }

        public String getExtensionName() {
            return "table";
        }

        public String getNLTypeName() {
            return "";
        }

        public boolean recursivelyEqual(Object o) {
            if (!(o instanceof Table)) {
                return false;
            }
            Table otherTable = (Table)o;
            if (this.size() != otherTable.size()) {
                return false;
            }
            for (Object key : this.keySet()) {
                if (otherTable.containsKey(key) && Equality.equals(this.get(key), otherTable.get(key))) continue;
                return false;
            }
            return true;
        }
    }
}

