/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.gogo;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.RXTXCommDriver;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.nlogo.api.ExtensionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoGoController {
    RXTXCommDriver driver;
    String portName;
    CommPortIdentifier portId;
    BurstReader burstReader;
    SerialPort port;
    public PushbackInputStream inputStream;
    public OutputStream outputStream;
    public int burstModeMask = 0;
    public static final byte IN_HEADER1 = 85;
    public static final byte IN_HEADER2 = -1;
    public static final byte OUT_HEADER1 = 84;
    public static final byte OUT_HEADER2 = -2;
    public static final byte ACK_BYTE = -86;
    public static final byte CMD_PING = 0;
    public static final byte CMD_READ_SENSOR = 32;
    public static final byte CMD_READ_EXTENDED_SENSOR = -32;
    public static final byte CMD_OUTPUT_PORT_ON = 64;
    public static final byte CMD_OUTPUT_PORT_OFF = 68;
    public static final byte CMD_OUTPUT_PORT_RD = 72;
    public static final byte CMD_OUTPUT_PORT_THISWAY = 76;
    public static final byte CMD_OUTPUT_PORT_THATWAY = 80;
    public static final byte CMD_OUTPUT_PORT_COAST = 84;
    public static final byte CMD_OUTPUT_PORT_POWER = 96;
    public static final byte CMD_TALK_TO_OUTPUT_PORT = -128;
    public static final byte CMD_SET_BURST_MODE = -96;
    public static final byte CMD_PWM_SERVO = -56;
    public static final byte CMD_LED_ON = -64;
    public static final byte CMD_LED_OFF = -63;
    public static final byte CMD_BEEP = -60;
    public static final byte SENSOR_READ_NORMAL = 0;
    public static final byte SENSOR_READ_MAX = 1;
    public static final byte SENSOR_READ_MIN = 2;
    public static final int OUTPUT_PORT_A = 1;
    public static final int OUTPUT_PORT_B = 2;
    public static final int OUTPUT_PORT_C = 4;
    public static final int OUTPUT_PORT_D = 8;
    public static final int SENSOR_1 = 1;
    public static final int SENSOR_2 = 2;
    public static final int SENSOR_3 = 4;
    public static final int SENSOR_4 = 8;
    public static final int SENSOR_5 = 16;
    public static final int SENSOR_6 = 32;
    public static final int SENSOR_7 = 64;
    public static final int SENSOR_8 = 128;
    public static final int BURST_SPEED_HIGH = 0;
    public static final int BURST_SPEED_LOW = 1;
    public static final byte BURST_CHUNK_HEADER = 12;
    private static final int[] sensorIDs = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

    public static int sensorID(int sensor) {
        if (sensor < 1 || sensor > 8) {
            throw new RuntimeException("Sensor number out of range: " + sensor);
        }
        return sensorIDs[sensor - 1];
    }

    public static CommPortIdentifier findPortByName(String portName) {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)portList.nextElement();
            if (id.getPortType() != 1 || !id.getName().equals(portName)) continue;
            return id;
        }
        return null;
    }

    public GoGoController(String portName) {
        this.portName = portName;
    }

    public static List<String> availablePorts() {
        return GoGoController.listPorts(true);
    }

    public static List<String> serialPorts() {
        return GoGoController.listPorts(false);
    }

    public static List<String> listPorts(boolean onlyAvailable) {
        ArrayList<String> portNames = new ArrayList<String>();
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || onlyAvailable && portId.isCurrentlyOwned()) continue;
            portNames.add(portId.getName());
        }
        return portNames;
    }

    public String currentPortName() {
        if (this.port != null) {
            return this.port.getName();
        }
        return null;
    }

    public SerialPort currentPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePort() {
        PushbackInputStream pushbackInputStream = this.inputStream;
        synchronized (pushbackInputStream) {
            OutputStream outputStream = this.outputStream;
            synchronized (outputStream) {
                if (this.port != null) {
                    this.port.removeEventListener();
                    if (this.inputStream != null) {
                        try {
                            this.inputStream.close();
                            this.inputStream = null;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.outputStream != null) {
                        try {
                            this.outputStream.close();
                            this.outputStream = null;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.port.close();
                    this.port = null;
                }
            }
        }
    }

    public boolean openPort() {
        if (this.port != null) {
            return true;
        }
        this.portId = GoGoController.findPortByName(this.portName);
        if (this.portId == null) {
            throw new RuntimeException("Cannot find port: " + this.portName);
        }
        try {
            this.port = (SerialPort)this.portId.open("GoGoController", 2000);
        }
        catch (PortInUseException e) {
            throw new RuntimeException("Port is already in use: " + (Object)((Object)e));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to open port: " + e);
        }
        if (this.port != null) {
            try {
                this.inputStream = new PushbackInputStream(this.port.getInputStream());
                this.outputStream = this.port.getOutputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.port.setSerialPortParams(9600, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadTimeout(int ms) {
        try {
            PushbackInputStream pushbackInputStream = this.inputStream;
            synchronized (pushbackInputStream) {
                this.port.enableReceiveTimeout(ms);
                this.inputStream = new PushbackInputStream(this.port.getInputStream());
            }
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCommand(byte[] command) {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            try {
                this.writeByte((byte)84);
                this.writeByte((byte)-2);
                this.outputStream.write(command);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws IOException {
        int b;
        PushbackInputStream pushbackInputStream = this.inputStream;
        synchronized (pushbackInputStream) {
            b = this.inputStream.read();
        }
        return (byte)b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte peekByte() throws IOException {
        int b;
        PushbackInputStream pushbackInputStream = this.inputStream;
        synchronized (pushbackInputStream) {
            b = this.inputStream.read();
            this.inputStream.unread(b);
        }
        return (byte)b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws IOException {
        int b;
        PushbackInputStream pushbackInputStream = this.inputStream;
        synchronized (pushbackInputStream) {
            b = this.inputStream.read();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeByte(byte b) throws IOException {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            this.outputStream.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForReplyHeader() {
        try {
            for (int i = 0; i < 256; ++i) {
                PushbackInputStream pushbackInputStream = this.inputStream;
                synchronized (pushbackInputStream) {
                    byte b = this.readByte();
                    if (b == 85) {
                        b = this.readByte();
                        if (b == -1) {
                            return true;
                        }
                    } else if (b == -1) {
                        return true;
                    }
                    continue;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForByte(byte target) {
        try {
            for (int i = 0; i < 256; ++i) {
                PushbackInputStream pushbackInputStream = this.inputStream;
                synchronized (pushbackInputStream) {
                    byte b = this.readByte();
                    if (b == target) {
                        return true;
                    }
                    continue;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean waitForAck() {
        this.waitForReplyHeader();
        return this.waitForByte((byte)-86);
    }

    public boolean waitForAck(int msec) {
        this.waitForReplyHeader();
        return this.waitForByte((byte)-86);
    }

    public boolean ping() {
        if (this.port == null) {
            return false;
        }
        this.writeCommand(new byte[]{0});
        return this.waitForAck();
    }

    public boolean beep() {
        if (this.port == null) {
            return false;
        }
        this.writeCommand(new byte[]{-60, 0});
        return this.waitForAck();
    }

    public boolean led(boolean on) {
        if (this.port == null) {
            return false;
        }
        byte cmd = -63;
        if (on) {
            cmd = -64;
        }
        this.writeCommand(new byte[]{cmd, 0});
        return this.waitForAck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int _readSensor(int sensor, int mode) {
        int sensorVal = 0;
        if (sensor < 1) {
            throw new RuntimeException("Sensor number out of range: " + sensor);
        }
        if (sensor > 8) {
            return this.readExtendedSensor(sensor);
        }
        int b = 0x20 | sensor - 1 << 2 | mode;
        try {
            this.writeCommand(new byte[]{(byte)b});
            PushbackInputStream pushbackInputStream = this.inputStream;
            synchronized (pushbackInputStream) {
                this.waitForReplyHeader();
                sensorVal = this.readInt() << 8;
                sensorVal += this.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sensorVal;
    }

    public int readSensor(int sensor) {
        return this._readSensor(sensor, 0);
    }

    public int readSensorMin(int sensor) {
        return this._readSensor(sensor, 2);
    }

    public int readSensorMax(int sensor) {
        return this._readSensor(sensor, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readExtendedSensor(int sensor) {
        int sensorVal = 0;
        byte highByte = (byte)((sensor -= 9) >> 8);
        byte lowByte = (byte)(sensor & 0xFF);
        byte[] command = new byte[]{-32, highByte, lowByte};
        try {
            this.writeCommand(command);
            PushbackInputStream pushbackInputStream = this.inputStream;
            synchronized (pushbackInputStream) {
                this.waitForReplyHeader();
                sensorVal = this.readInt() << 8;
                sensorVal += this.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sensorVal;
    }

    public void talkToOutputPorts(int outputPortMask) {
        this.writeCommand(new byte[]{-128, (byte)outputPortMask});
        this.waitForAck();
    }

    public void setBurstMode(int sensorMask) {
        this.setBurstMode(sensorMask, 0);
    }

    public void setBurstMode(int sensorMask, int speed) {
        this.writeCommand(new byte[]{(byte)(0xFFFFFFA0 | (byte)speed), (byte)sensorMask});
        this.waitForAck();
        this.burstModeMask = sensorMask;
    }

    public void startBurstReader(BurstCycleHandler handler) {
        this.burstReader = new BurstReader(this, handler);
        this.burstReader.start();
    }

    public void stopBurstReader() {
        this.burstReader.stopReading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] readBurstCycle() {
        try {
            for (int i = 0; i < 256; ++i) {
                PushbackInputStream pushbackInputStream = this.inputStream;
                synchronized (pushbackInputStream) {
                    byte b = this.peekByte();
                    if (b == 12) {
                        this.readByte();
                        int high = this.readInt();
                        int low = this.readInt();
                        int sensor = (high >> 5) + 1;
                        int val = (high & 3) << 8;
                        val += low;
                        if (sensor > 0) {
                            return new int[]{sensor, val};
                        }
                        return new int[0];
                    }
                    continue;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new int[0];
        }
        return new int[0];
    }

    public void outputPortControl(byte cmd) {
        this.writeCommand(new byte[]{cmd});
        this.waitForAck();
    }

    public void outputPortOn() {
        this.outputPortControl((byte)64);
    }

    public void outputPortOff() {
        this.outputPortControl((byte)68);
    }

    public void outputPortCoast() {
        this.outputPortControl((byte)84);
    }

    public void outputPortThatWay() {
        this.outputPortControl((byte)80);
    }

    public void outputPortThisWay() {
        this.outputPortControl((byte)80);
    }

    public void outputPortReverse() {
        this.outputPortControl((byte)72);
    }

    public void setOutputPortPower(int level) {
        if (level < 0 || level > 7) {
            throw new RuntimeException("Power level out of range: " + level);
        }
        int comm = 0x60 | level << 2;
        this.writeCommand(new byte[]{(byte)comm});
        this.waitForAck();
    }

    public void setServoPosition(int val) throws ExtensionException {
        if (val < 20 || val > 40) {
            throw new ExtensionException("Requested servo position (" + val + ") is out of safe range (20-40): ");
        }
        this.writeCommand(new byte[]{-56, (byte)val});
        this.waitForAck();
    }

    public void serialEvent(SerialPortEvent event) {
    }

    public static void main(String[] args) throws IOException {
        String port = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-l")) {
                for (String portName : GoGoController.serialPorts()) {
                    System.out.println(portName);
                }
                System.exit(0);
                continue;
            }
            if (!args[i].equals("-p")) continue;
            port = args[++i];
        }
    }

    public class BurstReader
    extends Thread {
        GoGoController controller;
        BurstCycleHandler handler;
        boolean keepRunning = true;

        BurstReader(GoGoController cont, BurstCycleHandler handler) {
            this.controller = cont;
            this.handler = handler;
        }

        public void stopReading() {
            this.keepRunning = false;
        }

        public void run() {
            while (this.keepRunning) {
                int[] result = this.controller.readBurstCycle();
                if (result.length != 2 || this.handler == null) continue;
                this.handler.handleBurstCycle(result[0], result[1]);
            }
        }
    }

    public class DefaultBurstCycleHandler
    implements BurstCycleHandler {
        private final int[] sensorValues = new int[8];

        public synchronized void handleBurstCycle(int sensor, int value) {
            System.out.println("Sensor " + sensor + " value: " + value);
            this.sensorValues[sensor - 1] = value;
        }
    }

    public static interface BurstCycleHandler {
        public void handleBurstCycle(int var1, int var2);
    }
}

