/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.gogo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.DefaultCommand;
import org.nlogo.api.DefaultReporter;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.Primitive;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Syntax;
import org.nlogo.extensions.gogo.GoGoController;
import org.nlogo.extensions.gogo.GoGoWindowsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoGoExtension
extends DefaultClassManager {
    public static GoGoController controller;
    public static NLBurstCycleHandler burstCycleHandler;

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("ports", (Primitive)new GoGoListPorts());
        primManager.addPrimitive("open", (Primitive)new GoGoOpen());
        primManager.addPrimitive("open?", (Primitive)new GoGoOpenPredicate());
        primManager.addPrimitive("close", (Primitive)new GoGoClose());
        primManager.addPrimitive("ping", (Primitive)new GoGoPing());
        primManager.addPrimitive("output-port-on", (Primitive)new GoGoOutputPortOn());
        primManager.addPrimitive("output-port-off", (Primitive)new GoGoOutputPortOff());
        primManager.addPrimitive("output-port-coast", (Primitive)new GoGoOutputPortCoast());
        primManager.addPrimitive("output-port-thisway", (Primitive)new GoGoOutputPortThisWay());
        primManager.addPrimitive("output-port-thatway", (Primitive)new GoGoOutputPortThatWay());
        primManager.addPrimitive("set-output-port-power", (Primitive)new GoGoOutputPortPower());
        primManager.addPrimitive("output-port-reverse", (Primitive)new GoGoOutputPortReverse());
        primManager.addPrimitive("talk-to-output-ports", (Primitive)new GoGoTalkToOutputPorts());
        primManager.addPrimitive("set-burst-mode", (Primitive)new GoGoSetBurstMode());
        primManager.addPrimitive("stop-burst-mode", (Primitive)new GoGoStopBurstMode());
        primManager.addPrimitive("burst-value", (Primitive)new GoGoSensorBurstValue());
        primManager.addPrimitive("sensor", (Primitive)new GoGoSensor());
        primManager.addPrimitive("beep", (Primitive)new GoGoBeep());
        primManager.addPrimitive("led-on", (Primitive)new GoGoLedOn());
        primManager.addPrimitive("led-off", (Primitive)new GoGoLedOff());
        primManager.addPrimitive("install", (Primitive)new GoGoInstall());
        primManager.addPrimitive("set-servo", (Primitive)new GoGoSetServo());
    }

    public void runOnce(ExtensionManager em) throws ExtensionException {
        em.addToLibraryPath((Object)this, "lib");
        GoGoExtension.runWindowsInstaller(true);
    }

    private static void runWindowsInstaller(boolean verify) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            GoGoWindowsHandler.run(verify);
        }
    }

    public void unload(ExtensionManager em) {
        GoGoExtension.close();
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Field field = ClassLoader.class.getDeclaredField("nativeLibraries");
            field.setAccessible(true);
            Vector libs = (Vector)field.get(classLoader);
            for (Object o : libs) {
                Method finalize = o.getClass().getDeclaredMethod("finalize", new Class[0]);
                finalize.setAccessible(true);
                finalize.invoke(o, new Object[0]);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void ensureGoGoPort() throws ExtensionException {
        if (controller == null || controller.currentPort() == null) {
            throw new ExtensionException("No GoGo port open.");
        }
    }

    public static void close() {
        if (controller != null) {
            if (controller.currentPort() != null) {
                controller.closePort();
            }
            controller = null;
        }
    }

    public static void initController(String portName) {
        controller = new GoGoController(portName);
    }

    private static int sensorMask(AbstractSequentialList<?> sensorList) {
        int sensorMask = 0;
        Iterator<?> iter = null;
        if (sensorList != null) {
            for (Object val : sensorList) {
                switch (val.toString().toLowerCase().charAt(0)) {
                    case '1': {
                        sensorMask |= 1;
                        break;
                    }
                    case '2': {
                        sensorMask |= 2;
                        break;
                    }
                    case '3': {
                        sensorMask |= 4;
                        break;
                    }
                    case '4': {
                        sensorMask |= 8;
                        break;
                    }
                    case '5': {
                        sensorMask |= 0x10;
                        break;
                    }
                    case '6': {
                        sensorMask |= 0x20;
                        break;
                    }
                    case '7': {
                        sensorMask |= 0x40;
                        break;
                    }
                    case '8': {
                        sensorMask |= 0x80;
                    }
                }
            }
        }
        return sensorMask;
    }

    public List<String> additionalJars() {
        return Arrays.asList("RXTXcomm.jar");
    }

    static {
        burstCycleHandler = null;
    }

    public static class GoGoInstall
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.runWindowsInstaller(false);
        }
    }

    public static class GoGoSensor
    extends DefaultReporter {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.NumberType()};
            return Syntax.reporterSyntax((int[])right, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            int sensor = args[0].getIntValue();
            try {
                return (double)controller.readSensor(sensor);
            }
            catch (RuntimeException e) {
                return 0.0;
            }
        }
    }

    public static class GoGoStopBurstMode
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] right = new int[]{};
            return Syntax.commandSyntax((int[])right);
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            controller.stopBurstReader();
            burstCycleHandler = null;
            controller.setBurstMode(0, 0);
            controller.setBurstMode(0, 1);
        }
    }

    public static class GoGoSetBurstMode
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.ListType(), Syntax.BooleanType()};
            return Syntax.commandSyntax((int[])right);
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            int sensorMask = GoGoExtension.sensorMask((AbstractSequentialList)args[0].getList());
            int speed = args[1].getBoolean() != false ? 0 : 1;
            controller.setBurstMode(sensorMask, speed);
            burstCycleHandler = new NLBurstCycleHandler();
            controller.startBurstReader(burstCycleHandler);
        }
    }

    public static class GoGoSensorBurstValue
    extends DefaultReporter {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.NumberType()};
            return Syntax.reporterSyntax((int[])right, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            int sensor = args[0].getIntValue();
            if (burstCycleHandler != null) {
                if (sensor > 0 && sensor < 9) {
                    return (double)burstCycleHandler.sensorValue(sensor);
                }
                throw new ExtensionException("Sensor id " + sensor + " is out of range, should be 1-8.");
            }
            throw new ExtensionException("Burst Mode is not set, use set-burst-mode to turn on burst mode for specific sensors.");
        }
    }

    public static class NLBurstCycleHandler
    implements GoGoController.BurstCycleHandler {
        public final int[] sensorValues = new int[8];

        public synchronized void handleBurstCycle(int sensor, int value) {
            this.sensorValues[sensor - 1] = value;
        }

        public int sensorValue(int sensor) {
            return this.sensorValues[sensor - 1];
        }
    }

    public static class GoGoTalkToOutputPorts
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.ListType()};
            return Syntax.commandSyntax((int[])right);
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            Iterator iter = args[0].getList().iterator();
            int outputPortMask = 0;
            while (iter.hasNext()) {
                Object val = iter.next();
                switch (val.toString().toLowerCase().charAt(0)) {
                    case 'a': {
                        outputPortMask |= 1;
                        break;
                    }
                    case 'b': {
                        outputPortMask |= 2;
                        break;
                    }
                    case 'c': {
                        outputPortMask |= 4;
                        break;
                    }
                    case 'd': {
                        outputPortMask |= 8;
                    }
                }
            }
            controller.talkToOutputPorts(outputPortMask);
        }
    }

    public static class GoGoOutputPortPower
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.NumberType()};
            return Syntax.commandSyntax((int[])right);
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            try {
                int level = args[0].getIntValue();
                controller.setOutputPortPower(level);
            }
            catch (RuntimeException e) {
                throw new ExtensionException("Cannot set output port power: " + e.getLocalizedMessage());
            }
        }
    }

    public static class GoGoOutputPortThatWay
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.outputPortThatWay();
        }
    }

    public static class GoGoOutputPortThisWay
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.outputPortThisWay();
        }
    }

    public static class GoGoOutputPortReverse
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.outputPortReverse();
        }
    }

    public static class GoGoOutputPortCoast
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.outputPortOff();
        }
    }

    public static class GoGoOutputPortOff
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.outputPortOff();
        }
    }

    public static class GoGoLedOff
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.led(false);
        }
    }

    public static class GoGoLedOn
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.led(true);
        }
    }

    public static class GoGoSetServo
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] posParam = new int[]{Syntax.NumberType()};
            return Syntax.commandSyntax((int[])posParam);
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            int val = args[0].getIntValue();
            controller.setServoPosition(val);
        }
    }

    public static class GoGoBeep
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.beep();
        }
    }

    public static class GoGoOutputPortOn
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            GoGoExtension.ensureGoGoPort();
            controller.outputPortOn();
        }
    }

    public static class GoGoPing
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int)Syntax.BooleanType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            if (controller == null) {
                return Boolean.FALSE;
            }
            return controller.ping() ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class GoGoOpenPredicate
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int)Syntax.BooleanType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return controller != null && controller.currentPort() != null ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class GoGoListPorts
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                return LogoList.fromJava(GoGoController.availablePorts());
            }
            catch (NoClassDefFoundError e) {
                throw new ExtensionException("Could not initialize GoGo Extension.  Please ensure that you have installed RXTX correctly.  Full error message: " + e.getLocalizedMessage());
            }
        }
    }

    public static class GoGoClose
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                GoGoExtension.close();
            }
            catch (RuntimeException e) {
                throw new ExtensionException("Cannot close port: " + controller.currentPortName() + " : " + e.getLocalizedMessage());
            }
        }
    }

    public static class GoGoOpen
    extends DefaultCommand {
        public Syntax getSyntax() {
            int[] right = new int[]{Syntax.StringType()};
            return Syntax.commandSyntax((int[])right);
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            try {
                GoGoExtension.close();
            }
            catch (RuntimeException e) {
                throw new ExtensionException("Cannot close port: " + controller.currentPortName() + " : " + e.getLocalizedMessage());
            }
            try {
                GoGoExtension.initController(args[0].getString());
                controller.openPort();
                controller.setReadTimeout(50);
            }
            catch (NoClassDefFoundError e) {
                throw new ExtensionException("Could not initialize GoGo Extension.  Please ensure that you have installed RXTX correctly.  Full error message: " + args[0].getString() + " : " + e.getLocalizedMessage());
            }
            catch (RuntimeException e) {
                throw new ExtensionException("Could not open port " + args[0].getString() + " : " + e.getLocalizedMessage());
            }
            try {
                if (!controller.ping()) {
                    throw new ExtensionException("GoGo board not responding.");
                }
            }
            catch (RuntimeException e) {
                throw new ExtensionException("GoGo board not responding: " + e.getLocalizedMessage());
            }
        }
    }
}

