/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.array;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.nlogo.api.Argument;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.DefaultCommand;
import org.nlogo.api.DefaultReporter;
import org.nlogo.api.Dump;
import org.nlogo.api.Equality;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.ExtensionObject;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.Primitive;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayExtension
extends DefaultClassManager {
    private static final WeakHashMap<LogoArray, Object> arrays = new WeakHashMap();
    private static long next = 0L;

    public void clearAll() {
        arrays.clear();
        next = 0L;
    }

    public StringBuilder exportWorld() {
        StringBuilder buffer = new StringBuilder();
        for (LogoArray array : arrays.keySet()) {
            buffer.append(Dump.csv().encode(Dump.extensionObject((ExtensionObject)array, (boolean)true, (boolean)true, (boolean)false)) + "\n");
        }
        return buffer;
    }

    public void importWorld(List<String[]> lines, ExtensionManager reader, ImportErrorHandler handler) throws ExtensionException {
        for (String[] line : lines) {
            try {
                reader.readFromString(line[0]);
            }
            catch (CompilerException e) {
                handler.showError("Error importing arrays", e.getMessage(), "This array will be ignored");
            }
        }
    }

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("item", (Primitive)new Item());
        primManager.addPrimitive("set", (Primitive)new Set());
        primManager.addPrimitive("length", (Primitive)new Length());
        primManager.addPrimitive("to-list", (Primitive)new ToList());
        primManager.addPrimitive("from-list", (Primitive)new FromList());
    }

    public ExtensionObject readExtensionObject(ExtensionManager reader, String typeName, String value) throws ExtensionException, CompilerException {
        String[] s = value.split(":");
        long id = Long.parseLong(s[0]);
        LogoArray array = this.getOrCreateArrayFromId(id);
        if (s.length > 1) {
            array.addAll((LogoList)reader.readFromString("[ " + s[1] + " ]"));
        }
        return array;
    }

    private LogoArray getOrCreateArrayFromId(long id) {
        for (LogoArray array : arrays.keySet()) {
            if (array.id != id) continue;
            return array;
        }
        return new LogoArray(id);
    }

    public static class FromList
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoArray((Collection<?>)args[0].getList());
        }
    }

    public static class ToList
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof LogoArray)) {
                throw new ExtensionException("not an array: " + Dump.logoObject((Object)arg0));
            }
            return LogoList.fromJava((Iterable)((LogoArray)arg0));
        }
    }

    public static class Length
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof LogoArray)) {
                throw new ExtensionException("not an array: " + Dump.logoObject((Object)arg0));
            }
            return (double)((LogoArray)arg0).size();
        }
    }

    public static class Set
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof LogoArray)) {
                throw new ExtensionException("not an array: " + Dump.logoObject((Object)arg0));
            }
            LogoArray array = (LogoArray)arg0;
            int index = args[1].getIntValue();
            if (index < 0 || index >= array.size()) {
                throw new ExtensionException(index + " is not a valid index into an array of length " + array.size());
            }
            array.set(index, args[2].get());
        }
    }

    public static class Item
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof LogoArray)) {
                throw new ExtensionException("not an array: " + Dump.logoObject((Object)arg0));
            }
            LogoArray array = (LogoArray)arg0;
            int index = args[1].getIntValue();
            if (index < 0 || index >= array.size()) {
                throw new ExtensionException(index + " is not a valid index into an array of length " + array.size());
            }
            return array.get(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogoArray
    extends ArrayList<Object>
    implements ExtensionObject {
        private final long id;
        private final Object hashKey = new Object();

        LogoArray(long id) {
            this.id = id;
            arrays.put(this, null);
            next = StrictMath.max(next, id + 1L);
        }

        LogoArray(Collection<?> collection) {
            super(collection);
            this.id = next;
            arrays.put(this, null);
            next++;
        }

        @Override
        public int hashCode() {
            return this.hashKey.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public String dump(boolean readable, boolean exporting, boolean reference) {
            StringBuilder buf = new StringBuilder();
            if (exporting) {
                buf.append(this.id);
                if (!reference) {
                    buf.append(": ");
                }
            }
            if (!reference || !exporting) {
                boolean first = true;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (!first) {
                        buf.append(" ");
                    }
                    first = false;
                    buf.append(Dump.logoObject(it.next(), (boolean)true, (boolean)exporting));
                }
            }
            return buf.toString();
        }

        public String getExtensionName() {
            return "array";
        }

        public String getNLTypeName() {
            return "";
        }

        public boolean recursivelyEqual(Object o) {
            if (!(o instanceof LogoArray)) {
                return false;
            }
            LogoArray otherArray = (LogoArray)o;
            if (this.size() != otherArray.size()) {
                return false;
            }
            Iterator iter1 = this.iterator();
            Iterator iter2 = otherArray.iterator();
            while (iter1.hasNext()) {
                if (Equality.equals(iter1.next(), iter2.next())) continue;
                return false;
            }
            return true;
        }
    }
}

