/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.matrix;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import org.nlogo.api.Argument;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.DefaultCommand;
import org.nlogo.api.DefaultReporter;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.ExtensionObject;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.Primitive;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixExtension
extends DefaultClassManager {
    private static final WeakHashMap<LogoMatrix, Long> matrices = new WeakHashMap();
    private static long next = 0L;

    public List<String> additionalJars() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Jama-1.0.2.jar");
        return list;
    }

    public void clearAll() {
        matrices.clear();
        next = 0L;
    }

    public StringBuilder exportWorld() {
        StringBuilder buffer = new StringBuilder();
        for (LogoMatrix mat : matrices.keySet()) {
            buffer.append(Dump.csv().encode(Dump.extensionObject((ExtensionObject)mat, (boolean)true, (boolean)true, (boolean)false)) + "\n");
        }
        return buffer;
    }

    public void importWorld(List<String[]> lines, ExtensionManager reader, ImportErrorHandler handler) {
        for (String[] line : lines) {
            try {
                reader.readFromString(line[0]);
            }
            catch (CompilerException e) {
                handler.showError("Error importing matrices", e.getMessage(), "This matrix will be ignored");
            }
        }
    }

    public ExtensionObject readExtensionObject(ExtensionManager reader, String typeName, String value) throws CompilerException, ExtensionException {
        String[] s = value.split(":");
        long id = Long.parseLong(s[0]);
        LogoMatrix mat = this.getOrCreateMatrixFromId(id);
        if (s.length > 1) {
            LogoList nestedL = (LogoList)reader.readFromString(s[1]);
            double[][] newData = MatrixExtension.convertNestedLogoListToArray(nestedL);
            mat.replaceData(newData);
        }
        return mat;
    }

    private static double[][] convertNestedLogoListToArray(LogoList nestedLogoList) throws ExtensionException {
        int numRows = nestedLogoList.size();
        if (numRows == 0) {
            throw new ExtensionException("input list was empty");
        }
        int numCols = -1;
        for (Object obj : nestedLogoList) {
            if (obj instanceof LogoList) {
                LogoList rowList = (LogoList)obj;
                if (numCols == -1) {
                    numCols = rowList.size();
                    continue;
                }
                if (numCols == rowList.size()) continue;
                throw new ExtensionException("To convert a nested list into a matrix, all nested lists must be the same length -- e.g. [[1 2 3 4] [1 2 3]] is invalid, because row 1 has one more entry.");
            }
            throw new ExtensionException("To convert a nested list into a matrix, there must be exactly two levels of nesting -- e.g. [[1 2 3] [4 5 6]] creates a good 2x3 matrix.");
        }
        if (numCols == 0) {
            throw new ExtensionException("input list contained only empty lists");
        }
        double[][] array = new double[numRows][numCols];
        int row = 0;
        for (Object obj : nestedLogoList) {
            int col = 0;
            LogoList rowList = (LogoList)obj;
            for (Object obj2 : rowList) {
                if (!(obj2 instanceof Number)) continue;
                array[row][col] = ((Number)obj2).doubleValue();
                ++col;
            }
            while (col < numCols) {
                array[row][col] = 0.0;
                ++col;
            }
            ++row;
        }
        return array;
    }

    private static double[][] convertSimpleLogoListToArray(LogoList SimpleLogoList) throws ExtensionException {
        int numRows = 1;
        int numCols = SimpleLogoList.size();
        double[][] array = new double[numRows][numCols];
        int row = 0;
        for (int i = 0; i < numCols; ++i) {
            array[row][i] = ((Number)SimpleLogoList.get(i)).doubleValue();
        }
        return array;
    }

    private static LogoList convertArrayToNestedLogoList(double[][] dArray) {
        LogoListBuilder lst = new LogoListBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            LogoListBuilder rowLst = new LogoListBuilder();
            for (int j = 0; j < dArray[i].length; ++j) {
                rowLst.add((Object)dArray[i][j]);
            }
            lst.add((Object)rowLst.toLogoList());
        }
        return lst.toLogoList();
    }

    private static LogoList convertArrayToSimpleLogoList(double[][] dArray) {
        LogoListBuilder lst = new LogoListBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                lst.add((Object)dArray[i][j]);
            }
        }
        return lst.toLogoList();
    }

    private LogoMatrix getOrCreateMatrixFromId(long id) {
        for (LogoMatrix mat : matrices.keySet()) {
            if (mat.id != id) continue;
            return mat;
        }
        return new LogoMatrix(id);
    }

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("get", (Primitive)new Get());
        primManager.addPrimitive("set", (Primitive)new Set());
        primManager.addPrimitive("set-row", (Primitive)new SetRow());
        primManager.addPrimitive("swap-rows", (Primitive)new SwapRows());
        primManager.addPrimitive("set-column", (Primitive)new SetColumn());
        primManager.addPrimitive("swap-columns", (Primitive)new SwapColumns());
        primManager.addPrimitive("set-and-report", (Primitive)new SetAndReport());
        primManager.addPrimitive("dimensions", (Primitive)new Dimensions());
        primManager.addPrimitive("to-row-list", (Primitive)new ToRowList());
        primManager.addPrimitive("from-row-list", (Primitive)new FromRowList());
        primManager.addPrimitive("to-column-list", (Primitive)new ToColumnList());
        primManager.addPrimitive("from-column-list", (Primitive)new FromColumnList());
        primManager.addPrimitive("make-constant", (Primitive)new MakeConstant());
        primManager.addPrimitive("make-identity", (Primitive)new MakeIdentity());
        primManager.addPrimitive("copy", (Primitive)new Copy());
        primManager.addPrimitive("pretty-print-text", (Primitive)new PrettyPrintText());
        primManager.addPrimitive("times-scalar", (Primitive)new TimesScalar());
        primManager.addPrimitive("times", (Primitive)new Times());
        primManager.addPrimitive("times-element-wise", (Primitive)new TimesElementWise());
        primManager.addPrimitive("plus-scalar", (Primitive)new PlusScalar());
        primManager.addPrimitive("plus", (Primitive)new Plus());
        primManager.addPrimitive("det", (Primitive)new Det());
        primManager.addPrimitive("rank", (Primitive)new Rank());
        primManager.addPrimitive("cond", (Primitive)new Cond());
        primManager.addPrimitive("trace", (Primitive)new Trace());
        primManager.addPrimitive("inverse", (Primitive)new Inverse());
        primManager.addPrimitive("transpose", (Primitive)new Transpose());
        primManager.addPrimitive("submatrix", (Primitive)new Submatrix());
        primManager.addPrimitive("get-row", (Primitive)new GetRow());
        primManager.addPrimitive("get-column", (Primitive)new GetColumn());
        primManager.addPrimitive("real-eigenvalues", (Primitive)new RealEigenvalues());
        primManager.addPrimitive("imaginary-eigenvalues", (Primitive)new ImaginaryEigenvalues());
        primManager.addPrimitive("eigenvectors", (Primitive)new Eigenvectors());
        primManager.addPrimitive("solve", (Primitive)new Solve());
        primManager.addPrimitive("forecast-linear-growth", (Primitive)new ForecastLinearTrend());
        primManager.addPrimitive("forecast-compound-growth", (Primitive)new ForecastCompoundTrend());
        primManager.addPrimitive("forecast-continuous-growth", (Primitive)new ForecastContinuousTrend());
        primManager.addPrimitive("regress", (Primitive)new Regress());
    }

    private static LogoMatrix getMatrixFromArgument(Argument arg) throws ExtensionException, LogoException {
        Object obj = arg.get();
        if (!(obj instanceof LogoMatrix)) {
            throw new ExtensionException("not a matrix: " + Dump.logoObject((Object)obj));
        }
        return (LogoMatrix)obj;
    }

    public static class Regress
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            Matrix X = mat.matrix.copy();
            int numObsv = X.getRowDimension();
            int numVars = X.getColumnDimension() - 1;
            if (numVars >= numObsv) {
                throw new ExtensionException("The system is overdetermined.");
            }
            Matrix Y = new Matrix(numObsv, 1);
            for (int i = 0; i < numObsv; ++i) {
                Y.set(i, 0, X.get(i, 0));
                X.set(i, 0, 1.0);
            }
            Matrix A = X.solve(Y);
            Matrix Ysum = new Matrix(1, numObsv, 1.0).times(Y);
            double Ybar = Ysum.get(0, 0) / (double)numObsv;
            Matrix Ydiff = Y.minus(new Matrix(numObsv, 1, Ybar));
            double TotalSumSq = Ydiff.transpose().times(Ydiff).get(0, 0);
            Matrix Resid = X.times(A).minus(Y);
            double ResidSumSq = Resid.transpose().times(Resid).get(0, 0);
            double RSquared = 1.0 - ResidSumSq / TotalSumSq;
            LogoListBuilder stats = new LogoListBuilder();
            stats.add((Object)RSquared);
            stats.add((Object)TotalSumSq);
            stats.add((Object)ResidSumSq);
            LogoList returnList = MatrixExtension.convertArrayToNestedLogoList(A.transpose().getArray());
            LogoListBuilder result = new LogoListBuilder();
            result.addAll((Iterable)returnList);
            result.add((Object)stats.toLogoList());
            return result.toLogoList();
        }
    }

    public static class ForecastContinuousTrend
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Matrix Yin = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[0].getList())).transpose();
            int numObsv = Yin.getRowDimension();
            if (numObsv < 1) {
                throw new ExtensionException("The input list is empty.");
            }
            for (int i = 0; i < numObsv; ++i) {
                if (!(Yin.get(i, 0) <= 0.0)) continue;
                throw new ExtensionException("Item " + i + " of the input list is zero or negative.");
            }
            LogoListBuilder forecast = new LogoListBuilder();
            if (numObsv == 1) {
                forecast.add((Object)Yin.get(0, 0));
                forecast.add((Object)Yin.get(0, 0));
                forecast.add((Object)0.0);
                forecast.add((Object)0.0);
                return forecast.toLogoList();
            }
            Matrix Y = new Matrix(numObsv, 1);
            Matrix X = new Matrix(numObsv, 2);
            for (int i = 0; i < numObsv; ++i) {
                Y.set(i, 0, Math.log(Yin.get(i, 0)));
                X.set(i, 0, 1.0);
                X.set(i, 1, (double)i);
            }
            Matrix A = X.solve(Y);
            double constant = Math.exp(A.get(0, 0));
            double rate = A.get(1, 0);
            double Yforecast = constant * Math.exp(rate * (double)numObsv);
            Matrix Ysum = new Matrix(1, numObsv, 1.0).times(Y);
            double Ybar = Ysum.get(0, 0) / (double)numObsv;
            Matrix Ydiff = Y.minus(new Matrix(numObsv, 1, Ybar));
            double TotalSumSq = Ydiff.transpose().times(Ydiff).get(0, 0);
            Matrix Resid = X.times(A).minus(Y);
            double ResidSumSq = Resid.transpose().times(Resid).get(0, 0);
            double RSquared = TotalSumSq > 0.0 ? 1.0 - ResidSumSq / TotalSumSq : 1.0;
            forecast.add((Object)Yforecast);
            forecast.add((Object)constant);
            forecast.add((Object)rate);
            forecast.add((Object)RSquared);
            return forecast.toLogoList();
        }
    }

    public static class ForecastCompoundTrend
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Matrix Yin = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[0].getList())).transpose();
            int numObsv = Yin.getRowDimension();
            if (numObsv < 1) {
                throw new ExtensionException("The input list is empty.");
            }
            for (int i = 0; i < numObsv; ++i) {
                if (!(Yin.get(i, 0) <= 0.0)) continue;
                throw new ExtensionException("Item " + i + " of the input list is zero or negative.");
            }
            LogoListBuilder forecast = new LogoListBuilder();
            if (numObsv == 1) {
                forecast.add((Object)Yin.get(0, 0));
                forecast.add((Object)Yin.get(0, 0));
                forecast.add((Object)1.0);
                forecast.add((Object)0.0);
                return forecast.toLogoList();
            }
            Matrix Y = new Matrix(numObsv, 1);
            Matrix X = new Matrix(numObsv, 2);
            for (int i = 0; i < numObsv; ++i) {
                Y.set(i, 0, Math.log(Yin.get(i, 0)));
                X.set(i, 0, 1.0);
                X.set(i, 1, (double)i);
            }
            Matrix A = X.solve(Y);
            double constant = Math.exp(A.get(0, 0));
            double onePlusRate = Math.exp(A.get(1, 0));
            double Yforecast = constant * Math.pow(onePlusRate, numObsv);
            Matrix Ysum = new Matrix(1, numObsv, 1.0).times(Y);
            double Ybar = Ysum.get(0, 0) / (double)numObsv;
            Matrix Ydiff = Y.minus(new Matrix(numObsv, 1, Ybar));
            double TotalSumSq = Ydiff.transpose().times(Ydiff).get(0, 0);
            Matrix Resid = X.times(A).minus(Y);
            double ResidSumSq = Resid.transpose().times(Resid).get(0, 0);
            double RSquared = TotalSumSq > 0.0 ? 1.0 - ResidSumSq / TotalSumSq : 1.0;
            forecast.add((Object)Yforecast);
            forecast.add((Object)constant);
            forecast.add((Object)onePlusRate);
            forecast.add((Object)RSquared);
            return forecast.toLogoList();
        }
    }

    public static class ForecastLinearTrend
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Matrix Y = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[0].getList())).transpose();
            int numObsv = Y.getRowDimension();
            if (numObsv < 1) {
                throw new ExtensionException("The input list is empty.");
            }
            LogoListBuilder forecast = new LogoListBuilder();
            if (numObsv == 1) {
                forecast.add((Object)Y.get(0, 0));
                forecast.add((Object)Y.get(0, 0));
                forecast.add((Object)0.0);
                forecast.add((Object)0.0);
                return forecast.toLogoList();
            }
            Matrix X = new Matrix(numObsv, 2);
            for (int i = 0; i < numObsv; ++i) {
                X.set(i, 0, 1.0);
                X.set(i, 1, (double)i);
            }
            Matrix A = X.solve(Y);
            double constant = A.get(0, 0);
            double slope = A.get(1, 0);
            double Yforecast = constant + slope * (double)numObsv;
            Matrix Ysum = new Matrix(1, numObsv, 1.0).times(Y);
            double Ybar = Ysum.get(0, 0) / (double)numObsv;
            Matrix Ydiff = Y.minus(new Matrix(numObsv, 1, Ybar));
            double TotalSumSq = Ydiff.transpose().times(Ydiff).get(0, 0);
            Matrix Resid = X.times(A).minus(Y);
            double ResidSumSq = Resid.transpose().times(Resid).get(0, 0);
            double RSquared = TotalSumSq > 0.0 ? 1.0 - ResidSumSq / TotalSumSq : 1.0;
            forecast.add((Object)Yforecast);
            forecast.add((Object)constant);
            forecast.add((Object)slope);
            forecast.add((Object)RSquared);
            return forecast.toLogoList();
        }
    }

    public static class Solve
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoMatrix mat2 = MatrixExtension.getMatrixFromArgument(args[1]);
            try {
                return new LogoMatrix(mat.matrix.solve(mat2.matrix));
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Eigenvectors
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            return new LogoMatrix(mat.matrix.eig().getV());
        }
    }

    public static class ImaginaryEigenvalues
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            double[] eigenVals;
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoListBuilder retList = new LogoListBuilder();
            for (double d : eigenVals = mat.matrix.eig().getImagEigenvalues()) {
                retList.add((Object)d);
            }
            return retList.toLogoList();
        }
    }

    public static class RealEigenvalues
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            double[] eigenVals;
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoListBuilder retList = new LogoListBuilder();
            for (double d : eigenVals = mat.matrix.eig().getRealEigenvalues()) {
                retList.add((Object)d);
            }
            return retList.toLogoList();
        }
    }

    public static class GetColumn
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int colIndex = args[1].getIntValue();
            int nrows = mat.matrix.getRowDimension();
            if (colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException("(" + colIndex + ") is not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            LogoMatrix colArray = new LogoMatrix(mat.matrix.getMatrix(0, nrows - 1, colIndex, colIndex));
            return MatrixExtension.convertArrayToSimpleLogoList(colArray.matrix.getArray());
        }
    }

    public static class GetRow
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            int ncols = mat.matrix.getColumnDimension();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension()) {
                throw new ExtensionException("(" + rowIndex + ") is not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            LogoMatrix rowArray = new LogoMatrix(mat.matrix.getMatrix(rowIndex, rowIndex, 0, ncols - 1));
            return MatrixExtension.convertArrayToSimpleLogoList(rowArray.matrix.getArray());
        }
    }

    public static class Submatrix
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int r1 = args[1].getIntValue();
            int c1 = args[2].getIntValue();
            int r2 = args[3].getIntValue();
            int c2 = args[4].getIntValue();
            int numRows = mat.matrix.getRowDimension();
            int numCols = mat.matrix.getColumnDimension();
            if (r1 < 0 || r1 >= numRows) {
                throw new ExtensionException("Start row index (" + r1 + ") is invalid.  Should be between 0 and " + (numRows - 1) + " inclusive.");
            }
            if (c1 < 0 || c1 >= numCols) {
                throw new ExtensionException("Start column index (" + c1 + ") is invalid.  Should be between 0 and " + (numCols - 1) + " inclusive.");
            }
            if (r2 < 1 || r2 > numRows) {
                throw new ExtensionException("End row index (" + r2 + ") is invalid.  Should be between 1 and " + numRows + " inclusive.");
            }
            if (c2 < 1 || c2 > numCols) {
                throw new ExtensionException("End column index (" + c2 + ") is invalid.  Should be between 1 and " + numCols + " inclusive.");
            }
            return new LogoMatrix(mat.matrix.getMatrix(r1, r2 - 1, c1, c2 - 1));
        }
    }

    public static class Transpose
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            return new LogoMatrix(mat.matrix.transpose());
        }
    }

    public static class Inverse
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return new LogoMatrix(mat.matrix.inverse());
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Trace
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return new Double(mat.matrix.trace());
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Cond
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return new Double(mat.matrix.cond());
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Rank
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return new Double(mat.matrix.rank());
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Det
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            try {
                return new Double(mat.matrix.det());
            }
            catch (RuntimeException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Plus
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoMatrix mat2 = MatrixExtension.getMatrixFromArgument(args[1]);
            int numrows = mat.matrix.getRowDimension();
            int numcols = mat.matrix.getColumnDimension();
            int numrows2 = mat2.matrix.getRowDimension();
            int numcols2 = mat2.matrix.getColumnDimension();
            if (numrows != numrows2 || numcols != numcols2) {
                throw new ExtensionException("Can not add matrices with different dimensions: " + numrows + "x" + numcols + " vs. " + numrows2 + "x" + numcols2);
            }
            return new LogoMatrix(mat.matrix.plus(mat2.matrix));
        }
    }

    public static class PlusScalar
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            double d = args[1].getDoubleValue();
            return new LogoMatrix(mat.matrix.plus(new Matrix(mat.matrix.getRowDimension(), mat.matrix.getColumnDimension(), d)));
        }
    }

    public static class TimesElementWise
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoMatrix mat2 = MatrixExtension.getMatrixFromArgument(args[1]);
            try {
                return new LogoMatrix(mat.matrix.arrayTimes(mat2.matrix));
            }
            catch (IllegalArgumentException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class Times
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoMatrix mat2 = MatrixExtension.getMatrixFromArgument(args[1]);
            try {
                return new LogoMatrix(mat.matrix.times(mat2.matrix));
            }
            catch (IllegalArgumentException ex) {
                throw new ExtensionException((Exception)ex);
            }
        }
    }

    public static class TimesScalar
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            double d = args[1].getDoubleValue();
            return new LogoMatrix(mat.matrix.times(d));
        }
    }

    public static class PrettyPrintText
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.StringType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            double[][] dArray = MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.getArray();
            int[] maxLen = new int[dArray[0].length];
            for (int j = 0; j < dArray[0].length; ++j) {
                maxLen[j] = 0;
            }
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[i].length; ++j) {
                    int len = Dump.number((double)dArray[i][j]).length();
                    if (len <= maxLen[j]) continue;
                    maxLen[j] = len;
                }
            }
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    buf.append(" ");
                }
                buf.append("[");
                for (int j = 0; j < dArray[i].length; ++j) {
                    if (j != 0) {
                        buf.append(" ");
                    }
                    buf.append(" ");
                    buf.append(String.format("%" + maxLen[j] + "s", Dump.number((double)dArray[i][j])));
                }
                buf.append(" ]");
                if (i >= dArray.length - 1) continue;
                buf.append("\n");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    public static class Copy
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoMatrix(MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.copy());
        }
    }

    public static class MakeIdentity
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            int size = args[0].getIntValue();
            return new LogoMatrix(Matrix.identity((int)size, (int)size));
        }
    }

    public static class MakeConstant
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoMatrix(new Matrix(args[0].getIntValue(), args[1].getIntValue(), args[2].getDoubleValue()));
        }
    }

    public static class FromColumnList
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoMatrix(new Matrix(MatrixExtension.convertNestedLogoListToArray(args[0].getList())).transpose());
        }
    }

    public static class ToColumnList
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return MatrixExtension.convertArrayToNestedLogoList(MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.transpose().getArray());
        }
    }

    public static class FromRowList
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new LogoMatrix(new Matrix(MatrixExtension.convertNestedLogoListToArray(args[0].getList())));
        }
    }

    public static class ToRowList
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return MatrixExtension.convertArrayToNestedLogoList(MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.getArray());
        }
    }

    public static class Dimensions
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            LogoListBuilder dims = new LogoListBuilder();
            dims.add((Object)mat.matrix.getRowDimension());
            dims.add((Object)mat.matrix.getColumnDimension());
            return dims.toLogoList();
        }
    }

    public static class SetAndReport
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            int colIndex = args[2].getIntValue();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension() || colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException("(" + rowIndex + "," + colIndex + ") are not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            LogoMatrix matcopy = new LogoMatrix(MatrixExtension.getMatrixFromArgument((Argument)args[0]).matrix.copy());
            matcopy.matrix.set(rowIndex, colIndex, args[3].getDoubleValue());
            return matcopy;
        }
    }

    public static class SwapColumns
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int colIndex1 = args[1].getIntValue();
            int colIndex2 = args[2].getIntValue();
            int numCols = mat.matrix.getColumnDimension();
            int numRows = mat.matrix.getRowDimension();
            if (colIndex1 < 0 || colIndex1 >= numCols) {
                throw new ExtensionException("The first column index, " + colIndex1 + ", is not valid for a " + numRows + " x " + numCols + " matrix.");
            }
            if (colIndex2 < 0 || colIndex2 >= numCols) {
                throw new ExtensionException("The second column index, " + colIndex2 + ", is not valid for a " + numRows + " x " + numCols + " matrix.");
            }
            Matrix col1 = mat.matrix.getMatrix(0, numRows - 1, colIndex1, colIndex1);
            mat.matrix.setMatrix(0, numRows - 1, colIndex1, colIndex1, mat.matrix.getMatrix(0, numRows - 1, colIndex2, colIndex2));
            mat.matrix.setMatrix(0, numRows - 1, colIndex2, colIndex2, col1);
        }
    }

    public static class SetColumn
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.ListType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int colIndex = args[1].getIntValue();
            Matrix newCol = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[2].getList())).transpose();
            int newColLength = newCol.getRowDimension();
            if (colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException(colIndex + " is not valid column index for a matrix with dimensions " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            if (newColLength != mat.matrix.getRowDimension()) {
                throw new ExtensionException("The length of the given list (" + newColLength + ") is different from the length of the matrix column (" + mat.matrix.getRowDimension() + ").");
            }
            mat.matrix.setMatrix(0, newColLength - 1, colIndex, colIndex, newCol);
        }
    }

    public static class SwapRows
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex1 = args[1].getIntValue();
            int rowIndex2 = args[2].getIntValue();
            int numCols = mat.matrix.getColumnDimension();
            int numRows = mat.matrix.getRowDimension();
            if (rowIndex1 < 0 || rowIndex1 >= numRows) {
                throw new ExtensionException("The first row index, " + rowIndex1 + ", is not valid for a " + numRows + " x " + numCols + " matrix.");
            }
            if (rowIndex2 < 0 || rowIndex2 >= numRows) {
                throw new ExtensionException("The second row index, " + rowIndex2 + ", is not valid for a " + numRows + " x " + numCols + " matrix.");
            }
            Matrix row1 = mat.matrix.getMatrix(rowIndex1, rowIndex1, 0, numCols - 1);
            mat.matrix.setMatrix(rowIndex1, rowIndex1, 0, numCols - 1, mat.matrix.getMatrix(rowIndex2, rowIndex2, 0, numCols - 1));
            mat.matrix.setMatrix(rowIndex2, rowIndex2, 0, numCols - 1, row1);
        }
    }

    public static class SetRow
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.ListType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            Matrix newRow = new Matrix(MatrixExtension.convertSimpleLogoListToArray(args[2].getList()));
            int newRowLength = newRow.getColumnDimension();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension()) {
                throw new ExtensionException(rowIndex + " is not valid row index for a matrix with dimensions " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            if (newRowLength != mat.matrix.getColumnDimension()) {
                throw new ExtensionException("The length of the given list (" + newRowLength + ") is different from the length of the matrix row (" + mat.matrix.getColumnDimension() + ").");
            }
            mat.matrix.setMatrix(rowIndex, rowIndex, 0, newRowLength - 1, newRow);
        }
    }

    public static class Set
    extends DefaultCommand {
        public Syntax getSyntax() {
            return Syntax.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.WildcardType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            int colIndex = args[2].getIntValue();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension() || colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException("(" + rowIndex + "," + colIndex + ") are not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            mat.matrix.set(rowIndex, colIndex, args[3].getDoubleValue());
        }
    }

    public static class Get
    extends DefaultReporter {
        public Syntax getSyntax() {
            return Syntax.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoMatrix mat = MatrixExtension.getMatrixFromArgument(args[0]);
            int rowIndex = args[1].getIntValue();
            int colIndex = args[2].getIntValue();
            if (rowIndex < 0 || rowIndex >= mat.matrix.getRowDimension() || colIndex < 0 || colIndex >= mat.matrix.getColumnDimension()) {
                throw new ExtensionException("(" + rowIndex + "," + colIndex + ") are not valid indices for a matrix with dimensions  " + mat.matrix.getRowDimension() + "x" + mat.matrix.getColumnDimension());
            }
            return mat.matrix.get(rowIndex, colIndex);
        }
    }

    private static class LogoMatrix
    implements ExtensionObject {
        Matrix matrix = null;
        private final long id;

        LogoMatrix(long id) {
            this.matrix = null;
            this.id = id;
            matrices.put(this, id);
            next = StrictMath.max(next, id + 1L);
        }

        LogoMatrix(Matrix matrixData) {
            this.matrix = matrixData;
            matrices.put(this, next);
            this.id = next;
            next++;
        }

        public void replaceData(double[][] dArray) {
            this.matrix = new Matrix(dArray);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String dump(boolean readable, boolean exporting, boolean reference) {
            StringBuilder buf = new StringBuilder();
            if (exporting) {
                buf.append(this.id);
                if (!reference) {
                    buf.append(":");
                }
            }
            if (!reference || !exporting) {
                double[][] dArray = this.matrix.getArray();
                buf.append(" [ ");
                for (int i = 0; i < dArray.length; ++i) {
                    buf.append("[");
                    for (int j = 0; j < dArray[i].length; ++j) {
                        buf.append(" ");
                        buf.append(Dump.number((double)dArray[i][j]));
                    }
                    buf.append(" ]");
                }
                buf.append(" ]");
            }
            return buf.toString();
        }

        public String getExtensionName() {
            return "matrix";
        }

        public String getNLTypeName() {
            return "";
        }

        public boolean recursivelyEqual(Object o) {
            if (!(o instanceof LogoMatrix)) {
                return false;
            }
            LogoMatrix otherMatrix = (LogoMatrix)o;
            double[][] otherArray = otherMatrix.matrix.getArray();
            return Arrays.deepEquals((Object[])this.matrix.getArray(), (Object[])otherArray);
        }
    }
}

