/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Observable;
import org.nlogo.agent.Patch;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Dump;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.api.ValueConstraint;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp abstract class Agent
extends Observable
implements Comparable<Agent>,
org.nlogo.api.Agent {
    final World world;
    public long id = 0L;
    public Object[] variables = null;
    ValueConstraint[] variableConstraints = null;

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public Object[] variables() {
        return this.variables;
    }

    Object agentKey() {
        return (double)this.id;
    }

    public Agent(World world) {
        this.world = world;
    }

    @Override
    public int compareTo(Agent agent) {
        long l = agent.id;
        return this.id < l ? -1 : (this.id > l ? 1 : 0);
    }

    abstract Agent realloc(boolean var1) throws AgentException;

    @Override
    public abstract void setVariable(int var1, Object var2) throws AgentException, LogoException;

    public ValueConstraint variableConstraint(int n) {
        return this.variableConstraints[n];
    }

    public void variableConstraint(int n, ValueConstraint valueConstraint) {
        this.variableConstraints[n] = valueConstraint;
    }

    public abstract Object getObserverVariable(int var1);

    public abstract Object getTurtleVariable(int var1) throws AgentException;

    public abstract Object getBreedVariable(String var1) throws AgentException;

    public abstract Object getLinkBreedVariable(String var1) throws AgentException;

    public abstract Object getLinkVariable(int var1) throws AgentException;

    public abstract Object getPatchVariable(int var1) throws AgentException;

    public abstract Object getTurtleOrLinkVariable(String var1) throws AgentException;

    public abstract void setObserverVariable(int var1, Object var2) throws AgentException, LogoException;

    public abstract void setTurtleVariable(int var1, Object var2) throws AgentException;

    public abstract void setLinkVariable(int var1, Object var2) throws AgentException;

    public abstract void setBreedVariable(String var1, Object var2) throws AgentException;

    public abstract void setLinkBreedVariable(String var1, Object var2) throws AgentException;

    public abstract void setPatchVariable(int var1, Object var2) throws AgentException;

    public abstract void setTurtleOrLinkVariable(String var1, Object var2) throws AgentException;

    public abstract Patch getPatchAtOffsets(double var1, double var3) throws AgentException;

    void wrongTypeForVariable(String string, Class<?> clazz, Object object) throws AgentException {
        throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.wrongTypeOnSetError", this.classDisplayName(), string, Dump.typeName(clazz), Dump.logoObject(object)));
    }

    void validRGBList(LogoList logoList, boolean bl) throws AgentException {
        if (logoList.size() == 3 || bl && logoList.size() == 4) {
            try {
                for (int i = 0; i < logoList.size(); ++i) {
                    this.validRGB(((Double)logoList.get(i)).intValue());
                }
                return;
            }
            catch (ClassCastException classCastException) {
                Exceptions.ignore(classCastException);
            }
        }
        String string = bl ? "org.nlogo.agent.Agent.rgbListSizeError.3or4" : "org.nlogo.agent.Agent.rgbListSizeError.3";
        throw new AgentException(I18N.errorsJ().get(string));
    }

    private void validRGB(int n) throws AgentException {
        if (n < 0 || n > 255) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Agent.rgbValueError"));
        }
    }

    @Override
    public abstract String classDisplayName();

    public abstract Class<? extends Agent> getAgentClass();

    public abstract int getAgentBit();

    @Override
    public boolean isPartiallyTransparent() {
        int n = this.alpha();
        return n > 0 && n < 255;
    }
}

