/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.LogoList;
import org.nlogo.util.MersenneTwisterFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp final class ArrayAgentSet
extends AgentSet {
    Agent[] agents;
    private int size = 0;
    private final int initialCapacity;
    private int capacity = 0;

    @Override
    public int count() {
        if (!(this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            int n = 0;
            AgentSet.Iterator iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                iterator2.next();
                ++n;
            }
            return n;
        }
        return this.size;
    }

    @Override
    boolean equalAgentSetsHelper(org.nlogo.api.AgentSet agentSet) {
        HashSet<Agent> hashSet = new HashSet<Agent>();
        AgentSet.Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            hashSet.add(iterator2.next());
        }
        for (org.nlogo.api.Agent agent : agentSet.agents()) {
            if (hashSet.contains(agent)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (!(this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            return !this.iterator().hasNext();
        }
        return this.size == 0;
    }

    public ArrayAgentSet(Class<? extends Agent> clazz, int n, boolean bl, World world) {
        super(clazz, world, null, bl);
        this.initialCapacity = n;
        this.agents = new Agent[n];
        this.capacity = n;
    }

    public ArrayAgentSet(Class<? extends Agent> clazz, Agent[] agentArray, World world) {
        super(clazz, world, null, false);
        this.initialCapacity = agentArray.length;
        this.agents = agentArray;
        this.capacity = this.initialCapacity;
        this.size = this.initialCapacity;
    }

    public ArrayAgentSet(Class<? extends Agent> clazz, Agent[] agentArray, String string, World world) {
        super(clazz, world, string, false);
        this.initialCapacity = agentArray.length;
        this.agents = agentArray;
        this.capacity = this.initialCapacity;
        this.size = this.initialCapacity;
    }

    ArrayAgentSet(Class<? extends Agent> clazz, int n, String string, boolean bl, World world) {
        super(clazz, world, string, bl);
        this.initialCapacity = n;
        this.agents = new Agent[n];
        this.capacity = n;
    }

    @Override
    public Agent agent(long l) {
        return this.agents[(int)l];
    }

    @Override
    Agent getAgent(Object object) {
        return this.agents[((Double)object).intValue()];
    }

    @Override
    public void add(Agent agent) {
        if (this.size < this.capacity) {
            this.agents[this.size] = agent;
            ++this.size;
        } else {
            Agent[] agentArray = new Agent[this.capacity * 2];
            System.arraycopy(this.agents, 0, agentArray, 0, this.capacity);
            this.agents = agentArray;
            this.capacity *= 2;
            this.add(agent);
        }
    }

    @Override
    void remove(Object object) {
        throw new IllegalStateException("Cannot call remove() from an  ArrayAgentSet");
    }

    @Override
    void clear() {
        if (!this.removableAgents) {
            throw new IllegalStateException("Cannot call remove() on an AgentSet with removableAgents set to false");
        }
        this.capacity = this.initialCapacity;
        this.agents = new Agent[this.capacity];
        this.size = 0;
    }

    @Override
    public boolean contains(Agent agent) {
        AgentSet.Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (iterator2.next() != agent) continue;
            return true;
        }
        return false;
    }

    @Override
    public Agent randomOne(int n, int n2) {
        if (this.size == this.capacity && (this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            return this.agents[n2];
        }
        AgentSet.Iterator iterator2 = this.iterator();
        for (int i = 0; i < n2; ++i) {
            iterator2.next();
        }
        return iterator2.next();
    }

    @Override
    Agent[] randomTwo(int n, int n2, int n3) {
        Agent[] agentArray = new Agent[2];
        if (n3 >= n2) {
            ++n3;
        } else {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        if (this.size == this.capacity && (this.type != Turtle.class && this.type != Link.class || this.removableAgents)) {
            agentArray[0] = this.agents[n2];
            agentArray[1] = this.agents[n3];
        } else {
            AgentSet.Iterator iterator2 = this.iterator();
            int n5 = 0;
            while (n5++ < n2) {
                iterator2.next();
            }
            agentArray[0] = iterator2.next();
            while (n5++ < n3) {
                iterator2.next();
            }
            agentArray[1] = iterator2.next();
        }
        return agentArray;
    }

    @Override
    Agent[] randomSubsetGeneral(int n, int n2, MersenneTwisterFast mersenneTwisterFast) {
        Agent[] agentArray = new Agent[n];
        if (n2 == this.capacity) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (mersenneTwisterFast.nextInt(n2 - n3) < n - n4) {
                    agentArray[n4] = this.agents[n3];
                    ++n4;
                }
                ++n3;
            }
        } else {
            AgentSet.Iterator iterator2 = this.iterator();
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                Agent agent = iterator2.next();
                if (mersenneTwisterFast.nextInt(n2 - n5) < n - n6) {
                    agentArray[n6] = agent;
                    ++n6;
                }
                ++n5;
            }
        }
        return agentArray;
    }

    @Override
    public LogoList toLogoList() {
        ArrayList<Agent> arrayList = new ArrayList<Agent>();
        AgentSet.Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            Agent agent = iterator2.next();
            arrayList.add(agent);
        }
        Collections.sort(arrayList);
        return LogoList.fromJava(arrayList);
    }

    @Override
    public Agent[] toArray() {
        return this.agents;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AgentSet");
        stringBuilder = stringBuilder.append("\n...... type: ");
        stringBuilder = stringBuilder.append(this.type == null ? "null" : this.type.toString());
        stringBuilder = stringBuilder.append("\n...... size: " + this.size);
        stringBuilder = stringBuilder.append("\n...... count(): " + this.count());
        stringBuilder = stringBuilder.append("\n...... capacity: " + this.capacity);
        stringBuilder = stringBuilder.append("\n...... agents: ");
        AgentSet.Iterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            stringBuilder = stringBuilder.append("\n" + iterator2.next().toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public AgentSet.Iterator iterator() {
        if (this.type == Patch.class) {
            return new Iterator();
        }
        return new IteratorWithDead();
    }

    @Override
    public AgentSet.Iterator shufflerator(MersenneTwisterFast mersenneTwisterFast) {
        return new Shufflerator(mersenneTwisterFast);
    }

    private strictfp class Shufflerator
    extends Iterator {
        private int i;
        private final Agent[] copy;
        private Agent next;
        private final MersenneTwisterFast random;

        Shufflerator(MersenneTwisterFast mersenneTwisterFast) {
            this.i = 0;
            this.copy = new Agent[ArrayAgentSet.this.size];
            this.random = mersenneTwisterFast;
            System.arraycopy(ArrayAgentSet.this.agents, 0, this.copy, 0, ArrayAgentSet.this.size);
            while (this.i < this.copy.length && this.copy[this.i] == null) {
                ++this.i;
            }
            this.fetch();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Agent next() {
            Agent agent = this.next;
            this.fetch();
            return agent;
        }

        private void fetch() {
            if (this.i >= this.copy.length) {
                this.next = null;
            } else {
                if (this.i < this.copy.length - 1) {
                    int n = this.i + this.random.nextInt(this.copy.length - this.i);
                    this.next = this.copy[n];
                    this.copy[n] = this.copy[this.i];
                } else {
                    this.next = this.copy[this.i];
                }
                ++this.i;
                if (this.next == null || this.next.id == -1L) {
                    this.fetch();
                }
            }
        }
    }

    private strictfp class IteratorWithDead
    extends Iterator {
        IteratorWithDead() {
            while (this.index < ArrayAgentSet.this.size && ArrayAgentSet.this.agents[this.index].id == -1L) {
                ++this.index;
            }
        }

        public Agent next() {
            int n = this.index;
            do {
                ++this.index;
            } while (this.index < ArrayAgentSet.this.size && ArrayAgentSet.this.agents[this.index].id == -1L);
            return ArrayAgentSet.this.agents[n];
        }
    }

    public strictfp class Iterator
    implements AgentSet.Iterator {
        int index;

        public boolean hasNext() {
            return this.index < ArrayAgentSet.this.size;
        }

        public Agent next() {
            return ArrayAgentSet.this.agents[this.index++];
        }
    }
}

