/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.I18N;

strictfp final class Box
extends Topology {
    Box(World world) {
        super(world);
    }

    double wrapX(double d) throws AgentException {
        double d2 = (double)this.world.maxPxcor() + 0.5;
        double d3 = (double)this.world.minPxcor() - 0.5;
        if (d >= d2 || d < d3) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Box.cantMoveTurtleBeyondWorldEdge"));
        }
        return d;
    }

    double wrapY(double d) throws AgentException {
        double d2 = (double)this.world.maxPycor() + 0.5;
        double d3 = (double)this.world.minPycor() - 0.5;
        if (d >= d2 || d < d3) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Box.cantMoveTurtleBeyondWorldEdge"));
        }
        return d;
    }

    double distanceWrap(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.world.rootsTable.gridRoot(d * d + d2 * d2);
    }

    double towardsWrap(double d, double d2) {
        if (d == 0.0) {
            return d2 > 0.0 ? 0.0 : 180.0;
        }
        if (d2 == 0.0) {
            return d > 0.0 ? 90.0 : 270.0;
        }
        return (270.0 + StrictMath.toDegrees(Math.PI + StrictMath.atan2(-d2, d))) % 360.0;
    }

    Patch getPatchAt(double d, double d2) throws AgentException {
        if (d2 > (double)this.world.maxPycor() + 0.5 || d2 < (double)this.world.minPycor() - 0.5) {
            return null;
        }
        if (d > (double)this.world.maxPxcor() + 0.5 || d < (double)this.world.minPxcor() - 0.5) {
            return null;
        }
        return this.world.getPatchAt(d, d2);
    }

    double shortestPathX(double d, double d2) {
        return d2;
    }

    double shortestPathY(double d, double d2) {
        return d2;
    }

    void diffuse(double d, int n) throws AgentException, PatchException {
        int n2 = this.world.worldWidth();
        int n3 = this.world.worldHeight();
        double[][] dArray = this.world.getPatchScratch();
        double[][] dArray2 = new double[n2][n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = this.world.minPxcor();
        int n7 = this.world.minPycor();
        try {
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n4][n5] = (Double)this.world.fastGetPatchAt(n4 + n6, n5 + n7).getPatchVariable(n);
                    dArray2[n4][n5] = 0.0;
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(n4), (int)this.wrapY(n5)));
        }
        for (n5 = 0; n5 < n3; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                double d2 = dArray[n4][n5] / 8.0 * d;
                if (n5 > 0 && n5 < n3 - 1 && n4 > 0 && n4 < n2 - 1) {
                    double[] dArray3 = dArray2[n4];
                    int n8 = n5;
                    dArray3[n8] = dArray3[n8] + (dArray[n4][n5] - 8.0 * d2);
                    double[] dArray4 = dArray2[n4 - 1];
                    int n9 = n5 - 1;
                    dArray4[n9] = dArray4[n9] + d2;
                    double[] dArray5 = dArray2[n4 - 1];
                    int n10 = n5;
                    dArray5[n10] = dArray5[n10] + d2;
                    double[] dArray6 = dArray2[n4 - 1];
                    int n11 = n5 + 1;
                    dArray6[n11] = dArray6[n11] + d2;
                    double[] dArray7 = dArray2[n4];
                    int n12 = n5 + 1;
                    dArray7[n12] = dArray7[n12] + d2;
                    double[] dArray8 = dArray2[n4];
                    int n13 = n5 - 1;
                    dArray8[n13] = dArray8[n13] + d2;
                    double[] dArray9 = dArray2[n4 + 1];
                    int n14 = n5 - 1;
                    dArray9[n14] = dArray9[n14] + d2;
                    double[] dArray10 = dArray2[n4 + 1];
                    int n15 = n5;
                    dArray10[n15] = dArray10[n15] + d2;
                    double[] dArray11 = dArray2[n4 + 1];
                    int n16 = n5 + 1;
                    dArray11[n16] = dArray11[n16] + d2;
                    continue;
                }
                if (n5 > 0 && n5 < n3 - 1) {
                    if (n4 == 0) {
                        double[] dArray12 = dArray2[n4];
                        int n17 = n5;
                        dArray12[n17] = dArray12[n17] + (dArray[n4][n5] - 5.0 * d2);
                        double[] dArray13 = dArray2[n4];
                        int n18 = n5 + 1;
                        dArray13[n18] = dArray13[n18] + d2;
                        double[] dArray14 = dArray2[n4];
                        int n19 = n5 - 1;
                        dArray14[n19] = dArray14[n19] + d2;
                        double[] dArray15 = dArray2[n4 + 1];
                        int n20 = n5 - 1;
                        dArray15[n20] = dArray15[n20] + d2;
                        double[] dArray16 = dArray2[n4 + 1];
                        int n21 = n5;
                        dArray16[n21] = dArray16[n21] + d2;
                        double[] dArray17 = dArray2[n4 + 1];
                        int n22 = n5 + 1;
                        dArray17[n22] = dArray17[n22] + d2;
                        continue;
                    }
                    double[] dArray18 = dArray2[n4];
                    int n23 = n5;
                    dArray18[n23] = dArray18[n23] + (dArray[n4][n5] - 5.0 * d2);
                    double[] dArray19 = dArray2[n4];
                    int n24 = n5 + 1;
                    dArray19[n24] = dArray19[n24] + d2;
                    double[] dArray20 = dArray2[n4];
                    int n25 = n5 - 1;
                    dArray20[n25] = dArray20[n25] + d2;
                    double[] dArray21 = dArray2[n4 - 1];
                    int n26 = n5 - 1;
                    dArray21[n26] = dArray21[n26] + d2;
                    double[] dArray22 = dArray2[n4 - 1];
                    int n27 = n5;
                    dArray22[n27] = dArray22[n27] + d2;
                    double[] dArray23 = dArray2[n4 - 1];
                    int n28 = n5 + 1;
                    dArray23[n28] = dArray23[n28] + d2;
                    continue;
                }
                if (n4 > 0 && n4 < n2 - 1) {
                    if (n5 == 0) {
                        double[] dArray24 = dArray2[n4];
                        int n29 = n5;
                        dArray24[n29] = dArray24[n29] + (dArray[n4][n5] - 5.0 * d2);
                        double[] dArray25 = dArray2[n4 - 1];
                        int n30 = n5;
                        dArray25[n30] = dArray25[n30] + d2;
                        double[] dArray26 = dArray2[n4 - 1];
                        int n31 = n5 + 1;
                        dArray26[n31] = dArray26[n31] + d2;
                        double[] dArray27 = dArray2[n4];
                        int n32 = n5 + 1;
                        dArray27[n32] = dArray27[n32] + d2;
                        double[] dArray28 = dArray2[n4 + 1];
                        int n33 = n5;
                        dArray28[n33] = dArray28[n33] + d2;
                        double[] dArray29 = dArray2[n4 + 1];
                        int n34 = n5 + 1;
                        dArray29[n34] = dArray29[n34] + d2;
                        continue;
                    }
                    double[] dArray30 = dArray2[n4];
                    int n35 = n5;
                    dArray30[n35] = dArray30[n35] + (dArray[n4][n5] - 5.0 * d2);
                    double[] dArray31 = dArray2[n4 - 1];
                    int n36 = n5;
                    dArray31[n36] = dArray31[n36] + d2;
                    double[] dArray32 = dArray2[n4 - 1];
                    int n37 = n5 - 1;
                    dArray32[n37] = dArray32[n37] + d2;
                    double[] dArray33 = dArray2[n4];
                    int n38 = n5 - 1;
                    dArray33[n38] = dArray33[n38] + d2;
                    double[] dArray34 = dArray2[n4 + 1];
                    int n39 = n5;
                    dArray34[n39] = dArray34[n39] + d2;
                    double[] dArray35 = dArray2[n4 + 1];
                    int n40 = n5 - 1;
                    dArray35[n40] = dArray35[n40] + d2;
                    continue;
                }
                if (n4 == 0) {
                    if (n5 == 0) {
                        double[] dArray36 = dArray2[n4];
                        int n41 = n5;
                        dArray36[n41] = dArray36[n41] + (dArray[n4][n5] - 3.0 * d2);
                        double[] dArray37 = dArray2[n4];
                        int n42 = n5 + 1;
                        dArray37[n42] = dArray37[n42] + d2;
                        double[] dArray38 = dArray2[n4 + 1];
                        int n43 = n5;
                        dArray38[n43] = dArray38[n43] + d2;
                        double[] dArray39 = dArray2[n4 + 1];
                        int n44 = n5 + 1;
                        dArray39[n44] = dArray39[n44] + d2;
                        continue;
                    }
                    double[] dArray40 = dArray2[n4];
                    int n45 = n5;
                    dArray40[n45] = dArray40[n45] + (dArray[n4][n5] - 3.0 * d2);
                    double[] dArray41 = dArray2[n4];
                    int n46 = n5 - 1;
                    dArray41[n46] = dArray41[n46] + d2;
                    double[] dArray42 = dArray2[n4 + 1];
                    int n47 = n5;
                    dArray42[n47] = dArray42[n47] + d2;
                    double[] dArray43 = dArray2[n4 + 1];
                    int n48 = n5 - 1;
                    dArray43[n48] = dArray43[n48] + d2;
                    continue;
                }
                if (n5 == 0) {
                    double[] dArray44 = dArray2[n4];
                    int n49 = n5;
                    dArray44[n49] = dArray44[n49] + (dArray[n4][n5] - 3.0 * d2);
                    double[] dArray45 = dArray2[n4];
                    int n50 = n5 + 1;
                    dArray45[n50] = dArray45[n50] + d2;
                    double[] dArray46 = dArray2[n4 - 1];
                    int n51 = n5;
                    dArray46[n51] = dArray46[n51] + d2;
                    double[] dArray47 = dArray2[n4 - 1];
                    int n52 = n5 + 1;
                    dArray47[n52] = dArray47[n52] + d2;
                    continue;
                }
                double[] dArray48 = dArray2[n4];
                int n53 = n5;
                dArray48[n53] = dArray48[n53] + (dArray[n4][n5] - 3.0 * d2);
                double[] dArray49 = dArray2[n4];
                int n54 = n5 - 1;
                dArray49[n54] = dArray49[n54] + d2;
                double[] dArray50 = dArray2[n4 - 1];
                int n55 = n5;
                dArray50[n55] = dArray50[n55] + d2;
                double[] dArray51 = dArray2[n4 - 1];
                int n56 = n5 - 1;
                dArray51[n56] = dArray51[n56] + d2;
            }
        }
        for (n5 = 0; n5 < n3; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                if (dArray2[n4][n5] == dArray[n4][n5]) continue;
                this.world.getPatchAtWrap(n4 + n6, n5 + n7).setPatchVariable(n, dArray2[n4][n5]);
            }
        }
    }

    void diffuse4(double d, int n) throws AgentException, PatchException {
        int n2 = this.world.worldWidth();
        int n3 = this.world.worldHeight();
        double[][] dArray = this.world.getPatchScratch();
        double[][] dArray2 = new double[n2][n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = this.world.minPxcor();
        int n7 = this.world.minPycor();
        try {
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n4][n5] = (Double)this.world.fastGetPatchAt(n4 + n6, n5 + n7).getPatchVariable(n);
                    dArray2[n4][n5] = 0.0;
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(this.world.fastGetPatchAt((int)this.wrapX(n4), (int)this.wrapY(n5)));
        }
        for (n5 = 0; n5 < n3; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                double d2 = dArray[n4][n5] / 4.0 * d;
                if (n5 > 0 && n5 < n3 - 1 && n4 > 0 && n4 < n2 - 1) {
                    double[] dArray3 = dArray2[n4];
                    int n8 = n5;
                    dArray3[n8] = dArray3[n8] + (dArray[n4][n5] - 4.0 * d2);
                    double[] dArray4 = dArray2[n4 - 1];
                    int n9 = n5;
                    dArray4[n9] = dArray4[n9] + d2;
                    double[] dArray5 = dArray2[n4];
                    int n10 = n5 + 1;
                    dArray5[n10] = dArray5[n10] + d2;
                    double[] dArray6 = dArray2[n4];
                    int n11 = n5 - 1;
                    dArray6[n11] = dArray6[n11] + d2;
                    double[] dArray7 = dArray2[n4 + 1];
                    int n12 = n5;
                    dArray7[n12] = dArray7[n12] + d2;
                    continue;
                }
                if (n5 > 0 && n5 < n3 - 1) {
                    if (n4 == 0) {
                        double[] dArray8 = dArray2[n4];
                        int n13 = n5;
                        dArray8[n13] = dArray8[n13] + (dArray[n4][n5] - 3.0 * d2);
                        double[] dArray9 = dArray2[n4];
                        int n14 = n5 + 1;
                        dArray9[n14] = dArray9[n14] + d2;
                        double[] dArray10 = dArray2[n4];
                        int n15 = n5 - 1;
                        dArray10[n15] = dArray10[n15] + d2;
                        double[] dArray11 = dArray2[n4 + 1];
                        int n16 = n5;
                        dArray11[n16] = dArray11[n16] + d2;
                        continue;
                    }
                    double[] dArray12 = dArray2[n4];
                    int n17 = n5;
                    dArray12[n17] = dArray12[n17] + (dArray[n4][n5] - 3.0 * d2);
                    double[] dArray13 = dArray2[n4];
                    int n18 = n5 + 1;
                    dArray13[n18] = dArray13[n18] + d2;
                    double[] dArray14 = dArray2[n4];
                    int n19 = n5 - 1;
                    dArray14[n19] = dArray14[n19] + d2;
                    double[] dArray15 = dArray2[n4 - 1];
                    int n20 = n5;
                    dArray15[n20] = dArray15[n20] + d2;
                    continue;
                }
                if (n4 > 0 && n4 < n2 - 1) {
                    if (n5 == 0) {
                        double[] dArray16 = dArray2[n4];
                        int n21 = n5;
                        dArray16[n21] = dArray16[n21] + (dArray[n4][n5] - 3.0 * d2);
                        double[] dArray17 = dArray2[n4 - 1];
                        int n22 = n5;
                        dArray17[n22] = dArray17[n22] + d2;
                        double[] dArray18 = dArray2[n4];
                        int n23 = n5 + 1;
                        dArray18[n23] = dArray18[n23] + d2;
                        double[] dArray19 = dArray2[n4 + 1];
                        int n24 = n5;
                        dArray19[n24] = dArray19[n24] + d2;
                        continue;
                    }
                    double[] dArray20 = dArray2[n4];
                    int n25 = n5;
                    dArray20[n25] = dArray20[n25] + (dArray[n4][n5] - 3.0 * d2);
                    double[] dArray21 = dArray2[n4 - 1];
                    int n26 = n5;
                    dArray21[n26] = dArray21[n26] + d2;
                    double[] dArray22 = dArray2[n4];
                    int n27 = n5 - 1;
                    dArray22[n27] = dArray22[n27] + d2;
                    double[] dArray23 = dArray2[n4 + 1];
                    int n28 = n5;
                    dArray23[n28] = dArray23[n28] + d2;
                    continue;
                }
                if (n4 == 0) {
                    if (n5 == 0) {
                        double[] dArray24 = dArray2[n4];
                        int n29 = n5;
                        dArray24[n29] = dArray24[n29] + (dArray[n4][n5] - 2.0 * d2);
                        double[] dArray25 = dArray2[n4];
                        int n30 = n5 + 1;
                        dArray25[n30] = dArray25[n30] + d2;
                        double[] dArray26 = dArray2[n4 + 1];
                        int n31 = n5;
                        dArray26[n31] = dArray26[n31] + d2;
                        continue;
                    }
                    double[] dArray27 = dArray2[n4];
                    int n32 = n5;
                    dArray27[n32] = dArray27[n32] + (dArray[n4][n5] - 2.0 * d2);
                    double[] dArray28 = dArray2[n4];
                    int n33 = n5 - 1;
                    dArray28[n33] = dArray28[n33] + d2;
                    double[] dArray29 = dArray2[n4 + 1];
                    int n34 = n5;
                    dArray29[n34] = dArray29[n34] + d2;
                    continue;
                }
                if (n5 == 0) {
                    double[] dArray30 = dArray2[n4];
                    int n35 = n5;
                    dArray30[n35] = dArray30[n35] + (dArray[n4][n5] - 2.0 * d2);
                    double[] dArray31 = dArray2[n4];
                    int n36 = n5 + 1;
                    dArray31[n36] = dArray31[n36] + d2;
                    double[] dArray32 = dArray2[n4 - 1];
                    int n37 = n5;
                    dArray32[n37] = dArray32[n37] + d2;
                    continue;
                }
                double[] dArray33 = dArray2[n4];
                int n38 = n5;
                dArray33[n38] = dArray33[n38] + (dArray[n4][n5] - 2.0 * d2);
                double[] dArray34 = dArray2[n4];
                int n39 = n5 - 1;
                dArray34[n39] = dArray34[n39] + d2;
                double[] dArray35 = dArray2[n4 - 1];
                int n40 = n5;
                dArray35[n40] = dArray35[n40] + d2;
            }
        }
        for (n5 = 0; n5 < n3; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                if (dArray2[n4][n5] == dArray[n4][n5]) continue;
                this.world.getPatchAtWrap(n4 + n6, n5 + n7).setPatchVariable(n, dArray2[n4][n5]);
            }
        }
    }

    double followOffsetX() {
        return 0.0;
    }

    double followOffsetY() {
        return 0.0;
    }

    AgentSet getNeighbors(Patch patch) {
        double d = patch.pxcor;
        double d2 = patch.pycor;
        if (d == (double)this.world._maxPxcor && d == (double)this.world._minPxcor && d2 == (double)this.world._maxPycor && d2 == (double)this.world._minPycor) {
            return new ArrayAgentSet(Patch.class, 1, false, this.world);
        }
        if (d == (double)this.world.maxPxcor()) {
            if (d == (double)this.world.minPxcor()) {
                if (d2 == (double)this.world.maxPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(patch)}, this.world);
                }
                if (d2 == (double)this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
            }
            if (d2 == (double)this.world.maxPycor()) {
                if (d2 == (double)this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchWest(patch)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchSouthWest(patch)}, this.world);
            }
            if (d2 == (double)this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchWest(patch), this.getPatchNorthWest(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchSouthWest(patch), this.getPatchNorthWest(patch)}, this.world);
        }
        if (d == (double)this.world.minPxcor()) {
            if (d2 == (double)this.world.maxPycor()) {
                if (d2 == (double)this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchSouthEast(patch)}, this.world);
            }
            if (d2 == (double)this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchNorthEast(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchNorthEast(patch), this.getPatchSouthEast(patch)}, this.world);
        }
        if (d2 == (double)this.world.maxPycor()) {
            if (d2 == (double)this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchSouthEast(patch), this.getPatchSouthWest(patch)}, this.world);
        }
        if (d2 == (double)this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchWest(patch), this.getPatchNorthEast(patch), this.getPatchNorthWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch), this.getPatchNorthEast(patch), this.getPatchSouthEast(patch), this.getPatchSouthWest(patch), this.getPatchNorthWest(patch)}, this.world);
    }

    AgentSet getNeighbors4(Patch patch) {
        int n = patch.pxcor;
        int n2 = patch.pycor;
        if (n == this.world.maxPxcor()) {
            if (n == this.world.minPxcor()) {
                if (n2 == this.world.maxPycor()) {
                    if (n2 == this.world.minPycor()) {
                        return new ArrayAgentSet(Patch.class, 1, false, this.world);
                    }
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(patch)}, this.world);
                }
                if (n2 == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch)}, this.world);
            }
            if (n2 == this.world.maxPycor()) {
                if (n2 == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchWest(patch)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
            }
            if (n2 == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchWest(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
        }
        if (n == this.world.minPxcor()) {
            if (n2 == this.world.maxPycor()) {
                if (n2 == this.world.minPycor()) {
                    return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch)}, this.world);
                }
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchSouth(patch)}, this.world);
            }
            if (n2 == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch)}, this.world);
        }
        if (n2 == this.world.maxPycor()) {
            if (n2 == this.world.minPycor()) {
                return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
            }
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
        }
        if (n2 == this.world.minPycor()) {
            return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchWest(patch)}, this.world);
        }
        return new ArrayAgentSet(Patch.class, new Agent[]{this.getPatchNorth(patch), this.getPatchEast(patch), this.getPatchSouth(patch), this.getPatchWest(patch)}, this.world);
    }

    Patch getPN(Patch patch) {
        if (patch.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorth(patch);
    }

    Patch getPE(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            return null;
        }
        return this.getPatchEast(patch);
    }

    Patch getPS(Patch patch) {
        if (patch.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouth(patch);
    }

    Patch getPW(Patch patch) {
        if (patch.pxcor == this.world.minPxcor()) {
            return null;
        }
        return this.getPatchWest(patch);
    }

    Patch getPNE(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor() || patch.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorthEast(patch);
    }

    Patch getPSE(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor() || patch.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouthEast(patch);
    }

    Patch getPSW(Patch patch) {
        if (patch.pxcor == this.world.minPxcor() || patch.pycor == this.world.minPycor()) {
            return null;
        }
        return this.getPatchSouthWest(patch);
    }

    Patch getPNW(Patch patch) {
        if (patch.pxcor == this.world.minPxcor() || patch.pycor == this.world.maxPycor()) {
            return null;
        }
        return this.getPatchNorthWest(patch);
    }
}

