/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

class ImportLexer {
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final char[] ZZ_CMAP = ImportLexer.zzUnpackCMap("\b\u0000\u0002\u0002\u0001\u0004\u0015\u0000\u0001\u0002\u0001\u0000\u0001\u0003\t\u0000\u0001\u0001\uffd3\u0000");
    private static final int[] ZZ_ACTION = ImportLexer.zzUnpackAction();
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;

    private static int[] zzUnpackAction() {
        int[] nArray = new int[15];
        int n = 0;
        n = ImportLexer.zzUnpackAction("\u0003\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\u0000\u0001\b\u0001\u0007\u0001\b", n, nArray);
        return nArray;
    }

    private static int zzUnpackAction(String string, int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.charAt(n2++);
            char c = string.charAt(n2++);
            do {
                nArray[n3++] = c;
            } while (--n5 > 0);
        }
        return n3;
    }

    static String[] lex(String string) throws LexerException {
        ImportLexer importLexer = new ImportLexer(new StringReader(string + ","));
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            while ((string2 = importLexer.yylex()) != null) {
                arrayList.add(string2);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String unescape(String string) {
        if (string.indexOf("\"\"") == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' && i < string.length() - 1 && string.charAt(i + 1) == '\"') {
                stringBuilder.append('\"');
                ++i;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    ImportLexer(Reader reader) {
        this.zzReader = reader;
    }

    private static char[] zzUnpackCMap(String string) {
        char[] cArray = new char[65536];
        int n = 0;
        int n2 = 0;
        while (n < 20) {
            int n3 = string.charAt(n++);
            char c = string.charAt(n++);
            do {
                cArray[n2++] = c;
            } while (--n3 > 0);
        }
        return cArray;
    }

    private boolean zzRefill() throws IOException {
        int n;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] cArray = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, cArray, 0, this.zzBuffer.length);
            this.zzBuffer = cArray;
        }
        if ((n = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += n;
            return false;
        }
        if (n == 0) {
            int n2 = this.zzReader.read();
            if (n2 == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)n2;
            return false;
        }
        return true;
    }

    public final void yybegin(int n) {
        this.zzLexicalState = n;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    private void zzScanError(int n) {
        String string;
        try {
            string = ZZ_ERROR_MSG[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = ZZ_ERROR_MSG[0];
        }
        throw new Error(string);
    }

    public String yylex() throws IOException, LexerException {
        int n = this.zzEndRead;
        char[] cArray = this.zzBuffer;
        char[] cArray2 = ZZ_CMAP;
        block72: while (true) {
            int n2;
            int n3 = this.zzMarkedPos;
            int n4 = -1;
            this.zzCurrentPos = this.zzStartRead = n3;
            int n5 = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            block73: while (true) {
                boolean bl;
                if (n5 < n) {
                    n2 = cArray[n5++];
                } else {
                    if (this.zzAtEOF) {
                        n2 = -1;
                        break;
                    }
                    this.zzCurrentPos = n5;
                    this.zzMarkedPos = n3;
                    bl = this.zzRefill();
                    n5 = this.zzCurrentPos;
                    n3 = this.zzMarkedPos;
                    cArray = this.zzBuffer;
                    n = this.zzEndRead;
                    if (bl) {
                        n2 = -1;
                        break;
                    }
                    n2 = cArray[n5++];
                }
                n2 = cArray2[n2];
                bl = false;
                boolean bl2 = false;
                block0 : switch (this.zzState) {
                    case 0: {
                        switch (n2) {
                            case 0: {
                                bl = true;
                                this.zzState = 3;
                                break block0;
                            }
                            case 1: {
                                bl = true;
                                bl2 = true;
                                this.zzState = 4;
                                break block0;
                            }
                            case 3: {
                                bl = true;
                                bl2 = true;
                                this.zzState = 6;
                                break block0;
                            }
                        }
                        bl = true;
                        this.zzState = 5;
                        break;
                    }
                    case 1: {
                        switch (n2) {
                            case 1: {
                                bl = true;
                                bl2 = true;
                                this.zzState = 8;
                                break;
                            }
                            case 4: {
                                break block73;
                            }
                            default: {
                                bl = true;
                                bl2 = true;
                                this.zzState = 7;
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (n2) {
                            case 3: {
                                bl = true;
                                this.zzState = 10;
                                break block0;
                            }
                            case 4: {
                                this.zzState = 11;
                                break block0;
                            }
                        }
                        bl = true;
                        this.zzState = 9;
                        break;
                    }
                    case 3: {
                        switch (n2) {
                            case 1: 
                            case 3: {
                                break block73;
                            }
                            default: {
                                bl = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (n2) {
                            case 0: {
                                bl = true;
                                this.zzState = 3;
                                break;
                            }
                            case 3: {
                                bl = true;
                                bl2 = true;
                                this.zzState = 6;
                                break;
                            }
                            case 1: {
                                break block73;
                            }
                            default: {
                                bl = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 9: {
                        switch (n2) {
                            case 3: {
                                bl = true;
                                this.zzState = 12;
                                break block0;
                            }
                        }
                        this.zzState = 11;
                        break;
                    }
                    case 10: {
                        switch (n2) {
                            case 3: {
                                this.zzState = 11;
                                break;
                            }
                            case 0: 
                            case 1: {
                                break block73;
                            }
                            default: {
                                bl = true;
                                this.zzState = 13;
                                break;
                            }
                        }
                        break;
                    }
                    case 11: {
                        switch (n2) {
                            case 3: {
                                bl = true;
                                this.zzState = 12;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 12: {
                        switch (n2) {
                            case 3: {
                                this.zzState = 11;
                                break;
                            }
                            case 0: 
                            case 1: {
                                break block73;
                            }
                            default: {
                                bl = true;
                                this.zzState = 14;
                                break;
                            }
                        }
                        break;
                    }
                    case 13: {
                        switch (n2) {
                            case 2: 
                            case 4: {
                                bl = true;
                                break block0;
                            }
                        }
                        break block73;
                    }
                    case 14: {
                        switch (n2) {
                            case 2: 
                            case 4: {
                                bl = true;
                                break block0;
                            }
                        }
                        break block73;
                    }
                    default: {
                        this.zzScanError(0);
                    }
                }
                if (!bl) continue;
                n4 = this.zzState;
                n3 = n5;
                if (bl2) break;
            }
            this.zzMarkedPos = n3;
            switch (n4 < 0 ? n4 : ZZ_ACTION[n4]) {
                case 6: {
                    throw new LexerException("Unclosed double quote");
                }
                case 9: {
                    continue block72;
                }
                case 3: {
                    this.yybegin(4);
                }
                case 10: {
                    continue block72;
                }
                case 8: {
                    this.yybegin(2);
                    String string = this.yytext();
                    return ImportLexer.unescape(string.substring(0, string.lastIndexOf(34)));
                }
                case 11: {
                    continue block72;
                }
                case 2: {
                    return "";
                }
                case 12: {
                    continue block72;
                }
                case 1: {
                    this.yybegin(2);
                    return this.yytext().trim();
                }
                case 13: {
                    continue block72;
                }
                case 7: {
                    this.yybegin(2);
                    return "";
                }
                case 14: {
                    continue block72;
                }
                case 5: {
                    this.yybegin(0);
                }
                case 15: {
                    continue block72;
                }
                case 4: {
                    throw new LexerException("Quoted fields must be followed by comma or end of line");
                }
                case 16: {
                    continue block72;
                }
            }
            if (n2 == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }

    static class LexerException
    extends Exception {
        public LexerException(String string) {
            super(string);
        }
    }
}

