/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.DummyLink;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class LinkManager {
    private final World world;
    final Map<Turtle, List<Link>> srcMap = new LinkedHashMap<Turtle, List<Link>>();
    final Map<Turtle, List<Link>> destMap = new LinkedHashMap<Turtle, List<Link>>();
    private double countUnbreededLinks = 0.0;

    public LinkManager(World world) {
        this.world = world;
    }

    private void bless(Link link) {
        ArrayList<Link> arrayList;
        Turtle turtle2 = link.end1();
        Turtle turtle3 = link.end2();
        if (this.srcMap.containsKey(turtle2)) {
            this.srcMap.get(turtle2).add(link);
        } else {
            arrayList = new ArrayList<Link>();
            arrayList.add(link);
            this.srcMap.put(turtle2, arrayList);
        }
        if (this.destMap.containsKey(turtle3)) {
            this.destMap.get(turtle3).add(link);
        } else {
            arrayList = new ArrayList();
            arrayList.add(link);
            this.destMap.put(turtle3, arrayList);
        }
        if (link.getBreed() == this.world.links()) {
            this.countUnbreededLinks += 1.0;
        }
    }

    public void reset() {
        this.srcMap.clear();
        this.destMap.clear();
        this.world.tieManager.reset();
        this.countUnbreededLinks = 0.0;
        this.resetLinkDirectedness();
    }

    private void resetLinkDirectedness() {
        if (this.countUnbreededLinks == 0.0) {
            this.world.links().clearDirected();
        }
    }

    public Link createLink(Turtle turtle2, Turtle turtle3, AgentSet agentSet) {
        Link link = this.newLink(this.world, turtle2, turtle3, agentSet);
        link.colorDoubleUnchecked(Link.DEFAULT_COLOR);
        this.bless(link);
        return link;
    }

    Link newLink(World world, Turtle turtle2, Turtle turtle3, AgentSet agentSet) {
        return new Link(world, turtle2, turtle3, agentSet);
    }

    public Link findLink(Turtle turtle2, Turtle turtle3, AgentSet agentSet, boolean bl) {
        if (agentSet.isDirected()) {
            return this.findLinkFrom(turtle2, turtle3, agentSet, bl);
        }
        return this.findLinkEitherWay(turtle2, turtle3, agentSet, bl);
    }

    public Link findLinkFrom(Turtle turtle2, Turtle turtle3, AgentSet agentSet, boolean bl) {
        if (turtle2 == null || turtle3 == null) {
            return null;
        }
        Link link = (Link)this.world.links().getAgent(new DummyLink(this.world, (Object)turtle2, (Object)turtle3, agentSet));
        if (link == null && bl && agentSet == this.world.links()) {
            Iterator<Object> iterator2 = this.world.getLinkBreeds().values().iterator();
            while (iterator2.hasNext()) {
                link = (Link)this.world.links().getAgent(new DummyLink(this.world, (Object)turtle2, (Object)turtle3, (AgentSet)iterator2.next()));
                if (link == null) continue;
                return link;
            }
        }
        return link;
    }

    public Link findLinkEitherWay(Turtle turtle2, Turtle turtle3, AgentSet agentSet, boolean bl) {
        Link link = this.findLinkFrom(turtle2, turtle3, agentSet, bl);
        if (link == null) {
            link = this.findLinkFrom(turtle3, turtle2, agentSet, bl);
        }
        return link;
    }

    public AgentSet findLinkedFrom(Turtle turtle2, AgentSet agentSet) {
        List<Link> list = this.srcMap.get(turtle2);
        if (list != null) {
            ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Turtle.class, list.size(), false, this.world);
            this.addLinkNeighborsFrom(arrayAgentSet, list, agentSet, true);
            return arrayAgentSet;
        }
        return this.world.noTurtles();
    }

    public AgentSet findLinkedTo(Turtle turtle2, AgentSet agentSet) {
        List<Link> list = this.destMap.get(turtle2);
        if (list != null) {
            ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Turtle.class, list.size(), false, this.world);
            this.addLinkNeighborsTo(arrayAgentSet, list, agentSet, true);
            return arrayAgentSet;
        }
        return this.world.noTurtles();
    }

    public AgentSet findLinkedWith(Turtle turtle2, AgentSet agentSet) {
        List<Link> list = this.destMap.get(turtle2);
        List<Link> list2 = this.srcMap.get(turtle2);
        int n = (list2 == null ? 0 : list2.size()) + (list == null ? 0 : list.size());
        if (n == 0) {
            return this.world.noTurtles();
        }
        ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Turtle.class, n, false, this.world);
        if (list != null) {
            this.addLinkNeighborsTo(arrayAgentSet, list, agentSet, false);
        }
        if (list2 != null) {
            this.addLinkNeighborsFrom(arrayAgentSet, list2, agentSet, false);
        }
        return arrayAgentSet;
    }

    private void addLinkNeighborsFrom(AgentSet agentSet, List<Link> list, AgentSet agentSet2, boolean bl) {
        boolean bl2 = agentSet2.printName() != null;
        boolean bl3 = agentSet2 == this.world.links();
        boolean bl4 = this.checkBreededCompatibility(true);
        for (Link link : list) {
            if (!(!bl2 && agentSet2.contains(link) || bl3 && (bl4 || bl == link.getBreed().isDirected() && !agentSet.contains(link.end1()))) && link.getBreed() != agentSet2) continue;
            agentSet.add(link.end2());
        }
    }

    private void addLinkNeighborsTo(AgentSet agentSet, List<Link> list, AgentSet agentSet2, boolean bl) {
        boolean bl2 = agentSet2.printName() != null;
        boolean bl3 = agentSet2 == this.world.links();
        boolean bl4 = this.checkBreededCompatibility(true);
        for (Link link : list) {
            if (!(!bl2 && agentSet2.contains(link) || bl3 && (bl4 || bl == link.getBreed().isDirected() && !agentSet.contains(link.end1()))) && link.getBreed() != agentSet2) continue;
            agentSet.add(link.end1());
        }
    }

    public boolean checkBreededCompatibility(boolean bl) {
        AgentSet.Iterator iterator2 = this.world.links().iterator();
        if (!iterator2.hasNext()) {
            return true;
        }
        return ((Link)iterator2.next()).getBreed() == this.world.links() == bl;
    }

    public AgentSet findLinksFrom(Turtle turtle2, AgentSet agentSet) {
        boolean bl;
        List<Link> list = this.srcMap.get(turtle2);
        ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Link.class, 1, false, this.world);
        boolean bl2 = bl = agentSet == this.world.links();
        if (list != null) {
            for (Link link : list) {
                if (!bl && link.getBreed() != agentSet) continue;
                ((AgentSet)arrayAgentSet).add(link);
            }
        }
        return arrayAgentSet;
    }

    public AgentSet findLinksTo(Turtle turtle2, AgentSet agentSet) {
        boolean bl;
        List<Link> list = this.destMap.get(turtle2);
        ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Link.class, 1, false, this.world);
        boolean bl2 = bl = agentSet == this.world.links();
        if (list != null) {
            for (Link link : list) {
                if (!bl && link.getBreed() != agentSet) continue;
                ((AgentSet)arrayAgentSet).add(link);
            }
        }
        return arrayAgentSet;
    }

    public AgentSet findLinksWith(Turtle turtle2, AgentSet agentSet) {
        List<Link> list = this.destMap.get(turtle2);
        List<Link> list2 = this.srcMap.get(turtle2);
        ArrayList<Link> arrayList = new ArrayList<Link>();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        boolean bl = agentSet == this.world.links();
        ArrayAgentSet arrayAgentSet = new ArrayAgentSet(Link.class, 1, false, this.world);
        for (Link link : arrayList) {
            if (!bl && link.getBreed() != agentSet) continue;
            ((AgentSet)arrayAgentSet).add(link);
        }
        return arrayAgentSet;
    }

    void cleanup(Link link) {
        Turtle turtle2;
        link.untie();
        Turtle turtle3 = link.end1();
        List<Link> list = this.srcMap.get(turtle3);
        if (list != null) {
            list.remove(link);
            if (list.isEmpty()) {
                this.srcMap.remove(turtle3);
            }
        }
        if ((list = this.destMap.get(turtle2 = link.end2())) != null) {
            list.remove(link);
            if (list.isEmpty()) {
                this.destMap.remove(turtle2);
            }
        }
        if (link.getBreed() == this.world.links()) {
            this.countUnbreededLinks -= 1.0;
        }
        this.resetLinkDirectedness();
    }

    void cleanup(Turtle turtle2) {
        List<Link> list;
        if (this.srcMap.containsKey(turtle2)) {
            list = this.srcMap.get(turtle2);
            this.srcMap.remove(turtle2);
            for (Link link : list) {
                link.die();
            }
        }
        if (this.destMap.containsKey(turtle2)) {
            list = this.destMap.get(turtle2);
            this.destMap.remove(turtle2);
            for (Link link : list) {
                link.die();
            }
        }
    }
}

