/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.HeadingSmoother;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Constants;
import org.nlogo.api.Link;
import org.nlogo.api.LogoException;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.ValueConstraint;
import org.nlogo.api.Vect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Observer
extends Agent
implements org.nlogo.api.Observer {
    final HeadingSmoother headingSmoother = new HeadingSmoother();
    Perspective perspective = PerspectiveJ.OBSERVE();
    org.nlogo.api.Agent targetAgent = null;
    private double _oxcor;
    private double _oycor;
    private double _ozcor;
    double heading;
    double pitch;
    double roll;
    Vect rotationPoint;
    int followDistance = 5;

    public Observer(World world) {
        super(world);
        this.resetPerspective();
    }

    @Override
    Agent realloc(boolean bl) {
        int n;
        Object[] objectArray = this.variables;
        Object[] objectArray2 = new Object[this.world.getVariablesArraySize(this)];
        ValueConstraint[] valueConstraintArray = new ValueConstraint[this.world.getVariablesArraySize(this)];
        for (n = 0; objectArray2.length != n; ++n) {
            objectArray2[n] = World.ZERO;
            valueConstraintArray[n] = null;
        }
        if (objectArray != null && bl) {
            for (n = 0; n < objectArray.length && n < this.world.oldGlobals.size(); ++n) {
                String string = this.world.oldGlobals.get(n);
                int n2 = this.world.observerOwnsIndexOf(string);
                if (n2 == -1) continue;
                objectArray2[n2] = objectArray[n];
            }
        }
        this.variables = objectArray2;
        this.variableConstraints = valueConstraintArray;
        return null;
    }

    @Override
    public Object getVariable(int n) {
        return this.variables[n];
    }

    @Override
    public Object getObserverVariable(int n) {
        return this.variables[n];
    }

    @Override
    public Object getTurtleVariable(int n) throws AgentException {
        throw new AgentException("the observer can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getTurtleOrLinkVariable(String string) throws AgentException {
        throw new AgentException("the observer can't access a turtle or link variable without specifying which agent");
    }

    @Override
    public Object getBreedVariable(String string) throws AgentException {
        throw new AgentException("the observer can't access a turtle variable without specifying which turtle");
    }

    @Override
    public Object getLinkVariable(int n) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public Object getLinkBreedVariable(String string) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public Object getPatchVariable(int n) throws AgentException {
        throw new AgentException("the observer can't access a patch variable without specifying which patch");
    }

    @Override
    public void setVariable(int n, Object object) throws AgentException, LogoException {
        this.setObserverVariable(n, object);
    }

    public void assertVariableConstraint(int n, Object object) throws AgentException, LogoException {
        ValueConstraint valueConstraint = this.variableConstraint(n);
        if (valueConstraint != null) {
            valueConstraint.assertConstraint(object);
        }
    }

    @Override
    public void setObserverVariable(int n, Object object) throws AgentException, LogoException {
        this.assertVariableConstraint(n, object);
        this.variables[n] = object;
    }

    @Override
    public void setTurtleVariable(int n, Object object) throws AgentException {
        throw new AgentException("the observer can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setBreedVariable(String string, Object object) throws AgentException {
        throw new AgentException("the observer can't set a turtle variable without specifying which turtle");
    }

    @Override
    public void setPatchVariable(int n, Object object) throws AgentException {
        throw new AgentException("the observer can't set a patch variable without specifying which turtle");
    }

    @Override
    public void setLinkVariable(int n, Object object) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public void setLinkBreedVariable(String string, Object object) throws AgentException {
        throw new AgentException("the observer can't access a link variable without specifying which link");
    }

    @Override
    public void setTurtleOrLinkVariable(String string, Object object) throws AgentException {
        throw new AgentException("the observer can't access a turtle or link variable without specifying which agent");
    }

    @Override
    public Perspective perspective() {
        return this.perspective;
    }

    public void perspective(Perspective perspective) {
        this.perspective = perspective;
    }

    @Override
    public org.nlogo.api.Agent targetAgent() {
        return this.targetAgent;
    }

    public void targetAgent(org.nlogo.api.Agent agent) {
        this.targetAgent = agent;
    }

    @Override
    public double oxcor() {
        return this._oxcor;
    }

    @Override
    public double oycor() {
        return this._oycor;
    }

    @Override
    public double ozcor() {
        return this._ozcor;
    }

    public void ozcor(double d) {
        this._ozcor = d;
    }

    public void oxyandzcor(double d, double d2, double d3) {
        this._oxcor = d;
        this._oycor = d2;
        this._ozcor = d3;
    }

    public double followOffsetX() {
        if (this.perspective == PerspectiveJ.FOLLOW() || this.perspective == PerspectiveJ.RIDE()) {
            return this._oxcor - ((double)this.world.minPxcor() - 0.5 + (double)this.world.worldWidth() / 2.0);
        }
        return 0.0;
    }

    public double followOffsetY() {
        if (this.perspective == PerspectiveJ.FOLLOW() || this.perspective == PerspectiveJ.RIDE()) {
            return this._oycor - ((double)this.world.minPycor() - 0.5 + (double)this.world.worldHeight() / 2.0);
        }
        return 0.0;
    }

    @Override
    public double heading() {
        return this.heading;
    }

    public void heading(double d) {
        this.heading = (d % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double pitch() {
        return this.pitch;
    }

    public void pitch(double d) {
        this.pitch = (d % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double roll() {
        return this.roll;
    }

    public void roll(double d) {
        this.roll = (d % 360.0 + 360.0) % 360.0;
    }

    @Override
    public double dist() {
        return StrictMath.sqrt((this.rotationPoint.x() - this._oxcor) * (this.rotationPoint.x() - this._oxcor) + (this.rotationPoint.y() - this._oycor) * (this.rotationPoint.y() - this._oycor) + (this.rotationPoint.z() - this._ozcor) * (this.rotationPoint.z() - this._ozcor));
    }

    public void setRotationPoint(double d, double d2, double d3) {
        this.rotationPoint = new Vect(d, d2, d3);
    }

    public void setRotationPoint(org.nlogo.api.Agent agent) {
        if (agent instanceof org.nlogo.api.Turtle) {
            org.nlogo.api.Turtle turtle2 = (org.nlogo.api.Turtle)agent;
            this.setRotationPoint(turtle2.xcor(), turtle2.ycor(), 0.0);
        } else if (agent instanceof Link) {
            Link link = (Link)agent;
            this.setRotationPoint(link.midpointX(), link.midpointY(), 0.0);
        } else {
            org.nlogo.api.Patch patch = (org.nlogo.api.Patch)agent;
            this.setRotationPoint(patch.pxcor(), patch.pycor(), 0.0);
        }
    }

    @Override
    public int followDistance() {
        return this.followDistance;
    }

    public void followDistance(int n) {
        this.followDistance = n;
    }

    @Override
    public double dx() {
        double d = StrictMath.cos(StrictMath.toRadians(this.pitch)) * StrictMath.sin(StrictMath.toRadians(this.heading));
        if (StrictMath.abs(d) < Constants.Infinitesimal()) {
            d = 0.0;
        }
        return d;
    }

    @Override
    public double dy() {
        double d = StrictMath.cos(StrictMath.toRadians(this.pitch)) * StrictMath.cos(StrictMath.toRadians(this.heading));
        if (StrictMath.abs(d) < Constants.Infinitesimal()) {
            d = 0.0;
        }
        return d;
    }

    @Override
    public double dz() {
        double d = StrictMath.sin(StrictMath.toRadians(this.pitch));
        if (StrictMath.abs(d) < Constants.Infinitesimal()) {
            d = 0.0;
        }
        return d;
    }

    public void face(org.nlogo.api.Agent agent) {
        try {
            this.heading(this.world.protractor().towards(this, agent, false));
        }
        catch (AgentException agentException) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor().towardsPitch(this, agent, false));
        }
        catch (AgentException agentException) {
            this.pitch(0.0);
        }
        this.setRotationPoint(agent);
    }

    public void face(double d, double d2) {
        try {
            this.heading(this.world.protractor().towards(this, d, d2, false));
        }
        catch (AgentException agentException) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor().towardsPitch(this, d, d2, 0.0, false));
        }
        catch (AgentException agentException) {
            this.pitch(0.0);
        }
        this.setRotationPoint(d, d2, 0.0);
    }

    public void moveto(Agent agent) throws AgentException {
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            this.oxyandzcor(turtle2.xcor(), turtle2.ycor(), 0.0);
        } else if (agent instanceof Patch) {
            Patch patch = (Patch)agent;
            this.oxyandzcor(patch.pxcor, patch.pycor, 0.0);
        } else {
            throw new AgentException("you can't move-to a link");
        }
        this.face(this.rotationPoint.x(), this.rotationPoint.y());
    }

    @Override
    public void setPerspective(Perspective perspective, org.nlogo.api.Agent agent) {
        this.perspective = perspective;
        this.targetAgent = agent;
        this.updatePosition();
    }

    public boolean updatePosition() {
        boolean bl = false;
        if (this.perspective == PerspectiveJ.OBSERVE()) {
            return false;
        }
        if (this.perspective == PerspectiveJ.WATCH()) {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            this.setRotationPoint(this.targetAgent);
            this.face(this.targetAgent);
        } else {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            Turtle turtle2 = (Turtle)this.targetAgent;
            this.oxyandzcor(turtle2.xcor(), turtle2.ycor(), 0.0);
            double d = this.headingSmoother.follow(this.targetAgent);
            if (this.perspective == PerspectiveJ.FOLLOW()) {
                bl = this.heading != d;
                this.heading(d);
            } else {
                this.heading(turtle2.heading());
            }
            this.pitch(0.0);
            this.roll(0.0);
        }
        return bl;
    }

    public void resetPerspective() {
        this.setPerspective(PerspectiveJ.OBSERVE(), null);
        this.home();
    }

    public void home() {
        this._oxcor = (double)this.world.minPxcor() + (double)(this.world.maxPxcor() - this.world.minPxcor()) / 2.0;
        this._oycor = (double)this.world.minPycor() + (double)(this.world.maxPycor() - this.world.minPycor()) / 2.0;
        this._ozcor = (double)StrictMath.max(this.world.worldWidth(), this.world.worldHeight()) * 1.5;
        this.heading = 0.0;
        this.pitch = 90.0;
        this.roll = 0.0;
        this.setRotationPoint(this._oxcor, this._oycor, 0.0);
    }

    public boolean atHome2D() {
        return this.perspective == PerspectiveJ.OBSERVE() && this._oxcor == 0.0 && this._oycor == 0.0;
    }

    @Override
    public Patch getPatchAtOffsets(double d, double d2) throws AgentException {
        return this.world.getPatchAt(d, d2);
    }

    public String toString() {
        return "observer";
    }

    @Override
    public String classDisplayName() {
        return "observer";
    }

    public Class<Observer> getAgentClass() {
        return Observer.class;
    }

    @Override
    public int getAgentBit() {
        return 1;
    }

    @Override
    public String shape() {
        return "";
    }

    @Override
    public double size() {
        return 0.0;
    }

    @Override
    public int alpha() {
        return 0;
    }
}

