/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.Agent3D;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.Vect;

public strictfp final class Observer3D
extends Observer
implements Agent3D {
    private Vect forward;
    private Vect right;

    public Observer3D(World world) {
        super(world);
    }

    public void home() {
        super.home();
        World3D world3D = (World3D)this.world;
        double d = (double)world3D.minPzcor() + (double)(world3D.maxPzcor() - world3D.minPzcor()) / 2.0;
        this.ozcor(d + (double)(StrictMath.max(this.world.worldWidth(), StrictMath.max(this.world.worldHeight(), world3D.worldDepth())) * 2));
        this.rotationPoint = new Vect(this.oxcor(), this.oycor(), d);
        this.right = new Vect(1.0, 0.0, 0.0);
        this.forward = new Vect(0.0, 0.0, 1.0);
    }

    public boolean updatePosition() {
        boolean bl = false;
        if (this.perspective == PerspectiveJ.OBSERVE()) {
            return false;
        }
        if (this.perspective == PerspectiveJ.WATCH()) {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            this.face(this.targetAgent);
        } else {
            if (this.targetAgent.id() == -1L) {
                this.resetPerspective();
                return true;
            }
            Turtle3D turtle3D = (Turtle3D)this.targetAgent;
            this.oxyandzcor(turtle3D.xcor(), turtle3D.ycor(), turtle3D.zcor());
            this.heading(turtle3D.heading());
            this.pitch(turtle3D.pitch());
            this.roll(turtle3D.roll());
        }
        return bl;
    }

    public double followOffsetZ() {
        if (this.perspective == PerspectiveJ.FOLLOW() || this.perspective == PerspectiveJ.RIDE()) {
            World3D world3D = (World3D)this.world;
            return this.ozcor() - (double)(world3D.minPzcor() + world3D.maxPzcor()) / 2.0;
        }
        return 0.0;
    }

    public void face(double d, double d2, double d3) {
        try {
            this.heading(this.world.protractor().towards(this, d, d2, false));
        }
        catch (AgentException agentException) {
            this.heading(0.0);
        }
        try {
            this.pitch(-this.world.protractor().towardsPitch(this, d, d2, d3, false));
        }
        catch (AgentException agentException) {
            this.pitch(0.0);
        }
        this.setRotationPoint(d, d2, d3);
        Vect[] vectArray = Vect.toVectors(this.heading, this.pitch, this.roll);
        this.forward = vectArray[0];
        this.right = vectArray[1];
    }

    public void moveto(Agent agent) {
        if (agent instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent;
            this.oxyandzcor(turtle3D.xcor(), turtle3D.ycor(), turtle3D.zcor());
        } else {
            Patch3D patch3D = (Patch3D)agent;
            this.oxyandzcor(patch3D.pxcor, patch3D.pycor, patch3D.pzcor);
        }
        this.face(this.rotationPoint.x(), this.rotationPoint.y(), this.rotationPoint.z());
    }

    public Patch3D getPatchAtOffsets(double d, double d2, double d3) throws AgentException {
        return ((World3D)this.world).getPatchAt(d, d2, d3);
    }

    public void setRotationPoint(org.nlogo.api.Agent agent) {
        if (agent instanceof Turtle) {
            Turtle3D turtle3D = (Turtle3D)agent;
            this.setRotationPoint(turtle3D.xcor(), turtle3D.ycor(), turtle3D.zcor());
        } else {
            Patch3D patch3D = (Patch3D)agent;
            this.setRotationPoint(patch3D.pxcor(), patch3D.pycor(), patch3D.pzcor());
        }
    }
}

