/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.Constants;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class TieManager {
    private final World world;
    final LinkManager linkManager;
    int tieCount = 0;

    TieManager(World world, LinkManager linkManager) {
        this.world = world;
        this.linkManager = linkManager;
    }

    public void reset() {
        this.tieCount = 0;
    }

    public void setTieMode(Link link, String string) {
        if (link.isTied()) {
            if (string.equals("none")) {
                --this.tieCount;
            }
        } else if (!string.equals("none")) {
            ++this.tieCount;
        }
    }

    List<Turtle> tiedTurtles(Turtle turtle2) {
        Turtle turtle3;
        ArrayList<Turtle> arrayList = new ArrayList<Turtle>();
        if (this.linkManager.srcMap.containsKey(turtle2)) {
            for (Link link : this.linkManager.srcMap.get(turtle2)) {
                if (!link.isTied()) continue;
                turtle3 = link.end2();
                arrayList.add(turtle3);
            }
        }
        if (this.linkManager.destMap.containsKey(turtle2)) {
            for (Link link : this.linkManager.destMap.get(turtle2)) {
                if (link.getBreed().isDirected() || !link.isTied()) continue;
                turtle3 = link.end1();
                arrayList.add(turtle3);
            }
        }
        return arrayList;
    }

    void turtleMoved(Turtle turtle2, double d, double d2, double d3, double d4) {
        this.turtleMoved(turtle2, d, d2, d3, d4, new HashSet<Turtle>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void turtleMoved(Turtle turtle2, double d, double d2, double d3, double d4, Set<Turtle> set) {
        boolean bl = false;
        try {
            if (set.isEmpty()) {
                set.add(turtle2);
                bl = true;
            }
            List<Turtle> list = this.tiedTurtles(turtle2);
            Iterator<Turtle> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Turtle turtle3 = iterator2.next();
                if (turtle3.id == -1L || set.contains(turtle3)) {
                    iterator2.remove();
                    continue;
                }
                set.add(turtle3);
            }
            for (Turtle turtle3 : list) {
                double d5 = d - d3;
                double d6 = d2 - d4;
                try {
                    turtle3.xandycor(turtle3.xcor + d5, turtle3.ycor + d6, set);
                }
                catch (AgentException agentException) {
                    Exceptions.ignore(agentException);
                }
            }
        }
        finally {
            if (bl) {
                set.clear();
            }
        }
    }

    void turtleTurned(Turtle turtle2, double d, double d2) {
        this.turtleTurned(turtle2, d, d2, new HashSet<Turtle>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void turtleTurned(Turtle turtle2, double d, double d2, Set<Turtle> set) {
        boolean bl = false;
        try {
            if (set.isEmpty()) {
                set.add(turtle2);
                bl = true;
            }
            List<Turtle> list = this.tiedTurtles(turtle2);
            Iterator<Turtle> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Turtle turtle3 = iterator2.next();
                if (turtle3.id == -1L || set.contains(turtle3)) {
                    iterator2.remove();
                    continue;
                }
                set.add(turtle3);
            }
            for (Turtle turtle4 : list) {
                try {
                    Link link = this.linkManager.findLink(turtle2, turtle4, this.world.links(), true);
                    boolean bl2 = link.mode().equals("fixed");
                    double d3 = Turtle.subtractHeadings(d, d2);
                    double d4 = this.world.protractor().distance(turtle2.xcor, turtle2.ycor, turtle4.xcor, turtle4.ycor, true);
                    if (d4 == 0.0) {
                        if (!bl2) continue;
                        turtle4.heading(turtle4.heading + d3, set);
                        continue;
                    }
                    double d5 = this.world.protractor().towards(turtle2, turtle4, true);
                    double d6 = StrictMath.toRadians(d5);
                    double d7 = StrictMath.toRadians(d5 + d3);
                    double d8 = StrictMath.cos(d6);
                    double d9 = StrictMath.sin(d6);
                    double d10 = StrictMath.cos(d7);
                    double d11 = StrictMath.sin(d7);
                    if (StrictMath.abs(d8) < Constants.Infinitesimal()) {
                        d8 = 0.0;
                    }
                    if (StrictMath.abs(d9) < Constants.Infinitesimal()) {
                        d9 = 0.0;
                    }
                    if (StrictMath.abs(d10) < Constants.Infinitesimal()) {
                        d10 = 0.0;
                    }
                    if (StrictMath.abs(d11) < Constants.Infinitesimal()) {
                        d11 = 0.0;
                    }
                    double d12 = turtle2.xcor + d4 * d9;
                    double d13 = turtle2.ycor + d4 * d8;
                    double d14 = turtle2.xcor + d4 * d11;
                    double d15 = turtle2.ycor + d4 * d10;
                    double d16 = d14 - d12;
                    double d17 = d15 - d13;
                    Set<Turtle> set2 = set;
                    try {
                        if (bl2) {
                            set2 = new HashSet<Turtle>(set);
                        }
                        turtle4.xandycor(turtle4.xcor + d16, turtle4.ycor + d17, set);
                    }
                    finally {
                        if (bl2) {
                            set = set2;
                        }
                    }
                    if (!bl2) continue;
                    turtle4.heading(turtle4.heading + d3, set);
                }
                catch (AgentException agentException) {
                    Exceptions.ignore(agentException);
                }
            }
        }
        finally {
            if (bl) {
                set.clear();
            }
        }
    }
}

