/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Box;
import org.nlogo.agent.HorizCylinder;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Torus;
import org.nlogo.agent.VertCylinder;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;

strictfp abstract class Topology {
    World world;

    Topology(World world) {
        this.world = world;
    }

    abstract double wrapX(double var1) throws AgentException;

    abstract double wrapY(double var1) throws AgentException;

    abstract double distanceWrap(double var1, double var3, double var5, double var7, double var9, double var11);

    abstract double towardsWrap(double var1, double var3);

    abstract Patch getPatchAt(double var1, double var3) throws AgentException;

    abstract AgentSet getNeighbors(Patch var1);

    abstract AgentSet getNeighbors4(Patch var1);

    abstract Patch getPN(Patch var1);

    abstract Patch getPE(Patch var1);

    abstract Patch getPS(Patch var1);

    abstract Patch getPW(Patch var1);

    abstract Patch getPNE(Patch var1);

    abstract Patch getPSE(Patch var1);

    abstract Patch getPSW(Patch var1);

    abstract Patch getPNW(Patch var1);

    abstract double shortestPathX(double var1, double var3);

    abstract double shortestPathY(double var1, double var3);

    public static Topology getTopology(World world, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return new Torus(world);
            }
            return new VertCylinder(world);
        }
        if (bl2) {
            return new HorizCylinder(world);
        }
        return new Box(world);
    }

    static double wrap(double d, double d2, double d3) {
        if (d >= d3) {
            return d2 + (d - d3) % (d3 - d2);
        }
        if (d < d2) {
            double d4 = d3 - (d2 - d) % (d3 - d2);
            return d4 < d3 ? d4 : d2;
        }
        return d;
    }

    double followOffsetX() {
        return this.world.observer().followOffsetX();
    }

    double followOffsetY() {
        return this.world.observer().followOffsetY();
    }

    void diffuse(double d, int n) throws AgentException, PatchException {
        int n2 = this.world.minPxcor();
        int n3 = this.world.maxPxcor();
        int n4 = this.world.minPycor();
        int n5 = this.world.maxPycor();
        double[][] dArray = this.world.getPatchScratch();
        double[][] dArray2 = new double[n3 - n2 + 1][n5 - n4 + 1];
        int n6 = n2;
        int n7 = n4;
        try {
            for (n6 = n2; n6 <= n3; ++n6) {
                for (n7 = n4; n7 <= n5; ++n7) {
                    Patch patch = this.world.fastGetPatchAt(n6, n7);
                    double d2 = (Double)patch.getPatchVariable(n);
                    AgentSet agentSet = patch.getNeighbors();
                    int n8 = agentSet.count();
                    double d3 = 0.0;
                    for (int i = 0; i < n8; ++i) {
                        Patch patch2 = (Patch)agentSet.agent(i);
                        d3 += (Double)patch2.getPatchVariable(n) / (double)patch2.getNeighbors().count();
                    }
                    dArray[n6 - n2][n7 - n4] = d2;
                    dArray2[n6 - n2][n7 - n4] = d2 * (1.0 - d) + d3 * d;
                }
            }
            for (n6 = n2; n6 <= n3; ++n6) {
                for (n7 = n4; n7 <= n5; ++n7) {
                    double d4 = dArray2[n6 - n2][n7 - n4];
                    if (d4 == dArray[n6 - n2][n7 - n4]) continue;
                    this.world.fastGetPatchAt(n6, n7).setPatchVariable(n, d4);
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(this.world.fastGetPatchAt(n6, n7));
        }
    }

    void diffuse4(double d, int n) throws AgentException, PatchException {
        int n2 = this.world.minPxcor();
        int n3 = this.world.maxPxcor();
        int n4 = this.world.minPycor();
        int n5 = this.world.maxPycor();
        double[][] dArray = this.world.getPatchScratch();
        double[][] dArray2 = new double[n3 - n2 + 1][n5 - n4 + 1];
        int n6 = n2;
        int n7 = n4;
        try {
            for (n6 = n2; n6 <= n3; ++n6) {
                for (n7 = n4; n7 <= n5; ++n7) {
                    Patch patch = this.world.fastGetPatchAt(n6, n7);
                    double d2 = (Double)patch.getPatchVariable(n);
                    AgentSet agentSet = patch.getNeighbors4();
                    int n8 = agentSet.count();
                    double d3 = 0.0;
                    for (int i = 0; i < n8; ++i) {
                        d3 += ((Double)((Patch)agentSet.agent(i)).getPatchVariable(n)).doubleValue();
                    }
                    dArray[n6 - n2][n7 - n4] = d2;
                    dArray2[n6 - n2][n7 - n4] = d2 * (1.0 - d) + d3 * d / (double)n8;
                }
            }
            for (n6 = n2; n6 <= n3; ++n6) {
                for (n7 = n4; n7 <= n5; ++n7) {
                    double d4 = dArray2[n6 - n2][n7 - n4];
                    if (d4 == dArray[n6 - n2][n7 - n4]) continue;
                    this.world.fastGetPatchAt(n6, n7).setPatchVariable(n, d4);
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new PatchException(this.world.fastGetPatchAt(n6, n7));
        }
    }

    Patch getPatchNorth(Patch patch) {
        if (patch.pycor == this.world.maxPycor()) {
            return patch.fastGetPatchAt(patch.pxcor, this.world.minPycor());
        }
        return patch.fastGetPatchAt(patch.pxcor, patch.pycor + 1);
    }

    Patch getPatchSouth(Patch patch) {
        if (patch.pycor == this.world.minPycor()) {
            return patch.fastGetPatchAt(patch.pxcor, this.world.maxPycor());
        }
        return patch.fastGetPatchAt(patch.pxcor, patch.pycor - 1);
    }

    Patch getPatchEast(Patch patch) {
        if (patch.pxcor == this.world.maxPxcor()) {
            return patch.fastGetPatchAt(this.world.minPxcor(), patch.pycor);
        }
        return patch.fastGetPatchAt(patch.pxcor + 1, patch.pycor);
    }

    Patch getPatchWest(Patch patch) {
        if (patch.pxcor == this.world.minPxcor()) {
            return patch.fastGetPatchAt(this.world.maxPxcor(), patch.pycor);
        }
        return patch.fastGetPatchAt(patch.pxcor - 1, patch.pycor);
    }

    Patch getPatchNorthWest(Patch patch) {
        if (patch.pycor == this.world.maxPycor()) {
            if (patch.pxcor == this.world.minPxcor()) {
                return patch.fastGetPatchAt(this.world.maxPxcor(), this.world.minPycor());
            }
            return patch.fastGetPatchAt(patch.pxcor - 1, this.world.minPycor());
        }
        if (patch.pxcor == this.world.minPxcor()) {
            return patch.fastGetPatchAt(this.world.maxPxcor(), patch.pycor + 1);
        }
        return patch.fastGetPatchAt(patch.pxcor - 1, patch.pycor + 1);
    }

    Patch getPatchSouthWest(Patch patch) {
        if (patch.pycor == this.world.minPycor()) {
            if (patch.pxcor == this.world.minPxcor()) {
                return patch.fastGetPatchAt(this.world.maxPxcor(), this.world.maxPycor());
            }
            return patch.fastGetPatchAt(patch.pxcor - 1, this.world.maxPycor());
        }
        if (patch.pxcor == this.world.minPxcor()) {
            return patch.fastGetPatchAt(this.world.maxPxcor(), patch.pycor - 1);
        }
        return patch.fastGetPatchAt(patch.pxcor - 1, patch.pycor - 1);
    }

    Patch getPatchSouthEast(Patch patch) {
        if (patch.pycor == this.world.minPycor()) {
            if (patch.pxcor == this.world.maxPxcor()) {
                return patch.fastGetPatchAt(this.world.minPxcor(), this.world.maxPycor());
            }
            return patch.fastGetPatchAt(patch.pxcor + 1, this.world.maxPycor());
        }
        if (patch.pxcor == this.world.maxPxcor()) {
            return patch.fastGetPatchAt(this.world.minPxcor(), patch.pycor - 1);
        }
        return patch.fastGetPatchAt(patch.pxcor + 1, patch.pycor - 1);
    }

    Patch getPatchNorthEast(Patch patch) {
        if (patch.pycor == this.world.maxPycor()) {
            if (patch.pxcor == this.world.maxPxcor()) {
                return patch.fastGetPatchAt(this.world.minPxcor(), this.world.minPycor());
            }
            return patch.fastGetPatchAt(patch.pxcor + 1, this.world.minPycor());
        }
        if (patch.pxcor == this.world.maxPxcor()) {
            return patch.fastGetPatchAt(this.world.minPxcor(), patch.pycor + 1);
        }
        return patch.fastGetPatchAt(patch.pxcor + 1, patch.pycor + 1);
    }
}

