/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.Iterator;
import java.util.Set;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.TrigTables;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.api.I18N;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoList;
import org.nlogo.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class Turtle
extends Agent
implements org.nlogo.api.Turtle {
    public static final int VAR_WHO = 0;
    static final int VAR_BREED = 8;
    public int LAST_PREDEFINED_VAR = 12;
    public int NUMBER_PREDEFINED_VARS = this.LAST_PREDEFINED_VAR + 1;
    public static final String PEN_UP = "up";
    public static final String PEN_DOWN = "down";
    public static final String PEN_ERASE = "erase";
    Patch currentPatch = null;
    double heading = 0.0;
    double cachedHeading = 0.0;
    double cachedSine = 0.0;
    double cachedCosine = 1.0;
    double xcor;
    double ycor;

    void id(long l) {
        this.id = l;
        this.variables[0] = (double)l;
    }

    void initvars(Double d, Double d2, AgentSet agentSet) {
        this.variables[1] = Color.BoxedBlack();
        this.heading = 0.0;
        this.variables[2] = World.ZERO;
        this.xcor = d;
        this.variables[3] = d;
        this.ycor = d2;
        this.variables[4] = d2;
        this.variables[5] = this.world.turtleBreedShapes.breedShape(agentSet);
        this.variables[6] = "";
        this.variables[7] = Color.BoxedWhite();
        this.variables[8] = agentSet;
        this.variables[9] = Boolean.FALSE;
        this.variables[10] = World.ONE;
        this.variables[11] = World.ONE;
        this.variables[12] = PEN_UP;
    }

    public Turtle(World world, AgentSet agentSet, Double d, Double d2) {
        this(world, agentSet, d, d2, true);
    }

    private Turtle(World world, AgentSet agentSet, Double d, Double d2, boolean bl) {
        super(world);
        this.variables = new Object[world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)agentSet)];
        if (bl) {
            this.id(world.newTurtleId());
            world.turtles().add(this);
        }
        this.initvars(d, d2, agentSet);
        for (int i = this.LAST_PREDEFINED_VAR + 1; i < this.variables.length; ++i) {
            this.variables[i] = World.ZERO;
        }
        if (agentSet != world.turtles()) {
            agentSet.add(this);
        }
        this.getPatchHere().addTurtle(this);
    }

    Turtle(World world, long l) {
        this(world, world.turtles(), World.ZERO, World.ZERO, false);
        this.id(l);
        world.turtles().add(this);
    }

    Turtle(World world) {
        super(world);
    }

    public Turtle hatch() {
        Turtle turtle2 = new Turtle(this.world);
        turtle2.heading = this.heading;
        turtle2.xcor = this.xcor;
        turtle2.ycor = this.ycor;
        turtle2.variables = (Object[])this.variables.clone();
        turtle2.id(this.world.newTurtleId());
        this.world.turtles().add(turtle2);
        if (this.getBreed() != this.world.turtles()) {
            this.getBreed().add(turtle2);
        }
        turtle2.getPatchHere().addTurtle(turtle2);
        return turtle2;
    }

    public void die() {
        if (this.id == -1L) {
            return;
        }
        this.world.linkManager.cleanup(this);
        Patch patch = this.getPatchHere();
        patch.removeTurtle(this);
        AgentSet agentSet = this.getBreed();
        if (agentSet != this.world.turtles()) {
            agentSet.remove(this.agentKey());
        }
        this.world.removeLineThickness(this);
        this.world.turtles().remove(this.agentKey());
        this.id(-1L);
        Observer observer = this.world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
    }

    @Override
    public double lineThickness() {
        if (this.world != null) {
            return this.world.lineThickness(this);
        }
        return 0.0;
    }

    @Override
    public Patch getPatchAtOffsets(double d, double d2) throws AgentException {
        Patch patch = this.world.getTopology().getPatchAt(this.xcor + d, this.ycor + d2);
        if (patch == null) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.patchBeyondLimits"));
        }
        return patch;
    }

    @Override
    Agent realloc(boolean bl) {
        return this.realloc(bl, null);
    }

    Agent realloc(boolean bl, AgentSet agentSet) {
        int n;
        String string;
        int n2;
        if (bl && this.getBreed() != this.world.turtles() && this.world.getBreed(this.getBreed().printName()) == null) {
            return this;
        }
        Object[] objectArray = this.variables;
        this.variables = new Object[this.world.getVariablesArraySize(this, (org.nlogo.api.AgentSet)this.getBreed())];
        int n3 = this.world.getVariablesArraySize((org.nlogo.api.Turtle)null, (org.nlogo.api.AgentSet)this.world.turtles());
        int n4 = bl ? this.NUMBER_PREDEFINED_VARS : n3;
        System.arraycopy(objectArray, 0, this.variables, 0, n4);
        if (bl) {
            for (n2 = this.NUMBER_PREDEFINED_VARS; n2 < n3; ++n2) {
                string = this.world.turtlesOwnNameAt(n2);
                n = this.world.oldTurtlesOwnIndexOf(string);
                if (n == -1) {
                    this.variables[n2] = World.ZERO;
                    continue;
                }
                this.variables[n2] = objectArray[n];
                objectArray[n] = null;
            }
        }
        for (n2 = n3; n2 < this.variables.length; ++n2) {
            string = this.world.breedsOwnNameAt(this.getBreed(), n2);
            int n5 = n = bl ? this.world.oldBreedsOwnIndexOf(this.getBreed(), string) : this.world.breedsOwnIndexOf(agentSet, string);
            if (n == -1) {
                this.variables[n2] = World.ZERO;
                continue;
            }
            this.variables[n2] = objectArray[n];
            objectArray[n] = null;
        }
        return null;
    }

    @Override
    public void jump(double d) throws AgentException {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int n = (int)this.heading;
            if (this.heading == (double)n) {
                this.cachedCosine = TrigTables.cos()[n];
                this.cachedSine = TrigTables.sin()[n];
            } else {
                double d2 = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(d2);
                this.cachedSine = StrictMath.sin(d2);
            }
        }
        this.xandycor(this.xcor + d * this.cachedSine, this.ycor + d * this.cachedCosine);
    }

    public Patch getPatchAtHeadingAndDistance(double d, double d2) throws AgentException {
        double d3 = this.heading + d;
        if (d3 < 0.0 || d3 >= 360.0) {
            d3 = (d3 % 360.0 + 360.0) % 360.0;
        }
        return this.world.protractor().getPatchAtHeadingAndDistance(this, d3, d2);
    }

    @Override
    public Patch getPatchHere() {
        if (this.currentPatch == null) {
            this.currentPatch = this.world.getPatchAtWrap(this.xcor, this.ycor);
        }
        return this.currentPatch;
    }

    private void mustOwn(String string) throws AgentException {
        if (string != null && !this.world.breedOwns(this.getBreed(), string)) {
            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.breedDoesNotOwnVariable", this.getBreed().printName(), string));
        }
    }

    @Override
    public Object getVariable(int n) {
        return this.getTurtleVariable(n);
    }

    @Override
    public void setVariable(int n, Object object) throws AgentException {
        this.setTurtleVariable(n, object);
    }

    @Override
    public Object getObserverVariable(int n) {
        return this.world.observer().getObserverVariable(n);
    }

    @Override
    public Object getTurtleOrLinkVariable(String string) {
        return this.getTurtleVariable(this.world.program().turtlesOwn().indexOf(string));
    }

    @Override
    public Object getTurtleVariable(int n) {
        if (n == 0) {
            if (this.variables[0] == null) {
                this.variables[0] = (double)this.id;
            }
        } else if (n == 2) {
            if (this.variables[2] == null) {
                this.variables[2] = this.heading;
            }
        } else if (n == 3) {
            if (this.variables[3] == null) {
                this.variables[3] = this.xcor;
            }
        } else if (n == 4 && this.variables[4] == null) {
            this.variables[4] = this.ycor;
        }
        return this.variables[n];
    }

    public double getTurtleVariableDouble(int n) {
        switch (n) {
            case 0: {
                return this.id;
            }
            case 2: {
                return this.heading;
            }
            case 3: {
                return this.xcor;
            }
            case 4: {
                return this.ycor;
            }
            case 10: {
                return this.size();
            }
            case 11: {
                return this.penSize();
            }
        }
        throw new IllegalArgumentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.notADoubleVariable", n));
    }

    @Override
    public Object getLinkBreedVariable(String string) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantAccessLinkWithoutSpecifyingLink"));
    }

    @Override
    public Object getBreedVariable(String string) throws AgentException {
        this.mustOwn(string);
        int n = this.world.breedsOwnIndexOf(this.getBreed(), string);
        return this.getTurtleVariable(n);
    }

    @Override
    public Object getLinkVariable(int n) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantAccessLinkWithoutSpecifyingLink"));
    }

    @Override
    public Object getPatchVariable(int n) {
        return this.getPatchHere().getPatchVariable(n);
    }

    @Override
    public void setObserverVariable(int n, Object object) throws AgentException, LogoException {
        this.world.observer().setObserverVariable(n, object);
    }

    @Override
    public void setTurtleOrLinkVariable(String string, Object object) throws AgentException {
        this.setTurtleVariable(this.world.program().turtlesOwn().indexOf(string), object);
    }

    @Override
    public void setTurtleVariable(int n, Object object) throws AgentException {
        if (n > this.LAST_PREDEFINED_VAR) {
            this.variables[n] = object;
        } else {
            switch (n) {
                case 1: {
                    if (object instanceof Double) {
                        this.colorDouble((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.color((LogoList)object, 1);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 2: {
                    if (object instanceof Double) {
                        this.heading((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 3: {
                    if (object instanceof Double) {
                        this.xcor((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 4: {
                    if (object instanceof Double) {
                        this.ycor((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 5: {
                    if (object instanceof String) {
                        String string = this.world.checkTurtleShapeName((String)object);
                        if (string == null) {
                            throw new AgentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.shapeUndefined", object));
                        }
                        this.shape(string);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], String.class, object);
                    break;
                }
                case 6: {
                    this.label(object);
                    break;
                }
                case 7: {
                    if (object instanceof Double) {
                        this.labelColor((Double)object);
                        break;
                    }
                    if (object instanceof LogoList) {
                        this.labelColor((LogoList)object, 7);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 8: {
                    if (object instanceof AgentSet) {
                        AgentSet agentSet = (AgentSet)object;
                        if (agentSet != this.world.turtles() && !this.world.isBreed(agentSet)) {
                            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantSetBreedToNonBreedAgentSet"));
                        }
                        this.setBreed(agentSet);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], AgentSet.class, object);
                    break;
                }
                case 9: {
                    if (object instanceof Boolean) {
                        this.hidden((Boolean)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Boolean.class, object);
                    break;
                }
                case 10: {
                    if (object instanceof Double) {
                        this.size((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 12: {
                    if (object instanceof String) {
                        this.penMode((String)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], String.class, object);
                    break;
                }
                case 11: {
                    if (object instanceof Double) {
                        this.penSize((Double)object);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitTurtleVariables(false)[n], Double.class, object);
                    break;
                }
                case 0: {
                    throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.cantChangeWho"));
                }
                default: {
                    throw new IllegalStateException(I18N.errorsJ().getN("org.nlogo.agent.Agent.cantSetUnknownVariable", n));
                }
            }
        }
    }

    @Override
    public void setBreedVariable(String string, Object object) throws AgentException {
        this.mustOwn(string);
        int n = this.world.breedsOwnIndexOf(this.getBreed(), string);
        this.setTurtleVariable(n, object);
    }

    @Override
    public void setPatchVariable(int n, Object object) throws AgentException {
        this.getPatchHere().setPatchVariable(n, object);
    }

    @Override
    public void setLinkVariable(int n, Object object) throws AgentException {
        throw new AgentException("a turtle can't set a link variable without specifying which link");
    }

    @Override
    public void setLinkBreedVariable(String string, Object object) throws AgentException {
        throw new AgentException("a turtle can't set a link variable without specifying which link");
    }

    @Override
    public Object color() {
        return this.variables[1];
    }

    public void colorDouble(Double d) {
        double d2 = d;
        if (d2 < 0.0 || d2 >= (double)Color.MaxColor()) {
            d2 = Color.modulateDouble(d2);
            d = d2;
        }
        this.variables[1] = d;
    }

    public void colorDoubleUnchecked(Double d) {
        this.variables[1] = d;
    }

    public void color(LogoList logoList, int n) throws AgentException {
        this.validRGBList(logoList, true);
        this.variables[n] = logoList;
        if (logoList.size() > 3) {
            this.world.mayHavePartiallyTransparentObjects = true;
        }
    }

    public void turnRight(double d) {
        this.heading(this.heading + d);
    }

    @Override
    public double heading() {
        return this.heading;
    }

    @Override
    public void heading(double d) {
        double d2 = this.heading;
        this.headingHelper(d);
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleTurned(this, d, d2);
        }
    }

    public void heading(double d, Set<Turtle> set) {
        double d2 = this.heading;
        this.headingHelper(d);
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleTurned(this, d, d2, set);
        }
    }

    private void headingHelper(double d) {
        if (d < 0.0 || d >= 360.0) {
            d = (d % 360.0 + 360.0) % 360.0;
        }
        this.heading = d;
        this.variables[2] = null;
        Observer observer = this.world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
    }

    public void heading(Double d) {
        double d2 = this.heading;
        double d3 = d;
        double d4 = d3 < 0.0 || d3 >= 360.0 ? (d3 % 360.0 + 360.0) % 360.0 : d3;
        this.heading = d4;
        this.variables[2] = d3 == d4 ? d : null;
        Observer observer = this.world.observer();
        if (this == observer.targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleTurned(this, d3, d2);
        }
    }

    void drawLine(double d, double d2, double d3, double d4) {
        if (!(this.penMode().equals(PEN_UP) || d == d3 && d2 == d4)) {
            this.world.drawLine(d, d2, d3, d4, this.variables[1], this.penSize(), this.penMode());
        }
    }

    public void moveTo(Agent agent) throws AgentException {
        double d;
        double d2;
        if (agent instanceof Turtle) {
            Turtle turtle2 = (Turtle)agent;
            d2 = turtle2.xcor();
            d = turtle2.ycor();
        } else if (agent instanceof Patch) {
            Patch patch = (Patch)agent;
            d2 = patch.pxcor;
            d = patch.pycor;
        } else {
            throw new AgentException("you can't move-to a link");
        }
        this.xandycor(this.shortestPathX(d2), this.shortestPathY(d));
    }

    public double shortestPathY(double d) throws AgentException {
        if (!this.penMode().equals(PEN_DOWN)) {
            return d;
        }
        double d2 = (d = this.world.wrapY(d)) > this.ycor ? d - (double)this.world.worldHeight() : d + (double)this.world.worldHeight();
        if (!this.world.wrappingAllowedInY()) {
            d2 = d;
        }
        if (StrictMath.abs(d - this.ycor) > StrictMath.abs(d2 - this.ycor)) {
            d = d2;
        }
        return d;
    }

    public double shortestPathX(double d) throws AgentException {
        if (!this.penMode().equals(PEN_DOWN)) {
            return d;
        }
        double d2 = (d = this.world.wrapX(d)) > this.xcor ? d - (double)this.world.worldWidth() : d + (double)this.world.worldWidth();
        if (!this.world.wrappingAllowedInX()) {
            d2 = d;
        }
        if (StrictMath.abs(d - this.xcor) > StrictMath.abs(d2 - this.xcor)) {
            d = d2;
        }
        return d;
    }

    @Override
    public double xcor() {
        return this.xcor;
    }

    public void xcor(Double d) throws AgentException {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d2 = d;
        double d3 = this.xcor;
        double d4 = this.world.wrapX(d2);
        this.drawLine(this.xcor, this.ycor, this.shortestPathX(d2), this.ycor);
        this.xcor = d4;
        this.variables[3] = d2 == d4 ? d : null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, d2, this.ycor, d3, this.ycor);
        }
    }

    @Override
    public double ycor() {
        return this.ycor;
    }

    public void ycor(Double d) throws AgentException {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d2 = d;
        double d3 = this.ycor;
        double d4 = this.world.wrapY(d2);
        this.drawLine(this.xcor, this.ycor, this.xcor, this.shortestPathY(d2));
        this.ycor = d4;
        this.variables[4] = d2 == d4 ? d : null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, this.xcor, d2, this.xcor, d3);
        }
    }

    public void xandycor(double d, double d2) throws AgentException {
        double d3 = this.xcor;
        double d4 = this.ycor;
        this.xandycorHelper(d, d2);
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, d, d2, d3, d4);
        }
    }

    public void xandycor(double d, double d2, Set<Turtle> set) throws AgentException {
        double d3 = this.xcor;
        double d4 = this.ycor;
        this.xandycorHelper(d, d2);
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, d, d2, d3, d4, set);
        }
    }

    public void xandycorHelper(double d, double d2) throws AgentException {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d3 = this.world.wrapX(d);
        double d4 = this.world.wrapY(d2);
        this.drawLine(this.xcor, this.ycor, d, d2);
        this.xcor = d3;
        this.ycor = d4;
        this.variables[3] = null;
        this.variables[4] = null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
    }

    public void xandycor(Double d, Double d2) throws AgentException {
        Observer observer;
        Patch patch = this.getPatchHere();
        double d3 = d;
        double d4 = d2;
        double d5 = this.xcor;
        double d6 = this.ycor;
        double d7 = this.world.wrapX(d3);
        double d8 = this.world.wrapY(d4);
        this.drawLine(this.xcor, this.ycor, d3, d4);
        this.xcor = d7;
        this.ycor = d8;
        this.variables[3] = d3 == d7 ? d : null;
        this.variables[4] = d4 == d8 ? d2 : null;
        this.currentPatch = null;
        Patch patch2 = this.getPatchHere();
        if (patch != patch2) {
            patch.removeTurtle(this);
            patch2.addTurtle(this);
        }
        if (this == (observer = this.world.observer()).targetAgent()) {
            observer.updatePosition();
        }
        if (this.world.tieManager.tieCount > 0) {
            this.world.tieManager.turtleMoved(this, d3, d4, d5, d6);
        }
    }

    public void moveToPatchCenter() {
        Patch patch = this.getPatchHere();
        double d = patch.pxcor;
        double d2 = patch.pycor;
        double d3 = this.xcor;
        double d4 = this.ycor;
        this.drawLine(d3, d4, d, d2);
        if (d != d3 || d2 != d4) {
            this.xcor = d;
            this.ycor = d2;
            this.variables[3] = patch.variables[0];
            this.variables[4] = patch.variables[1];
            Observer observer = this.world.observer();
            if (this == observer.targetAgent()) {
                observer.updatePosition();
            }
            if (this.world.tieManager.tieCount > 0) {
                this.world.tieManager.turtleMoved(this, d, d2, d3, d4);
            }
        }
    }

    public void face(Agent agent, boolean bl) {
        try {
            this.heading(this.world.protractor().towards(this, agent, bl));
        }
        catch (AgentException agentException) {
            Exceptions.ignore(agentException);
        }
    }

    public void face(double d, double d2, boolean bl) {
        try {
            this.heading(this.world.protractor().towards(this, d, d2, bl));
        }
        catch (AgentException agentException) {
            Exceptions.ignore(agentException);
        }
    }

    public static double subtractHeadings(double d, double d2) {
        double d3;
        if (d < 0.0 || d >= 360.0) {
            d = (d % 360.0 + 360.0) % 360.0;
        }
        if (d2 < 0.0 || d2 >= 360.0) {
            d2 = (d2 % 360.0 + 360.0) % 360.0;
        }
        if ((d3 = d - d2) > -180.0 && d3 <= 180.0) {
            return d3;
        }
        if (d3 > 0.0) {
            return d3 - 360.0;
        }
        return d3 + 360.0;
    }

    public void home() {
        try {
            this.xandycor(World.ZERO, World.ZERO);
        }
        catch (AgentException agentException) {
            throw new IllegalStateException(agentException);
        }
    }

    public double dx() {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int n = (int)this.heading;
            if (this.heading == (double)n) {
                this.cachedCosine = TrigTables.cos()[n];
                this.cachedSine = TrigTables.sin()[n];
            } else {
                double d = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(d);
                this.cachedSine = StrictMath.sin(d);
            }
        }
        return this.cachedSine;
    }

    public double dy() {
        if (this.heading != this.cachedHeading) {
            this.cachedHeading = this.heading;
            int n = (int)this.heading;
            if (this.heading == (double)n) {
                this.cachedCosine = TrigTables.cos()[n];
                this.cachedSine = TrigTables.sin()[n];
            } else {
                double d = StrictMath.toRadians(this.heading);
                this.cachedCosine = StrictMath.cos(d);
                this.cachedSine = StrictMath.sin(d);
            }
        }
        return this.cachedCosine;
    }

    @Override
    public String shape() {
        return (String)this.variables[5];
    }

    public void shape(String string) {
        this.variables[5] = string;
    }

    public Object label() {
        return this.variables[6];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables[6]);
    }

    public void label(Object object) {
        this.variables[6] = object;
    }

    @Override
    public Object labelColor() {
        return this.variables[7];
    }

    public void labelColor(double d) {
        this.variables[7] = Color.modulateDouble(d);
    }

    public void labelColor(LogoList logoList, int n) throws AgentException {
        this.validRGBList(logoList, true);
        this.variables[n] = logoList;
    }

    @Override
    public AgentSet getBreed() {
        return (AgentSet)this.variables[8];
    }

    @Override
    public int getBreedIndex() {
        AgentSet agentSet = this.getBreed();
        if (agentSet == this.world.turtles()) {
            return 0;
        }
        int n = 0;
        Iterator<Object> iterator2 = this.world.program().breeds().values().iterator();
        while (iterator2.hasNext()) {
            if (agentSet == (AgentSet)iterator2.next()) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public void setBreed(AgentSet agentSet) {
        AgentSet agentSet2 = null;
        if (this.variables[8] instanceof AgentSet) {
            agentSet2 = (AgentSet)this.variables[8];
            if (agentSet == agentSet2) {
                return;
            }
            if (agentSet2 != this.world.turtles()) {
                ((AgentSet)this.variables[8]).remove(this.agentKey());
            }
        }
        if (agentSet != this.world.turtles()) {
            agentSet.add(this);
        }
        this.variables[8] = agentSet;
        this.shape(this.world.turtleBreedShapes.breedShape(agentSet));
        this.realloc(false, agentSet2);
    }

    @Override
    public boolean hidden() {
        return (Boolean)this.variables[9];
    }

    public void hidden(boolean bl) {
        this.variables[9] = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public double size() {
        return (Double)this.variables[10];
    }

    public void size(double d) {
        this.variables[10] = d;
    }

    public double penSize() {
        return (Double)this.variables[11];
    }

    public void penSize(double d) {
        this.variables[11] = d;
    }

    public String penMode() {
        return (String)this.variables[12];
    }

    public void penMode(String string) {
        this.variables[12] = string;
    }

    public String toString() {
        return this.world.getBreedSingular(this.getBreed()).toLowerCase() + " " + this.id;
    }

    @Override
    public String classDisplayName() {
        return this.world.getBreedSingular(this.getBreed()).toLowerCase();
    }

    public Class<Turtle> getAgentClass() {
        return Turtle.class;
    }

    @Override
    public int getAgentBit() {
        return 2;
    }

    @Override
    public int alpha() {
        return Color.getColor(this.color()).getAlpha();
    }
}

