/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.AllStoredValues;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.BreedShapes;
import org.nlogo.agent.Exporter;
import org.nlogo.agent.HorizCylinder;
import org.nlogo.agent.Importer;
import org.nlogo.agent.InRadiusOrCone;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Protractor;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.TickCounter;
import org.nlogo.agent.TieManager;
import org.nlogo.agent.Timer;
import org.nlogo.agent.Topology;
import org.nlogo.agent.Torus;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.VertCylinder;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.LogoException;
import org.nlogo.api.Program;
import org.nlogo.api.RandomSeedGenerator$;
import org.nlogo.api.ShapeList;
import org.nlogo.api.TrailDrawerInterface;
import org.nlogo.api.ValueConstraint;
import org.nlogo.api.WorldDimensions;
import org.nlogo.util.Exceptions;
import org.nlogo.util.MersenneTwisterFast;
import scala.collection.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class World
implements org.nlogo.api.World {
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    public final TickCounter tickCounter = new TickCounter();
    public final Timer timer = new Timer();
    private final ShapeList _turtleShapeList;
    private final ShapeList _linkShapeList;
    private double patchSize = 12.0;
    TrailDrawerInterface trailDrawer;
    private final Map<Agent, Double> lineThicknesses = new HashMap<Agent, Double>();
    Topology topology;
    RootsTable rootsTable;
    protected Protractor _protractor;
    public LinkManager linkManager;
    public TieManager tieManager;
    public InRadiusOrCone inRadiusOrCone;
    public volatile boolean comeUpForAir = false;
    private final AgentSet _noTurtles = new ArrayAgentSet(Turtle.class, 0, false, this);
    private final AgentSet _noPatches = new ArrayAgentSet(Patch.class, 0, false, this);
    private final AgentSet _noLinks = new ArrayAgentSet(Link.class, 0, false, this);
    public final MersenneTwisterFast mainRNG = new MersenneTwisterFast();
    public final MersenneTwisterFast auxRNG = new MersenneTwisterFast();
    Double _worldWidthBoxed;
    Double _worldHeightBoxed;
    Double _minPxcorBoxed;
    Double _minPycorBoxed;
    Double _maxPxcorBoxed;
    Double _maxPycorBoxed;
    int _worldWidth;
    int _worldHeight;
    int _minPxcor;
    int _minPycor;
    int _maxPxcor;
    int _maxPycor;
    final AgentSet _observers;
    final Observer _observer;
    AgentSet _patches = null;
    AgentSet _turtles = null;
    AgentSet _links = null;
    private long nextTurtleIndex = 0L;
    private long nextLinkIndex = 0L;
    int[] patchColors;
    boolean patchColorsDirty = true;
    boolean patchesAllBlack = true;
    boolean mayHavePartiallyTransparentObjects = false;
    int patchesWithLabels = 0;
    double[][] patchScratch;
    public final BreedShapes linkBreedShapes = new BreedShapes("LINKS");
    public final BreedShapes turtleBreedShapes = new BreedShapes("TURTLES");
    private Program _program = this.newProgram();
    List<String> oldTurtlesOwn = new ArrayList<String>();
    List<String> oldPatchesOwn = new ArrayList<String>();
    List<String> oldLinksOwn = new ArrayList<String>();
    List<String> oldGlobals = new ArrayList<String>();
    Map<String, Object> oldBreeds = new LinkedHashMap<String, Object>();
    Map<String, Object> oldLinkBreeds = new LinkedHashMap<String, Object>();
    Map<String, List<String>> oldBreedsOwn = new HashMap<String, List<String>>();
    Map<String, List<String>> oldLinkBreedsOwn = new HashMap<String, List<String>>();
    private boolean displayOn = true;
    private CompilerServices _compiler;

    @Override
    public double ticks() {
        return this.tickCounter.ticks();
    }

    @Override
    public ShapeList turtleShapeList() {
        return this._turtleShapeList;
    }

    @Override
    public ShapeList linkShapeList() {
        return this._linkShapeList;
    }

    @Override
    public Protractor protractor() {
        return this._protractor;
    }

    public World() {
        this._turtleShapeList = new ShapeList();
        this._linkShapeList = new ShapeList();
        this._observer = this.createObserver();
        this._observers = new ArrayAgentSet(Observer.class, 1, "observers", false, this);
        this.linkManager = new LinkManager(this);
        this.tieManager = new TieManager(this, this.linkManager);
        this.inRadiusOrCone = new InRadiusOrCone(this);
        this._protractor = new Protractor(this);
        this._observers.add(this._observer);
        this.changeTopology(true, true);
        this.createPatches(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor);
    }

    Observer createObserver() {
        return new Observer(this);
    }

    public AgentSet noTurtles() {
        return this._noTurtles;
    }

    public AgentSet noPatches() {
        return this._noPatches;
    }

    public AgentSet noLinks() {
        return this._noLinks;
    }

    public void trailDrawer(TrailDrawerInterface trailDrawerInterface) {
        this.trailDrawer = trailDrawerInterface;
    }

    Topology getTopology() {
        return this.topology;
    }

    public void changeTopology(boolean bl, boolean bl2) {
        this.topology = Topology.getTopology(this, bl, bl2);
        if (this._patches != null) {
            AgentSet.Iterator iterator2 = this._patches.iterator();
            while (iterator2.hasNext()) {
                ((Patch)iterator2.next()).topologyChanged();
            }
        }
    }

    @Override
    public double wrappedObserverX(double d) {
        try {
            d = this.topology.wrapX(d - this.topology.followOffsetX());
        }
        catch (AgentException agentException) {
            Exceptions.ignore(agentException);
        }
        return d;
    }

    @Override
    public double wrappedObserverY(double d) {
        try {
            d = this.topology.wrapY(d - this.topology.followOffsetY());
        }
        catch (AgentException agentException) {
            Exceptions.ignore(agentException);
        }
        return d;
    }

    @Override
    public double followOffsetX() {
        return this._observer.followOffsetX();
    }

    @Override
    public double followOffsetY() {
        return this._observer.followOffsetY();
    }

    @Override
    public boolean wrappingAllowedInX() {
        return this.topology instanceof Torus || this.topology instanceof VertCylinder;
    }

    @Override
    public boolean wrappingAllowedInY() {
        return this.topology instanceof Torus || this.topology instanceof HorizCylinder;
    }

    public void exportWorld(PrintWriter printWriter, boolean bl) {
        new Exporter(this, printWriter).exportWorld(bl);
    }

    public void importWorld(Importer.ErrorHandler errorHandler, ImporterUser importerUser, Importer.StringReader stringReader, BufferedReader bufferedReader) throws IOException {
        new Importer(errorHandler, this, importerUser, stringReader).importWorld(bufferedReader);
    }

    public double generateSeed() {
        return RandomSeedGenerator$.MODULE$.generateSeed();
    }

    public void setLineThickness(Agent agent, double d) {
        this.lineThicknesses.put(agent, d);
    }

    public double lineThickness(Agent agent) {
        Double d = this.lineThicknesses.get(agent);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public void removeLineThickness(Agent agent) {
        this.lineThicknesses.remove(agent);
    }

    void drawLine(double d, double d2, double d3, double d4, Object object, double d5, String string) {
        this.trailDrawer.drawLine(d, d2, d3, d4, object, d5, string);
    }

    public Double worldWidthBoxed() {
        return this._worldWidthBoxed;
    }

    public Double worldHeightBoxed() {
        return this._worldHeightBoxed;
    }

    public Double minPxcorBoxed() {
        return this._minPxcorBoxed;
    }

    public Double minPycorBoxed() {
        return this._minPycorBoxed;
    }

    public Double maxPxcorBoxed() {
        return this._maxPxcorBoxed;
    }

    public Double maxPycorBoxed() {
        return this._maxPycorBoxed;
    }

    @Override
    public int worldWidth() {
        return this._worldWidth;
    }

    @Override
    public int worldHeight() {
        return this._worldHeight;
    }

    @Override
    public int minPxcor() {
        return this._minPxcor;
    }

    @Override
    public int minPycor() {
        return this._minPycor;
    }

    @Override
    public int maxPxcor() {
        return this._maxPxcor;
    }

    @Override
    public int maxPycor() {
        return this._maxPycor;
    }

    @Override
    public double wrapX(double d) throws AgentException {
        return this.topology.wrapX(d);
    }

    @Override
    public double wrapY(double d) throws AgentException {
        return this.topology.wrapY(d);
    }

    @Override
    public double wrap(double d, double d2, double d3) {
        return Topology.wrap(d, d2, d3);
    }

    public void diffuse(double d, int n) throws AgentException, PatchException {
        this.topology.diffuse(d, n);
    }

    public void diffuse4(double d, int n) throws AgentException, PatchException {
        this.topology.diffuse4(d, n);
    }

    public int roundX(double d) throws AgentException {
        try {
            d = this.topology.wrapX(d);
        }
        catch (AgentException agentException) {
            throw new AgentException("Cannot access patches beyond the limits of current world.");
        }
        if (d > 0.0) {
            return (int)(d + 0.5);
        }
        int n = (int)d;
        double d2 = (double)n - d;
        return d2 > 0.5 ? n - 1 : n;
    }

    public int roundY(double d) throws AgentException {
        try {
            d = this.topology.wrapY(d);
        }
        catch (AgentException agentException) {
            throw new AgentException("Cannot access patches beyond the limits of current world.");
        }
        if (d > 0.0) {
            return (int)(d + 0.5);
        }
        int n = (int)d;
        double d2 = (double)n - d;
        return d2 > 0.5 ? n - 1 : n;
    }

    public Turtle createTurtle(AgentSet agentSet) {
        return new Turtle(this, agentSet, ZERO, ZERO);
    }

    public Turtle createTurtle(AgentSet agentSet, int n, int n2) {
        Turtle turtle2 = new Turtle(this, agentSet, ZERO, ZERO);
        turtle2.colorDoubleUnchecked(Double.valueOf(5 + 10 * n));
        turtle2.heading(n2);
        return turtle2;
    }

    public AgentSet observers() {
        return this._observers;
    }

    @Override
    public Observer observer() {
        return this._observer;
    }

    @Override
    public AgentSet patches() {
        return this._patches;
    }

    @Override
    public AgentSet turtles() {
        return this._turtles;
    }

    @Override
    public AgentSet links() {
        return this._links;
    }

    public AgentSet agentClassToAgentSet(Class<? extends Agent> clazz) {
        if (clazz == Turtle.class) {
            return this._turtles;
        }
        if (clazz == Patch.class) {
            return this._patches;
        }
        if (clazz == Observer.class) {
            return this._observers;
        }
        if (clazz == Link.class) {
            return this._links;
        }
        throw new IllegalArgumentException("agentClass = " + clazz);
    }

    public WorldDimensions getDimensions() {
        return new WorldDimensions(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor);
    }

    @Override
    public Patch getPatch(int n) {
        return (Patch)this._patches.toArray()[n];
    }

    @Override
    public Patch getPatchAt(double d, double d2) throws AgentException {
        int n = this.roundX(d);
        int n2 = this.roundY(d2);
        int n3 = this._worldWidth * (this._maxPycor - n2) + n - this._minPxcor;
        return (Patch)this._patches.toArray()[n3];
    }

    public Patch getPatchAtWrap(double d, double d2) {
        double d3;
        int n;
        int n2;
        d = Topology.wrap(d, (double)this._minPxcor - 0.5, (double)this._maxPxcor + 0.5);
        d2 = Topology.wrap(d2, (double)this._minPycor - 0.5, (double)this._maxPycor + 0.5);
        if (d > 0.0) {
            n2 = (int)(d + 0.5);
        } else {
            n = (int)d;
            d3 = (double)n - d;
            int n3 = n2 = d3 > 0.5 ? n - 1 : n;
        }
        int n4 = d2 > 0.0 ? (int)(d2 + 0.5) : ((d3 = (double)(n = (int)d2) - d2) > 0.5 ? n - 1 : n);
        int n5 = this._worldWidth * (this._maxPycor - n4) + n2 - this._minPxcor;
        return (Patch)this._patches.toArray()[n5];
    }

    public boolean validPatchCoordinates(int n, int n2) {
        return n >= this._minPxcor && n <= this._maxPxcor && n2 >= this._minPycor && n2 <= this._maxPycor;
    }

    @Override
    public Patch fastGetPatchAt(int n, int n2) {
        return (Patch)this._patches.toArray()[this._worldWidth * (this._maxPycor - n2) + n - this._minPxcor];
    }

    public Turtle getTurtle(long l) {
        return (Turtle)this._turtles.getAgent(l);
    }

    public Link getLink(Object object, Object object2, AgentSet agentSet) {
        return this.linkManager.findLink((Turtle)this._turtles.getAgent(object), (Turtle)this._turtles.getAgent(object2), agentSet, false);
    }

    void nextTurtleIndex(long l) {
        this.nextTurtleIndex = l;
    }

    long nextTurtleIndex() {
        return this.nextTurtleIndex;
    }

    long newTurtleId() {
        return this.nextTurtleIndex++;
    }

    long newLinkId() {
        return this.nextLinkIndex++;
    }

    public Turtle getOrCreateTurtle(long l) {
        Turtle turtle2 = this.getTurtle(l);
        if (turtle2 == null) {
            turtle2 = new Turtle(this, l);
            this.nextTurtleIndex = StrictMath.max(this.nextTurtleIndex, l + 1L);
        }
        return turtle2;
    }

    public Link getOrCreateLink(Double d, Double d2, AgentSet agentSet) {
        return this.getOrCreateLink(this.getOrCreateTurtle(d.longValue()), this.getOrCreateTurtle(d2.longValue()), agentSet);
    }

    public Link getOrCreateLink(Turtle turtle2, Turtle turtle3, AgentSet agentSet) {
        Link link = this.getLink(turtle2.agentKey(), turtle3.agentKey(), agentSet);
        if (link == null) {
            link = this.linkManager.createLink(turtle2, turtle3, agentSet);
        }
        return link;
    }

    @Override
    public boolean patchColorsDirty() {
        return this.patchColorsDirty;
    }

    @Override
    public void markPatchColorsDirty() {
        this.patchColorsDirty = true;
    }

    @Override
    public void markPatchColorsClean() {
        this.patchColorsDirty = false;
    }

    @Override
    public boolean patchesAllBlack() {
        return this.patchesAllBlack;
    }

    @Override
    public boolean mayHavePartiallyTransparentObjects() {
        return this.mayHavePartiallyTransparentObjects;
    }

    @Override
    public int[] patchColors() {
        return this.patchColors;
    }

    @Override
    public int patchesWithLabels() {
        return this.patchesWithLabels;
    }

    public void createPatches(int n, int n2, int n3, int n4) {
        java.util.Iterator<Object> iterator2;
        this.patchScratch = null;
        this._minPxcor = n;
        this._maxPxcor = n2;
        this._minPycor = n3;
        this._maxPycor = n4;
        this._worldWidth = n2 - n + 1;
        this._worldHeight = n4 - n3 + 1;
        this.rootsTable = new RootsTable(this._worldWidth, this._worldHeight);
        this._worldWidthBoxed = this._worldWidth;
        this._worldHeightBoxed = this._worldHeight;
        this._minPxcorBoxed = this._minPxcor;
        this._minPycorBoxed = this._minPycor;
        this._maxPxcorBoxed = this._maxPxcor;
        this._maxPycorBoxed = this._maxPycor;
        if (this._program.breeds() != null) {
            iterator2 = this._program.breeds().values().iterator();
            while (iterator2.hasNext()) {
                ((AgentSet)iterator2.next()).clear();
            }
        }
        if (this._program.linkBreeds() != null) {
            iterator2 = this._program.linkBreeds().values().iterator();
            while (iterator2.hasNext()) {
                ((AgentSet)iterator2.next()).clear();
            }
        }
        if (this._turtles != null) {
            this._turtles.clear();
        }
        this._turtles = new TreeAgentSet(Turtle.class, "TURTLES", this);
        if (this._links != null) {
            this._links.clear();
        }
        this._links = new TreeAgentSet(Link.class, "LINKS", this);
        int n5 = n;
        int n6 = n4;
        Agent[] agentArray = new Agent[this._worldWidth * this._worldHeight];
        this.patchColors = new int[this._worldWidth * this._worldHeight];
        Arrays.fill(this.patchColors, Color.getARGBbyPremodulatedColorNumber(0.0));
        this.patchColorsDirty = true;
        int n7 = this._program.patchesOwn().size();
        this._observer.resetPerspective();
        for (int i = 0; this._worldWidth * this._worldHeight != i; ++i) {
            Patch patch = new Patch(this, i, n5, n6, n7);
            if (++n5 == n2 + 1) {
                n5 = n;
                --n6;
            }
            agentArray[i] = patch;
        }
        this._patches = new ArrayAgentSet(Patch.class, agentArray, "patches", this);
        this.patchesWithLabels = 0;
        this.patchesAllBlack = true;
        this.mayHavePartiallyTransparentObjects = false;
    }

    public void clearAll() {
        this.tickCounter.clear();
        this.clearTurtles();
        this.clearPatches();
        this.clearGlobals();
        this.clearLinks();
        this._observer.resetPerspective();
        this.mayHavePartiallyTransparentObjects = false;
    }

    public void clearDrawing() {
    }

    public void stamp(Agent agent, boolean bl) {
        this.trailDrawer.stamp(agent, bl);
    }

    @Override
    public double patchSize() {
        return this.patchSize;
    }

    public boolean patchSize(double d) {
        if (this.patchSize != d) {
            this.patchSize = d;
            return true;
        }
        return false;
    }

    @Override
    public Object getDrawing() {
        return this.trailDrawer.getDrawing();
    }

    @Override
    public boolean sendPixels() {
        return this.trailDrawer.sendPixels();
    }

    @Override
    public void markDrawingClean() {
        this.trailDrawer.sendPixels(false);
    }

    public void clearPatches() {
        AgentSet.Iterator iterator2 = this._patches.iterator();
        while (iterator2.hasNext()) {
            Patch patch = (Patch)iterator2.next();
            patch.pcolorDoubleUnchecked(Color.BoxedBlack());
            patch.label("");
            patch.labelColor(Color.BoxedWhite());
            try {
                for (int i = patch.NUMBER_PREDEFINED_VARS; i < patch.variables.length; ++i) {
                    patch.setPatchVariable(i, ZERO);
                }
            }
            catch (AgentException agentException) {
                throw new IllegalStateException(agentException);
            }
        }
        this.patchesAllBlack = true;
    }

    public void clearTurtles() {
        Object object;
        if (this._program.breeds() != null) {
            object = this._program.breeds().values().iterator();
            while (object.hasNext()) {
                ((AgentSet)object.next()).clear();
            }
        }
        object = this._turtles.iterator();
        while (object.hasNext()) {
            Turtle turtle2 = (Turtle)object.next();
            this.lineThicknesses.remove(turtle2);
            this.linkManager.cleanup(turtle2);
            turtle2.id(-1L);
        }
        this._turtles.clear();
        object = this._patches.iterator();
        while (object.hasNext()) {
            ((Patch)object.next()).clearTurtles();
        }
        this.nextTurtleIndex = 0L;
        this._observer.updatePosition();
    }

    public void clearLinks() {
        if (this._program.linkBreeds() != null) {
            for (Object object : this._program.linkBreeds().values()) {
                ((AgentSet)object).clear();
            }
        }
        AgentSet.Iterator iterator2 = this._links.iterator();
        while (iterator2.hasNext()) {
            Object object;
            object = (Link)iterator2.next();
            ((Link)object).id = -1L;
        }
        this._links.clear();
        this.nextLinkIndex = 0L;
        this.linkManager.reset();
    }

    public void clearGlobals() {
        for (int i = this._program.interfaceGlobals().size(); i < this._observer.variables.length; ++i) {
            try {
                ValueConstraint valueConstraint = this._observer.variableConstraint(i);
                if (valueConstraint != null) {
                    this._observer.setObserverVariable(i, valueConstraint.defaultValue());
                    continue;
                }
                this._observer.setObserverVariable(i, ZERO);
                continue;
            }
            catch (AgentException agentException) {
                throw new IllegalStateException(agentException);
            }
            catch (LogoException logoException) {
                throw new IllegalStateException(logoException);
            }
        }
    }

    public void realloc() {
        for (String object2 : this._program.breeds().keySet()) {
            AgentSet agentSet = (AgentSet)this.oldBreeds.get(object2);
            if (agentSet == null) {
                this._program.breeds().put(object2, new TreeAgentSet(Turtle.class, object2.toUpperCase(), this));
                continue;
            }
            this._program.breeds().put(object2, agentSet);
        }
        for (String agentException : this._program.linkBreeds().keySet()) {
            boolean bl = this._program.linkBreeds().get(agentException).equals("DIRECTED-LINK-BREED");
            AgentSet agentSet = (AgentSet)this.oldLinkBreeds.get(agentException);
            if (agentSet == null) {
                agentSet = new TreeAgentSet(Link.class, agentException.toUpperCase(), this);
            } else {
                agentSet.clearDirected();
            }
            this._program.linkBreeds().put(agentException, agentSet);
            agentSet.setDirected(bl);
        }
        ArrayList arrayList = new ArrayList();
        try {
            if (this._turtles != null) {
                AgentSet.Iterator agentException = this._turtles.iterator();
                while (agentException.hasNext()) {
                    Agent agent = agentException.next().realloc(true);
                    if (agent == null) continue;
                    arrayList.add(agent);
                }
                java.util.Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    ((Turtle)iterator2.next()).die();
                }
                arrayList.clear();
            }
        }
        catch (AgentException agentException) {
            throw new IllegalStateException(agentException);
        }
        try {
            if (this._links != null) {
                AgentSet.Iterator iterator3 = this._links.iterator();
                while (iterator3.hasNext()) {
                    Agent agent = iterator3.next().realloc(true);
                    if (agent == null) continue;
                    arrayList.add(agent);
                }
                java.util.Iterator iterator4 = arrayList.iterator();
                while (iterator4.hasNext()) {
                    ((Link)iterator4.next()).die();
                }
                arrayList.clear();
            }
        }
        catch (AgentException agentException) {
            throw new IllegalStateException(agentException);
        }
        try {
            if (this._patches != null && !((Object)this._program.patchesOwn()).equals(this.oldPatchesOwn)) {
                AgentSet.Iterator iterator5 = this._patches.iterator();
                while (iterator5.hasNext()) {
                    iterator5.next().realloc(true);
                }
            }
        }
        catch (AgentException agentException) {
            throw new IllegalStateException(agentException);
        }
        this._observer.realloc(true);
        this.turtleBreedShapes.setUpBreedShapes(false, this._program.breeds());
        this.linkBreedShapes.setUpBreedShapes(false, this._program.linkBreeds());
    }

    public double[][] getPatchScratch() {
        if (this.patchScratch == null) {
            this.patchScratch = new double[this._worldWidth][this._worldHeight];
        }
        return this.patchScratch;
    }

    @Override
    public String turtlesOwnNameAt(int n) {
        return this._program.turtlesOwn().get(n);
    }

    public int turtlesOwnIndexOf(String string) {
        return this._program.turtlesOwn().indexOf(string);
    }

    public int linksOwnIndexOf(String string) {
        return this._program.linksOwn().indexOf(string);
    }

    @Override
    public String linksOwnNameAt(int n) {
        return this._program.linksOwn().get(n);
    }

    int oldTurtlesOwnIndexOf(String string) {
        return this.oldTurtlesOwn.indexOf(string);
    }

    int oldLinksOwnIndexOf(String string) {
        return this.oldLinksOwn.indexOf(string);
    }

    @Override
    public String breedsOwnNameAt(org.nlogo.api.AgentSet agentSet, int n) {
        List<String> list = this._program.breedsOwn().get(agentSet.printName());
        return list.get(n - this._program.turtlesOwn().size());
    }

    public int breedsOwnIndexOf(AgentSet agentSet, String string) {
        List<String> list = this._program.breedsOwn().get(agentSet.printName());
        if (list == null) {
            return -1;
        }
        int n = list.indexOf(string);
        if (n == -1) {
            return -1;
        }
        return agentSet.type() == Turtle.class ? this._program.turtlesOwn().size() + n : this._program.linksOwn().size() + n;
    }

    public String linkBreedsOwnNameAt(AgentSet agentSet, int n) {
        List<String> list = this._program.linkBreedsOwn().get(agentSet.printName());
        return list.get(n - this._program.linksOwn().size());
    }

    public int linkBreedsOwnIndexOf(AgentSet agentSet, String string) {
        List<String> list = this._program.linkBreedsOwn().get(agentSet.printName());
        if (list == null) {
            return -1;
        }
        int n = list.indexOf(string);
        if (n == -1) {
            return -1;
        }
        return this._program.linksOwn().size() + n;
    }

    int oldBreedsOwnIndexOf(AgentSet agentSet, String string) {
        List<String> list = this.oldBreedsOwn.get(agentSet.printName());
        if (list == null) {
            return -1;
        }
        int n = list.indexOf(string);
        if (n == -1) {
            return -1;
        }
        return this.oldTurtlesOwn.size() + n;
    }

    int oldLinkBreedsOwnIndexOf(AgentSet agentSet, String string) {
        List<String> list = this.oldLinkBreedsOwn.get(agentSet.printName());
        if (list == null) {
            return -1;
        }
        int n = list.indexOf(string);
        if (n == -1) {
            return -1;
        }
        return this.oldLinksOwn.size() + n;
    }

    public String patchesOwnNameAt(int n) {
        return this._program.patchesOwn().get(n);
    }

    public int patchesOwnIndexOf(String string) {
        return this._program.patchesOwn().indexOf(string);
    }

    public String observerOwnsNameAt(int n) {
        return this._program.globals().get(n);
    }

    public int observerOwnsIndexOf(String string) {
        return this._program.globals().indexOf(string);
    }

    public boolean isBreed(AgentSet agentSet) {
        return this._program.breeds().containsValue(agentSet);
    }

    public boolean isLinkBreed(AgentSet agentSet) {
        return this._program.linkBreeds().containsValue(agentSet);
    }

    public AgentSet getBreed(String string) {
        return (AgentSet)this._program.breeds().get(string);
    }

    public AgentSet getLinkBreed(String string) {
        return (AgentSet)this._program.linkBreeds().get(string);
    }

    public String getBreedSingular(AgentSet agentSet) {
        if (agentSet == this._turtles) {
            return "TURTLE";
        }
        String string = agentSet.printName();
        for (Map.Entry<String, String> entry : this._program.breedsSingular().entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return "TURTLE";
    }

    public String getLinkBreedSingular(AgentSet agentSet) {
        if (agentSet == this._links) {
            return "LINK";
        }
        String string = agentSet.printName();
        for (Map.Entry<String, String> entry : this._program.linkBreedsSingular().entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return "LINK";
    }

    public int compareLinkBreeds(AgentSet agentSet, AgentSet agentSet2) {
        for (AgentSet agentSet3 : this._program.linkBreeds().values()) {
            if (agentSet3 == agentSet) {
                return -1;
            }
            if (agentSet3 != agentSet2) continue;
            return 1;
        }
        throw new IllegalStateException("neither of the breeds exist, that's bad");
    }

    public int getVariablesArraySize(Observer observer) {
        return this._program.globals().size();
    }

    public int getVariablesArraySize(Patch patch) {
        return this._program.patchesOwn().size();
    }

    @Override
    public int getVariablesArraySize(org.nlogo.api.Turtle turtle2, org.nlogo.api.AgentSet agentSet) {
        if (agentSet == this._turtles) {
            return this._program.turtlesOwn().size();
        }
        List<String> list = this._program.breedsOwn().get(agentSet.printName());
        return this._program.turtlesOwn().size() + list.size();
    }

    @Override
    public int getVariablesArraySize(org.nlogo.api.Link link, org.nlogo.api.AgentSet agentSet) {
        if (agentSet == this._links) {
            return this._program.linksOwn().size();
        }
        List<String> list = this._program.linkBreedsOwn().get(agentSet.printName());
        return this._program.linksOwn().size() + list.size();
    }

    public int getLinkVariablesArraySize(AgentSet agentSet) {
        if (agentSet == this._links) {
            return this._program.linksOwn().size();
        }
        List<String> list = this._program.linkBreedsOwn().get(agentSet.printName());
        return this._program.linksOwn().size() + list.size();
    }

    public String checkTurtleShapeName(String string) {
        if (this._turtleShapeList.exists(string = string.toLowerCase())) {
            return string;
        }
        return null;
    }

    public String checkLinkShapeName(String string) {
        if (this._linkShapeList.exists(string = string.toLowerCase())) {
            return string;
        }
        return null;
    }

    public Map<String, Object> getBreeds() {
        return this._program.breeds();
    }

    public boolean breedOwns(AgentSet agentSet, String string) {
        if (agentSet == this._turtles) {
            return false;
        }
        List<String> list = this._program.breedsOwn().get(agentSet.printName());
        return list.contains(string);
    }

    public Map<String, Object> getLinkBreeds() {
        return this._program.linkBreeds();
    }

    public boolean linkBreedOwns(AgentSet agentSet, String string) {
        if (agentSet == this._links) {
            return false;
        }
        List<String> list = this._program.linkBreedsOwn().get(agentSet.printName());
        return list.contains(string);
    }

    @Override
    public Program program() {
        return this._program;
    }

    public void program(Program program) {
        if (program == null) {
            throw new IllegalArgumentException("World.program cannot be set to null");
        }
        this._program = program;
    }

    public Program newProgram() {
        return new Program(false);
    }

    public Program newProgram(List<String> list) {
        return new Program(list, false);
    }

    public void rememberOldProgram() {
        this.oldTurtlesOwn = this._program.turtlesOwn();
        this.oldPatchesOwn = this._program.patchesOwn();
        this.oldLinksOwn = this._program.linksOwn();
        this.oldGlobals = this._program.globals();
        this.oldBreeds = this._program.breeds();
        this.oldLinkBreeds = this._program.linkBreeds();
        this.oldBreedsOwn = this._program.breedsOwn();
        this.oldLinkBreedsOwn = this._program.linkBreedsOwn();
    }

    public boolean displayOn() {
        return this.displayOn;
    }

    public void displayOn(boolean bl) {
        this.displayOn = bl;
    }

    public Object getObserverVariableByName(String string) {
        int n = this._program.globals().indexOf(string.toUpperCase());
        if (n >= 0 && n < this._observer.variables.length) {
            return this._observer.variables[n];
        }
        throw new IllegalArgumentException("\"" + string + "\" not found");
    }

    public void setObserverVariableByName(String string, Object object) throws AgentException, LogoException {
        int n;
        string = string.toUpperCase();
        if (this._program.globals().contains(string) && -1 != (n = this._program.globals().indexOf(string)) && n < this._observer.variables.length) {
            this._observer.setObserverVariable(n, object);
            return;
        }
        throw new IllegalArgumentException("\"" + string + "\" not found");
    }

    public void compiler_$eq(CompilerServices compilerServices) {
        this._compiler = compilerServices;
    }

    public CompilerServices compiler() {
        return this._compiler;
    }

    @Override
    public Iterator<Object> allStoredValues() {
        return AllStoredValues.apply(this);
    }
}

