/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.security.AccessControlException;
import org.nlogo.api.Constants$;
import org.nlogo.api.Graphics2DWrapper$;
import org.nlogo.api.GraphicsInterface;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.Tuple2$mcDD$sp;
import scala.UninitializedFieldError;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphics2DWrapper
implements GraphicsInterface,
ScalaObject {
    private final Graphics2D g;
    private final boolean renderLabelsAsRectangles;
    private final boolean isMac;
    private final boolean isQuartz;
    private List<AffineTransform> transforms;
    private List<Stroke> strokes;
    private volatile int bitmap$init$0;

    public static final boolean init$default$2() {
        return Graphics2DWrapper$.MODULE$.init$default$2();
    }

    public boolean isMac() {
        if ((this.bitmap$init$0 & 1) != 0) {
            return this.isMac;
        }
        throw new UninitializedFieldError("Uninitialized field: Graphics2DWrapper.scala: 15".toString());
    }

    public boolean isQuartz() {
        if ((this.bitmap$init$0 & 2) != 0) {
            return this.isQuartz;
        }
        throw new UninitializedFieldError("Uninitialized field: Graphics2DWrapper.scala: 18".toString());
    }

    @Override
    public String location(double d, double d2) {
        return new StringBuilder().append((Object)"(").append(BoxesRunTime.boxToDouble(this.g.getTransform().getTranslateX() + d)).append((Object)" , ").append(BoxesRunTime.boxToDouble(this.g.getTransform().getTranslateY() + d2)).append((Object)")").toString();
    }

    @Override
    public void draw(Shape shape2) {
        this.g.draw(shape2);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage) {
        this.g.drawImage(bufferedImage, null, 0, 0);
    }

    @Override
    public void drawImage(Image image, int n, int n2, int n3, int n4) {
        this.g.drawImage(image, n, n2, n3, n4, null);
    }

    @Override
    public void drawLine(double d, double d2, double d3, double d4) {
        this.g.draw(new Line2D.Double(d, d2, d3, d4));
    }

    @Override
    public void drawLabel(String string, double d, double d2, double d3) {
        if (this.renderLabelsAsRectangles) {
            this.push();
            this.translate(d, d2);
            this.fillRect(0, 0, 5, 5);
            this.pop();
        } else {
            FontMetrics fontMetrics = this.g.getFontMetrics();
            this.g.translate(d - (double)fontMetrics.stringWidth(string), 0.0);
            if (d3 >= (double)(fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent())) {
                this.g.translate(0.0, d2 - (double)fontMetrics.getMaxDescent());
            } else {
                double d4 = BoxesRunTime.unboxToDouble(Predef$.MODULE$.doubleWrapper(0.0).min(BoxesRunTime.boxToDouble(d3 / (double)4 - (double)(fontMetrics.getMaxAscent() / 4))));
                this.g.translate(0.0, d2 - d4);
            }
            this.g.drawString(string, 0, 0);
        }
    }

    @Override
    public void fillCircle(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (this.isQuartz()) {
            d7 = (double)Constants$.MODULE$.ShapeWidth() / d5;
            d9 = d8 = -0.5 * d7;
        }
        this.g.fill(new Ellipse2D.Double(d + d8, d2 + d9, d3 + d7, d4 + d7));
    }

    @Override
    public void drawCircle(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (!this.isQuartz()) {
            d7 = (double)(-Constants$.MODULE$.ShapeWidth()) / d5;
            d8 = this.getXCorrection(d7, d6);
            d9 = this.getYCorrection(d7, d6);
        }
        this.g.draw(new Ellipse2D.Double(d + d8, d2 + d9, d3 + d7, d4 + d7));
    }

    @Override
    public void fillRect(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (this.isQuartz()) {
            d7 = (double)Constants$.MODULE$.ShapeWidth() / d5;
            d8 = this.getXCorrection(d7, d6);
            d9 = this.getYCorrection(d7, d6);
        }
        this.g.fill(new Rectangle2D.Double(d + d8, d2 + d9, d3 + d7, d4 + d7));
    }

    @Override
    public void drawRect(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        if (!this.isQuartz()) {
            d7 = (double)(-Constants$.MODULE$.ShapeWidth()) / d5;
        }
        this.g.draw(new Rectangle2D.Double(d, d2, d3 + d7, d4 + d7));
    }

    private double getXCorrection(double d, double d2) {
        return d2 == 0.0 ? 0.0 : d * (StrictMath.cos((d2 + (double)135) / 180.0 * Math.PI) + 0.7071067811865476) / -1.4142135623730951;
    }

    private double getYCorrection(double d, double d2) {
        return d2 == 0.0 ? 0.0 : d * (StrictMath.sin((d2 - (double)45) / 180.0 * Math.PI) + 0.7071067811865476) / -1.4142135623730951;
    }

    @Override
    public void fill(Shape shape2) {
        this.g.fill(shape2);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    private List<AffineTransform> transforms() {
        if ((this.bitmap$init$0 & 4) != 0) {
            return this.transforms;
        }
        throw new UninitializedFieldError("Uninitialized field: Graphics2DWrapper.scala: 124".toString());
    }

    private void transforms_$eq(List<AffineTransform> list) {
        this.transforms = list;
        this.bitmap$init$0 |= 4;
    }

    private List<Stroke> strokes() {
        if ((this.bitmap$init$0 & 8) != 0) {
            return this.strokes;
        }
        throw new UninitializedFieldError("Uninitialized field: Graphics2DWrapper.scala: 125".toString());
    }

    private void strokes_$eq(List<Stroke> list) {
        this.strokes = list;
        this.bitmap$init$0 |= 8;
    }

    @Override
    public void pop() {
        this.g.setTransform((AffineTransform)this.transforms().head());
        this.transforms_$eq((List)this.transforms().tail());
        this.g.setStroke((Stroke)this.strokes().head());
        this.strokes_$eq((List)this.strokes().tail());
    }

    @Override
    public void push() {
        this.transforms_$eq(this.transforms().$colon$colon(this.g.getTransform()));
        this.strokes_$eq(this.strokes().$colon$colon(this.g.getStroke()));
    }

    @Override
    public void rotate(double d) {
        this.g.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.g.rotate(d, d2, d3);
    }

    @Override
    public void rotate(double d, double d2, double d3, double d4) {
        double d5 = this.isQuartz() ? d4 - 1.0 : d4;
        this.g.rotate(d, d2 + d5 / (double)2, d3 + d5 / (double)2);
    }

    @Override
    public void scale(double d, double d2) {
        this.g.scale(d, d2);
    }

    @Override
    public void scale(double d, double d2, double d3) {
        Tuple2$mcDD$sp tuple2$mcDD$sp;
        Tuple2$mcDD$sp tuple2$mcDD$sp2 = tuple2$mcDD$sp = this.isQuartz() ? new Tuple2$mcDD$sp(d - 1.0, d2 - 1.0) : new Tuple2$mcDD$sp(d, d2);
        if (tuple2$mcDD$sp != null) {
            Tuple2$mcDD$sp tuple2$mcDD$sp3 = new Tuple2$mcDD$sp(BoxesRunTime.unboxToDouble(((Tuple2)tuple2$mcDD$sp)._1()), BoxesRunTime.unboxToDouble(((Tuple2)tuple2$mcDD$sp)._2()));
            double d4 = ((Tuple2)tuple2$mcDD$sp3)._1$mcD$sp();
            double d5 = ((Tuple2)tuple2$mcDD$sp3)._2$mcD$sp();
            this.g.scale(d4 / d3, d5 / d3);
            return;
        }
        throw new MatchError(tuple2$mcDD$sp);
    }

    @Override
    public void antiAliasing(boolean bl) {
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void setInterpolation() {
        if (this.isMac()) {
            this.g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
    }

    @Override
    public void setStrokeControl() {
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    @Override
    public void setColor(Color color) {
        this.g.setColor(color);
    }

    @Override
    public void setComposite(Composite composite) {
        this.g.setComposite(composite);
    }

    @Override
    public void setStroke(double d) {
        this.g.setStroke(new BasicStroke((float)BoxesRunTime.unboxToDouble(Predef$.MODULE$.doubleWrapper(d).max(BoxesRunTime.boxToDouble(1.0)))));
    }

    @Override
    public void setStrokeFromLineThickness(double d, double d2, double d3, double d4) {
        double d5 = this.isQuartz() ? d2 - 1.0 : d2;
        this.setStroke(d4 / d5 * (d == 0.0 ? 1.0 : d * d3));
    }

    @Override
    public void setStroke(float f, float[] fArray) {
        this.g.setStroke(new BasicStroke(f, 1, 1, 1.0f, fArray, 0.0f));
    }

    public void setPenWidth(double d) {
        float f = (float)BoxesRunTime.unboxToDouble(Predef$.MODULE$.doubleWrapper(d).max(BoxesRunTime.boxToDouble(1.0)));
        if (((BasicStroke)this.g.getStroke()).getLineWidth() != f) {
            this.g.setStroke(new BasicStroke(f, 1, 0));
        }
    }

    @Override
    public void translate(double d, double d2) {
        this.g.translate(d, d2);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolygon(nArray, nArray2, n);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.fillPolygon(nArray, nArray2, n);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolyline(nArray, nArray2, n);
    }

    @Override
    public void dispose() {
        this.g.dispose();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    private final boolean liftedTree1$1() {
        boolean bl = false;
        try {
            bl = this.isMac() && Boolean.getBoolean("apple.awt.graphics.UseQuartz");
        }
        catch (AccessControlException accessControlException) {
            bl = false;
        }
        return bl;
    }

    public Graphics2DWrapper(Graphics2D graphics2D, boolean bl) {
        this.g = graphics2D;
        this.renderLabelsAsRectangles = bl;
        this.isMac = System.getProperty("os.name").startsWith("Mac");
        this.bitmap$init$0 |= 1;
        this.isQuartz = this.liftedTree1$1();
        this.bitmap$init$0 |= 2;
        this.transforms = Nil$.MODULE$;
        this.bitmap$init$0 |= 4;
        this.strokes = Nil$.MODULE$;
        this.bitmap$init$0 |= 8;
    }

    public Graphics2DWrapper(Graphics2D graphics2D) {
        this(graphics2D, false);
    }
}

