/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compiler;

import java.util.Map;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.Program;
import org.nlogo.api.Token;
import org.nlogo.api.TokenizerInterface;
import org.nlogo.api.Version$;
import org.nlogo.compiler.AgentTypeChecker;
import org.nlogo.compiler.ArgumentStuffer;
import org.nlogo.compiler.Assembler;
import org.nlogo.compiler.CarefullyVisitor;
import org.nlogo.compiler.Compiler$;
import org.nlogo.compiler.ConstantFolder;
import org.nlogo.compiler.ExpressionParser;
import org.nlogo.compiler.IdentifierParser;
import org.nlogo.compiler.LocalsVisitor;
import org.nlogo.compiler.Optimizer;
import org.nlogo.compiler.ProcedureDefinition;
import org.nlogo.compiler.ReferenceVisitor;
import org.nlogo.compiler.SetVisitor;
import org.nlogo.compiler.SimpleOfVisitor;
import org.nlogo.compiler.StructureParser;
import org.nlogo.compiler.TaskVisitor;
import org.nlogo.nvm.GeneratorInterface;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.Femto$;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompilerMain$
implements ScalaObject {
    public static final CompilerMain$ MODULE$;

    static {
        new CompilerMain$();
    }

    public Seq<Procedure> compile(String string, Option<String> option, Program program, boolean bl, Map<String, Procedure> map2, ExtensionManager extensionManager) {
        TokenizerInterface tokenizerInterface = program.is3D() ? Compiler$.MODULE$.Tokenizer3D() : Compiler$.MODULE$.Tokenizer2D();
        StructureParser.Results results = new StructureParser(tokenizerInterface.tokenize(string), option, program, map2, extensionManager, tokenizerInterface).parse(bl);
        ArrayBuffer<ProcedureDefinition> arrayBuffer = new ArrayBuffer<ProcedureDefinition>();
        Iterator<Object> iterator2 = package$.MODULE$.Iterator().from(1);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(results.procedures().values()).asScala()).foreach(new Serializable(program, bl, map2, results, arrayBuffer, iterator2){
            public static final long serialVersionUID;
            private final Program program$1;
            private final boolean subprogram$1;
            private final Map oldProcedures$1;
            private final StructureParser.Results structureResults$1;
            private final ArrayBuffer defs$1;
            private final Iterator taskNumbers$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ArrayBuffer<ProcedureDefinition> apply(Procedure procedure) {
                procedure.topLevel = this.subprogram$1;
                Seq<Token> seq = new IdentifierParser(this.program$1, this.oldProcedures$1, this.structureResults$1.procedures(), false).process(((IterableLike)this.structureResults$1.tokens().apply(procedure)).iterator(), procedure);
                return this.defs$1.$plus$plus$eq((TraversableOnce)new ExpressionParser(procedure, this.taskNumbers$1).parse(seq));
            }
            {
                this.program$1 = program;
                this.subprogram$1 = bl;
                this.oldProcedures$1 = map2;
                this.structureResults$1 = results;
                this.defs$1 = arrayBuffer;
                this.taskNumbers$1 = iterator2;
            }
        });
        arrayBuffer.foreach(new Serializable(program){
            public static final long serialVersionUID;
            private final Program program$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ProcedureDefinition procedureDefinition) {
                procedureDefinition.accept(new ReferenceVisitor());
                procedureDefinition.accept(new ConstantFolder());
                procedureDefinition.accept(new SimpleOfVisitor());
                procedureDefinition.accept(new TaskVisitor());
                procedureDefinition.accept(new LocalsVisitor());
                procedureDefinition.accept(new SetVisitor());
                procedureDefinition.accept(new CarefullyVisitor());
                procedureDefinition.accept(new Optimizer(this.program$1.is3D()));
            }
            {
                this.program$1 = program;
            }
        });
        new AgentTypeChecker(arrayBuffer).parse();
        arrayBuffer.foreach(new Serializable(string, extensionManager){
            public static final long serialVersionUID;
            private final String source$1;
            private final ExtensionManager extensionManager$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ProcedureDefinition procedureDefinition) {
                procedureDefinition.accept(new ArgumentStuffer());
                new Assembler().assemble(procedureDefinition);
                if (Version$.MODULE$.useGenerator()) {
                    procedureDefinition.procedure().code = Femto$.MODULE$.get(GeneratorInterface.class, "org.nlogo.generator.Generator", new Object[]{this.source$1, procedureDefinition.procedure(), BoxesRunTime.boxToBoolean(this.extensionManager$1.profilingEnabled())}).generate();
                }
            }
            {
                this.source$1 = string;
                this.extensionManager$1 = extensionManager;
            }
        });
        return (Seq)((TraversableLike)arrayBuffer.map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Procedure apply(ProcedureDefinition procedureDefinition) {
                return procedureDefinition.procedure();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).filterNot(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Procedure procedure) {
                return procedure.isTask();
            }

            public final /* synthetic */ Object apply(Object object) {
                return BoxesRunTime.boxToBoolean(this.apply((Procedure)object));
            }
        });
    }

    private CompilerMain$() {
        MODULE$ = this;
    }
}

